/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.text.webvtt;

import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.util.Log;
import com.mbridge.msdk.playercommon.exoplayer2.text.Cue;

public final class WebvttCue
extends Cue {
    public final long endTime;
    public final long startTime;

    public WebvttCue(long l2, long l3, CharSequence charSequence) {
        this(l2, l3, charSequence, null, Float.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Float.MIN_VALUE, Integer.MIN_VALUE, Float.MIN_VALUE);
    }

    public WebvttCue(long l2, long l3, CharSequence charSequence, Layout.Alignment alignment, float f2, int n2, int n3, float f3, int n4, float f4) {
        super(charSequence, alignment, f2, n2, n3, f3, n4, f4);
        this.startTime = l2;
        this.endTime = l3;
    }

    public WebvttCue(CharSequence charSequence) {
        this(0L, 0L, charSequence);
    }

    public final boolean isNormalCue() {
        boolean bl = this.line == Float.MIN_VALUE && this.position == Float.MIN_VALUE;
        return bl;
    }

    public static class Builder {
        private static final String TAG = "WebvttCueBuilder";
        private long endTime;
        private float line;
        private int lineAnchor;
        private int lineType;
        private float position;
        private int positionAnchor;
        private long startTime;
        private SpannableStringBuilder text;
        private Layout.Alignment textAlignment;
        private float width;

        public Builder() {
            this.reset();
        }

        private Builder derivePositionAnchorFromAlignment() {
            if (this.textAlignment == null) {
                this.positionAnchor = Integer.MIN_VALUE;
            } else {
                int n2 = 1.$SwitchMap$android$text$Layout$Alignment[this.textAlignment.ordinal()];
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 != 3) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Unrecognized alignment: ");
                            stringBuilder.append(this.textAlignment);
                            Log.w((String)TAG, (String)stringBuilder.toString());
                            this.positionAnchor = 0;
                        } else {
                            this.positionAnchor = 2;
                        }
                    } else {
                        this.positionAnchor = 1;
                    }
                } else {
                    this.positionAnchor = 0;
                }
            }
            return this;
        }

        public WebvttCue build() {
            if (this.position != Float.MIN_VALUE && this.positionAnchor == Integer.MIN_VALUE) {
                this.derivePositionAnchorFromAlignment();
            }
            return new WebvttCue(this.startTime, this.endTime, (CharSequence)this.text, this.textAlignment, this.line, this.lineType, this.lineAnchor, this.position, this.positionAnchor, this.width);
        }

        public void reset() {
            this.startTime = 0L;
            this.endTime = 0L;
            this.text = null;
            this.textAlignment = null;
            this.line = Float.MIN_VALUE;
            this.lineType = Integer.MIN_VALUE;
            this.lineAnchor = Integer.MIN_VALUE;
            this.position = Float.MIN_VALUE;
            this.positionAnchor = Integer.MIN_VALUE;
            this.width = Float.MIN_VALUE;
        }

        public Builder setEndTime(long l2) {
            this.endTime = l2;
            return this;
        }

        public Builder setLine(float f2) {
            this.line = f2;
            return this;
        }

        public Builder setLineAnchor(int n2) {
            this.lineAnchor = n2;
            return this;
        }

        public Builder setLineType(int n2) {
            this.lineType = n2;
            return this;
        }

        public Builder setPosition(float f2) {
            this.position = f2;
            return this;
        }

        public Builder setPositionAnchor(int n2) {
            this.positionAnchor = n2;
            return this;
        }

        public Builder setStartTime(long l2) {
            this.startTime = l2;
            return this;
        }

        public Builder setText(SpannableStringBuilder spannableStringBuilder) {
            this.text = spannableStringBuilder;
            return this;
        }

        public Builder setTextAlignment(Layout.Alignment alignment) {
            this.textAlignment = alignment;
            return this;
        }

        public Builder setWidth(float f2) {
            this.width = f2;
            return this;
        }
    }
}

