/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.text.webvtt;

import android.text.Layout;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class WebvttCssStyle {
    public static final int FONT_SIZE_UNIT_EM = 2;
    public static final int FONT_SIZE_UNIT_PERCENT = 3;
    public static final int FONT_SIZE_UNIT_PIXEL = 1;
    private static final int OFF = 0;
    private static final int ON = 1;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_BOLD_ITALIC = 3;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_NORMAL = 0;
    public static final int UNSPECIFIED = -1;
    private int backgroundColor;
    private int bold;
    private int fontColor;
    private String fontFamily;
    private float fontSize;
    private int fontSizeUnit;
    private boolean hasBackgroundColor;
    private boolean hasFontColor;
    private int italic;
    private int linethrough;
    private List<String> targetClasses;
    private String targetId;
    private String targetTag;
    private String targetVoice;
    private Layout.Alignment textAlign;
    private int underline;

    public WebvttCssStyle() {
        this.reset();
    }

    private static int updateScoreForMatch(int n2, String string2, String string3, int n3) {
        if (!string2.isEmpty()) {
            int n4 = -1;
            if (n2 != -1) {
                if (string2.equals(string3)) {
                    n4 = n2 + n3;
                }
                return n4;
            }
        }
        return n2;
    }

    public final void cascadeFrom(WebvttCssStyle webvttCssStyle) {
        String string2;
        int n2;
        if (webvttCssStyle.hasFontColor) {
            this.setFontColor(webvttCssStyle.fontColor);
        }
        if ((n2 = webvttCssStyle.bold) != -1) {
            this.bold = n2;
        }
        if ((n2 = webvttCssStyle.italic) != -1) {
            this.italic = n2;
        }
        if ((string2 = webvttCssStyle.fontFamily) != null) {
            this.fontFamily = string2;
        }
        if (this.linethrough == -1) {
            this.linethrough = webvttCssStyle.linethrough;
        }
        if (this.underline == -1) {
            this.underline = webvttCssStyle.underline;
        }
        if (this.textAlign == null) {
            this.textAlign = webvttCssStyle.textAlign;
        }
        if (this.fontSizeUnit == -1) {
            this.fontSizeUnit = webvttCssStyle.fontSizeUnit;
            this.fontSize = webvttCssStyle.fontSize;
        }
        if (webvttCssStyle.hasBackgroundColor) {
            this.setBackgroundColor(webvttCssStyle.backgroundColor);
        }
    }

    public final int getBackgroundColor() {
        if (this.hasBackgroundColor) {
            return this.backgroundColor;
        }
        throw new IllegalStateException("Background color not defined.");
    }

    public final int getFontColor() {
        if (this.hasFontColor) {
            return this.fontColor;
        }
        throw new IllegalStateException("Font color not defined");
    }

    public final String getFontFamily() {
        return this.fontFamily;
    }

    public final float getFontSize() {
        return this.fontSize;
    }

    public final int getFontSizeUnit() {
        return this.fontSizeUnit;
    }

    public final int getSpecificityScore(String string2, String string3, String[] stringArray, String string4) {
        if (this.targetId.isEmpty() && this.targetTag.isEmpty() && this.targetClasses.isEmpty() && this.targetVoice.isEmpty()) {
            return string3.isEmpty() ? 1 : 0;
        }
        int n2 = WebvttCssStyle.updateScoreForMatch(WebvttCssStyle.updateScoreForMatch(WebvttCssStyle.updateScoreForMatch(0, this.targetId, string2, 0x40000000), this.targetTag, string3, 2), this.targetVoice, string4, 4);
        if (n2 != -1 && Arrays.asList(stringArray).containsAll(this.targetClasses)) {
            return n2 + this.targetClasses.size() * 4;
        }
        return 0;
    }

    public final int getStyle() {
        if (this.bold == -1 && this.italic == -1) {
            return -1;
        }
        int n2 = this.bold;
        int n3 = 0;
        n2 = n2 == 1 ? 1 : 0;
        if (this.italic == 1) {
            n3 = 2;
        }
        return n2 | n3;
    }

    public final Layout.Alignment getTextAlign() {
        return this.textAlign;
    }

    public final boolean hasBackgroundColor() {
        return this.hasBackgroundColor;
    }

    public final boolean hasFontColor() {
        return this.hasFontColor;
    }

    public final boolean isLinethrough() {
        int n2 = this.linethrough;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public final boolean isUnderline() {
        int n2 = this.underline;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public final void reset() {
        this.targetId = "";
        this.targetTag = "";
        this.targetClasses = Collections.emptyList();
        this.targetVoice = "";
        this.fontFamily = null;
        this.hasFontColor = false;
        this.hasBackgroundColor = false;
        this.linethrough = -1;
        this.underline = -1;
        this.bold = -1;
        this.italic = -1;
        this.fontSizeUnit = -1;
        this.textAlign = null;
    }

    public final WebvttCssStyle setBackgroundColor(int n2) {
        this.backgroundColor = n2;
        this.hasBackgroundColor = true;
        return this;
    }

    public final WebvttCssStyle setBold(boolean bl) {
        this.bold = bl ? 1 : 0;
        return this;
    }

    public final WebvttCssStyle setFontColor(int n2) {
        this.fontColor = n2;
        this.hasFontColor = true;
        return this;
    }

    public final WebvttCssStyle setFontFamily(String string2) {
        this.fontFamily = Util.toLowerInvariant((String)string2);
        return this;
    }

    public final WebvttCssStyle setFontSize(float f2) {
        this.fontSize = f2;
        return this;
    }

    public final WebvttCssStyle setFontSizeUnit(short s2) {
        this.fontSizeUnit = s2;
        return this;
    }

    public final WebvttCssStyle setItalic(boolean bl) {
        this.italic = bl ? 1 : 0;
        return this;
    }

    public final WebvttCssStyle setLinethrough(boolean bl) {
        this.linethrough = bl ? 1 : 0;
        return this;
    }

    public final void setTargetClasses(String[] stringArray) {
        this.targetClasses = Arrays.asList(stringArray);
    }

    public final void setTargetId(String string2) {
        this.targetId = string2;
    }

    public final void setTargetTagName(String string2) {
        this.targetTag = string2;
    }

    public final void setTargetVoice(String string2) {
        this.targetVoice = string2;
    }

    public final WebvttCssStyle setTextAlign(Layout.Alignment alignment) {
        this.textAlign = alignment;
        return this;
    }

    public final WebvttCssStyle setUnderline(boolean bl) {
        this.underline = bl ? 1 : 0;
        return this;
    }

    public static @interface FontSizeUnit {
    }

    private static @interface OptionalBoolean {
    }

    public static @interface StyleFlags {
    }
}

