/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.text.ttml;

import android.text.Layout;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;

final class TtmlStyle {
    public static final int FONT_SIZE_UNIT_EM = 2;
    public static final int FONT_SIZE_UNIT_PERCENT = 3;
    public static final int FONT_SIZE_UNIT_PIXEL = 1;
    private static final int OFF = 0;
    private static final int ON = 1;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_BOLD_ITALIC = 3;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_NORMAL = 0;
    public static final int UNSPECIFIED = -1;
    private int backgroundColor;
    private int bold = -1;
    private int fontColor;
    private String fontFamily;
    private float fontSize;
    private int fontSizeUnit = -1;
    private boolean hasBackgroundColor;
    private boolean hasFontColor;
    private String id;
    private TtmlStyle inheritableStyle;
    private int italic = -1;
    private int linethrough = -1;
    private Layout.Alignment textAlign;
    private int underline = -1;

    private TtmlStyle inherit(TtmlStyle ttmlStyle, boolean bl) {
        if (ttmlStyle != null) {
            if (!this.hasFontColor && ttmlStyle.hasFontColor) {
                this.setFontColor(ttmlStyle.fontColor);
            }
            if (this.bold == -1) {
                this.bold = ttmlStyle.bold;
            }
            if (this.italic == -1) {
                this.italic = ttmlStyle.italic;
            }
            if (this.fontFamily == null) {
                this.fontFamily = ttmlStyle.fontFamily;
            }
            if (this.linethrough == -1) {
                this.linethrough = ttmlStyle.linethrough;
            }
            if (this.underline == -1) {
                this.underline = ttmlStyle.underline;
            }
            if (this.textAlign == null) {
                this.textAlign = ttmlStyle.textAlign;
            }
            if (this.fontSizeUnit == -1) {
                this.fontSizeUnit = ttmlStyle.fontSizeUnit;
                this.fontSize = ttmlStyle.fontSize;
            }
            if (bl && !this.hasBackgroundColor && ttmlStyle.hasBackgroundColor) {
                this.setBackgroundColor(ttmlStyle.backgroundColor);
            }
        }
        return this;
    }

    public final TtmlStyle chain(TtmlStyle ttmlStyle) {
        return this.inherit(ttmlStyle, true);
    }

    public final int getBackgroundColor() {
        if (this.hasBackgroundColor) {
            return this.backgroundColor;
        }
        throw new IllegalStateException("Background color has not been defined.");
    }

    public final int getFontColor() {
        if (this.hasFontColor) {
            return this.fontColor;
        }
        throw new IllegalStateException("Font color has not been defined.");
    }

    public final String getFontFamily() {
        return this.fontFamily;
    }

    public final float getFontSize() {
        return this.fontSize;
    }

    public final int getFontSizeUnit() {
        return this.fontSizeUnit;
    }

    public final String getId() {
        return this.id;
    }

    public final int getStyle() {
        if (this.bold == -1 && this.italic == -1) {
            return -1;
        }
        int n2 = this.bold;
        int n3 = 0;
        n2 = n2 == 1 ? 1 : 0;
        if (this.italic == 1) {
            n3 = 2;
        }
        return n2 | n3;
    }

    public final Layout.Alignment getTextAlign() {
        return this.textAlign;
    }

    public final boolean hasBackgroundColor() {
        return this.hasBackgroundColor;
    }

    public final boolean hasFontColor() {
        return this.hasFontColor;
    }

    public final TtmlStyle inherit(TtmlStyle ttmlStyle) {
        return this.inherit(ttmlStyle, false);
    }

    public final boolean isLinethrough() {
        int n2 = this.linethrough;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public final boolean isUnderline() {
        int n2 = this.underline;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public final TtmlStyle setBackgroundColor(int n2) {
        this.backgroundColor = n2;
        this.hasBackgroundColor = true;
        return this;
    }

    public final TtmlStyle setBold(boolean bl) {
        boolean bl2 = this.inheritableStyle == null;
        Assertions.checkState(bl2);
        this.bold = bl ? 1 : 0;
        return this;
    }

    public final TtmlStyle setFontColor(int n2) {
        boolean bl = this.inheritableStyle == null;
        Assertions.checkState(bl);
        this.fontColor = n2;
        this.hasFontColor = true;
        return this;
    }

    public final TtmlStyle setFontFamily(String string2) {
        boolean bl = this.inheritableStyle == null;
        Assertions.checkState(bl);
        this.fontFamily = string2;
        return this;
    }

    public final TtmlStyle setFontSize(float f2) {
        this.fontSize = f2;
        return this;
    }

    public final TtmlStyle setFontSizeUnit(int n2) {
        this.fontSizeUnit = n2;
        return this;
    }

    public final TtmlStyle setId(String string2) {
        this.id = string2;
        return this;
    }

    public final TtmlStyle setItalic(boolean bl) {
        boolean bl2 = this.inheritableStyle == null;
        Assertions.checkState(bl2);
        this.italic = bl ? 1 : 0;
        return this;
    }

    public final TtmlStyle setLinethrough(boolean bl) {
        boolean bl2 = this.inheritableStyle == null;
        Assertions.checkState(bl2);
        this.linethrough = bl ? 1 : 0;
        return this;
    }

    public final TtmlStyle setTextAlign(Layout.Alignment alignment) {
        this.textAlign = alignment;
        return this;
    }

    public final TtmlStyle setUnderline(boolean bl) {
        boolean bl2 = this.inheritableStyle == null;
        Assertions.checkState(bl2);
        this.underline = bl ? 1 : 0;
        return this;
    }

    public static @interface FontSizeUnit {
    }

    private static @interface OptionalBoolean {
    }

    public static @interface StyleFlags {
    }
}

