/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.text.subrip;

import android.text.Html;
import android.text.TextUtils;
import android.util.Log;
import com.mbridge.msdk.playercommon.exoplayer2.text.Cue;
import com.mbridge.msdk.playercommon.exoplayer2.text.SimpleSubtitleDecoder;
import com.mbridge.msdk.playercommon.exoplayer2.text.subrip.SubripSubtitle;
import com.mbridge.msdk.playercommon.exoplayer2.util.LongArray;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SubripDecoder
extends SimpleSubtitleDecoder {
    private static final String SUBRIP_TIMECODE = "(?:(\\d+):)?(\\d+):(\\d+),(\\d+)";
    private static final Pattern SUBRIP_TIMING_LINE = Pattern.compile("\\s*((?:(\\d+):)?(\\d+):(\\d+),(\\d+))\\s*-->\\s*((?:(\\d+):)?(\\d+):(\\d+),(\\d+))?\\s*");
    private static final String TAG = "SubripDecoder";
    private final StringBuilder textBuilder = new StringBuilder();

    public SubripDecoder() {
        super(TAG);
    }

    private static long parseTimecode(Matcher matcher, int n2) {
        return (Long.parseLong(matcher.group(n2 + 1)) * 60L * 60L * 1000L + Long.parseLong(matcher.group(n2 + 2)) * 60L * 1000L + Long.parseLong(matcher.group(n2 + 3)) * 1000L + Long.parseLong(matcher.group(n2 + 4))) * 1000L;
    }

    protected final SubripSubtitle decode(byte[] object, int n2, boolean bl) {
        String string2;
        ArrayList<Cue> arrayList = new ArrayList<Cue>();
        LongArray longArray = new LongArray();
        object = new ParsableByteArray(object, n2);
        while ((string2 = object.readLine()) != null) {
            Object object2;
            if (string2.length() == 0) continue;
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Skipping invalid index: ");
                ((StringBuilder)object2).append(string2);
                Log.w((String)TAG, (String)((StringBuilder)object2).toString());
                continue;
            }
            string2 = object.readLine();
            if (string2 == null) {
                Log.w((String)TAG, (String)"Unexpected end");
                break;
            }
            object2 = SUBRIP_TIMING_LINE.matcher(string2);
            if (((Matcher)object2).matches()) {
                n2 = 1;
                longArray.add(SubripDecoder.parseTimecode((Matcher)object2, 1));
                if (!TextUtils.isEmpty((CharSequence)((Matcher)object2).group(6))) {
                    longArray.add(SubripDecoder.parseTimecode((Matcher)object2, 6));
                } else {
                    n2 = 0;
                }
                this.textBuilder.setLength(0);
                while (!TextUtils.isEmpty((CharSequence)(string2 = object.readLine()))) {
                    if (this.textBuilder.length() > 0) {
                        this.textBuilder.append("<br>");
                    }
                    this.textBuilder.append(string2.trim());
                }
                arrayList.add(new Cue((CharSequence)Html.fromHtml((String)this.textBuilder.toString())));
                if (n2 == 0) continue;
                arrayList.add(null);
                continue;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Skipping invalid timing: ");
            ((StringBuilder)object2).append(string2);
            Log.w((String)TAG, (String)((StringBuilder)object2).toString());
        }
        object = new Cue[arrayList.size()];
        arrayList.toArray((T[])object);
        return new SubripSubtitle((Cue[])object, longArray.toArray());
    }
}

