/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.text.cea;

import com.mbridge.msdk.playercommon.exoplayer2.text.Subtitle;
import com.mbridge.msdk.playercommon.exoplayer2.text.SubtitleDecoder;
import com.mbridge.msdk.playercommon.exoplayer2.text.SubtitleDecoderException;
import com.mbridge.msdk.playercommon.exoplayer2.text.SubtitleInputBuffer;
import com.mbridge.msdk.playercommon.exoplayer2.text.SubtitleOutputBuffer;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import java.util.ArrayDeque;
import java.util.PriorityQueue;

abstract class CeaDecoder
implements SubtitleDecoder {
    private static final int NUM_INPUT_BUFFERS = 10;
    private static final int NUM_OUTPUT_BUFFERS = 2;
    private final ArrayDeque<CeaInputBuffer> availableInputBuffers = new ArrayDeque();
    private final ArrayDeque<SubtitleOutputBuffer> availableOutputBuffers;
    private CeaInputBuffer dequeuedInputBuffer;
    private long playbackPositionUs;
    private long queuedInputBufferCount;
    private final PriorityQueue<CeaInputBuffer> queuedInputBuffers;

    public CeaDecoder() {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 10; ++n2) {
            this.availableInputBuffers.add(new CeaInputBuffer());
        }
        this.availableOutputBuffers = new ArrayDeque();
        for (n2 = n3; n2 < 2; ++n2) {
            this.availableOutputBuffers.add(new CeaOutputBuffer());
        }
        this.queuedInputBuffers = new PriorityQueue();
    }

    private void releaseInputBuffer(CeaInputBuffer ceaInputBuffer) {
        ceaInputBuffer.clear();
        this.availableInputBuffers.add(ceaInputBuffer);
    }

    protected abstract Subtitle createSubtitle();

    protected abstract void decode(SubtitleInputBuffer var1);

    public SubtitleInputBuffer dequeueInputBuffer() throws SubtitleDecoderException {
        boolean bl = this.dequeuedInputBuffer == null;
        Assertions.checkState(bl);
        if (this.availableInputBuffers.isEmpty()) {
            return null;
        }
        this.dequeuedInputBuffer = this.availableInputBuffers.pollFirst();
        return this.dequeuedInputBuffer;
    }

    public SubtitleOutputBuffer dequeueOutputBuffer() throws SubtitleDecoderException {
        if (this.availableOutputBuffers.isEmpty()) {
            return null;
        }
        while (!this.queuedInputBuffers.isEmpty() && this.queuedInputBuffers.peek().timeUs <= this.playbackPositionUs) {
            SubtitleOutputBuffer subtitleOutputBuffer;
            CeaInputBuffer ceaInputBuffer = this.queuedInputBuffers.poll();
            if (ceaInputBuffer.isEndOfStream()) {
                subtitleOutputBuffer = this.availableOutputBuffers.pollFirst();
                subtitleOutputBuffer.addFlag(4);
                this.releaseInputBuffer(ceaInputBuffer);
                return subtitleOutputBuffer;
            }
            this.decode(ceaInputBuffer);
            if (this.isNewSubtitleDataAvailable()) {
                subtitleOutputBuffer = this.createSubtitle();
                if (!ceaInputBuffer.isDecodeOnly()) {
                    SubtitleOutputBuffer subtitleOutputBuffer2 = this.availableOutputBuffers.pollFirst();
                    subtitleOutputBuffer2.setContent(ceaInputBuffer.timeUs, (Subtitle)subtitleOutputBuffer, Long.MAX_VALUE);
                    this.releaseInputBuffer(ceaInputBuffer);
                    return subtitleOutputBuffer2;
                }
            }
            this.releaseInputBuffer(ceaInputBuffer);
        }
        return null;
    }

    public void flush() {
        this.queuedInputBufferCount = 0L;
        this.playbackPositionUs = 0L;
        while (!this.queuedInputBuffers.isEmpty()) {
            this.releaseInputBuffer(this.queuedInputBuffers.poll());
        }
        CeaInputBuffer ceaInputBuffer = this.dequeuedInputBuffer;
        if (ceaInputBuffer != null) {
            this.releaseInputBuffer(ceaInputBuffer);
            this.dequeuedInputBuffer = null;
        }
    }

    public abstract String getName();

    protected abstract boolean isNewSubtitleDataAvailable();

    public void queueInputBuffer(SubtitleInputBuffer subtitleInputBuffer) throws SubtitleDecoderException {
        boolean bl = subtitleInputBuffer == this.dequeuedInputBuffer;
        Assertions.checkArgument(bl);
        if (subtitleInputBuffer.isDecodeOnly()) {
            this.releaseInputBuffer(this.dequeuedInputBuffer);
        } else {
            subtitleInputBuffer = this.dequeuedInputBuffer;
            long l2 = this.queuedInputBufferCount;
            this.queuedInputBufferCount = 1L + l2;
            CeaInputBuffer.access$202((CeaInputBuffer)subtitleInputBuffer, l2);
            this.queuedInputBuffers.add(this.dequeuedInputBuffer);
        }
        this.dequeuedInputBuffer = null;
    }

    public void release() {
    }

    protected void releaseOutputBuffer(SubtitleOutputBuffer subtitleOutputBuffer) {
        subtitleOutputBuffer.clear();
        this.availableOutputBuffers.add(subtitleOutputBuffer);
    }

    public void setPositionUs(long l2) {
        this.playbackPositionUs = l2;
    }

    private static final class CeaInputBuffer
    extends SubtitleInputBuffer
    implements Comparable<CeaInputBuffer> {
        private long queuedInputBufferCount;

        private CeaInputBuffer() {
        }

        static /* synthetic */ long access$202(CeaInputBuffer ceaInputBuffer, long l2) {
            ceaInputBuffer.queuedInputBufferCount = l2;
            return l2;
        }

        @Override
        public final int compareTo(CeaInputBuffer ceaInputBuffer) {
            long l2;
            boolean bl = this.isEndOfStream();
            boolean bl2 = ceaInputBuffer.isEndOfStream();
            int n2 = 1;
            int n3 = 1;
            if (bl != bl2) {
                if (!this.isEndOfStream()) {
                    n3 = -1;
                }
                return n3;
            }
            long l3 = l2 = this.timeUs - ceaInputBuffer.timeUs;
            if (l2 == 0L) {
                l3 = l2 = this.queuedInputBufferCount - ceaInputBuffer.queuedInputBufferCount;
                if (l2 == 0L) {
                    return 0;
                }
            }
            n3 = l3 > 0L ? n2 : -1;
            return n3;
        }
    }

    private final class CeaOutputBuffer
    extends SubtitleOutputBuffer {
        private CeaOutputBuffer() {
        }

        public final void release() {
            CeaDecoder.this.releaseOutputBuffer(this);
        }
    }
}

