/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.text;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.mbridge.msdk.playercommon.exoplayer2.BaseRenderer;
import com.mbridge.msdk.playercommon.exoplayer2.ExoPlaybackException;
import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.FormatHolder;
import com.mbridge.msdk.playercommon.exoplayer2.decoder.DecoderInputBuffer;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmInitData;
import com.mbridge.msdk.playercommon.exoplayer2.text.Cue;
import com.mbridge.msdk.playercommon.exoplayer2.text.SubtitleDecoder;
import com.mbridge.msdk.playercommon.exoplayer2.text.SubtitleDecoderException;
import com.mbridge.msdk.playercommon.exoplayer2.text.SubtitleDecoderFactory;
import com.mbridge.msdk.playercommon.exoplayer2.text.SubtitleInputBuffer;
import com.mbridge.msdk.playercommon.exoplayer2.text.SubtitleOutputBuffer;
import com.mbridge.msdk.playercommon.exoplayer2.text.TextOutput;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.MimeTypes;
import java.util.Collections;
import java.util.List;

public final class TextRenderer
extends BaseRenderer
implements Handler.Callback {
    private static final int MSG_UPDATE_OUTPUT = 0;
    private static final int REPLACEMENT_STATE_NONE = 0;
    private static final int REPLACEMENT_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REPLACEMENT_STATE_WAIT_END_OF_STREAM = 2;
    private SubtitleDecoder decoder;
    private final SubtitleDecoderFactory decoderFactory;
    private int decoderReplacementState;
    private final FormatHolder formatHolder;
    private boolean inputStreamEnded;
    private SubtitleInputBuffer nextInputBuffer;
    private SubtitleOutputBuffer nextSubtitle;
    private int nextSubtitleEventIndex;
    private final TextOutput output;
    private final Handler outputHandler;
    private boolean outputStreamEnded;
    private Format streamFormat;
    private SubtitleOutputBuffer subtitle;

    public TextRenderer(TextOutput textOutput, Looper looper) {
        this(textOutput, looper, SubtitleDecoderFactory.DEFAULT);
    }

    public TextRenderer(TextOutput object, Looper looper, SubtitleDecoderFactory subtitleDecoderFactory) {
        super(3);
        this.output = Assertions.checkNotNull(object);
        object = looper == null ? null : new Handler(looper, (Handler.Callback)this);
        this.outputHandler = object;
        this.decoderFactory = subtitleDecoderFactory;
        this.formatHolder = new FormatHolder();
    }

    private void clearOutput() {
        this.updateOutput(Collections.<Cue>emptyList());
    }

    private long getNextEventTime() {
        int n2 = this.nextSubtitleEventIndex;
        long l2 = n2 != -1 && n2 < this.subtitle.getEventTimeCount() ? this.subtitle.getEventTime(this.nextSubtitleEventIndex) : Long.MAX_VALUE;
        return l2;
    }

    private void invokeUpdateOutputInternal(List<Cue> list) {
        this.output.onCues(list);
    }

    private void releaseBuffers() {
        this.nextInputBuffer = null;
        this.nextSubtitleEventIndex = -1;
        SubtitleOutputBuffer subtitleOutputBuffer = this.subtitle;
        if (subtitleOutputBuffer != null) {
            subtitleOutputBuffer.release();
            this.subtitle = null;
        }
        if ((subtitleOutputBuffer = this.nextSubtitle) != null) {
            subtitleOutputBuffer.release();
            this.nextSubtitle = null;
        }
    }

    private void releaseDecoder() {
        this.releaseBuffers();
        this.decoder.release();
        this.decoder = null;
        this.decoderReplacementState = 0;
    }

    private void replaceDecoder() {
        this.releaseDecoder();
        this.decoder = this.decoderFactory.createDecoder(this.streamFormat);
    }

    private void updateOutput(List<Cue> list) {
        Handler handler = this.outputHandler;
        if (handler != null) {
            handler.obtainMessage(0, list).sendToTarget();
        } else {
            this.invokeUpdateOutputInternal(list);
        }
    }

    public final boolean handleMessage(Message message) {
        if (message.what == 0) {
            this.invokeUpdateOutputInternal((List)message.obj);
            return true;
        }
        throw new IllegalStateException();
    }

    public final boolean isEnded() {
        return this.outputStreamEnded;
    }

    public final boolean isReady() {
        return true;
    }

    protected final void onDisabled() {
        this.streamFormat = null;
        this.clearOutput();
        this.releaseDecoder();
    }

    protected final void onPositionReset(long l2, boolean bl) {
        this.clearOutput();
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.decoderReplacementState != 0) {
            this.replaceDecoder();
        } else {
            this.releaseBuffers();
            this.decoder.flush();
        }
    }

    protected final void onStreamChanged(Format[] formatArray, long l2) throws ExoPlaybackException {
        this.streamFormat = formatArray[0];
        if (this.decoder != null) {
            this.decoderReplacementState = 1;
        } else {
            this.decoder = this.decoderFactory.createDecoder(this.streamFormat);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void render(long l2, long l3) throws ExoPlaybackException {
        int n3;
        int n2;
        block25: {
            SubtitleOutputBuffer subtitleOutputBuffer;
            block26: {
                if (this.outputStreamEnded) {
                    return;
                }
                if (this.nextSubtitle == null) {
                    this.decoder.setPositionUs(l2);
                    try {
                        this.nextSubtitle = (SubtitleOutputBuffer)this.decoder.dequeueOutputBuffer();
                    }
                    catch (SubtitleDecoderException subtitleDecoderException) {
                        throw ExoPlaybackException.createForRenderer((Exception)((Object)subtitleDecoderException), this.getIndex());
                    }
                }
                if (this.getState() != 2) {
                    return;
                }
                if (this.subtitle != null) {
                    l3 = this.getNextEventTime();
                    n2 = 0;
                    while (l3 <= l2) {
                        ++this.nextSubtitleEventIndex;
                        l3 = this.getNextEventTime();
                        n2 = 1;
                    }
                } else {
                    n2 = 0;
                }
                subtitleOutputBuffer = this.nextSubtitle;
                n3 = n2;
                if (subtitleOutputBuffer == null) break block25;
                if (!subtitleOutputBuffer.isEndOfStream()) break block26;
                n3 = n2;
                if (n2 != 0) break block25;
                n3 = n2;
                if (this.getNextEventTime() == Long.MAX_VALUE) {
                    if (this.decoderReplacementState == 2) {
                        this.replaceDecoder();
                        n3 = n2;
                        break block25;
                    } else {
                        this.releaseBuffers();
                        this.outputStreamEnded = true;
                        n3 = n2;
                    }
                }
                break block25;
            }
            n3 = n2;
            if (this.nextSubtitle.timeUs <= l2) {
                subtitleOutputBuffer = this.subtitle;
                if (subtitleOutputBuffer != null) {
                    subtitleOutputBuffer.release();
                }
                this.subtitle = this.nextSubtitle;
                this.nextSubtitle = null;
                this.nextSubtitleEventIndex = this.subtitle.getNextEventTimeIndex(l2);
                n3 = 1;
            }
        }
        if (n3 != 0) {
            this.updateOutput(this.subtitle.getCues(l2));
        }
        if (this.decoderReplacementState == 2) {
            return;
        }
        try {
            while (!this.inputStreamEnded) {
                if (this.nextInputBuffer == null) {
                    this.nextInputBuffer = (SubtitleInputBuffer)this.decoder.dequeueInputBuffer();
                    if (this.nextInputBuffer == null) {
                        return;
                    }
                }
                if (this.decoderReplacementState == 1) {
                    this.nextInputBuffer.setFlags(4);
                    this.decoder.queueInputBuffer((Object)this.nextInputBuffer);
                    this.nextInputBuffer = null;
                    this.decoderReplacementState = 2;
                    return;
                }
                n2 = this.readSource(this.formatHolder, (DecoderInputBuffer)this.nextInputBuffer, false);
                if (n2 == -4) {
                    if (this.nextInputBuffer.isEndOfStream()) {
                        this.inputStreamEnded = true;
                    } else {
                        this.nextInputBuffer.subsampleOffsetUs = this.formatHolder.format.subsampleOffsetUs;
                        this.nextInputBuffer.flip();
                    }
                    this.decoder.queueInputBuffer((Object)this.nextInputBuffer);
                    this.nextInputBuffer = null;
                    continue;
                }
                if (n2 == -3) return;
            }
            return;
        }
        catch (SubtitleDecoderException subtitleDecoderException) {
            ExoPlaybackException exoPlaybackException = ExoPlaybackException.createForRenderer((Exception)((Object)subtitleDecoderException), this.getIndex());
            throw exoPlaybackException;
        }
    }

    public final int supportsFormat(Format format) {
        if (this.decoderFactory.supportsFormat(format)) {
            int n2 = TextRenderer.supportsFormatDrm(null, (DrmInitData)format.drmInitData) ? 4 : 2;
            return n2;
        }
        if (MimeTypes.isText((String)format.sampleMimeType)) {
            return 1;
        }
        return 0;
    }

    public static interface Output
    extends TextOutput {
    }

    private static @interface ReplacementState {
    }
}

