/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.text;

import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;

public final class CaptionStyleCompat {
    public static final CaptionStyleCompat DEFAULT = new CaptionStyleCompat(-1, -16777216, 0, 0, -1, null);
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int USE_TRACK_COLOR_SETTINGS = 1;
    public final int backgroundColor;
    public final int edgeColor;
    public final int edgeType;
    public final int foregroundColor;
    public final Typeface typeface;
    public final int windowColor;

    public CaptionStyleCompat(int n2, int n3, int n4, int n5, int n6, Typeface typeface) {
        this.foregroundColor = n2;
        this.backgroundColor = n3;
        this.windowColor = n4;
        this.edgeType = n5;
        this.edgeColor = n6;
        this.typeface = typeface;
    }

    public static CaptionStyleCompat createFromCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
        if (Util.SDK_INT >= 21) {
            return CaptionStyleCompat.createFromCaptionStyleV21(captionStyle);
        }
        return CaptionStyleCompat.createFromCaptionStyleV19(captionStyle);
    }

    private static CaptionStyleCompat createFromCaptionStyleV19(CaptioningManager.CaptionStyle captionStyle) {
        return new CaptionStyleCompat(captionStyle.foregroundColor, captionStyle.backgroundColor, 0, captionStyle.edgeType, captionStyle.edgeColor, captionStyle.getTypeface());
    }

    private static CaptionStyleCompat createFromCaptionStyleV21(CaptioningManager.CaptionStyle captionStyle) {
        int n2 = captionStyle.hasForegroundColor() ? captionStyle.foregroundColor : CaptionStyleCompat.DEFAULT.foregroundColor;
        int n3 = captionStyle.hasBackgroundColor() ? captionStyle.backgroundColor : CaptionStyleCompat.DEFAULT.backgroundColor;
        int n4 = captionStyle.hasWindowColor() ? captionStyle.windowColor : CaptionStyleCompat.DEFAULT.windowColor;
        int n5 = captionStyle.hasEdgeType() ? captionStyle.edgeType : CaptionStyleCompat.DEFAULT.edgeType;
        int n6 = captionStyle.hasEdgeColor() ? captionStyle.edgeColor : CaptionStyleCompat.DEFAULT.edgeColor;
        return new CaptionStyleCompat(n2, n3, n4, n5, n6, captionStyle.getTypeface());
    }

    public static @interface EdgeType {
    }
}

