/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.source.chunk;

import android.util.SparseArray;
import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.DummyTrackOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.Extractor;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorInput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.SeekMap;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.TrackOutput;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableByteArray;
import java.io.IOException;

public final class ChunkExtractorWrapper
implements ExtractorOutput {
    private final SparseArray<BindingTrackOutput> bindingTrackOutputs;
    public final Extractor extractor;
    private boolean extractorInitialized;
    private final Format primaryTrackManifestFormat;
    private final int primaryTrackType;
    private Format[] sampleFormats;
    private SeekMap seekMap;
    private TrackOutputProvider trackOutputProvider;

    public ChunkExtractorWrapper(Extractor extractor, int n2, Format format) {
        this.extractor = extractor;
        this.primaryTrackType = n2;
        this.primaryTrackManifestFormat = format;
        this.bindingTrackOutputs = new SparseArray();
    }

    public final void endTracks() {
        Format[] formatArray = new Format[this.bindingTrackOutputs.size()];
        for (int i2 = 0; i2 < this.bindingTrackOutputs.size(); ++i2) {
            formatArray[i2] = ((BindingTrackOutput)this.bindingTrackOutputs.valueAt((int)i2)).sampleFormat;
        }
        this.sampleFormats = formatArray;
    }

    public final Format[] getSampleFormats() {
        return this.sampleFormats;
    }

    public final SeekMap getSeekMap() {
        return this.seekMap;
    }

    public final void init(TrackOutputProvider trackOutputProvider, long l2) {
        this.trackOutputProvider = trackOutputProvider;
        if (!this.extractorInitialized) {
            this.extractor.init((ExtractorOutput)this);
            if (l2 != -9223372036854775807L) {
                this.extractor.seek(0L, l2);
            }
            this.extractorInitialized = true;
        } else {
            Extractor extractor = this.extractor;
            long l3 = l2;
            if (l2 == -9223372036854775807L) {
                l3 = 0L;
            }
            extractor.seek(0L, l3);
            for (int i2 = 0; i2 < this.bindingTrackOutputs.size(); ++i2) {
                ((BindingTrackOutput)this.bindingTrackOutputs.valueAt(i2)).bind(trackOutputProvider);
            }
        }
    }

    public final void seekMap(SeekMap seekMap) {
        this.seekMap = seekMap;
    }

    public final TrackOutput track(int n2, int n3) {
        BindingTrackOutput bindingTrackOutput;
        BindingTrackOutput bindingTrackOutput2 = bindingTrackOutput = (BindingTrackOutput)this.bindingTrackOutputs.get(n2);
        if (bindingTrackOutput == null) {
            boolean bl = this.sampleFormats == null;
            Assertions.checkState(bl);
            bindingTrackOutput2 = n3 == this.primaryTrackType ? this.primaryTrackManifestFormat : null;
            bindingTrackOutput2 = new BindingTrackOutput(n2, n3, (Format)bindingTrackOutput2);
            bindingTrackOutput2.bind(this.trackOutputProvider);
            this.bindingTrackOutputs.put(n2, (Object)bindingTrackOutput2);
        }
        return bindingTrackOutput2;
    }

    private static final class BindingTrackOutput
    implements TrackOutput {
        private final int id;
        private final Format manifestFormat;
        public Format sampleFormat;
        private TrackOutput trackOutput;
        private final int type;

        public BindingTrackOutput(int n2, int n3, Format format) {
            this.id = n2;
            this.type = n3;
            this.manifestFormat = format;
        }

        public final void bind(TrackOutputProvider trackOutputProvider) {
            if (trackOutputProvider == null) {
                this.trackOutput = new DummyTrackOutput();
                return;
            }
            this.trackOutput = trackOutputProvider.track(this.id, this.type);
            trackOutputProvider = this.sampleFormat;
            if (trackOutputProvider != null) {
                this.trackOutput.format((Format)trackOutputProvider);
            }
        }

        public final void format(Format format) {
            Format format2 = this.manifestFormat;
            Format format3 = format;
            if (format2 != null) {
                format3 = format.copyWithManifestFormatInfo(format2);
            }
            this.sampleFormat = format3;
            this.trackOutput.format(this.sampleFormat);
        }

        public final int sampleData(ExtractorInput extractorInput, int n2, boolean bl) throws IOException, InterruptedException {
            return this.trackOutput.sampleData(extractorInput, n2, bl);
        }

        public final void sampleData(ParsableByteArray parsableByteArray, int n2) {
            this.trackOutput.sampleData(parsableByteArray, n2);
        }

        public final void sampleMetadata(long l2, int n2, int n3, int n4, TrackOutput.CryptoData cryptoData) {
            this.trackOutput.sampleMetadata(l2, n2, n3, n4, cryptoData);
        }
    }

    public static interface TrackOutputProvider {
        public TrackOutput track(int var1, int var2);
    }
}

