/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.source.ads;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.ViewGroup;
import com.mbridge.msdk.playercommon.exoplayer2.ExoPlayer;
import com.mbridge.msdk.playercommon.exoplayer2.Timeline;
import com.mbridge.msdk.playercommon.exoplayer2.source.CompositeMediaSource;
import com.mbridge.msdk.playercommon.exoplayer2.source.DeferredMediaPeriod;
import com.mbridge.msdk.playercommon.exoplayer2.source.ExtractorMediaSource;
import com.mbridge.msdk.playercommon.exoplayer2.source.MediaPeriod;
import com.mbridge.msdk.playercommon.exoplayer2.source.MediaSource;
import com.mbridge.msdk.playercommon.exoplayer2.source.ads.AdPlaybackState;
import com.mbridge.msdk.playercommon.exoplayer2.source.ads.AdsLoader;
import com.mbridge.msdk.playercommon.exoplayer2.source.ads.SinglePeriodAdTimeline;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.Allocator;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSource;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSpec;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AdsMediaSource
extends CompositeMediaSource<MediaSource.MediaPeriodId> {
    private static final String TAG = "AdsMediaSource";
    private long[][] adDurationsUs;
    private MediaSource[][] adGroupMediaSources;
    private final MediaSourceFactory adMediaSourceFactory;
    private AdPlaybackState adPlaybackState;
    private final ViewGroup adUiViewGroup;
    private final AdsLoader adsLoader;
    private ComponentListener componentListener;
    private Object contentManifest;
    private final MediaSource contentMediaSource;
    private Timeline contentTimeline;
    private final Map<MediaSource, List<DeferredMediaPeriod>> deferredMediaPeriodByAdMediaSource;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final Handler mainHandler;
    private final Timeline.Period period;

    public AdsMediaSource(MediaSource mediaSource, MediaSourceFactory mediaSourceFactory, AdsLoader adsLoader, ViewGroup viewGroup) {
        this(mediaSource, mediaSourceFactory, adsLoader, viewGroup, null, null);
    }

    public AdsMediaSource(MediaSource mediaSource, MediaSourceFactory mediaSourceFactory, AdsLoader adsLoader, ViewGroup viewGroup, Handler handler, EventListener eventListener) {
        this.contentMediaSource = mediaSource;
        this.adMediaSourceFactory = mediaSourceFactory;
        this.adsLoader = adsLoader;
        this.adUiViewGroup = viewGroup;
        this.eventHandler = handler;
        this.eventListener = eventListener;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.deferredMediaPeriodByAdMediaSource = new HashMap<MediaSource, List<DeferredMediaPeriod>>();
        this.period = new Timeline.Period();
        this.adGroupMediaSources = new MediaSource[0][];
        this.adDurationsUs = new long[0][];
        adsLoader.setSupportedContentTypes(mediaSourceFactory.getSupportedTypes());
    }

    public AdsMediaSource(MediaSource mediaSource, DataSource.Factory factory, AdsLoader adsLoader, ViewGroup viewGroup) {
        this(mediaSource, (MediaSourceFactory)new ExtractorMediaSource.Factory(factory), adsLoader, viewGroup, null, null);
    }

    public AdsMediaSource(MediaSource mediaSource, DataSource.Factory factory, AdsLoader adsLoader, ViewGroup viewGroup, Handler handler, EventListener eventListener) {
        this(mediaSource, (MediaSourceFactory)new ExtractorMediaSource.Factory(factory), adsLoader, viewGroup, handler, eventListener);
    }

    private void maybeUpdateSourceInfo() {
        AdPlaybackState adPlaybackState = this.adPlaybackState;
        if (adPlaybackState != null && this.contentTimeline != null) {
            this.adPlaybackState = adPlaybackState.withAdDurationsUs(this.adDurationsUs);
            adPlaybackState = this.adPlaybackState.adGroupCount == 0 ? this.contentTimeline : new SinglePeriodAdTimeline(this.contentTimeline, this.adPlaybackState);
            this.refreshSourceInfo((Timeline)adPlaybackState, this.contentManifest);
        }
    }

    private void onAdPlaybackState(AdPlaybackState adPlaybackState) {
        if (this.adPlaybackState == null) {
            this.adGroupMediaSources = new MediaSource[adPlaybackState.adGroupCount][];
            Arrays.fill((Object[])this.adGroupMediaSources, new MediaSource[0]);
            this.adDurationsUs = new long[adPlaybackState.adGroupCount][];
            Arrays.fill((Object[])this.adDurationsUs, new long[0]);
        }
        this.adPlaybackState = adPlaybackState;
        this.maybeUpdateSourceInfo();
    }

    private void onAdSourceInfoRefreshed(MediaSource mediaSource, int n2, int n3, Timeline object) {
        int n4 = object.getPeriodCount();
        int n5 = 0;
        boolean bl = true;
        if (n4 != 1) {
            bl = false;
        }
        Assertions.checkArgument(bl);
        this.adDurationsUs[n2][n3] = object.getPeriod(0, this.period).getDurationUs();
        if (this.deferredMediaPeriodByAdMediaSource.containsKey(mediaSource)) {
            object = this.deferredMediaPeriodByAdMediaSource.get(mediaSource);
            for (n2 = n5; n2 < object.size(); ++n2) {
                ((DeferredMediaPeriod)object.get(n2)).createPeriod();
            }
            this.deferredMediaPeriodByAdMediaSource.remove(mediaSource);
        }
        this.maybeUpdateSourceInfo();
    }

    private void onContentSourceInfoRefreshed(Timeline timeline, Object object) {
        this.contentTimeline = timeline;
        this.contentManifest = object;
        this.maybeUpdateSourceInfo();
    }

    public final MediaPeriod createPeriod(MediaSource.MediaPeriodId object, Allocator object2) {
        if (this.adPlaybackState.adGroupCount > 0 && ((MediaSource.MediaPeriodId)object).isAd()) {
            MediaSource mediaSource;
            int n2 = ((MediaSource.MediaPeriodId)object).adGroupIndex;
            int n3 = ((MediaSource.MediaPeriodId)object).adIndexInAdGroup;
            Uri uri = this.adPlaybackState.adGroups[n2].uris[n3];
            if (this.adGroupMediaSources[n2].length <= n3) {
                mediaSource = this.adMediaSourceFactory.createMediaSource(uri);
                Object object3 = this.adGroupMediaSources;
                int n4 = object3[n2].length;
                if (n3 >= n4) {
                    int n5 = n3 + 1;
                    object3[n2] = Arrays.copyOf(object3[n2], n5);
                    object3 = this.adDurationsUs;
                    object3[n2] = (MediaSource[])Arrays.copyOf((long[])object3[n2], n5);
                    Arrays.fill(this.adDurationsUs[n2], n4, n5, -9223372036854775807L);
                }
                this.adGroupMediaSources[n2][n3] = mediaSource;
                this.deferredMediaPeriodByAdMediaSource.put(mediaSource, new ArrayList());
                this.prepareChildSource(object, mediaSource);
            }
            mediaSource = this.adGroupMediaSources[n2][n3];
            object = new DeferredMediaPeriod(mediaSource, new MediaSource.MediaPeriodId(0, ((MediaSource.MediaPeriodId)object).windowSequenceNumber), (Allocator)object2);
            ((DeferredMediaPeriod)object).setPrepareErrorListener(new AdPrepareErrorListener(uri, n2, n3));
            object2 = this.deferredMediaPeriodByAdMediaSource.get(mediaSource);
            if (object2 == null) {
                ((DeferredMediaPeriod)object).createPeriod();
            } else {
                object2.add(object);
            }
            return object;
        }
        object = new DeferredMediaPeriod(this.contentMediaSource, (MediaSource.MediaPeriodId)object, (Allocator)object2);
        ((DeferredMediaPeriod)object).createPeriod();
        return object;
    }

    protected final MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(MediaSource.MediaPeriodId mediaPeriodId, MediaSource.MediaPeriodId mediaPeriodId2) {
        if (!mediaPeriodId.isAd()) {
            mediaPeriodId = mediaPeriodId2;
        }
        return mediaPeriodId;
    }

    protected final void onChildSourceInfoRefreshed(MediaSource.MediaPeriodId mediaPeriodId, MediaSource mediaSource, Timeline timeline, Object object) {
        if (mediaPeriodId.isAd()) {
            this.onAdSourceInfoRefreshed(mediaSource, mediaPeriodId.adGroupIndex, mediaPeriodId.adIndexInAdGroup, timeline);
        } else {
            this.onContentSourceInfoRefreshed(timeline, object);
        }
    }

    public final void prepareSourceInternal(final ExoPlayer exoPlayer, boolean bl) {
        ComponentListener componentListener;
        super.prepareSourceInternal(exoPlayer, bl);
        Assertions.checkArgument(bl);
        this.componentListener = componentListener = new ComponentListener();
        this.prepareChildSource(new MediaSource.MediaPeriodId(0), this.contentMediaSource);
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                AdsMediaSource.this.adsLoader.attachPlayer(exoPlayer, (AdsLoader.EventListener)componentListener, AdsMediaSource.this.adUiViewGroup);
            }
        });
    }

    public final void releasePeriod(MediaPeriod mediaPeriod) {
        mediaPeriod = (DeferredMediaPeriod)mediaPeriod;
        List<DeferredMediaPeriod> list = this.deferredMediaPeriodByAdMediaSource.get(mediaPeriod.mediaSource);
        if (list != null) {
            list.remove(mediaPeriod);
        }
        mediaPeriod.releasePeriod();
    }

    public final void releaseSourceInternal() {
        super.releaseSourceInternal();
        this.componentListener.release();
        this.componentListener = null;
        this.deferredMediaPeriodByAdMediaSource.clear();
        this.contentTimeline = null;
        this.contentManifest = null;
        this.adPlaybackState = null;
        this.adGroupMediaSources = new MediaSource[0][];
        this.adDurationsUs = new long[0][];
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                AdsMediaSource.this.adsLoader.detachPlayer();
            }
        });
    }

    public static final class AdLoadException
    extends IOException {
        public static final int TYPE_AD = 0;
        public static final int TYPE_AD_GROUP = 1;
        public static final int TYPE_ALL_ADS = 2;
        public static final int TYPE_UNEXPECTED = 3;
        public final int type;

        private AdLoadException(int n2, Exception exception) {
            super(exception);
            this.type = n2;
        }

        public static AdLoadException createForAd(Exception exception) {
            return new AdLoadException(0, exception);
        }

        public static AdLoadException createForAdGroup(Exception exception, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to load ad group ");
            stringBuilder.append(n2);
            return new AdLoadException(1, new IOException(stringBuilder.toString(), exception));
        }

        public static AdLoadException createForAllAds(Exception exception) {
            return new AdLoadException(2, exception);
        }

        public static AdLoadException createForUnexpected(RuntimeException runtimeException) {
            return new AdLoadException(3, runtimeException);
        }

        public final RuntimeException getRuntimeExceptionForUnexpected() {
            boolean bl = this.type == 3;
            Assertions.checkState(bl);
            return (RuntimeException)this.getCause();
        }

        public static @interface Type {
        }
    }

    private final class AdPrepareErrorListener
    implements DeferredMediaPeriod.PrepareErrorListener {
        private final int adGroupIndex;
        private final int adIndexInAdGroup;
        private final Uri adUri;

        public AdPrepareErrorListener(Uri uri, int n2, int n3) {
            this.adUri = uri;
            this.adGroupIndex = n2;
            this.adIndexInAdGroup = n3;
        }

        @Override
        public final void onPrepareError(MediaSource.MediaPeriodId mediaPeriodId, final IOException iOException) {
            AdsMediaSource.this.createEventDispatcher(mediaPeriodId).loadError(new DataSpec(this.adUri), 6, -1L, 0L, 0L, (IOException)AdLoadException.createForAd(iOException), true);
            AdsMediaSource.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    AdsMediaSource.this.adsLoader.handlePrepareError(AdPrepareErrorListener.this.adGroupIndex, AdPrepareErrorListener.this.adIndexInAdGroup, iOException);
                }
            });
        }
    }

    private final class ComponentListener
    implements AdsLoader.EventListener {
        private final Handler playerHandler = new Handler();
        private volatile boolean released;

        public final void onAdClicked() {
            if (this.released) {
                return;
            }
            if (AdsMediaSource.this.eventHandler != null && AdsMediaSource.this.eventListener != null) {
                AdsMediaSource.this.eventHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!ComponentListener.this.released) {
                            AdsMediaSource.this.eventListener.onAdClicked();
                        }
                    }
                });
            }
        }

        public final void onAdLoadError(final AdLoadException adLoadException, DataSpec dataSpec) {
            if (this.released) {
                return;
            }
            AdsMediaSource.this.createEventDispatcher(null).loadError(dataSpec, 6, -1L, 0L, 0L, (IOException)adLoadException, true);
            if (AdsMediaSource.this.eventHandler != null && AdsMediaSource.this.eventListener != null) {
                AdsMediaSource.this.eventHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!ComponentListener.this.released) {
                            if (adLoadException.type == 3) {
                                AdsMediaSource.this.eventListener.onInternalAdLoadError(adLoadException.getRuntimeExceptionForUnexpected());
                            } else {
                                AdsMediaSource.this.eventListener.onAdLoadError(adLoadException);
                            }
                        }
                    }
                });
            }
        }

        public final void onAdPlaybackState(final AdPlaybackState adPlaybackState) {
            if (this.released) {
                return;
            }
            this.playerHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (ComponentListener.this.released) {
                        return;
                    }
                    AdsMediaSource.this.onAdPlaybackState(adPlaybackState);
                }
            });
        }

        public final void onAdTapped() {
            if (this.released) {
                return;
            }
            if (AdsMediaSource.this.eventHandler != null && AdsMediaSource.this.eventListener != null) {
                AdsMediaSource.this.eventHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!ComponentListener.this.released) {
                            AdsMediaSource.this.eventListener.onAdTapped();
                        }
                    }
                });
            }
        }

        public final void release() {
            this.released = true;
            this.playerHandler.removeCallbacksAndMessages(null);
        }
    }

    public static interface EventListener {
        public void onAdClicked();

        public void onAdLoadError(IOException var1);

        public void onAdTapped();

        public void onInternalAdLoadError(RuntimeException var1);
    }

    public static interface MediaSourceFactory {
        public MediaSource createMediaSource(Uri var1);

        public int[] getSupportedTypes();
    }
}

