/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.source.ads;

import android.net.Uri;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import java.util.Arrays;

public final class AdPlaybackState {
    public static final int AD_STATE_AVAILABLE = 1;
    public static final int AD_STATE_ERROR = 4;
    public static final int AD_STATE_PLAYED = 3;
    public static final int AD_STATE_SKIPPED = 2;
    public static final int AD_STATE_UNAVAILABLE = 0;
    public static final AdPlaybackState NONE = new AdPlaybackState(new long[0]);
    public final int adGroupCount;
    public final long[] adGroupTimesUs;
    public final AdGroup[] adGroups;
    public final long adResumePositionUs;
    public final long contentDurationUs;

    public AdPlaybackState(long ... lArray) {
        int n2;
        this.adGroupCount = n2 = lArray.length;
        this.adGroupTimesUs = Arrays.copyOf(lArray, n2);
        this.adGroups = new AdGroup[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.adGroups[i2] = new AdGroup();
        }
        this.adResumePositionUs = 0L;
        this.contentDurationUs = -9223372036854775807L;
    }

    private AdPlaybackState(long[] lArray, AdGroup[] adGroupArray, long l2, long l3) {
        this.adGroupCount = adGroupArray.length;
        this.adGroupTimesUs = lArray;
        this.adGroups = adGroupArray;
        this.adResumePositionUs = l2;
        this.contentDurationUs = l3;
    }

    public final int getAdGroupIndexAfterPositionUs(long l2) {
        long[] lArray;
        int n2;
        for (n2 = 0; !(n2 >= (lArray = this.adGroupTimesUs).length || lArray[n2] == Long.MIN_VALUE || l2 < lArray[n2] && this.adGroups[n2].hasUnplayedAds()); ++n2) {
        }
        if (n2 >= this.adGroupTimesUs.length) {
            n2 = -1;
        }
        return n2;
    }

    public final int getAdGroupIndexForPositionUs(long l2) {
        long[] lArray;
        int n2;
        for (n2 = this.adGroupTimesUs.length - 1; n2 >= 0 && ((lArray = this.adGroupTimesUs)[n2] == Long.MIN_VALUE || lArray[n2] > l2); --n2) {
        }
        if (n2 < 0 || !this.adGroups[n2].hasUnplayedAds()) {
            n2 = -1;
        }
        return n2;
    }

    public final AdPlaybackState withAdCount(int n2, int n3) {
        boolean bl = n3 > 0;
        Assertions.checkArgument(bl);
        if (this.adGroups[n2].count == n3) {
            return this;
        }
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Arrays.copyOf(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = this.adGroups[n2].withAdCount(n3);
        return new AdPlaybackState(this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public final AdPlaybackState withAdDurationsUs(long[][] lArray) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Arrays.copyOf(adGroupArray, adGroupArray.length);
        for (int i2 = 0; i2 < this.adGroupCount; ++i2) {
            adGroupArray[i2] = adGroupArray[i2].withAdDurationsUs(lArray[i2]);
        }
        return new AdPlaybackState(this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public final AdPlaybackState withAdLoadError(int n2, int n3) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Arrays.copyOf(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAdState(4, n3);
        return new AdPlaybackState(this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public final AdPlaybackState withAdResumePositionUs(long l2) {
        if (this.adResumePositionUs == l2) {
            return this;
        }
        return new AdPlaybackState(this.adGroupTimesUs, this.adGroups, l2, this.contentDurationUs);
    }

    public final AdPlaybackState withAdUri(int n2, int n3, Uri uri) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Arrays.copyOf(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAdUri(uri, n3);
        return new AdPlaybackState(this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public final AdPlaybackState withContentDurationUs(long l2) {
        if (this.contentDurationUs == l2) {
            return this;
        }
        return new AdPlaybackState(this.adGroupTimesUs, this.adGroups, this.adResumePositionUs, l2);
    }

    public final AdPlaybackState withPlayedAd(int n2, int n3) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Arrays.copyOf(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAdState(3, n3);
        return new AdPlaybackState(this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public final AdPlaybackState withSkippedAd(int n2, int n3) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Arrays.copyOf(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAdState(2, n3);
        return new AdPlaybackState(this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public final AdPlaybackState withSkippedAdGroup(int n2) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Arrays.copyOf(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAllAdsSkipped();
        return new AdPlaybackState(this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public static final class AdGroup {
        public final int count;
        public final long[] durationsUs;
        public final int[] states;
        public final Uri[] uris;

        public AdGroup() {
            this(-1, new int[0], new Uri[0], new long[0]);
        }

        private AdGroup(int n2, int[] nArray, Uri[] uriArray, long[] lArray) {
            boolean bl = nArray.length == uriArray.length;
            Assertions.checkArgument(bl);
            this.count = n2;
            this.states = nArray;
            this.uris = uriArray;
            this.durationsUs = lArray;
        }

        private static long[] copyDurationsUsWithSpaceForAdCount(long[] lArray, int n2) {
            int n3 = lArray.length;
            n2 = Math.max(n2, n3);
            lArray = Arrays.copyOf(lArray, n2);
            Arrays.fill(lArray, n3, n2, -9223372036854775807L);
            return lArray;
        }

        private static int[] copyStatesWithSpaceForAdCount(int[] nArray, int n2) {
            int n3 = nArray.length;
            n2 = Math.max(n2, n3);
            nArray = Arrays.copyOf(nArray, n2);
            Arrays.fill(nArray, n3, n2, 0);
            return nArray;
        }

        public final int getFirstAdIndexToPlay() {
            return this.getNextAdIndexToPlay(-1);
        }

        public final int getNextAdIndexToPlay(int n2) {
            int[] nArray;
            ++n2;
            while (n2 < (nArray = this.states).length && nArray[n2] != 0 && nArray[n2] != 1) {
                ++n2;
            }
            return n2;
        }

        public final boolean hasUnplayedAds() {
            boolean bl = this.count == -1 || this.getFirstAdIndexToPlay() < this.count;
            return bl;
        }

        public final AdGroup withAdCount(int n2) {
            boolean bl = this.count == -1 && this.states.length <= n2;
            Assertions.checkArgument(bl);
            int[] nArray = AdGroup.copyStatesWithSpaceForAdCount(this.states, n2);
            long[] lArray = AdGroup.copyDurationsUsWithSpaceForAdCount(this.durationsUs, n2);
            return new AdGroup(n2, nArray, Arrays.copyOf(this.uris, n2), lArray);
        }

        public final AdGroup withAdDurationsUs(long[] lArray) {
            boolean bl = this.count == -1 || lArray.length <= this.uris.length;
            Assertions.checkArgument(bl);
            int n2 = lArray.length;
            Uri[] uriArray = this.uris;
            long[] lArray2 = lArray;
            if (n2 < uriArray.length) {
                lArray2 = AdGroup.copyDurationsUsWithSpaceForAdCount(lArray, uriArray.length);
            }
            return new AdGroup(this.count, this.states, this.uris, lArray2);
        }

        public final AdGroup withAdState(int n2, int n3) {
            int[] nArray;
            boolean bl;
            block6: {
                block5: {
                    int n4 = this.count;
                    boolean bl2 = false;
                    bl = n4 == -1 || n3 < n4;
                    Assertions.checkArgument(bl);
                    nArray = AdGroup.copyStatesWithSpaceForAdCount(this.states, n3 + 1);
                    if (nArray[n3] == 0 || nArray[n3] == 1) break block5;
                    bl = bl2;
                    if (nArray[n3] != n2) break block6;
                }
                bl = true;
            }
            Assertions.checkArgument(bl);
            long[] lArray = this.durationsUs;
            if (lArray.length != nArray.length) {
                lArray = AdGroup.copyDurationsUsWithSpaceForAdCount(lArray, nArray.length);
            }
            Uri[] uriArray = this.uris;
            if (uriArray.length != nArray.length) {
                uriArray = Arrays.copyOf(uriArray, nArray.length);
            }
            nArray[n3] = n2;
            return new AdGroup(this.count, nArray, uriArray, lArray);
        }

        public final AdGroup withAdUri(Uri uri, int n2) {
            int n3 = this.count;
            boolean bl = false;
            boolean bl2 = n3 == -1 || n2 < n3;
            Assertions.checkArgument(bl2);
            int[] nArray = AdGroup.copyStatesWithSpaceForAdCount(this.states, n2 + 1);
            bl2 = bl;
            if (nArray[n2] == 0) {
                bl2 = true;
            }
            Assertions.checkArgument(bl2);
            long[] lArray = this.durationsUs;
            if (lArray.length != nArray.length) {
                lArray = AdGroup.copyDurationsUsWithSpaceForAdCount(lArray, nArray.length);
            }
            Uri[] uriArray = Arrays.copyOf(this.uris, nArray.length);
            uriArray[n2] = uri;
            nArray[n2] = 1;
            return new AdGroup(this.count, nArray, uriArray, lArray);
        }

        public final AdGroup withAllAdsSkipped() {
            int n2 = this.count;
            if (n2 == -1) {
                return new AdGroup(0, new int[0], new Uri[0], new long[0]);
            }
            int[] nArray = this.states;
            n2 = nArray.length;
            nArray = Arrays.copyOf(nArray, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (nArray[i2] != 1 && nArray[i2] != 0) continue;
                nArray[i2] = 2;
            }
            return new AdGroup(n2, nArray, this.uris, this.durationsUs);
        }
    }

    public static @interface AdState {
    }
}

