/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.source;

import java.util.Arrays;
import java.util.Random;

public interface ShuffleOrder {
    public ShuffleOrder cloneAndClear();

    public ShuffleOrder cloneAndInsert(int var1, int var2);

    public ShuffleOrder cloneAndRemove(int var1);

    public int getFirstIndex();

    public int getLastIndex();

    public int getLength();

    public int getNextIndex(int var1);

    public int getPreviousIndex(int var1);

    public static class DefaultShuffleOrder
    implements ShuffleOrder {
        private final int[] indexInShuffled;
        private final Random random;
        private final int[] shuffled;

        public DefaultShuffleOrder(int n2) {
            this(n2, new Random());
        }

        public DefaultShuffleOrder(int n2, long l2) {
            this(n2, new Random(l2));
        }

        private DefaultShuffleOrder(int n2, Random random) {
            this(DefaultShuffleOrder.createShuffledList(n2, random), random);
        }

        private DefaultShuffleOrder(int[] nArray, Random random) {
            this.shuffled = nArray;
            this.random = random;
            this.indexInShuffled = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.indexInShuffled[nArray[i2]] = i2;
            }
        }

        private static int[] createShuffledList(int n2, Random random) {
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 + 1;
                int n5 = random.nextInt(n4);
                nArray[n3] = nArray[n5];
                nArray[n5] = n3;
                n3 = n4;
            }
            return nArray;
        }

        @Override
        public ShuffleOrder cloneAndClear() {
            return new DefaultShuffleOrder(0, new Random(this.random.nextLong()));
        }

        @Override
        public ShuffleOrder cloneAndInsert(int n2, int n3) {
            int n4;
            int n5;
            Object object;
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            int n6 = 0;
            int n7 = 0;
            while (n7 < n3) {
                nArray[n7] = this.random.nextInt(this.shuffled.length + 1);
                object = this.random;
                n5 = n7 + 1;
                n4 = ((Random)object).nextInt(n5);
                nArray2[n7] = nArray2[n4];
                nArray2[n4] = n7 + n2;
                n7 = n5;
            }
            Arrays.sort(nArray);
            object = new int[this.shuffled.length + n3];
            n4 = 0;
            n5 = 0;
            for (n7 = n6; n7 < this.shuffled.length + n3; ++n7) {
                if (n4 < n3 && n5 == nArray[n4]) {
                    object[n7] = nArray2[n4];
                    ++n4;
                    continue;
                }
                object[n7] = this.shuffled[n5];
                if (object[n7] >= n2) {
                    object[n7] = object[n7] + n3;
                }
                ++n5;
            }
            return new DefaultShuffleOrder((int[])object, new Random(this.random.nextLong()));
        }

        @Override
        public ShuffleOrder cloneAndRemove(int n2) {
            int[] nArray;
            int[] nArray2 = new int[this.shuffled.length - 1];
            boolean bl = false;
            for (int i2 = 0; i2 < (nArray = this.shuffled).length; ++i2) {
                if (nArray[i2] == n2) {
                    bl = true;
                    continue;
                }
                int n3 = bl ? i2 - 1 : i2;
                nArray = this.shuffled;
                int n4 = nArray[i2] > n2 ? nArray[i2] - 1 : nArray[i2];
                nArray2[n3] = n4;
            }
            return new DefaultShuffleOrder(nArray2, new Random(this.random.nextLong()));
        }

        @Override
        public int getFirstIndex() {
            int[] nArray = this.shuffled;
            int n2 = nArray.length > 0 ? nArray[0] : -1;
            return n2;
        }

        @Override
        public int getLastIndex() {
            int[] nArray = this.shuffled;
            int n2 = nArray.length > 0 ? nArray[nArray.length - 1] : -1;
            return n2;
        }

        @Override
        public int getLength() {
            return this.shuffled.length;
        }

        @Override
        public int getNextIndex(int n2) {
            int[] nArray = this.shuffled;
            n2 = (n2 = this.indexInShuffled[n2] + 1) < nArray.length ? nArray[n2] : -1;
            return n2;
        }

        @Override
        public int getPreviousIndex(int n2) {
            int n3 = this.indexInShuffled[n2];
            n2 = -1;
            if (--n3 >= 0) {
                n2 = this.shuffled[n3];
            }
            return n2;
        }
    }

    public static final class UnshuffledShuffleOrder
    implements ShuffleOrder {
        private final int length;

        public UnshuffledShuffleOrder(int n2) {
            this.length = n2;
        }

        @Override
        public final ShuffleOrder cloneAndClear() {
            return new UnshuffledShuffleOrder(0);
        }

        @Override
        public final ShuffleOrder cloneAndInsert(int n2, int n3) {
            return new UnshuffledShuffleOrder(this.length + n3);
        }

        @Override
        public final ShuffleOrder cloneAndRemove(int n2) {
            return new UnshuffledShuffleOrder(this.length - 1);
        }

        @Override
        public final int getFirstIndex() {
            int n2 = this.length > 0 ? 0 : -1;
            return n2;
        }

        @Override
        public final int getLastIndex() {
            int n2 = this.length;
            n2 = n2 > 0 ? --n2 : -1;
            return n2;
        }

        @Override
        public final int getLength() {
            return this.length;
        }

        @Override
        public final int getNextIndex(int n2) {
            if (++n2 >= this.length) {
                n2 = -1;
            }
            return n2;
        }

        @Override
        public final int getPreviousIndex(int n2) {
            if (--n2 < 0) {
                n2 = -1;
            }
            return n2;
        }
    }
}

