/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.source;

import com.mbridge.msdk.playercommon.exoplayer2.ExoPlayer;
import com.mbridge.msdk.playercommon.exoplayer2.Timeline;
import com.mbridge.msdk.playercommon.exoplayer2.source.CompositeMediaSource;
import com.mbridge.msdk.playercommon.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.mbridge.msdk.playercommon.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.mbridge.msdk.playercommon.exoplayer2.source.MediaPeriod;
import com.mbridge.msdk.playercommon.exoplayer2.source.MediaSource;
import com.mbridge.msdk.playercommon.exoplayer2.source.MergingMediaPeriod;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.Allocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public final class MergingMediaSource
extends CompositeMediaSource<Integer> {
    private static final int PERIOD_COUNT_UNSET = -1;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final MediaSource[] mediaSources;
    private IllegalMergeException mergeError;
    private final ArrayList<MediaSource> pendingTimelineSources;
    private int periodCount;
    private Object primaryManifest;
    private Timeline primaryTimeline;

    public MergingMediaSource(CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, MediaSource ... mediaSourceArray) {
        this.mediaSources = mediaSourceArray;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.pendingTimelineSources = new ArrayList<MediaSource>(Arrays.asList(mediaSourceArray));
        this.periodCount = -1;
    }

    public MergingMediaSource(MediaSource ... mediaSourceArray) {
        this((CompositeSequenceableLoaderFactory)new DefaultCompositeSequenceableLoaderFactory(), mediaSourceArray);
    }

    private IllegalMergeException checkTimelineMerges(Timeline timeline) {
        if (this.periodCount == -1) {
            this.periodCount = timeline.getPeriodCount();
        } else if (timeline.getPeriodCount() != this.periodCount) {
            return new IllegalMergeException(0);
        }
        return null;
    }

    public final MediaPeriod createPeriod(MediaSource.MediaPeriodId mediaPeriodId, Allocator allocator) {
        MediaPeriod[] mediaPeriodArray = new MediaPeriod[this.mediaSources.length];
        for (int i2 = 0; i2 < mediaPeriodArray.length; ++i2) {
            mediaPeriodArray[i2] = this.mediaSources[i2].createPeriod(mediaPeriodId, allocator);
        }
        return new MergingMediaPeriod(this.compositeSequenceableLoaderFactory, mediaPeriodArray);
    }

    public final void maybeThrowSourceInfoRefreshError() throws IOException {
        IllegalMergeException illegalMergeException = this.mergeError;
        if (illegalMergeException == null) {
            super.maybeThrowSourceInfoRefreshError();
            return;
        }
        throw illegalMergeException;
    }

    protected final void onChildSourceInfoRefreshed(Integer n2, MediaSource mediaSource, Timeline timeline, Object object) {
        if (this.mergeError == null) {
            this.mergeError = this.checkTimelineMerges(timeline);
        }
        if (this.mergeError != null) {
            return;
        }
        this.pendingTimelineSources.remove(mediaSource);
        if (mediaSource == this.mediaSources[0]) {
            this.primaryTimeline = timeline;
            this.primaryManifest = object;
        }
        if (this.pendingTimelineSources.isEmpty()) {
            this.refreshSourceInfo(this.primaryTimeline, this.primaryManifest);
        }
    }

    public final void prepareSourceInternal(ExoPlayer exoPlayer, boolean bl) {
        super.prepareSourceInternal(exoPlayer, bl);
        for (int i2 = 0; i2 < this.mediaSources.length; ++i2) {
            this.prepareChildSource(i2, this.mediaSources[i2]);
        }
    }

    public final void releasePeriod(MediaPeriod mediaSourceArray) {
        MergingMediaPeriod mergingMediaPeriod = (MergingMediaPeriod)mediaSourceArray;
        for (int i2 = 0; i2 < (mediaSourceArray = this.mediaSources).length; ++i2) {
            mediaSourceArray[i2].releasePeriod(mergingMediaPeriod.periods[i2]);
        }
    }

    public final void releaseSourceInternal() {
        super.releaseSourceInternal();
        this.primaryTimeline = null;
        this.primaryManifest = null;
        this.periodCount = -1;
        this.mergeError = null;
        this.pendingTimelineSources.clear();
        Collections.addAll(this.pendingTimelineSources, this.mediaSources);
    }

    public static final class IllegalMergeException
    extends IOException {
        public static final int REASON_PERIOD_COUNT_MISMATCH = 0;
        public final int reason;

        public IllegalMergeException(int n2) {
            this.reason = n2;
        }

        public static @interface Reason {
        }
    }
}

