/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.scheduler;

import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.PowerManager;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;

public final class Requirements {
    private static final int DEVICE_CHARGING = 16;
    private static final int DEVICE_IDLE = 8;
    public static final int NETWORK_TYPE_ANY = 1;
    private static final int NETWORK_TYPE_MASK = 7;
    public static final int NETWORK_TYPE_METERED = 4;
    public static final int NETWORK_TYPE_NONE = 0;
    public static final int NETWORK_TYPE_NOT_ROAMING = 3;
    private static final String[] NETWORK_TYPE_STRINGS;
    public static final int NETWORK_TYPE_UNMETERED = 2;
    private static final String TAG = "Requirements";
    private final int requirements;

    public Requirements(int n2) {
        this.requirements = n2;
    }

    public Requirements(int n2, boolean bl, boolean bl2) {
        int n3 = 0;
        int n4 = bl ? 16 : 0;
        if (bl2) {
            n3 = 8;
        }
        this(n2 | n4 | n3);
    }

    private boolean checkChargingRequirement(Context context) {
        if (!this.isChargingRequired()) {
            return true;
        }
        context = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        boolean bl = false;
        if (context == null) {
            return false;
        }
        int n2 = context.getIntExtra("status", -1);
        if (n2 == 2 || n2 == 5) {
            bl = true;
        }
        return bl;
    }

    private boolean checkIdleRequirement(Context context) {
        boolean bl;
        block1: {
            boolean bl2 = this.isIdleRequired();
            bl = true;
            if (!bl2) {
                return true;
            }
            context = (PowerManager)context.getSystemService("power");
            if (Util.SDK_INT >= 23 ? !context.isDeviceIdleMode() : (Util.SDK_INT >= 20 ? !context.isInteractive() : !context.isScreenOn())) break block1;
            bl = false;
        }
        return bl;
    }

    private static boolean checkInternetConnectivity(ConnectivityManager object) {
        if (Util.SDK_INT < 23) {
            return true;
        }
        Network network = object.getActiveNetwork();
        boolean bl = false;
        if (network == null) {
            Requirements.logd("No active network.");
            return false;
        }
        if ((object = object.getNetworkCapabilities(network)) == null || !object.hasCapability(16)) {
            bl = true;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Network capability validated: ");
        ((StringBuilder)object).append(bl);
        Requirements.logd(((StringBuilder)object).toString());
        return bl ^ true;
    }

    private boolean checkNetworkRequirements(Context object) {
        int n2 = this.getRequiredNetworkType();
        if (n2 == 0) {
            return true;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object.getSystemService("connectivity");
        if ((object = connectivityManager.getActiveNetworkInfo()) != null && object.isConnected()) {
            if (!Requirements.checkInternetConnectivity(connectivityManager)) {
                return false;
            }
            if (n2 == 1) {
                return true;
            }
            if (n2 == 3) {
                boolean bl = object.isRoaming();
                object = new StringBuilder();
                ((StringBuilder)object).append("Roaming: ");
                ((StringBuilder)object).append(bl);
                Requirements.logd(((StringBuilder)object).toString());
                return bl ^ true;
            }
            boolean bl = Requirements.isActiveNetworkMetered(connectivityManager, (NetworkInfo)object);
            object = new StringBuilder();
            ((StringBuilder)object).append("Metered network: ");
            ((StringBuilder)object).append(bl);
            Requirements.logd(((StringBuilder)object).toString());
            if (n2 == 2) {
                return bl ^ true;
            }
            if (n2 == 4) {
                return bl;
            }
            throw new IllegalStateException();
        }
        Requirements.logd("No network info or no connection.");
        return false;
    }

    private static boolean isActiveNetworkMetered(ConnectivityManager connectivityManager, NetworkInfo networkInfo) {
        if (Util.SDK_INT >= 16) {
            return connectivityManager.isActiveNetworkMetered();
        }
        int n2 = networkInfo.getType();
        boolean bl = true;
        if (n2 == 1 || n2 == 7 || n2 == 9) {
            bl = false;
        }
        return bl;
    }

    private static void logd(String string2) {
    }

    public final boolean checkRequirements(Context context) {
        boolean bl = this.checkNetworkRequirements(context) && this.checkChargingRequirement(context) && this.checkIdleRequirement(context);
        return bl;
    }

    public final int getRequiredNetworkType() {
        return this.requirements & 7;
    }

    public final int getRequirementsData() {
        return this.requirements;
    }

    public final boolean isChargingRequired() {
        boolean bl = (this.requirements & 0x10) != 0;
        return bl;
    }

    public final boolean isIdleRequired() {
        boolean bl = (this.requirements & 8) != 0;
        return bl;
    }

    public final String toString() {
        return super.toString();
    }

    public static @interface NetworkType {
    }
}

