/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.offline;

import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.mbridge.msdk.playercommon.exoplayer2.offline.ActionFile;
import com.mbridge.msdk.playercommon.exoplayer2.offline.DownloadAction;
import com.mbridge.msdk.playercommon.exoplayer2.offline.Downloader;
import com.mbridge.msdk.playercommon.exoplayer2.offline.DownloaderConstructorHelper;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSource;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.cache.Cache;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;

public final class DownloadManager {
    private static final boolean DEBUG = false;
    public static final int DEFAULT_MAX_SIMULTANEOUS_DOWNLOADS = 1;
    public static final int DEFAULT_MIN_RETRY_COUNT = 5;
    private static final String TAG = "DownloadManager";
    private final ActionFile actionFile;
    private final ArrayList<Task> activeDownloadTasks;
    private final DownloadAction.Deserializer[] deserializers;
    private final DownloaderConstructorHelper downloaderConstructorHelper;
    private boolean downloadsStopped;
    private final Handler fileIOHandler;
    private final HandlerThread fileIOThread;
    private final Handler handler;
    private boolean initialized;
    private final CopyOnWriteArraySet<Listener> listeners;
    private final int maxActiveDownloadTasks;
    private final int minRetryCount;
    private int nextTaskId;
    private boolean released;
    private final ArrayList<Task> tasks;

    public DownloadManager(DownloaderConstructorHelper object, int n2, int n3, File file, DownloadAction.Deserializer ... deserializerArray) {
        boolean bl = deserializerArray.length > 0;
        Assertions.checkArgument(bl, "At least one Deserializer is required.");
        this.downloaderConstructorHelper = object;
        this.maxActiveDownloadTasks = n2;
        this.minRetryCount = n3;
        this.actionFile = new ActionFile(file);
        this.deserializers = deserializerArray;
        this.downloadsStopped = true;
        this.tasks = new ArrayList();
        this.activeDownloadTasks = new ArrayList();
        file = Looper.myLooper();
        object = file;
        if (file == null) {
            object = Looper.getMainLooper();
        }
        this.handler = new Handler((Looper)object);
        this.fileIOThread = new HandlerThread("DownloadManager file i/o");
        this.fileIOThread.start();
        this.fileIOHandler = new Handler(this.fileIOThread.getLooper());
        this.listeners = new CopyOnWriteArraySet();
        this.loadActions();
        DownloadManager.logd("Created");
    }

    public DownloadManager(DownloaderConstructorHelper downloaderConstructorHelper, File file, DownloadAction.Deserializer ... deserializerArray) {
        this(downloaderConstructorHelper, 1, 5, file, deserializerArray);
    }

    public DownloadManager(Cache cache, DataSource.Factory factory, File file, DownloadAction.Deserializer ... deserializerArray) {
        this(new DownloaderConstructorHelper(cache, factory), file, deserializerArray);
    }

    static /* synthetic */ boolean access$1402(DownloadManager downloadManager, boolean bl) {
        downloadManager.initialized = bl;
        return bl;
    }

    private Task addTaskForAction(DownloadAction object) {
        int n2 = this.nextTaskId;
        this.nextTaskId = n2 + 1;
        object = new Task(n2, this, (DownloadAction)object, this.minRetryCount);
        this.tasks.add((Task)object);
        DownloadManager.logd("Task is added", (Task)object);
        return object;
    }

    private void loadActions() {
        this.fileIOHandler.post(new Runnable(){

            @Override
            public void run() {
                DownloadAction[] downloadActionArray;
                try {
                    downloadActionArray = DownloadManager.this.actionFile.load(DownloadManager.this.deserializers);
                    DownloadManager.logd("Action file is loaded.");
                }
                catch (Throwable throwable) {
                    Log.e((String)DownloadManager.TAG, (String)"Action file loading failed.", (Throwable)throwable);
                    downloadActionArray = new DownloadAction[]{};
                }
                DownloadManager.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        int n2;
                        if (DownloadManager.this.released) {
                            return;
                        }
                        Object object2 = new ArrayList(DownloadManager.this.tasks);
                        DownloadManager.this.tasks.clear();
                        DownloadAction[] downloadActionArray2 = downloadActionArray;
                        int n3 = downloadActionArray2.length;
                        int n4 = 0;
                        for (n2 = 0; n2 < n3; ++n2) {
                            object = downloadActionArray2[n2];
                            DownloadManager.this.addTaskForAction((DownloadAction)object);
                        }
                        DownloadManager.logd("Tasks are created.");
                        DownloadManager.access$1402(DownloadManager.this, true);
                        object = DownloadManager.this.listeners.iterator();
                        while (object.hasNext()) {
                            ((Listener)object.next()).onInitialized(DownloadManager.this);
                        }
                        if (!object2.isEmpty()) {
                            DownloadManager.this.tasks.addAll(object2);
                            DownloadManager.this.saveActions();
                        }
                        DownloadManager.this.maybeStartTasks();
                        for (n2 = n4; n2 < DownloadManager.this.tasks.size(); ++n2) {
                            object2 = (Task)DownloadManager.this.tasks.get(n2);
                            if (((Task)object2).currentState != 0) continue;
                            DownloadManager.this.notifyListenersTaskStateChange((Task)object2);
                        }
                    }
                });
            }
        });
    }

    private static void logd(String string2) {
    }

    private static void logd(String string2, Task task2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append(task2);
        DownloadManager.logd(stringBuilder.toString());
    }

    private void maybeNotifyListenersIdle() {
        if (!this.isIdle()) {
            return;
        }
        DownloadManager.logd("Notify idle state");
        Iterator<Listener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onIdle(this);
        }
    }

    private void maybeStartTasks() {
        if (this.initialized && !this.released) {
            boolean bl = this.downloadsStopped || this.activeDownloadTasks.size() == this.maxActiveDownloadTasks;
            for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
                boolean bl2;
                boolean bl3;
                Task task2 = this.tasks.get(i2);
                if (!task2.canStart()) continue;
                DownloadAction downloadAction = task2.action;
                boolean bl4 = downloadAction.isRemoveAction;
                if (!bl4 && bl) continue;
                int n2 = 0;
                boolean bl5 = true;
                while (true) {
                    bl3 = bl;
                    bl2 = bl5;
                    if (n2 >= i2) break;
                    Task task3 = this.tasks.get(n2);
                    bl3 = bl5;
                    if (task3.action.isSameMedia(downloadAction)) {
                        if (bl4) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(task2);
                            stringBuilder.append(" clashes with ");
                            stringBuilder.append(task3);
                            DownloadManager.logd(stringBuilder.toString());
                            task3.cancel();
                            bl3 = false;
                        } else {
                            bl3 = bl5;
                            if (((Task)task3).action.isRemoveAction) {
                                bl3 = true;
                                bl2 = false;
                                break;
                            }
                        }
                    }
                    ++n2;
                    bl5 = bl3;
                }
                bl = bl3;
                if (!bl2) continue;
                task2.start();
                bl = bl3;
                if (bl4) continue;
                this.activeDownloadTasks.add(task2);
                bl = this.activeDownloadTasks.size() == this.maxActiveDownloadTasks;
            }
        }
    }

    private void notifyListenersTaskStateChange(Task object) {
        DownloadManager.logd("Task state is changed", (Task)object);
        object = ((Task)object).getDownloadState();
        Iterator<Listener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onTaskStateChanged(this, (TaskState)object);
        }
    }

    private void onTaskStateChange(Task task2) {
        if (this.released) {
            return;
        }
        boolean bl = task2.isActive() ^ true;
        if (bl) {
            this.activeDownloadTasks.remove(task2);
        }
        this.notifyListenersTaskStateChange(task2);
        if (task2.isFinished()) {
            this.tasks.remove(task2);
            this.saveActions();
        }
        if (bl) {
            this.maybeStartTasks();
            this.maybeNotifyListenersIdle();
        }
    }

    private void saveActions() {
        if (this.released) {
            return;
        }
        final DownloadAction[] downloadActionArray = new DownloadAction[this.tasks.size()];
        for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
            downloadActionArray[i2] = this.tasks.get(i2).action;
        }
        this.fileIOHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DownloadManager.this.actionFile.store(downloadActionArray);
                    DownloadManager.logd("Actions persisted.");
                }
                catch (IOException iOException) {
                    Log.e((String)DownloadManager.TAG, (String)"Persisting actions failed.", (Throwable)iOException);
                }
            }
        });
    }

    public final void addListener(Listener listener2) {
        this.listeners.add(listener2);
    }

    public final TaskState[] getAllTaskStates() {
        Assertions.checkState(this.released ^ true);
        TaskState[] taskStateArray = new TaskState[this.tasks.size()];
        for (int i2 = 0; i2 < taskStateArray.length; ++i2) {
            taskStateArray[i2] = this.tasks.get(i2).getDownloadState();
        }
        return taskStateArray;
    }

    public final int getDownloadCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
            int n3 = n2;
            if (!((Task)this.tasks.get((int)i2)).action.isRemoveAction) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    public final int getTaskCount() {
        Assertions.checkState(this.released ^ true);
        return this.tasks.size();
    }

    public final TaskState getTaskState(int n2) {
        Assertions.checkState(this.released ^ true);
        for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
            Task task2 = this.tasks.get(i2);
            if (task2.id != n2) continue;
            return task2.getDownloadState();
        }
        return null;
    }

    public final int handleAction(DownloadAction object) {
        Assertions.checkState(this.released ^ true);
        object = this.addTaskForAction((DownloadAction)object);
        if (this.initialized) {
            this.saveActions();
            this.maybeStartTasks();
            if (((Task)object).currentState == 0) {
                this.notifyListenersTaskStateChange((Task)object);
            }
        }
        return ((Task)object).id;
    }

    public final int handleAction(byte[] object) throws IOException {
        Assertions.checkState(this.released ^ true);
        object = new ByteArrayInputStream((byte[])object);
        return this.handleAction(DownloadAction.deserializeFromStream((DownloadAction.Deserializer[])this.deserializers, (InputStream)object));
    }

    public final boolean isIdle() {
        Assertions.checkState(this.released ^ true);
        if (!this.initialized) {
            return false;
        }
        for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
            if (!this.tasks.get(i2).isActive()) continue;
            return false;
        }
        return true;
    }

    public final boolean isInitialized() {
        Assertions.checkState(this.released ^ true);
        return this.initialized;
    }

    public final void release() {
        if (this.released) {
            return;
        }
        this.released = true;
        for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
            this.tasks.get(i2).stop();
        }
        final ConditionVariable conditionVariable = new ConditionVariable();
        this.fileIOHandler.post(new Runnable(){

            @Override
            public void run() {
                conditionVariable.open();
            }
        });
        conditionVariable.block();
        this.fileIOThread.quit();
        DownloadManager.logd("Released");
    }

    public final void removeListener(Listener listener2) {
        this.listeners.remove(listener2);
    }

    public final void startDownloads() {
        Assertions.checkState(this.released ^ true);
        if (this.downloadsStopped) {
            this.downloadsStopped = false;
            this.maybeStartTasks();
            DownloadManager.logd("Downloads are started");
        }
    }

    public final void stopDownloads() {
        Assertions.checkState(this.released ^ true);
        if (!this.downloadsStopped) {
            this.downloadsStopped = true;
            for (int i2 = 0; i2 < this.activeDownloadTasks.size(); ++i2) {
                this.activeDownloadTasks.get(i2).stop();
            }
            DownloadManager.logd("Downloads are stopping");
        }
    }

    public static interface Listener {
        public void onIdle(DownloadManager var1);

        public void onInitialized(DownloadManager var1);

        public void onTaskStateChanged(DownloadManager var1, TaskState var2);
    }

    private static final class Task
    implements Runnable {
        public static final int STATE_QUEUED_CANCELING = 5;
        public static final int STATE_STARTED_CANCELING = 6;
        public static final int STATE_STARTED_STOPPING = 7;
        private final DownloadAction action;
        private volatile int currentState;
        private final DownloadManager downloadManager;
        private volatile Downloader downloader;
        private Throwable error;
        private final int id;
        private final int minRetryCount;
        private Thread thread;

        private Task(int n2, DownloadManager downloadManager, DownloadAction downloadAction, int n3) {
            this.id = n2;
            this.downloadManager = downloadManager;
            this.action = downloadAction;
            this.currentState = 0;
            this.minRetryCount = n3;
        }

        private boolean canStart() {
            boolean bl = this.currentState == 0;
            return bl;
        }

        private void cancel() {
            if (this.changeStateAndNotify(0, 5)) {
                this.downloadManager.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.changeStateAndNotify(5, 3);
                    }
                });
            } else if (this.changeStateAndNotify(1, 6)) {
                this.cancelDownload();
            }
        }

        private void cancelDownload() {
            if (this.downloader != null) {
                this.downloader.cancel();
            }
            this.thread.interrupt();
        }

        private boolean changeStateAndNotify(int n2, int n3) {
            return this.changeStateAndNotify(n2, n3, null);
        }

        private boolean changeStateAndNotify(int n2, int n3, Throwable throwable) {
            int n4 = this.currentState;
            int n5 = 0;
            if (n4 != n2) {
                return false;
            }
            this.currentState = n3;
            this.error = throwable;
            n2 = n5;
            if (this.currentState != this.getExternalState()) {
                n2 = 1;
            }
            if (n2 == 0) {
                this.downloadManager.onTaskStateChange(this);
            }
            return true;
        }

        private int getExternalState() {
            int n2 = this.currentState;
            if (n2 != 5) {
                if (n2 != 6 && n2 != 7) {
                    return this.currentState;
                }
                return 1;
            }
            return 0;
        }

        private int getRetryDelayMillis(int n2) {
            return Math.min((n2 - 1) * 1000, 5000);
        }

        private String getStateString() {
            int n2 = this.currentState;
            if (n2 != 5 && n2 != 6) {
                if (n2 != 7) {
                    return TaskState.getStateString(this.currentState);
                }
                return "STOPPING";
            }
            return "CANCELING";
        }

        private void start() {
            if (this.changeStateAndNotify(0, 1)) {
                this.thread = new Thread(this);
                this.thread.start();
            }
        }

        private void stop() {
            if (this.changeStateAndNotify(1, 7)) {
                DownloadManager.logd("Stopping", this);
                this.thread.interrupt();
            }
        }

        private static String toString(byte[] byArray) {
            if (byArray.length > 100) {
                return "<data is too long>";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\'');
            stringBuilder.append(Util.fromUtf8Bytes((byte[])byArray));
            stringBuilder.append('\'');
            return stringBuilder.toString();
        }

        public final float getDownloadPercentage() {
            float f2 = this.downloader != null ? this.downloader.getDownloadPercentage() : -1.0f;
            return f2;
        }

        public final TaskState getDownloadState() {
            int n2 = this.getExternalState();
            return new TaskState(this.id, this.action, n2, this.getDownloadPercentage(), this.getDownloadedBytes(), this.error);
        }

        public final long getDownloadedBytes() {
            long l2 = this.downloader != null ? this.downloader.getDownloadedBytes() : 0L;
            return l2;
        }

        public final boolean isActive() {
            boolean bl;
            int n2 = this.currentState;
            boolean bl2 = bl = true;
            if (n2 != 5) {
                bl2 = bl;
                if (this.currentState != 1) {
                    bl2 = bl;
                    if (this.currentState != 7) {
                        bl2 = this.currentState == 6 ? bl : false;
                    }
                }
            }
            return bl2;
        }

        public final boolean isFinished() {
            boolean bl = this.currentState == 4 || this.currentState == 2 || this.currentState == 3;
            return bl;
        }

        /*
         * Loose catch block
         */
        @Override
        public final void run() {
            StringBuilder stringBuilder;
            block15: {
                block12: {
                    DownloadManager.logd("Task is started", this);
                    this.downloader = this.action.createDownloader(this.downloadManager.downloaderConstructorHelper);
                    if (this.action.isRemoveAction) {
                        this.downloader.remove();
                        break block12;
                    }
                    long l2 = -1L;
                    int n2 = 0;
                    while (true) {
                        boolean bl = Thread.interrupted();
                        if (bl) break;
                        try {
                            this.downloader.download();
                        }
                        catch (IOException iOException) {
                            block14: {
                                long l3;
                                block13: {
                                    long l4 = this.downloader.getDownloadedBytes();
                                    l3 = l2;
                                    if (l4 == l2) break block13;
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    stringBuilder2.append("Reset error count. downloadedBytes = ");
                                    stringBuilder2.append(l4);
                                    DownloadManager.logd(stringBuilder2.toString(), this);
                                    l3 = l4;
                                    n2 = 0;
                                }
                                if (this.currentState != 1) break block14;
                                ++n2;
                                if (n2 > this.minRetryCount) break block14;
                                stringBuilder = new StringBuilder();
                                stringBuilder.append("Download error. Retry ");
                                stringBuilder.append(n2);
                                DownloadManager.logd(stringBuilder.toString(), this);
                                Thread.sleep(this.getRetryDelayMillis(n2));
                                l2 = l3;
                                continue;
                            }
                            throw iOException;
                        }
                        break;
                    }
                }
                stringBuilder = null;
                break block15;
                {
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.downloadManager.handler.post(new Runnable((Throwable)((Object)stringBuilder)){
                final /* synthetic */ Throwable val$finalError;
                {
                    this.val$finalError = throwable;
                }

                @Override
                public void run() {
                    Task task2 = Task.this;
                    int n2 = this.val$finalError != null ? 4 : 2;
                    if (!(task2.changeStateAndNotify(1, n2, this.val$finalError) || Task.this.changeStateAndNotify(6, 3) || Task.this.changeStateAndNotify(7, 0))) {
                        throw new IllegalStateException();
                    }
                }
            });
        }

        public final String toString() {
            return super.toString();
        }

        public static @interface InternalState {
        }
    }

    public static final class TaskState {
        public static final int STATE_CANCELED = 3;
        public static final int STATE_COMPLETED = 2;
        public static final int STATE_FAILED = 4;
        public static final int STATE_QUEUED = 0;
        public static final int STATE_STARTED = 1;
        public final DownloadAction action;
        public final float downloadPercentage;
        public final long downloadedBytes;
        public final Throwable error;
        public final int state;
        public final int taskId;

        private TaskState(int n2, DownloadAction downloadAction, int n3, float f2, long l2, Throwable throwable) {
            this.taskId = n2;
            this.action = downloadAction;
            this.state = n3;
            this.downloadPercentage = f2;
            this.downloadedBytes = l2;
            this.error = throwable;
        }

        public static String getStateString(int n2) {
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 != 3) {
                            if (n2 == 4) {
                                return "FAILED";
                            }
                            throw new IllegalStateException();
                        }
                        return "CANCELED";
                    }
                    return "COMPLETED";
                }
                return "STARTED";
            }
            return "QUEUED";
        }

        public static @interface State {
        }
    }
}

