/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.metadata.emsg;

import com.mbridge.msdk.playercommon.exoplayer2.metadata.emsg.EventMessage;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class EventMessageEncoder {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
    private final DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);

    private static void writeNullTerminatedString(DataOutputStream dataOutputStream, String string2) throws IOException {
        dataOutputStream.writeBytes(string2);
        dataOutputStream.writeByte(0);
    }

    private static void writeUnsignedInt(DataOutputStream dataOutputStream, long l2) throws IOException {
        dataOutputStream.writeByte((int)(l2 >>> 24) & 0xFF);
        dataOutputStream.writeByte((int)(l2 >>> 16) & 0xFF);
        dataOutputStream.writeByte((int)(l2 >>> 8) & 0xFF);
        dataOutputStream.writeByte((int)l2 & 0xFF);
    }

    public final byte[] encode(EventMessage object, long l2) {
        String string2;
        boolean bl = l2 >= 0L;
        Assertions.checkArgument(bl);
        this.byteArrayOutputStream.reset();
        try {
            EventMessageEncoder.writeNullTerminatedString(this.dataOutputStream, object.schemeIdUri);
            string2 = object.value != null ? object.value : "";
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        EventMessageEncoder.writeNullTerminatedString(this.dataOutputStream, string2);
        EventMessageEncoder.writeUnsignedInt(this.dataOutputStream, l2);
        long l3 = Util.scaleLargeTimestamp((long)object.presentationTimeUs, (long)l2, (long)1000000L);
        EventMessageEncoder.writeUnsignedInt(this.dataOutputStream, l3);
        l2 = Util.scaleLargeTimestamp((long)object.durationMs, (long)l2, (long)1000L);
        EventMessageEncoder.writeUnsignedInt(this.dataOutputStream, l2);
        EventMessageEncoder.writeUnsignedInt(this.dataOutputStream, object.id);
        this.dataOutputStream.write(object.messageData);
        this.dataOutputStream.flush();
        object = this.byteArrayOutputStream.toByteArray();
        return object;
    }
}

