/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.mediacodec;

import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.mbridge.msdk.playercommon.exoplayer2.BaseRenderer;
import com.mbridge.msdk.playercommon.exoplayer2.ExoPlaybackException;
import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.FormatHolder;
import com.mbridge.msdk.playercommon.exoplayer2.decoder.DecoderCounters;
import com.mbridge.msdk.playercommon.exoplayer2.decoder.DecoderInputBuffer;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmInitData;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmSession;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmSessionManager;
import com.mbridge.msdk.playercommon.exoplayer2.drm.FrameworkMediaCrypto;
import com.mbridge.msdk.playercommon.exoplayer2.mediacodec.MediaCodecInfo;
import com.mbridge.msdk.playercommon.exoplayer2.mediacodec.MediaCodecSelector;
import com.mbridge.msdk.playercommon.exoplayer2.mediacodec.MediaCodecUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.NalUnitUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.TraceUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaCodecRenderer
extends BaseRenderer {
    private static final byte[] ADAPTATION_WORKAROUND_BUFFER = Util.getBytesFromHexString((String)"0000016742C00BDA259000000168CE0F13200000016588840DCE7118A0002FBF1C31C3275D78");
    private static final int ADAPTATION_WORKAROUND_MODE_ALWAYS = 2;
    private static final int ADAPTATION_WORKAROUND_MODE_NEVER = 0;
    private static final int ADAPTATION_WORKAROUND_MODE_SAME_RESOLUTION = 1;
    private static final int ADAPTATION_WORKAROUND_SLICE_WIDTH_HEIGHT = 32;
    protected static final int KEEP_CODEC_RESULT_NO = 0;
    protected static final int KEEP_CODEC_RESULT_YES_WITHOUT_RECONFIGURATION = 1;
    protected static final int KEEP_CODEC_RESULT_YES_WITH_RECONFIGURATION = 3;
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 2;
    private static final String TAG = "MediaCodecRenderer";
    private final DecoderInputBuffer buffer;
    private MediaCodec codec;
    private int codecAdaptationWorkaroundMode;
    private long codecHotswapDeadlineMs;
    private MediaCodecInfo codecInfo;
    private boolean codecNeedsAdaptationWorkaroundBuffer;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsEosOutputExceptionWorkaround;
    private boolean codecNeedsEosPropagationWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private int codecReconfigurationState;
    private boolean codecReconfigured;
    private int codecReinitializationState;
    private final List<Long> decodeOnlyPresentationTimestamps;
    protected DecoderCounters decoderCounters;
    private DrmSession<FrameworkMediaCrypto> drmSession;
    private final DrmSessionManager<FrameworkMediaCrypto> drmSessionManager;
    private final DecoderInputBuffer flagsOnlyBuffer;
    private Format format;
    private final FormatHolder formatHolder;
    private ByteBuffer[] inputBuffers;
    private int inputIndex;
    private boolean inputStreamEnded;
    private final MediaCodecSelector mediaCodecSelector;
    private ByteBuffer outputBuffer;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private ByteBuffer[] outputBuffers;
    private int outputIndex;
    private boolean outputStreamEnded;
    private DrmSession<FrameworkMediaCrypto> pendingDrmSession;
    private final boolean playClearSamplesWithoutKeys;
    private boolean shouldSkipAdaptationWorkaroundOutputBuffer;
    private boolean shouldSkipOutputBuffer;
    private boolean waitingForFirstSyncFrame;
    private boolean waitingForKeys;

    public MediaCodecRenderer(int n2, MediaCodecSelector mediaCodecSelector, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, boolean bl) {
        super(n2);
        boolean bl2 = Util.SDK_INT >= 16;
        Assertions.checkState(bl2);
        this.mediaCodecSelector = Assertions.checkNotNull(mediaCodecSelector);
        this.drmSessionManager = drmSessionManager;
        this.playClearSamplesWithoutKeys = bl;
        this.buffer = new DecoderInputBuffer(0);
        this.flagsOnlyBuffer = DecoderInputBuffer.newFlagsOnlyInstance();
        this.formatHolder = new FormatHolder();
        this.decodeOnlyPresentationTimestamps = new ArrayList<Long>();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
    }

    private int codecAdaptationWorkaroundMode(String string2) {
        if (Util.SDK_INT <= 25 && "OMX.Exynos.avc.dec.secure".equals(string2) && (Util.MODEL.startsWith("SM-T585") || Util.MODEL.startsWith("SM-A510") || Util.MODEL.startsWith("SM-A520") || Util.MODEL.startsWith("SM-J700"))) {
            return 2;
        }
        if (Util.SDK_INT < 24 && ("OMX.Nvidia.h264.decode".equals(string2) || "OMX.Nvidia.h264.decode.secure".equals(string2)) && ("flounder".equals(Util.DEVICE) || "flounder_lte".equals(Util.DEVICE) || "grouper".equals(Util.DEVICE) || "tilapia".equals(Util.DEVICE))) {
            return 1;
        }
        return 0;
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String string2, Format format) {
        boolean bl = Util.SDK_INT < 21 && format.initializationData.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(string2);
        return bl;
    }

    private static boolean codecNeedsEosFlushWorkaround(String string2) {
        boolean bl = Util.SDK_INT <= 23 && "OMX.google.vorbis.decoder".equals(string2) || Util.SDK_INT <= 19 && "hb2000".equals(Util.DEVICE) && ("OMX.amlogic.avc.decoder.awesome".equals(string2) || "OMX.amlogic.avc.decoder.awesome.secure".equals(string2));
        return bl;
    }

    private static boolean codecNeedsEosOutputExceptionWorkaround(String string2) {
        boolean bl = Util.SDK_INT == 21 && "OMX.google.aac.decoder".equals(string2);
        return bl;
    }

    private static boolean codecNeedsEosPropagationWorkaround(MediaCodecInfo mediaCodecInfo) {
        String string2 = mediaCodecInfo.name;
        boolean bl = Util.SDK_INT <= 17 && ("OMX.rk.video_decoder.avc".equals(string2) || "OMX.allwinner.video.decoder.avc".equals(string2)) || "Amazon".equals(Util.MANUFACTURER) && "AFTS".equals(Util.MODEL) && mediaCodecInfo.secure;
        return bl;
    }

    private static boolean codecNeedsFlushWorkaround(String string2) {
        boolean bl = Util.SDK_INT < 18 || Util.SDK_INT == 18 && ("OMX.SEC.avc.dec".equals(string2) || "OMX.SEC.avc.dec.secure".equals(string2)) || Util.SDK_INT == 19 && Util.MODEL.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(string2) || "OMX.Exynos.avc.dec.secure".equals(string2));
        return bl;
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String string2, Format format) {
        int n2 = Util.SDK_INT;
        boolean bl = true;
        if (n2 > 18 || format.channelCount != 1 || !"OMX.MTK.AUDIO.DECODER.MP3".equals(string2)) {
            bl = false;
        }
        return bl;
    }

    private boolean deviceNeedsDrmKeysToConfigureCodecWorkaround() {
        boolean bl = "Amazon".equals(Util.MANUFACTURER) && ("AFTM".equals(Util.MODEL) || "AFTB".equals(Util.MODEL));
        return bl;
    }

    private boolean drainOutputBuffer(long l2, long l3) throws ExoPlaybackException {
        boolean bl;
        int n2;
        if (!this.hasOutputBuffer()) {
            if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
                try {
                    n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
                }
                catch (IllegalStateException illegalStateException) {
                    this.processEndOfStream();
                    if (this.outputStreamEnded) {
                        this.releaseCodec();
                    }
                    return false;
                }
            } else {
                n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
            }
            if (n2 >= 0) {
                if (this.shouldSkipAdaptationWorkaroundOutputBuffer) {
                    this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
                    this.codec.releaseOutputBuffer(n2, false);
                    return true;
                }
                if (this.outputBufferInfo.size == 0 && (this.outputBufferInfo.flags & 4) != 0) {
                    this.processEndOfStream();
                    return false;
                }
                this.outputIndex = n2;
                this.outputBuffer = this.getOutputBuffer(n2);
                ByteBuffer byteBuffer = this.outputBuffer;
                if (byteBuffer != null) {
                    byteBuffer.position(this.outputBufferInfo.offset);
                    this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
                }
                this.shouldSkipOutputBuffer = this.shouldSkipOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            } else {
                if (n2 == -2) {
                    this.processOutputFormat();
                    return true;
                }
                if (n2 == -3) {
                    this.processOutputBuffersChanged();
                    return true;
                }
                if (this.codecNeedsEosPropagationWorkaround && (this.inputStreamEnded || this.codecReinitializationState == 2)) {
                    this.processEndOfStream();
                }
                return false;
            }
        }
        if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
            try {
                bl = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer);
            }
            catch (IllegalStateException illegalStateException) {
                this.processEndOfStream();
                if (this.outputStreamEnded) {
                    this.releaseCodec();
                }
                return false;
            }
        } else {
            bl = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer);
        }
        if (bl) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            n2 = (this.outputBufferInfo.flags & 4) != 0 ? 1 : 0;
            this.resetOutputBuffer();
            if (n2 == 0) {
                return true;
            }
            this.processEndOfStream();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean feedInputBuffer() throws ExoPlaybackException {
        int n2;
        int n3;
        MediaCodec mediaCodec = this.codec;
        if (mediaCodec == null) return false;
        if (this.codecReinitializationState == 2) return false;
        if (this.inputStreamEnded) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = mediaCodec.dequeueInputBuffer(0L);
            n3 = this.inputIndex;
            if (n3 < 0) {
                return false;
            }
            this.buffer.data = this.getInputBuffer(n3);
            this.buffer.clear();
        }
        if (this.codecReinitializationState == 1) {
            if (!this.codecNeedsEosPropagationWorkaround) {
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.resetInputBuffer();
            }
            this.codecReinitializationState = 2;
            return false;
        }
        if (this.codecNeedsAdaptationWorkaroundBuffer) {
            this.codecNeedsAdaptationWorkaroundBuffer = false;
            this.buffer.data.put(ADAPTATION_WORKAROUND_BUFFER);
            this.codec.queueInputBuffer(this.inputIndex, 0, ADAPTATION_WORKAROUND_BUFFER.length, 0L, 0);
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            return true;
        }
        if (this.waitingForKeys) {
            n2 = -4;
            n3 = 0;
        } else {
            if (this.codecReconfigurationState == 1) {
                for (n3 = 0; n3 < this.format.initializationData.size(); ++n3) {
                    byte[] byArray = (byte[])this.format.initializationData.get(n3);
                    this.buffer.data.put(byArray);
                }
                this.codecReconfigurationState = 2;
            }
            n3 = this.buffer.data.position();
            n2 = this.readSource(this.formatHolder, this.buffer, false);
        }
        if (n2 == -3) {
            return false;
        }
        if (n2 == -5) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.clear();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(this.formatHolder.format);
            return true;
        }
        if (this.buffer.isEndOfStream()) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.clear();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (this.codecNeedsEosPropagationWorkaround) {
                    return false;
                }
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.resetInputBuffer();
                return false;
            }
            catch (MediaCodec.CryptoException cryptoException) {
                throw ExoPlaybackException.createForRenderer((Exception)((Object)cryptoException), this.getIndex());
            }
        }
        if (this.waitingForFirstSyncFrame && !this.buffer.isKeyFrame()) {
            this.buffer.clear();
            if (this.codecReconfigurationState != 2) return true;
            this.codecReconfigurationState = 1;
            return true;
        }
        this.waitingForFirstSyncFrame = false;
        boolean bl = this.buffer.isEncrypted();
        this.waitingForKeys = this.shouldWaitForKeys(bl);
        if (this.waitingForKeys) {
            return false;
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !bl) {
            NalUnitUtil.discardToSps((ByteBuffer)this.buffer.data);
            if (this.buffer.data.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        try {
            long l2 = this.buffer.timeUs;
            if (this.buffer.isDecodeOnly()) {
                this.decodeOnlyPresentationTimestamps.add(l2);
            }
            this.buffer.flip();
            this.onQueueInputBuffer(this.buffer);
            if (bl) {
                MediaCodec.CryptoInfo cryptoInfo = MediaCodecRenderer.getFrameworkCryptoInfo(this.buffer, n3);
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, cryptoInfo, l2, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, this.buffer.data.limit(), l2, 0);
            }
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            this.codecReconfigurationState = 0;
            DecoderCounters decoderCounters = this.decoderCounters;
            ++decoderCounters.inputBufferCount;
            return true;
        }
        catch (MediaCodec.CryptoException cryptoException) {
            throw ExoPlaybackException.createForRenderer((Exception)((Object)cryptoException), this.getIndex());
        }
    }

    private void getCodecBuffers() {
        if (Util.SDK_INT < 21) {
            this.inputBuffers = this.codec.getInputBuffers();
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    private static MediaCodec.CryptoInfo getFrameworkCryptoInfo(DecoderInputBuffer object, int n2) {
        MediaCodec.CryptoInfo cryptoInfo = object.cryptoInfo.getFrameworkCryptoInfoV16();
        if (n2 == 0) {
            return cryptoInfo;
        }
        if (cryptoInfo.numBytesOfClearData == null) {
            cryptoInfo.numBytesOfClearData = new int[1];
        }
        object = cryptoInfo.numBytesOfClearData;
        object[0] = object[0] + n2;
        return cryptoInfo;
    }

    private ByteBuffer getInputBuffer(int n2) {
        if (Util.SDK_INT >= 21) {
            return this.codec.getInputBuffer(n2);
        }
        return this.inputBuffers[n2];
    }

    private ByteBuffer getOutputBuffer(int n2) {
        if (Util.SDK_INT >= 21) {
            return this.codec.getOutputBuffer(n2);
        }
        return this.outputBuffers[n2];
    }

    private boolean hasOutputBuffer() {
        boolean bl = this.outputIndex >= 0;
        return bl;
    }

    private void processEndOfStream() throws ExoPlaybackException {
        if (this.codecReinitializationState == 2) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.outputStreamEnded = true;
            this.renderToEndOfStream();
        }
    }

    private void processOutputBuffersChanged() {
        if (Util.SDK_INT < 21) {
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    private void processOutputFormat() throws ExoPlaybackException {
        MediaFormat mediaFormat = this.codec.getOutputFormat();
        if (this.codecAdaptationWorkaroundMode != 0 && mediaFormat.getInteger("width") == 32 && mediaFormat.getInteger("height") == 32) {
            this.shouldSkipAdaptationWorkaroundOutputBuffer = true;
            return;
        }
        if (this.codecNeedsMonoChannelCountWorkaround) {
            mediaFormat.setInteger("channel-count", 1);
        }
        this.onOutputFormatChanged(this.codec, mediaFormat);
    }

    private void resetCodecBuffers() {
        if (Util.SDK_INT < 21) {
            this.inputBuffers = null;
            this.outputBuffers = null;
        }
    }

    private void resetInputBuffer() {
        this.inputIndex = -1;
        this.buffer.data = null;
    }

    private void resetOutputBuffer() {
        this.outputIndex = -1;
        this.outputBuffer = null;
    }

    private boolean shouldSkipOutputBuffer(long l2) {
        int n2 = this.decodeOnlyPresentationTimestamps.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.decodeOnlyPresentationTimestamps.get(i2) != l2) continue;
            this.decodeOnlyPresentationTimestamps.remove(i2);
            return true;
        }
        return false;
    }

    private boolean shouldWaitForKeys(boolean bl) throws ExoPlaybackException {
        if (this.drmSession != null && (bl || !this.playClearSamplesWithoutKeys)) {
            int n2 = this.drmSession.getState();
            bl = true;
            if (n2 != 1) {
                if (n2 == 4) {
                    bl = false;
                }
                return bl;
            }
            throw ExoPlaybackException.createForRenderer(this.drmSession.getError(), this.getIndex());
        }
        return false;
    }

    private void throwDecoderInitError(DecoderInitializationException decoderInitializationException) throws ExoPlaybackException {
        throw ExoPlaybackException.createForRenderer(decoderInitializationException, this.getIndex());
    }

    protected int canKeepCodec(MediaCodec mediaCodec, MediaCodecInfo mediaCodecInfo, Format format, Format format2) {
        return 0;
    }

    protected abstract void configureCodec(MediaCodecInfo var1, MediaCodec var2, Format var3, MediaCrypto var4) throws MediaCodecUtil.DecoderQueryException;

    protected void flushCodec() throws ExoPlaybackException {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        if (!(this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos)) {
            if (this.codecReinitializationState != 0) {
                this.releaseCodec();
                this.maybeInitCodec();
            } else {
                this.codec.flush();
                this.codecReceivedBuffers = false;
            }
        } else {
            this.releaseCodec();
            this.maybeInitCodec();
        }
        if (this.codecReconfigured && this.format != null) {
            this.codecReconfigurationState = 1;
        }
    }

    protected final MediaCodec getCodec() {
        return this.codec;
    }

    protected final MediaCodecInfo getCodecInfo() {
        return this.codecInfo;
    }

    protected MediaCodecInfo getDecoderInfo(MediaCodecSelector mediaCodecSelector, Format format, boolean bl) throws MediaCodecUtil.DecoderQueryException {
        return mediaCodecSelector.getDecoderInfo(format.sampleMimeType, bl);
    }

    protected long getDequeueOutputBufferTimeoutUs() {
        return 0L;
    }

    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    public boolean isReady() {
        boolean bl = this.format != null && !this.waitingForKeys && (this.isSourceReady() || this.hasOutputBuffer() || this.codecHotswapDeadlineMs != -9223372036854775807L && SystemClock.elapsedRealtime() < this.codecHotswapDeadlineMs);
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void maybeInitCodec() throws ExoPlaybackException {
        long l2;
        boolean bl;
        Object object;
        if (this.codec != null || (object = this.format) == null) return;
        this.drmSession = this.pendingDrmSession;
        CharSequence charSequence = ((Format)object).sampleMimeType;
        object = this.drmSession;
        if (object != null) {
            boolean bl2;
            FrameworkMediaCrypto frameworkMediaCrypto = (FrameworkMediaCrypto)object.getMediaCrypto();
            if (frameworkMediaCrypto == null) {
                if (this.drmSession.getError() == null) return;
                object = null;
                bl2 = false;
            } else {
                object = frameworkMediaCrypto.getWrappedMediaCrypto();
                bl2 = frameworkMediaCrypto.requiresSecureDecoderComponent((String)charSequence);
            }
            bl = bl2;
            Object object2 = object;
            if (this.deviceNeedsDrmKeysToConfigureCodecWorkaround()) {
                int n2 = this.drmSession.getState();
                if (n2 == 1) throw ExoPlaybackException.createForRenderer(this.drmSession.getError(), this.getIndex());
                bl = bl2;
                Object object3 = object;
                if (n2 != 4) {
                    return;
                }
            }
        } else {
            Object var3_7 = null;
            bl = false;
        }
        if (this.codecInfo == null) {
            block15: {
                this.codecInfo = this.getDecoderInfo(this.mediaCodecSelector, this.format, bl);
                if (this.codecInfo != null || !bl) break block15;
                try {
                    this.codecInfo = this.getDecoderInfo(this.mediaCodecSelector, this.format, false);
                    if (this.codecInfo != null) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Drm session requires secure decoder for ");
                        ((StringBuilder)object).append((String)charSequence);
                        ((StringBuilder)object).append(", but no secure decoder available. Trying to proceed with ");
                        ((StringBuilder)object).append(this.codecInfo.name);
                        ((StringBuilder)object).append(".");
                        Log.w((String)TAG, (String)((StringBuilder)object).toString());
                    }
                }
                catch (MediaCodecUtil.DecoderQueryException decoderQueryException) {
                    this.throwDecoderInitError(new DecoderInitializationException(this.format, (Throwable)decoderQueryException, bl, -49998));
                }
            }
            if (this.codecInfo == null) {
                this.throwDecoderInitError(new DecoderInitializationException(this.format, null, bl, -49999));
            }
        }
        if (!this.shouldInitCodec(this.codecInfo)) {
            return;
        }
        object = this.codecInfo.name;
        this.codecAdaptationWorkaroundMode = this.codecAdaptationWorkaroundMode((String)object);
        this.codecNeedsDiscardToSpsWorkaround = MediaCodecRenderer.codecNeedsDiscardToSpsWorkaround((String)object, this.format);
        this.codecNeedsFlushWorkaround = MediaCodecRenderer.codecNeedsFlushWorkaround((String)object);
        this.codecNeedsEosPropagationWorkaround = MediaCodecRenderer.codecNeedsEosPropagationWorkaround(this.codecInfo);
        this.codecNeedsEosFlushWorkaround = MediaCodecRenderer.codecNeedsEosFlushWorkaround((String)object);
        this.codecNeedsEosOutputExceptionWorkaround = MediaCodecRenderer.codecNeedsEosOutputExceptionWorkaround((String)object);
        this.codecNeedsMonoChannelCountWorkaround = MediaCodecRenderer.codecNeedsMonoChannelCountWorkaround((String)object, this.format);
        try {
            void var3_8;
            long l3 = SystemClock.elapsedRealtime();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("createCodec:");
            ((StringBuilder)charSequence).append((String)object);
            TraceUtil.beginSection((String)((StringBuilder)charSequence).toString());
            this.codec = MediaCodec.createByCodecName((String)object);
            TraceUtil.endSection();
            TraceUtil.beginSection((String)"configureCodec");
            this.configureCodec(this.codecInfo, this.codec, this.format, (MediaCrypto)var3_8);
            TraceUtil.endSection();
            TraceUtil.beginSection((String)"startCodec");
            this.codec.start();
            TraceUtil.endSection();
            l2 = SystemClock.elapsedRealtime();
            this.onCodecInitialized((String)object, l2, l2 - l3);
            this.getCodecBuffers();
        }
        catch (Exception exception) {
            this.throwDecoderInitError(new DecoderInitializationException(this.format, (Throwable)exception, bl, (String)object));
        }
        l2 = this.getState() == 2 ? SystemClock.elapsedRealtime() + 1000L : -9223372036854775807L;
        this.codecHotswapDeadlineMs = l2;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        object = this.decoderCounters;
        ++((DecoderCounters)object).decoderInitCount;
    }

    protected void onCodecInitialized(String string2, long l2, long l3) {
    }

    protected void onDisabled() {
        block22: {
            this.format = null;
            try {
                this.releaseCodec();
            }
            catch (Throwable throwable) {
                block23: {
                    try {
                        if (this.drmSession == null) break block23;
                        this.drmSessionManager.releaseSession(this.drmSession);
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (this.pendingDrmSession != null && this.pendingDrmSession != this.drmSession) {
                                this.drmSessionManager.releaseSession(this.pendingDrmSession);
                            }
                            throw throwable2;
                        }
                        finally {
                            this.drmSession = null;
                            this.pendingDrmSession = null;
                        }
                    }
                }
                try {
                    if (this.pendingDrmSession != null && this.pendingDrmSession != this.drmSession) {
                        this.drmSessionManager.releaseSession(this.pendingDrmSession);
                    }
                    throw throwable;
                }
                finally {
                    this.drmSession = null;
                    this.pendingDrmSession = null;
                }
            }
            try {
                if (this.drmSession == null) break block22;
                this.drmSessionManager.releaseSession(this.drmSession);
            }
            catch (Throwable throwable) {
                try {
                    if (this.pendingDrmSession != null && this.pendingDrmSession != this.drmSession) {
                        this.drmSessionManager.releaseSession(this.pendingDrmSession);
                    }
                    throw throwable;
                }
                finally {
                    this.drmSession = null;
                    this.pendingDrmSession = null;
                }
            }
        }
        try {
            if (this.pendingDrmSession != null && this.pendingDrmSession != this.drmSession) {
                this.drmSessionManager.releaseSession(this.pendingDrmSession);
            }
            return;
        }
        finally {
            this.drmSession = null;
            this.pendingDrmSession = null;
        }
    }

    protected void onEnabled(boolean bl) throws ExoPlaybackException {
        this.decoderCounters = new DecoderCounters();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onInputFormatChanged(Format object) throws ExoPlaybackException {
        int n2;
        block12: {
            boolean bl;
            block14: {
                block13: {
                    void var1_4;
                    Format format = this.format;
                    this.format = object;
                    Object object2 = this.format.drmInitData;
                    if (format == null) {
                        Object var1_2 = null;
                    } else {
                        DrmInitData drmInitData = format.drmInitData;
                    }
                    if (Util.areEqual((Object)object2, (Object)var1_4) ^ true) {
                        if (this.format.drmInitData != null) {
                            DrmSessionManager<FrameworkMediaCrypto> drmSessionManager = this.drmSessionManager;
                            if (drmSessionManager == null) throw ExoPlaybackException.createForRenderer(new IllegalStateException("Media requires a DrmSessionManager"), this.getIndex());
                            this.pendingDrmSession = drmSessionManager.acquireSession(Looper.myLooper(), this.format.drmInitData);
                            DrmSession<FrameworkMediaCrypto> drmSession = this.pendingDrmSession;
                            if (drmSession == this.drmSession) {
                                this.drmSessionManager.releaseSession(drmSession);
                            }
                        } else {
                            this.pendingDrmSession = null;
                        }
                    }
                    object2 = this.pendingDrmSession;
                    DrmSession<FrameworkMediaCrypto> drmSession = this.drmSession;
                    int n3 = 0;
                    boolean bl2 = false;
                    n2 = n3;
                    if (object2 != drmSession) break block12;
                    MediaCodec mediaCodec = this.codec;
                    n2 = n3;
                    if (mediaCodec == null) break block12;
                    int n4 = this.canKeepCodec(mediaCodec, this.codecInfo, format, this.format);
                    n2 = n3;
                    if (n4 == 0) break block12;
                    if (n4 == 1) return;
                    if (n4 != 3) throw new IllegalStateException();
                    this.codecReconfigured = true;
                    this.codecReconfigurationState = 1;
                    n2 = this.codecAdaptationWorkaroundMode;
                    if (n2 == 2) break block13;
                    bl = bl2;
                    if (n2 != 1) break block14;
                    bl = bl2;
                    if (this.format.width != format.width) break block14;
                    bl = bl2;
                    if (this.format.height != format.height) break block14;
                }
                bl = true;
            }
            this.codecNeedsAdaptationWorkaroundBuffer = bl;
            return;
        }
        if (n2 != 0) return;
        if (this.codecReceivedBuffers) {
            this.codecReinitializationState = 1;
            return;
        } else {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) throws ExoPlaybackException {
    }

    protected void onPositionReset(long l2, boolean bl) throws ExoPlaybackException {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.codec != null) {
            this.flushCodec();
        }
    }

    protected void onProcessedOutputBuffer(long l2) {
    }

    protected void onQueueInputBuffer(DecoderInputBuffer decoderInputBuffer) {
    }

    protected void onStarted() {
    }

    protected void onStopped() {
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, MediaCodec var5, ByteBuffer var6, int var7, int var8, long var9, boolean var11) throws ExoPlaybackException;

    protected void releaseCodec() {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.resetCodecBuffers();
        this.codecInfo = null;
        this.codecReconfigured = false;
        this.codecReceivedBuffers = false;
        this.codecNeedsDiscardToSpsWorkaround = false;
        this.codecNeedsFlushWorkaround = false;
        this.codecAdaptationWorkaroundMode = 0;
        this.codecNeedsEosPropagationWorkaround = false;
        this.codecNeedsEosFlushWorkaround = false;
        this.codecNeedsMonoChannelCountWorkaround = false;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.codecReceivedEos = false;
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
        if (this.codec != null) {
            DecoderCounters decoderCounters = this.decoderCounters;
            ++decoderCounters.decoderReleaseCount;
            try {
                this.codec.stop();
            }
            catch (Throwable throwable) {
                try {
                    this.codec.release();
                    throw throwable;
                }
                finally {
                    this.codec = null;
                    DrmSession<FrameworkMediaCrypto> drmSession = this.drmSession;
                    if (drmSession != null && this.pendingDrmSession != drmSession) {
                        try {
                            this.drmSessionManager.releaseSession(drmSession);
                        }
                        finally {
                            this.drmSession = null;
                        }
                    }
                }
            }
            try {
                this.codec.release();
            }
            finally {
                this.codec = null;
                DrmSession<FrameworkMediaCrypto> drmSession = this.drmSession;
                if (drmSession != null && this.pendingDrmSession != drmSession) {
                    try {
                        this.drmSessionManager.releaseSession(drmSession);
                    }
                    finally {
                        this.drmSession = null;
                    }
                }
            }
        }
    }

    public void render(long l2, long l3) throws ExoPlaybackException {
        int n2;
        if (this.outputStreamEnded) {
            this.renderToEndOfStream();
            return;
        }
        if (this.format == null) {
            this.flagsOnlyBuffer.clear();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, true);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.format);
            } else {
                if (n2 == -4) {
                    Assertions.checkState(this.flagsOnlyBuffer.isEndOfStream());
                    this.inputStreamEnded = true;
                    this.processEndOfStream();
                }
                return;
            }
        }
        this.maybeInitCodec();
        if (this.codec != null) {
            TraceUtil.beginSection((String)"drainAndFeed");
            while (this.drainOutputBuffer(l2, l3)) {
            }
            while (this.feedInputBuffer()) {
            }
            TraceUtil.endSection();
        } else {
            DecoderCounters decoderCounters = this.decoderCounters;
            decoderCounters.skippedInputBufferCount += this.skipSource(l2);
            this.flagsOnlyBuffer.clear();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, false);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.format);
            } else if (n2 == -4) {
                Assertions.checkState(this.flagsOnlyBuffer.isEndOfStream());
                this.inputStreamEnded = true;
                this.processEndOfStream();
            }
        }
        this.decoderCounters.ensureUpdated();
    }

    protected void renderToEndOfStream() throws ExoPlaybackException {
    }

    protected boolean shouldInitCodec(MediaCodecInfo mediaCodecInfo) {
        return true;
    }

    public final int supportsFormat(Format format) throws ExoPlaybackException {
        try {
            int n2 = this.supportsFormat(this.mediaCodecSelector, this.drmSessionManager, format);
            return n2;
        }
        catch (MediaCodecUtil.DecoderQueryException decoderQueryException) {
            throw ExoPlaybackException.createForRenderer((Exception)((Object)decoderQueryException), this.getIndex());
        }
    }

    protected abstract int supportsFormat(MediaCodecSelector var1, DrmSessionManager<FrameworkMediaCrypto> var2, Format var3) throws MediaCodecUtil.DecoderQueryException;

    public final int supportsMixedMimeTypeAdaptation() {
        return 8;
    }

    private static @interface AdaptationWorkaroundMode {
    }

    public static class DecoderInitializationException
    extends Exception {
        private static final int CUSTOM_ERROR_CODE_BASE = -50000;
        private static final int DECODER_QUERY_ERROR = -49998;
        private static final int NO_SUITABLE_DECODER_ERROR = -49999;
        public final String decoderName;
        public final String diagnosticInfo;
        public final String mimeType;
        public final boolean secureDecoderRequired;

        public DecoderInitializationException(Format format, Throwable throwable, boolean bl, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Decoder init failed: [");
            stringBuilder.append(n2);
            stringBuilder.append("], ");
            stringBuilder.append(format);
            super(stringBuilder.toString(), throwable);
            this.mimeType = format.sampleMimeType;
            this.secureDecoderRequired = bl;
            this.decoderName = null;
            this.diagnosticInfo = DecoderInitializationException.buildCustomDiagnosticInfo(n2);
        }

        public DecoderInitializationException(Format object, Throwable throwable, boolean bl, String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Decoder init failed: ");
            stringBuilder.append(string2);
            stringBuilder.append(", ");
            stringBuilder.append(object);
            super(stringBuilder.toString(), throwable);
            this.mimeType = object.sampleMimeType;
            this.secureDecoderRequired = bl;
            this.decoderName = string2;
            object = Util.SDK_INT >= 21 ? DecoderInitializationException.getDiagnosticInfoV21(throwable) : null;
            this.diagnosticInfo = object;
        }

        private static String buildCustomDiagnosticInfo(int n2) {
            String string2 = n2 < 0 ? "neg_" : "";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("com.google.android.exoplayer.MediaCodecTrackRenderer_");
            stringBuilder.append(string2);
            stringBuilder.append(Math.abs(n2));
            return stringBuilder.toString();
        }

        private static String getDiagnosticInfoV21(Throwable throwable) {
            if (throwable instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)throwable).getDiagnosticInfo();
            }
            return null;
        }
    }

    protected static @interface KeepCodecResult {
    }

    private static @interface ReconfigurationState {
    }

    private static @interface ReinitializationState {
    }
}

