/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.extractor.ts;

import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.mbridge.msdk.playercommon.exoplayer2.ParserException;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.Extractor;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorInput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorsFactory;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.PositionHolder;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.SeekMap;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ts.DefaultTsPayloadReaderFactory;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ts.SectionPayloadReader;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ts.SectionReader;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ts.TsPayloadReader;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableBitArray;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableByteArray;
import com.mbridge.msdk.playercommon.exoplayer2.util.TimestampAdjuster;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TsExtractor
implements Extractor {
    private static final long AC3_FORMAT_IDENTIFIER;
    private static final int BUFFER_SIZE = 9400;
    private static final long E_AC3_FORMAT_IDENTIFIER;
    public static final ExtractorsFactory FACTORY;
    private static final long HEVC_FORMAT_IDENTIFIER;
    private static final int MAX_PID_PLUS_ONE = 8192;
    public static final int MODE_HLS = 2;
    public static final int MODE_MULTI_PMT = 0;
    public static final int MODE_SINGLE_PMT = 1;
    private static final int SNIFF_TS_PACKET_COUNT = 5;
    private static final int TS_PACKET_SIZE = 188;
    private static final int TS_PAT_PID = 0;
    public static final int TS_STREAM_TYPE_AAC_ADTS = 15;
    public static final int TS_STREAM_TYPE_AAC_LATM = 17;
    public static final int TS_STREAM_TYPE_AC3 = 129;
    public static final int TS_STREAM_TYPE_DTS = 138;
    public static final int TS_STREAM_TYPE_DVBSUBS = 89;
    public static final int TS_STREAM_TYPE_E_AC3 = 135;
    public static final int TS_STREAM_TYPE_H262 = 2;
    public static final int TS_STREAM_TYPE_H264 = 27;
    public static final int TS_STREAM_TYPE_H265 = 36;
    public static final int TS_STREAM_TYPE_HDMV_DTS = 130;
    public static final int TS_STREAM_TYPE_ID3 = 21;
    public static final int TS_STREAM_TYPE_MPA = 3;
    public static final int TS_STREAM_TYPE_MPA_LSF = 4;
    public static final int TS_STREAM_TYPE_SPLICE_INFO = 134;
    private static final int TS_SYNC_BYTE = 71;
    private int bytesSinceLastSync;
    private final SparseIntArray continuityCounters;
    private TsPayloadReader id3Reader;
    private final int mode;
    private ExtractorOutput output;
    private final TsPayloadReader.Factory payloadReaderFactory;
    private int remainingPmts;
    private final List<TimestampAdjuster> timestampAdjusters;
    private final SparseBooleanArray trackIds;
    private boolean tracksEnded;
    private final ParsableByteArray tsPacketBuffer;
    private final SparseArray<TsPayloadReader> tsPayloadReaders;

    static {
        FACTORY = new ExtractorsFactory(){

            public final Extractor[] createExtractors() {
                return new Extractor[]{new TsExtractor()};
            }
        };
        AC3_FORMAT_IDENTIFIER = Util.getIntegerCodeForString((String)"AC-3");
        E_AC3_FORMAT_IDENTIFIER = Util.getIntegerCodeForString((String)"EAC3");
        HEVC_FORMAT_IDENTIFIER = Util.getIntegerCodeForString((String)"HEVC");
    }

    public TsExtractor() {
        this(0);
    }

    public TsExtractor(int n2) {
        this(1, n2);
    }

    public TsExtractor(int n2, int n3) {
        this(n2, new TimestampAdjuster(0L), new DefaultTsPayloadReaderFactory(n3));
    }

    public TsExtractor(int n2, TimestampAdjuster timestampAdjuster, TsPayloadReader.Factory factory) {
        this.payloadReaderFactory = Assertions.checkNotNull(factory);
        this.mode = n2;
        if (n2 != 1 && n2 != 2) {
            this.timestampAdjusters = new ArrayList<TimestampAdjuster>();
            this.timestampAdjusters.add(timestampAdjuster);
        } else {
            this.timestampAdjusters = Collections.singletonList(timestampAdjuster);
        }
        this.tsPacketBuffer = new ParsableByteArray(new byte[9400], 0);
        this.trackIds = new SparseBooleanArray();
        this.tsPayloadReaders = new SparseArray();
        this.continuityCounters = new SparseIntArray();
        this.resetPayloadReaders();
    }

    static /* synthetic */ long access$1000() {
        return E_AC3_FORMAT_IDENTIFIER;
    }

    static /* synthetic */ int access$102(TsExtractor tsExtractor, int n2) {
        tsExtractor.remainingPmts = n2;
        return n2;
    }

    static /* synthetic */ int access$108(TsExtractor tsExtractor) {
        int n2 = tsExtractor.remainingPmts;
        tsExtractor.remainingPmts = n2 + 1;
        return n2;
    }

    static /* synthetic */ long access$1100() {
        return HEVC_FORMAT_IDENTIFIER;
    }

    static /* synthetic */ TsPayloadReader access$402(TsExtractor tsExtractor, TsPayloadReader tsPayloadReader) {
        tsExtractor.id3Reader = tsPayloadReader;
        return tsPayloadReader;
    }

    static /* synthetic */ boolean access$802(TsExtractor tsExtractor, boolean bl) {
        tsExtractor.tracksEnded = bl;
        return bl;
    }

    static /* synthetic */ long access$900() {
        return AC3_FORMAT_IDENTIFIER;
    }

    private void resetPayloadReaders() {
        this.trackIds.clear();
        this.tsPayloadReaders.clear();
        SparseArray sparseArray = this.payloadReaderFactory.createInitialPayloadReaders();
        int n2 = sparseArray.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tsPayloadReaders.put(sparseArray.keyAt(i2), sparseArray.valueAt(i2));
        }
        this.tsPayloadReaders.put(0, (Object)new SectionReader((SectionPayloadReader)new PatReader()));
        this.id3Reader = null;
    }

    public final void init(ExtractorOutput extractorOutput) {
        this.output = extractorOutput;
        extractorOutput.seekMap((SeekMap)new SeekMap.Unseekable(-9223372036854775807L));
    }

    public final int read(ExtractorInput object, PositionHolder object2) throws IOException, InterruptedException {
        int n2;
        int n3;
        object2 = this.tsPacketBuffer.data;
        if (9400 - this.tsPacketBuffer.getPosition() < 188) {
            n3 = this.tsPacketBuffer.bytesLeft();
            if (n3 > 0) {
                System.arraycopy(object2, this.tsPacketBuffer.getPosition(), object2, 0, n3);
            }
            this.tsPacketBuffer.reset((byte[])object2, n3);
        }
        while (this.tsPacketBuffer.bytesLeft() < 188) {
            n2 = this.tsPacketBuffer.limit();
            n3 = object.read((byte[])object2, n2, 9400 - n2);
            if (n3 == -1) {
                return -1;
            }
            this.tsPacketBuffer.setLimit(n2 + n3);
        }
        int n4 = this.tsPacketBuffer.limit();
        for (n3 = n2 = this.tsPacketBuffer.getPosition(); n3 < n4 && object2[n3] != 71; ++n3) {
        }
        this.tsPacketBuffer.setPosition(n3);
        int n5 = n3 + 188;
        if (n5 > n4) {
            this.bytesSinceLastSync += n3 - n2;
            if (this.mode == 2 && this.bytesSinceLastSync > 376) {
                throw new ParserException("Cannot find sync byte. Most likely not a Transport Stream.");
            }
            return 0;
        }
        this.bytesSinceLastSync = 0;
        int n6 = this.tsPacketBuffer.readInt();
        if ((0x800000 & n6) != 0) {
            this.tsPacketBuffer.setPosition(n5);
            return 0;
        }
        boolean bl = (0x400000 & n6) != 0;
        int n7 = (0x1FFF00 & n6) >> 8;
        n3 = (n6 & 0x20) != 0 ? 1 : 0;
        n2 = (n6 & 0x10) != 0 ? 1 : 0;
        object = n2 != 0 ? (TsPayloadReader)this.tsPayloadReaders.get(n7) : null;
        if (object == null) {
            this.tsPacketBuffer.setPosition(n5);
            return 0;
        }
        if (this.mode != 2) {
            n2 = n6 & 0xF;
            n6 = this.continuityCounters.get(n7, n2 - 1);
            this.continuityCounters.put(n7, n2);
            if (n6 == n2) {
                this.tsPacketBuffer.setPosition(n5);
                return 0;
            }
            if (n2 != (n6 + 1 & 0xF)) {
                object.seek();
            }
        }
        if (n3 != 0) {
            n3 = this.tsPacketBuffer.readUnsignedByte();
            this.tsPacketBuffer.skipBytes(n3);
        }
        this.tsPacketBuffer.setLimit(n5);
        object.consume(this.tsPacketBuffer, bl);
        this.tsPacketBuffer.setLimit(n4);
        this.tsPacketBuffer.setPosition(n5);
        return 0;
    }

    public final void release() {
    }

    public final void seek(long l2, long l3) {
        int n2 = this.timestampAdjusters.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.timestampAdjusters.get(i2).reset();
        }
        this.tsPacketBuffer.reset();
        this.continuityCounters.clear();
        this.resetPayloadReaders();
        this.bytesSinceLastSync = 0;
    }

    public final boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        byte[] byArray = this.tsPacketBuffer.data;
        extractorInput.peekFully(byArray, 0, 940);
        block0: for (int i2 = 0; i2 < 188; ++i2) {
            int n2 = 0;
            while (true) {
                if (n2 == 5) {
                    extractorInput.skipFully(i2);
                    return true;
                }
                if (byArray[n2 * 188 + i2] != 71) {
                    continue block0;
                }
                ++n2;
            }
        }
        return false;
    }

    public static @interface Mode {
    }

    private class PatReader
    implements SectionPayloadReader {
        private final ParsableBitArray patScratch = new ParsableBitArray(new byte[4]);

        public void consume(ParsableByteArray parsableByteArray) {
            if (parsableByteArray.readUnsignedByte() != 0) {
                return;
            }
            parsableByteArray.skipBytes(7);
            int n2 = parsableByteArray.bytesLeft() / 4;
            for (int i2 = 0; i2 < n2; ++i2) {
                parsableByteArray.readBytes(this.patScratch, 4);
                int n3 = this.patScratch.readBits(16);
                this.patScratch.skipBits(3);
                if (n3 == 0) {
                    this.patScratch.skipBits(13);
                    continue;
                }
                n3 = this.patScratch.readBits(13);
                TsExtractor.this.tsPayloadReaders.put(n3, (Object)new SectionReader((SectionPayloadReader)new PmtReader(n3)));
                TsExtractor.access$108(TsExtractor.this);
            }
            if (TsExtractor.this.mode != 2) {
                TsExtractor.this.tsPayloadReaders.remove(0);
            }
        }

        public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        }
    }

    private class PmtReader
    implements SectionPayloadReader {
        private static final int TS_PMT_DESC_AC3 = 106;
        private static final int TS_PMT_DESC_DTS = 123;
        private static final int TS_PMT_DESC_DVBSUBS = 89;
        private static final int TS_PMT_DESC_EAC3 = 122;
        private static final int TS_PMT_DESC_ISO639_LANG = 10;
        private static final int TS_PMT_DESC_REGISTRATION = 5;
        private final int pid;
        private final ParsableBitArray pmtScratch = new ParsableBitArray(new byte[5]);
        private final SparseIntArray trackIdToPidScratch;
        private final SparseArray<TsPayloadReader> trackIdToReaderScratch = new SparseArray();

        public PmtReader(int n2) {
            this.trackIdToPidScratch = new SparseIntArray();
            this.pid = n2;
        }

        /*
         * Unable to fully structure code
         */
        private TsPayloadReader.EsInfo readEsInfo(ParsableByteArray var1_1, int var2_2) {
            var3_3 = var1_1.getPosition();
            var4_4 = var2_2 + var3_3;
            var5_5 = null;
            var2_2 = -1;
            var6_6 = null;
            while (var1_1.getPosition() < var4_4) {
                block13: {
                    block12: {
                        var7_7 = var1_1.readUnsignedByte();
                        var8_8 = var1_1.readUnsignedByte();
                        var8_8 = var1_1.getPosition() + var8_8;
                        if (var7_7 != 5) break block12;
                        var9_9 = var1_1.readUnsignedInt();
                        if (var9_9 == TsExtractor.access$900()) ** GOTO lbl-1000
                        if (var9_9 == TsExtractor.access$1000()) ** GOTO lbl-1000
                        var11_10 = var5_5;
                        var12_11 = var6_6;
                        if (var9_9 == TsExtractor.access$1100()) {
                            var2_2 = 36;
                            var11_10 = var5_5;
                            var12_11 = var6_6;
                        }
                        break block13;
                    }
                    if (var7_7 == 106) lbl-1000:
                    // 2 sources

                    {
                        var2_2 = 129;
                        var11_10 = var5_5;
                        var12_11 = var6_6;
                    } else if (var7_7 == 122) lbl-1000:
                    // 2 sources

                    {
                        var2_2 = 135;
                        var11_10 = var5_5;
                        var12_11 = var6_6;
                    } else if (var7_7 == 123) {
                        var2_2 = 138;
                        var11_10 = var5_5;
                        var12_11 = var6_6;
                    } else if (var7_7 == 10) {
                        var11_10 = var1_1.readString(3).trim();
                        var12_11 = var6_6;
                    } else {
                        var11_10 = var5_5;
                        var12_11 = var6_6;
                        if (var7_7 == 89) {
                            var12_11 = new ArrayList<TsPayloadReader.DvbSubtitleInfo>();
                            while (var1_1.getPosition() < var8_8) {
                                var11_10 = var1_1.readString(3).trim();
                                var2_2 = var1_1.readUnsignedByte();
                                var6_6 = new byte[4];
                                var1_1.readBytes((byte[])var6_6, 0, 4);
                                var12_11.add(new TsPayloadReader.DvbSubtitleInfo(var11_10, var2_2, (byte[])var6_6));
                            }
                            var2_2 = 89;
                            var11_10 = var5_5;
                        }
                    }
                }
                var1_1.skipBytes(var8_8 - var1_1.getPosition());
                var5_5 = var11_10;
                var6_6 = var12_11;
            }
            var1_1.setPosition(var4_4);
            return new TsPayloadReader.EsInfo(var2_2, var5_5, var6_6, Arrays.copyOfRange(var1_1.data, var3_3, var4_4));
        }

        public void consume(ParsableByteArray object) {
            int n2;
            TsPayloadReader.EsInfo esInfo;
            TimestampAdjuster timestampAdjuster;
            if (object.readUnsignedByte() != 2) {
                return;
            }
            int n3 = TsExtractor.this.mode;
            int n4 = 0;
            if (n3 != 1 && TsExtractor.this.mode != 2 && TsExtractor.this.remainingPmts != 1) {
                timestampAdjuster = new TimestampAdjuster(((TimestampAdjuster)TsExtractor.this.timestampAdjusters.get(0)).getFirstSampleTimestampUs());
                TsExtractor.this.timestampAdjusters.add(timestampAdjuster);
            } else {
                timestampAdjuster = (TimestampAdjuster)TsExtractor.this.timestampAdjusters.get(0);
            }
            object.skipBytes(2);
            int n5 = object.readUnsignedShort();
            object.skipBytes(5);
            object.readBytes(this.pmtScratch, 2);
            this.pmtScratch.skipBits(4);
            object.skipBytes(this.pmtScratch.readBits(12));
            if (TsExtractor.this.mode == 2 && TsExtractor.this.id3Reader == null) {
                esInfo = new TsPayloadReader.EsInfo(21, null, null, new byte[0]);
                TsExtractor tsExtractor = TsExtractor.this;
                TsExtractor.access$402(tsExtractor, tsExtractor.payloadReaderFactory.createPayloadReader(21, esInfo));
                TsExtractor.this.id3Reader.init(timestampAdjuster, TsExtractor.this.output, new TsPayloadReader.TrackIdGenerator(n5, 21, 8192));
            }
            this.trackIdToReaderScratch.clear();
            this.trackIdToPidScratch.clear();
            int n6 = object.bytesLeft();
            while (n6 > 0) {
                object.readBytes(this.pmtScratch, 5);
                int n7 = this.pmtScratch.readBits(8);
                this.pmtScratch.skipBits(3);
                n2 = this.pmtScratch.readBits(13);
                this.pmtScratch.skipBits(4);
                int n8 = this.pmtScratch.readBits(12);
                esInfo = this.readEsInfo((ParsableByteArray)object, n8);
                n3 = n7;
                if (n7 == 6) {
                    n3 = esInfo.streamType;
                }
                n7 = n6 - (n8 + 5);
                n6 = TsExtractor.this.mode == 2 ? n3 : n2;
                if (!TsExtractor.this.trackIds.get(n6)) {
                    esInfo = TsExtractor.this.mode == 2 && n3 == 21 ? TsExtractor.this.id3Reader : TsExtractor.this.payloadReaderFactory.createPayloadReader(n3, esInfo);
                    if (TsExtractor.this.mode != 2 || n2 < this.trackIdToPidScratch.get(n6, 8192)) {
                        this.trackIdToPidScratch.put(n6, n2);
                        this.trackIdToReaderScratch.put(n6, (Object)esInfo);
                    }
                }
                n6 = n7;
            }
            n6 = this.trackIdToPidScratch.size();
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = this.trackIdToPidScratch.keyAt(n3);
                TsExtractor.this.trackIds.put(n2, true);
                object = (TsPayloadReader)this.trackIdToReaderScratch.valueAt(n3);
                if (object == null) continue;
                if (object != TsExtractor.this.id3Reader) {
                    object.init(timestampAdjuster, TsExtractor.this.output, new TsPayloadReader.TrackIdGenerator(n5, n2, 8192));
                }
                TsExtractor.this.tsPayloadReaders.put(this.trackIdToPidScratch.valueAt(n3), object);
            }
            if (TsExtractor.this.mode == 2) {
                if (!TsExtractor.this.tracksEnded) {
                    TsExtractor.this.output.endTracks();
                    TsExtractor.access$102(TsExtractor.this, 0);
                    TsExtractor.access$802(TsExtractor.this, true);
                }
            } else {
                TsExtractor.this.tsPayloadReaders.remove(this.pid);
                object = TsExtractor.this;
                n3 = ((TsExtractor)object).mode == 1 ? n4 : TsExtractor.this.remainingPmts - 1;
                TsExtractor.access$102((TsExtractor)object, n3);
                if (TsExtractor.this.remainingPmts == 0) {
                    TsExtractor.this.output.endTracks();
                    TsExtractor.access$802(TsExtractor.this, true);
                }
            }
        }

        public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        }
    }
}

