/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4;

import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.ParserException;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.Extractor;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorInput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorsFactory;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.GaplessInfoHolder;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.PositionHolder;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.SeekMap;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.SeekPoint;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.TrackOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.Atom;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.AtomParsers;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.Sniffer;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.Track;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.TrackSampleTable;
import com.mbridge.msdk.playercommon.exoplayer2.metadata.Metadata;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.NalUnitUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableByteArray;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;

public final class Mp4Extractor
implements Extractor,
SeekMap {
    private static final int BRAND_QUICKTIME;
    public static final ExtractorsFactory FACTORY;
    public static final int FLAG_WORKAROUND_IGNORE_EDIT_LISTS = 1;
    private static final long MAXIMUM_READ_AHEAD_BYTES_STREAM = 0xA00000L;
    private static final long RELOAD_MINIMUM_SEEK_DISTANCE = 262144L;
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private long[][] accumulatedSampleSizes;
    private ParsableByteArray atomData;
    private final ParsableByteArray atomHeader;
    private int atomHeaderBytesRead;
    private long atomSize;
    private int atomType;
    private final ArrayDeque<Atom.ContainerAtom> containerAtoms;
    private long durationUs;
    private ExtractorOutput extractorOutput;
    private int firstVideoTrackIndex;
    private final int flags;
    private boolean isQuickTime;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray nalStartCode;
    private int parserState;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private int sampleTrackIndex;
    private Mp4Track[] tracks;

    static {
        FACTORY = new ExtractorsFactory(){

            public final Extractor[] createExtractors() {
                return new Extractor[]{new Mp4Extractor()};
            }
        };
        BRAND_QUICKTIME = Util.getIntegerCodeForString((String)"qt  ");
    }

    public Mp4Extractor() {
        this(0);
    }

    public Mp4Extractor(int n2) {
        this.flags = n2;
        this.atomHeader = new ParsableByteArray(16);
        this.containerAtoms = new ArrayDeque();
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.sampleTrackIndex = -1;
    }

    private static long[][] calculateAccumulatedSampleSizes(Mp4Track[] mp4TrackArray) {
        int n2;
        long[][] lArrayArray = new long[mp4TrackArray.length][];
        int[] nArray = new int[mp4TrackArray.length];
        long[] lArray = new long[mp4TrackArray.length];
        boolean[] blArray = new boolean[mp4TrackArray.length];
        for (n2 = 0; n2 < mp4TrackArray.length; ++n2) {
            lArrayArray[n2] = new long[mp4TrackArray[n2].sampleTable.sampleCount];
            lArray[n2] = mp4TrackArray[n2].sampleTable.timestampsUs[0];
        }
        long l2 = 0L;
        int n3 = 0;
        while (n3 < mp4TrackArray.length) {
            int n4 = -1;
            long l3 = Long.MAX_VALUE;
            for (n2 = 0; n2 < mp4TrackArray.length; ++n2) {
                int n5 = n4;
                long l4 = l3;
                if (!blArray[n2]) {
                    n5 = n4;
                    l4 = l3;
                    if (lArray[n2] <= l3) {
                        l4 = lArray[n2];
                        n5 = n2;
                    }
                }
                n4 = n5;
                l3 = l4;
            }
            n2 = nArray[n4];
            lArrayArray[n4][n2] = l2;
            l2 += (long)mp4TrackArray[n4].sampleTable.sizes[n2];
            nArray[n4] = ++n2;
            if (n2 < lArrayArray[n4].length) {
                lArray[n4] = mp4TrackArray[n4].sampleTable.timestampsUs[n2];
                continue;
            }
            blArray[n4] = true;
            ++n3;
        }
        return lArrayArray;
    }

    private void enterReadingAtomHeaderState() {
        this.parserState = 0;
        this.atomHeaderBytesRead = 0;
    }

    private static int getSynchronizationSampleIndex(TrackSampleTable trackSampleTable, long l2) {
        int n2;
        int n3 = n2 = trackSampleTable.getIndexOfEarlierOrEqualSynchronizationSample(l2);
        if (n2 == -1) {
            n3 = trackSampleTable.getIndexOfLaterOrEqualSynchronizationSample(l2);
        }
        return n3;
    }

    private int getTrackIndexOfNextReadSample(long l2) {
        Object object;
        long l3 = Long.MAX_VALUE;
        int n2 = 1;
        long l4 = Long.MAX_VALUE;
        int n3 = -1;
        int n4 = -1;
        int n5 = 1;
        long l5 = Long.MAX_VALUE;
        for (int i2 = 0; i2 < ((Mp4Track[])(object = this.tracks)).length; ++i2) {
            long l6;
            block7: {
                int n6;
                int n7;
                long l7;
                long l8;
                long l9;
                int n8;
                block9: {
                    block8: {
                        block6: {
                            object = object[i2];
                            n8 = object.sampleIndex;
                            if (n8 != object.sampleTable.sampleCount) break block6;
                            l6 = l3;
                            break block7;
                        }
                        l9 = object.sampleTable.offsets[n8];
                        l8 = this.accumulatedSampleSizes[i2][n8];
                        l6 = l9 - l2;
                        n8 = l6 >= 0L && l6 < 262144L ? 0 : 1;
                        if (n8 == 0 && n5 != 0) break block8;
                        l7 = l4;
                        n7 = n4;
                        n6 = n5;
                        l9 = l5;
                        if (n8 != n5) break block9;
                        l7 = l4;
                        n7 = n4;
                        n6 = n5;
                        l9 = l5;
                        if (l6 >= l5) break block9;
                    }
                    n6 = n8;
                    n7 = i2;
                    l9 = l6;
                    l7 = l8;
                }
                l6 = l3;
                l4 = l7;
                n4 = n7;
                n5 = n6;
                l5 = l9;
                if (l8 < l3) {
                    n3 = i2;
                    l5 = l9;
                    n5 = n6;
                    n4 = n7;
                    l4 = l7;
                    n2 = n8;
                    l6 = l8;
                }
            }
            l3 = l6;
        }
        if (l3 == Long.MAX_VALUE || n2 == 0 || l4 < l3 + 0xA00000L) {
            n3 = n4;
        }
        return n3;
    }

    private ArrayList<TrackSampleTable> getTrackSampleTables(Atom.ContainerAtom containerAtom, GaplessInfoHolder gaplessInfoHolder, boolean bl) throws ParserException {
        ArrayList<TrackSampleTable> arrayList = new ArrayList<TrackSampleTable>();
        for (int i2 = 0; i2 < containerAtom.containerChildren.size(); ++i2) {
            Track track;
            Atom.ContainerAtom containerAtom2 = (Atom.ContainerAtom)containerAtom.containerChildren.get(i2);
            if (containerAtom2.type != Atom.TYPE_trak || (track = AtomParsers.parseTrak((Atom.ContainerAtom)containerAtom2, (Atom.LeafAtom)containerAtom.getLeafAtomOfType(Atom.TYPE_mvhd), (long)-9223372036854775807L, null, (boolean)bl, (boolean)this.isQuickTime)) == null) continue;
            containerAtom2 = AtomParsers.parseStbl((Track)track, (Atom.ContainerAtom)containerAtom2.getContainerAtomOfType(Atom.TYPE_mdia).getContainerAtomOfType(Atom.TYPE_minf).getContainerAtomOfType(Atom.TYPE_stbl), (GaplessInfoHolder)gaplessInfoHolder);
            if (containerAtom2.sampleCount == 0) continue;
            arrayList.add((TrackSampleTable)containerAtom2);
        }
        return arrayList;
    }

    private static long maybeAdjustSeekOffset(TrackSampleTable trackSampleTable, long l2, long l3) {
        int n2 = Mp4Extractor.getSynchronizationSampleIndex(trackSampleTable, l2);
        if (n2 == -1) {
            return l3;
        }
        return Math.min(trackSampleTable.offsets[n2], l3);
    }

    private void processAtomEnded(long l2) throws ParserException {
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endPosition == l2) {
            Atom.ContainerAtom containerAtom = this.containerAtoms.pop();
            if (containerAtom.type == Atom.TYPE_moov) {
                this.processMoovAtom(containerAtom);
                this.containerAtoms.clear();
                this.parserState = 2;
                continue;
            }
            if (this.containerAtoms.isEmpty()) continue;
            this.containerAtoms.peek().add(containerAtom);
        }
        if (this.parserState != 2) {
            this.enterReadingAtomHeaderState();
        }
    }

    private static boolean processFtypAtom(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        if (parsableByteArray.readInt() == BRAND_QUICKTIME) {
            return true;
        }
        parsableByteArray.skipBytes(4);
        while (parsableByteArray.bytesLeft() > 0) {
            if (parsableByteArray.readInt() != BRAND_QUICKTIME) continue;
            return true;
        }
        return false;
    }

    private void processMoovAtom(Atom.ContainerAtom containerAtom) throws ParserException {
        ArrayList<TrackSampleTable> arrayList;
        Atom.LeafAtom leafAtom;
        ArrayList<Mp4Track> arrayList2 = new ArrayList<Mp4Track>();
        GaplessInfoHolder gaplessInfoHolder = new GaplessInfoHolder();
        Atom.LeafAtom leafAtom2 = containerAtom.getLeafAtomOfType(Atom.TYPE_udta);
        if (leafAtom2 != null) {
            leafAtom = leafAtom2 = AtomParsers.parseUdta((Atom.LeafAtom)leafAtom2, (boolean)this.isQuickTime);
            if (leafAtom2 != null) {
                gaplessInfoHolder.setFromMetadata((Metadata)leafAtom2);
                leafAtom = leafAtom2;
            }
        } else {
            leafAtom = null;
        }
        int n2 = this.flags;
        int n3 = 0;
        boolean bl = (n2 & 1) != 0;
        try {
            arrayList = this.getTrackSampleTables(containerAtom, gaplessInfoHolder, bl);
        }
        catch (AtomParsers.UnhandledEditListException unhandledEditListException) {
            gaplessInfoHolder = new GaplessInfoHolder();
            arrayList = this.getTrackSampleTables(containerAtom, gaplessInfoHolder, true);
        }
        int n4 = arrayList.size();
        n2 = -1;
        long l2 = -9223372036854775807L;
        while (n3 < n4) {
            TrackSampleTable trackSampleTable = arrayList.get(n3);
            Track track = trackSampleTable.track;
            Mp4Track mp4Track = new Mp4Track(track, trackSampleTable, this.extractorOutput.track(n3, track.type));
            int n5 = trackSampleTable.maximumSize;
            Format format = track.format.copyWithMaxInputSize(n5 + 30);
            containerAtom = format;
            if (track.type == 1) {
                leafAtom2 = format;
                if (gaplessInfoHolder.hasGaplessInfo()) {
                    leafAtom2 = format.copyWithGaplessInfo(gaplessInfoHolder.encoderDelay, gaplessInfoHolder.encoderPadding);
                }
                containerAtom = leafAtom2;
                if (leafAtom != null) {
                    containerAtom = leafAtom2.copyWithMetadata((Metadata)leafAtom);
                }
            }
            mp4Track.trackOutput.format((Format)containerAtom);
            long l3 = track.durationUs != -9223372036854775807L ? track.durationUs : trackSampleTable.durationUs;
            l2 = Math.max(l2, l3);
            if (track.type == 2) {
                n5 = n2;
                if (n2 == -1) {
                    n5 = arrayList2.size();
                }
            } else {
                n5 = n2;
            }
            arrayList2.add(mp4Track);
            ++n3;
            n2 = n5;
        }
        this.firstVideoTrackIndex = n2;
        this.durationUs = l2;
        this.tracks = arrayList2.toArray(new Mp4Track[arrayList2.size()]);
        this.accumulatedSampleSizes = Mp4Extractor.calculateAccumulatedSampleSizes(this.tracks);
        this.extractorOutput.endTracks();
        this.extractorOutput.seekMap((SeekMap)this);
    }

    private boolean readAtomHeader(ExtractorInput extractorInput) throws IOException, InterruptedException {
        long l2;
        if (this.atomHeaderBytesRead == 0) {
            if (!extractorInput.readFully(this.atomHeader.data, 0, 8, true)) {
                return false;
            }
            this.atomHeaderBytesRead = 8;
            this.atomHeader.setPosition(0);
            this.atomSize = this.atomHeader.readUnsignedInt();
            this.atomType = this.atomHeader.readInt();
        }
        if ((l2 = this.atomSize) == 1L) {
            extractorInput.readFully(this.atomHeader.data, 8, 8);
            this.atomHeaderBytesRead += 8;
            this.atomSize = this.atomHeader.readUnsignedLongToLong();
        } else if (l2 == 0L) {
            long l3;
            l2 = l3 = extractorInput.getLength();
            if (l3 == -1L) {
                l2 = l3;
                if (!this.containerAtoms.isEmpty()) {
                    l2 = this.containerAtoms.peek().endPosition;
                }
            }
            if (l2 != -1L) {
                this.atomSize = l2 - extractorInput.getPosition() + (long)this.atomHeaderBytesRead;
            }
        }
        if (this.atomSize >= (long)this.atomHeaderBytesRead) {
            if (Mp4Extractor.shouldParseContainerAtom(this.atomType)) {
                l2 = extractorInput.getPosition() + this.atomSize - (long)this.atomHeaderBytesRead;
                this.containerAtoms.push(new Atom.ContainerAtom(this.atomType, l2));
                if (this.atomSize == (long)this.atomHeaderBytesRead) {
                    this.processAtomEnded(l2);
                } else {
                    this.enterReadingAtomHeaderState();
                }
            } else if (Mp4Extractor.shouldParseLeafAtom(this.atomType)) {
                boolean bl = this.atomHeaderBytesRead == 8;
                Assertions.checkState(bl);
                bl = this.atomSize <= Integer.MAX_VALUE;
                Assertions.checkState(bl);
                this.atomData = new ParsableByteArray((int)this.atomSize);
                System.arraycopy(this.atomHeader.data, 0, this.atomData.data, 0, 8);
                this.parserState = 1;
            } else {
                this.atomData = null;
                this.parserState = 1;
            }
            return true;
        }
        throw new ParserException("Atom size less than header length (unsupported).");
    }

    /*
     * Unable to fully structure code
     */
    private boolean readAtomPayload(ExtractorInput var1_1, PositionHolder var2_2) throws IOException, InterruptedException {
        block6: {
            var3_3 = this.atomSize - (long)this.atomHeaderBytesRead;
            var5_4 = var1_1.getPosition();
            var7_5 = this.atomData;
            var8_6 = true;
            if (var7_5 == null) break block6;
            var1_1.readFully(var7_5.data, this.atomHeaderBytesRead, (int)var3_3);
            if (this.atomType == Atom.TYPE_ftyp) {
                this.isQuickTime = Mp4Extractor.processFtypAtom(this.atomData);
            } else if (!this.containerAtoms.isEmpty()) {
                this.containerAtoms.peek().add(new Atom.LeafAtom(this.atomType, this.atomData));
            }
            ** GOTO lbl16
        }
        if (var3_3 < 262144L) {
            var1_1.skipFully((int)var3_3);
lbl16:
            // 3 sources

            var9_7 = false;
        } else {
            var2_2.position = var1_1.getPosition() + var3_3;
            var9_7 = true;
        }
        this.processAtomEnded(var5_4 + var3_3);
        if (!var9_7 || this.parserState == 2) {
            var8_6 = false;
        }
        return var8_6;
    }

    private int readSample(ExtractorInput extractorInput, PositionHolder object) throws IOException, InterruptedException {
        long l2 = extractorInput.getPosition();
        if (this.sampleTrackIndex == -1) {
            this.sampleTrackIndex = this.getTrackIndexOfNextReadSample(l2);
            if (this.sampleTrackIndex == -1) {
                return -1;
            }
        }
        Mp4Track mp4Track = this.tracks[this.sampleTrackIndex];
        TrackOutput trackOutput = mp4Track.trackOutput;
        int n2 = mp4Track.sampleIndex;
        long l3 = mp4Track.sampleTable.offsets[n2];
        int n3 = mp4Track.sampleTable.sizes[n2];
        if ((l2 = l3 - l2 + (long)this.sampleBytesWritten) >= 0L && l2 < 262144L) {
            l3 = l2;
            int n4 = n3;
            if (mp4Track.track.sampleTransformation == 1) {
                l3 = l2 + 8L;
                n4 = n3 - 8;
            }
            extractorInput.skipFully((int)l3);
            if (mp4Track.track.nalUnitLengthFieldLength != 0) {
                object = this.nalLength.data;
                object[0] = (PositionHolder)((byte)0);
                object[1] = (PositionHolder)((byte)0);
                object[2] = (PositionHolder)((byte)0);
                int n5 = mp4Track.track.nalUnitLengthFieldLength;
                int n6 = 4 - mp4Track.track.nalUnitLengthFieldLength;
                while (true) {
                    n3 = n4;
                    if (this.sampleBytesWritten < n4) {
                        n3 = this.sampleCurrentNalBytesRemaining;
                        if (n3 == 0) {
                            extractorInput.readFully(this.nalLength.data, n6, n5);
                            this.nalLength.setPosition(0);
                            this.sampleCurrentNalBytesRemaining = this.nalLength.readUnsignedIntToInt();
                            this.nalStartCode.setPosition(0);
                            trackOutput.sampleData(this.nalStartCode, 4);
                            this.sampleBytesWritten += 4;
                            n4 += n6;
                            continue;
                        }
                        n3 = trackOutput.sampleData(extractorInput, n3, false);
                        this.sampleBytesWritten += n3;
                        this.sampleCurrentNalBytesRemaining -= n3;
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    int n7 = this.sampleBytesWritten;
                    n3 = n4;
                    if (n7 >= n4) break;
                    n3 = trackOutput.sampleData(extractorInput, n4 - n7, false);
                    this.sampleBytesWritten += n3;
                    this.sampleCurrentNalBytesRemaining -= n3;
                }
            }
            trackOutput.sampleMetadata(mp4Track.sampleTable.timestampsUs[n2], mp4Track.sampleTable.flags[n2], n3, 0, null);
            ++mp4Track.sampleIndex;
            this.sampleTrackIndex = -1;
            this.sampleBytesWritten = 0;
            this.sampleCurrentNalBytesRemaining = 0;
            return 0;
        }
        object.position = l3;
        return 1;
    }

    private static boolean shouldParseContainerAtom(int n2) {
        boolean bl = n2 == Atom.TYPE_moov || n2 == Atom.TYPE_trak || n2 == Atom.TYPE_mdia || n2 == Atom.TYPE_minf || n2 == Atom.TYPE_stbl || n2 == Atom.TYPE_edts;
        return bl;
    }

    private static boolean shouldParseLeafAtom(int n2) {
        boolean bl = n2 == Atom.TYPE_mdhd || n2 == Atom.TYPE_mvhd || n2 == Atom.TYPE_hdlr || n2 == Atom.TYPE_stsd || n2 == Atom.TYPE_stts || n2 == Atom.TYPE_stss || n2 == Atom.TYPE_ctts || n2 == Atom.TYPE_elst || n2 == Atom.TYPE_stsc || n2 == Atom.TYPE_stsz || n2 == Atom.TYPE_stz2 || n2 == Atom.TYPE_stco || n2 == Atom.TYPE_co64 || n2 == Atom.TYPE_tkhd || n2 == Atom.TYPE_ftyp || n2 == Atom.TYPE_udta;
        return bl;
    }

    private void updateSampleIndices(long l2) {
        for (Mp4Track mp4Track : this.tracks) {
            int n2;
            TrackSampleTable trackSampleTable = mp4Track.sampleTable;
            int n3 = n2 = trackSampleTable.getIndexOfEarlierOrEqualSynchronizationSample(l2);
            if (n2 == -1) {
                n3 = trackSampleTable.getIndexOfLaterOrEqualSynchronizationSample(l2);
            }
            mp4Track.sampleIndex = n3;
        }
    }

    public final long getDurationUs() {
        return this.durationUs;
    }

    public final SeekMap.SeekPoints getSeekPoints(long l2) {
        long l3;
        long l4;
        long l5;
        long l6;
        SeekPoint seekPoint = this.tracks;
        if (((Mp4Track[])seekPoint).length == 0) {
            return new SeekMap.SeekPoints(SeekPoint.START);
        }
        int n2 = this.firstVideoTrackIndex;
        if (n2 != -1) {
            int n3;
            seekPoint = seekPoint[n2].sampleTable;
            n2 = Mp4Extractor.getSynchronizationSampleIndex((TrackSampleTable)seekPoint, l2);
            if (n2 == -1) {
                return new SeekMap.SeekPoints(SeekPoint.START);
            }
            l6 = seekPoint.timestampsUs[n2];
            l5 = seekPoint.offsets[n2];
            if (l6 < l2 && n2 < seekPoint.sampleCount - 1 && (n3 = seekPoint.getIndexOfLaterOrEqualSynchronizationSample(l2)) != -1 && n3 != n2) {
                l2 = seekPoint.timestampsUs[n3];
                l4 = seekPoint.offsets[n3];
            } else {
                l4 = -1L;
                l2 = -9223372036854775807L;
            }
            l3 = l2;
            l2 = l4;
            l4 = l5;
        } else {
            l4 = Long.MAX_VALUE;
            l5 = -1L;
            l3 = -9223372036854775807L;
            l6 = l2;
            l2 = l5;
        }
        for (n2 = 0; n2 < ((Mp4Track[])(seekPoint = this.tracks)).length; ++n2) {
            long l7 = l2;
            l5 = l4;
            if (n2 != this.firstVideoTrackIndex) {
                seekPoint = seekPoint[n2].sampleTable;
                l5 = Mp4Extractor.maybeAdjustSeekOffset((TrackSampleTable)seekPoint, l6, l4);
                l4 = l2;
                if (l3 != -9223372036854775807L) {
                    l4 = Mp4Extractor.maybeAdjustSeekOffset((TrackSampleTable)seekPoint, l3, l2);
                }
                l7 = l4;
            }
            l2 = l7;
            l4 = l5;
        }
        seekPoint = new SeekPoint(l6, l4);
        if (l3 == -9223372036854775807L) {
            return new SeekMap.SeekPoints(seekPoint);
        }
        return new SeekMap.SeekPoints(seekPoint, new SeekPoint(l3, l2));
    }

    public final void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
    }

    public final boolean isSeekable() {
        return true;
    }

    public final int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        while (true) {
            int n2;
            if ((n2 = this.parserState) != 0) {
                if (n2 != 1) {
                    if (n2 == 2) {
                        return this.readSample(extractorInput, positionHolder);
                    }
                    throw new IllegalStateException();
                }
                if (!this.readAtomPayload(extractorInput, positionHolder)) continue;
                return 1;
            }
            if (!this.readAtomHeader(extractorInput)) break;
        }
        return -1;
    }

    public final void release() {
    }

    public final void seek(long l2, long l3) {
        this.containerAtoms.clear();
        this.atomHeaderBytesRead = 0;
        this.sampleTrackIndex = -1;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        if (l2 == 0L) {
            this.enterReadingAtomHeaderState();
        } else if (this.tracks != null) {
            this.updateSampleIndices(l3);
        }
    }

    public final boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return Sniffer.sniffUnfragmented((ExtractorInput)extractorInput);
    }

    public static @interface Flags {
    }

    private static final class Mp4Track {
        public int sampleIndex;
        public final TrackSampleTable sampleTable;
        public final Track track;
        public final TrackOutput trackOutput;

        public Mp4Track(Track track, TrackSampleTable trackSampleTable, TrackOutput trackOutput) {
            this.track = track;
            this.sampleTable = trackSampleTable;
            this.trackOutput = trackOutput;
        }
    }

    private static @interface State {
    }
}

