/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4;

import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.mbridge.msdk.playercommon.exoplayer2.C;
import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.ParserException;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmInitData;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ChunkIndex;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.Extractor;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorInput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorsFactory;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.PositionHolder;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.SeekMap;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.TrackOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.Atom;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.AtomParsers;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.DefaultSampleValues;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.Sniffer;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.Track;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.TrackEncryptionBox;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.TrackFragment;
import com.mbridge.msdk.playercommon.exoplayer2.text.cea.CeaUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.NalUnitUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableByteArray;
import com.mbridge.msdk.playercommon.exoplayer2.util.TimestampAdjuster;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public final class FragmentedMp4Extractor
implements Extractor {
    private static final Format EMSG_FORMAT;
    public static final ExtractorsFactory FACTORY;
    public static final int FLAG_ENABLE_EMSG_TRACK = 4;
    private static final int FLAG_SIDELOADED = 8;
    public static final int FLAG_WORKAROUND_EVERY_VIDEO_FRAME_IS_SYNC_FRAME = 1;
    public static final int FLAG_WORKAROUND_IGNORE_EDIT_LISTS = 16;
    public static final int FLAG_WORKAROUND_IGNORE_TFDT_BOX = 2;
    private static final byte[] PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE;
    private static final int SAMPLE_GROUP_TYPE_seig;
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_ENCRYPTION_DATA = 2;
    private static final int STATE_READING_SAMPLE_CONTINUE = 4;
    private static final int STATE_READING_SAMPLE_START = 3;
    private static final String TAG = "FragmentedMp4Extractor";
    private final TrackOutput additionalEmsgTrackOutput;
    private ParsableByteArray atomData;
    private final ParsableByteArray atomHeader;
    private int atomHeaderBytesRead;
    private long atomSize;
    private int atomType;
    private TrackOutput[] cea608TrackOutputs;
    private final List<Format> closedCaptionFormats;
    private final ArrayDeque<Atom.ContainerAtom> containerAtoms;
    private TrackBundle currentTrackBundle;
    private long durationUs;
    private TrackOutput[] emsgTrackOutputs;
    private long endOfMdatPosition;
    private final byte[] extendedTypeScratch;
    private ExtractorOutput extractorOutput;
    private final int flags;
    private boolean haveOutputSeekMap;
    private final ParsableByteArray nalBuffer;
    private final ParsableByteArray nalPrefix;
    private final ParsableByteArray nalStartCode;
    private int parserState;
    private int pendingMetadataSampleBytes;
    private final ArrayDeque<MetadataSampleInfo> pendingMetadataSampleInfos;
    private long pendingSeekTimeUs;
    private boolean processSeiNalUnitPayload;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private int sampleSize;
    private long segmentIndexEarliestPresentationTimeUs;
    private final DrmInitData sideloadedDrmInitData;
    private final Track sideloadedTrack;
    private final TimestampAdjuster timestampAdjuster;
    private final SparseArray<TrackBundle> trackBundles;

    static {
        FACTORY = new ExtractorsFactory(){

            public final Extractor[] createExtractors() {
                return new Extractor[]{new FragmentedMp4Extractor()};
            }
        };
        SAMPLE_GROUP_TYPE_seig = Util.getIntegerCodeForString((String)"seig");
        PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE = new byte[]{-94, 57, 79, 82, 90, -101, 79, 20, -94, 68, 108, 66, 124, 100, -115, -12};
        EMSG_FORMAT = Format.createSampleFormat(null, (String)"application/x-emsg", (long)Long.MAX_VALUE);
    }

    public FragmentedMp4Extractor() {
        this(0);
    }

    public FragmentedMp4Extractor(int n2) {
        this(n2, null);
    }

    public FragmentedMp4Extractor(int n2, TimestampAdjuster timestampAdjuster) {
        this(n2, timestampAdjuster, null, null);
    }

    public FragmentedMp4Extractor(int n2, TimestampAdjuster timestampAdjuster, Track track, DrmInitData drmInitData) {
        this(n2, timestampAdjuster, track, drmInitData, Collections.emptyList());
    }

    public FragmentedMp4Extractor(int n2, TimestampAdjuster timestampAdjuster, Track track, DrmInitData drmInitData, List<Format> list) {
        this(n2, timestampAdjuster, track, drmInitData, list, null);
    }

    public FragmentedMp4Extractor(int n2, TimestampAdjuster timestampAdjuster, Track track, DrmInitData drmInitData, List<Format> list, TrackOutput trackOutput) {
        int n3 = track != null ? 8 : 0;
        this.flags = n2 | n3;
        this.timestampAdjuster = timestampAdjuster;
        this.sideloadedTrack = track;
        this.sideloadedDrmInitData = drmInitData;
        this.closedCaptionFormats = Collections.unmodifiableList(list);
        this.additionalEmsgTrackOutput = trackOutput;
        this.atomHeader = new ParsableByteArray(16);
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalPrefix = new ParsableByteArray(5);
        this.nalBuffer = new ParsableByteArray();
        this.extendedTypeScratch = new byte[16];
        this.containerAtoms = new ArrayDeque();
        this.pendingMetadataSampleInfos = new ArrayDeque();
        this.trackBundles = new SparseArray();
        this.durationUs = -9223372036854775807L;
        this.pendingSeekTimeUs = -9223372036854775807L;
        this.segmentIndexEarliestPresentationTimeUs = -9223372036854775807L;
        this.enterReadingAtomHeaderState();
    }

    private void enterReadingAtomHeaderState() {
        this.parserState = 0;
        this.atomHeaderBytesRead = 0;
    }

    private DefaultSampleValues getDefaultSampleValues(SparseArray<DefaultSampleValues> sparseArray, int n2) {
        if (sparseArray.size() == 1) {
            return (DefaultSampleValues)sparseArray.valueAt(0);
        }
        return (DefaultSampleValues)Assertions.checkNotNull(sparseArray.get(n2));
    }

    private static DrmInitData getDrmInitDataFromAtoms(List<Atom.LeafAtom> object) {
        int n2 = object.size();
        Object var2_2 = null;
        Serializable serializable = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object.get(i2);
            ArrayList<DrmInitData.SchemeData> arrayList = serializable;
            if (object2.type == Atom.TYPE_pssh) {
                arrayList = serializable;
                if (serializable == null) {
                    arrayList = new ArrayList<DrmInitData.SchemeData>();
                }
                if ((serializable = PsshAtomUtil.parseUuid((byte[])(object2 = (Object)object2.data.data))) == null) {
                    Log.w((String)TAG, (String)"Skipped pssh atom (failed to extract uuid)");
                } else {
                    arrayList.add(new DrmInitData.SchemeData((UUID)serializable, "video/mp4", (byte[])object2));
                }
            }
            serializable = arrayList;
        }
        object = serializable == null ? var2_2 : new DrmInitData((List<DrmInitData.SchemeData>)((Object)serializable));
        return object;
    }

    private static TrackBundle getNextFragmentRun(SparseArray<TrackBundle> sparseArray) {
        int n2 = sparseArray.size();
        TrackBundle trackBundle = null;
        long l2 = Long.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3;
            TrackBundle trackBundle2 = (TrackBundle)sparseArray.valueAt(i2);
            if (trackBundle2.currentTrackRunIndex == trackBundle2.fragment.trunCount) {
                l3 = l2;
            } else {
                long l4 = trackBundle2.fragment.trunDataPosition[trackBundle2.currentTrackRunIndex];
                l3 = l2;
                if (l4 < l2) {
                    trackBundle = trackBundle2;
                    l3 = l4;
                }
            }
            l2 = l3;
        }
        return trackBundle;
    }

    private static TrackBundle getTrackBundle(SparseArray<TrackBundle> sparseArray, int n2) {
        if (sparseArray.size() == 1) {
            return (TrackBundle)sparseArray.valueAt(0);
        }
        return (TrackBundle)sparseArray.get(n2);
    }

    private void maybeInitExtraTracks() {
        int n2;
        TrackOutput trackOutput = this.emsgTrackOutputs;
        int n3 = 0;
        if (trackOutput == null) {
            this.emsgTrackOutputs = new TrackOutput[2];
            trackOutput = this.additionalEmsgTrackOutput;
            if (trackOutput != null) {
                this.emsgTrackOutputs[0] = trackOutput;
                n2 = 1;
            } else {
                n2 = 0;
            }
            int n4 = n2;
            if ((this.flags & 4) != 0) {
                this.emsgTrackOutputs[n2] = this.extractorOutput.track(this.trackBundles.size(), 4);
                n4 = n2 + 1;
            }
            this.emsgTrackOutputs = Arrays.copyOf(this.emsgTrackOutputs, n4);
            trackOutput = this.emsgTrackOutputs;
            n4 = ((TrackOutput)trackOutput).length;
            for (n2 = 0; n2 < n4; ++n2) {
                trackOutput[n2].format(EMSG_FORMAT);
            }
        }
        if (this.cea608TrackOutputs == null) {
            this.cea608TrackOutputs = new TrackOutput[this.closedCaptionFormats.size()];
            for (n2 = n3; n2 < this.cea608TrackOutputs.length; ++n2) {
                trackOutput = this.extractorOutput.track(this.trackBundles.size() + 1 + n2, 3);
                trackOutput.format(this.closedCaptionFormats.get(n2));
                this.cea608TrackOutputs[n2] = trackOutput;
            }
        }
    }

    private void onContainerAtomRead(Atom.ContainerAtom containerAtom) throws ParserException {
        if (containerAtom.type == Atom.TYPE_moov) {
            this.onMoovContainerAtomRead(containerAtom);
        } else if (containerAtom.type == Atom.TYPE_moof) {
            this.onMoofContainerAtomRead(containerAtom);
        } else if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(containerAtom);
        }
    }

    private void onEmsgLeafAtomRead(ParsableByteArray timestampAdjuster) {
        TrackOutput trackOutput2 = this.emsgTrackOutputs;
        if (trackOutput2 != null && ((TrackOutput[])trackOutput2).length != 0) {
            timestampAdjuster.setPosition(12);
            int n2 = timestampAdjuster.bytesLeft();
            timestampAdjuster.readNullTerminatedString();
            timestampAdjuster.readNullTerminatedString();
            long l2 = timestampAdjuster.readUnsignedInt();
            l2 = Util.scaleLargeTimestamp((long)timestampAdjuster.readUnsignedInt(), (long)1000000L, (long)l2);
            for (TrackOutput trackOutput2 : this.emsgTrackOutputs) {
                timestampAdjuster.setPosition(12);
                trackOutput2.sampleData((ParsableByteArray)timestampAdjuster, n2);
            }
            long l3 = this.segmentIndexEarliestPresentationTimeUs;
            if (l3 != -9223372036854775807L) {
                l2 = l3 + l2;
                timestampAdjuster = this.timestampAdjuster;
                if (timestampAdjuster != null) {
                    l2 = timestampAdjuster.adjustSampleTimestamp(l2);
                }
                timestampAdjuster = this.emsgTrackOutputs;
                int n3 = ((TrackOutput[])timestampAdjuster).length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    timestampAdjuster[i2].sampleMetadata(l2, 1, n2, 0, null);
                }
            } else {
                this.pendingMetadataSampleInfos.addLast(new MetadataSampleInfo(l2, n2));
                this.pendingMetadataSampleBytes += n2;
            }
        }
    }

    private void onLeafAtomRead(Atom.LeafAtom pair, long l2) throws ParserException {
        if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add((Atom.LeafAtom)pair);
        } else if (pair.type == Atom.TYPE_sidx) {
            pair = FragmentedMp4Extractor.parseSidx(pair.data, l2);
            this.segmentIndexEarliestPresentationTimeUs = (Long)pair.first;
            this.extractorOutput.seekMap((SeekMap)pair.second);
            this.haveOutputSeekMap = true;
        } else if (pair.type == Atom.TYPE_emsg) {
            this.onEmsgLeafAtomRead(pair.data);
        }
    }

    private void onMoofContainerAtomRead(Atom.ContainerAtom object) throws ParserException {
        int n2;
        int n3;
        FragmentedMp4Extractor.parseMoof(object, this.trackBundles, this.flags, this.extendedTypeScratch);
        object = this.sideloadedDrmInitData != null ? null : FragmentedMp4Extractor.getDrmInitDataFromAtoms(object.leafChildren);
        int n4 = 0;
        if (object != null) {
            n3 = this.trackBundles.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ((TrackBundle)this.trackBundles.valueAt(n2)).updateDrmInitData((DrmInitData)object);
            }
        }
        if (this.pendingSeekTimeUs != -9223372036854775807L) {
            n3 = this.trackBundles.size();
            for (n2 = n4; n2 < n3; ++n2) {
                ((TrackBundle)this.trackBundles.valueAt(n2)).seek(this.pendingSeekTimeUs);
            }
            this.pendingSeekTimeUs = -9223372036854775807L;
        }
    }

    private void onMoovContainerAtomRead(Atom.ContainerAtom object) throws ParserException {
        Object object2;
        int n2;
        Object object3 = this.sideloadedTrack;
        boolean bl = true;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = object3 == null;
        Assertions.checkState(bl2, "Unexpected moov box.");
        object3 = this.sideloadedDrmInitData;
        if (object3 == null) {
            object3 = FragmentedMp4Extractor.getDrmInitDataFromAtoms(((Atom.ContainerAtom)object).leafChildren);
        }
        Atom.ContainerAtom containerAtom = object.getContainerAtomOfType(Atom.TYPE_mvex);
        SparseArray sparseArray = new SparseArray();
        int n5 = containerAtom.leafChildren.size();
        long l2 = -9223372036854775807L;
        for (n2 = 0; n2 < n5; ++n2) {
            object2 = (Atom.ContainerAtom)containerAtom.leafChildren.get(n2);
            if (object2.type == Atom.TYPE_trex) {
                object2 = FragmentedMp4Extractor.parseTrex(object2.data);
                sparseArray.put(((Integer)object2.first).intValue(), object2.second);
                continue;
            }
            if (object2.type != Atom.TYPE_mehd) continue;
            l2 = FragmentedMp4Extractor.parseMehd(object2.data);
        }
        containerAtom = new SparseArray();
        n2 = ((Atom.ContainerAtom)object).containerChildren.size();
        for (n5 = 0; n5 < n2; ++n5) {
            Atom.LeafAtom leafAtom;
            object2 = (Atom.ContainerAtom)((Atom.ContainerAtom)object).containerChildren.get(n5);
            if (object2.type != Atom.TYPE_trak || (object2 = AtomParsers.parseTrak((Atom.ContainerAtom)object2, (Atom.LeafAtom)(leafAtom = object.getLeafAtomOfType(Atom.TYPE_mvhd)), (long)l2, (DrmInitData)object3, (boolean)(bl2 = (this.flags & 0x10) != 0), (boolean)false)) == null) continue;
            containerAtom.put(object2.id, object2);
        }
        n5 = containerAtom.size();
        if (this.trackBundles.size() == 0) {
            for (n2 = n4; n2 < n5; ++n2) {
                object3 = (Track)containerAtom.valueAt(n2);
                object = new TrackBundle(this.extractorOutput.track(n2, ((Track)object3).type));
                ((TrackBundle)object).init((Track)object3, this.getDefaultSampleValues((SparseArray<DefaultSampleValues>)sparseArray, ((Track)object3).id));
                this.trackBundles.put(((Track)object3).id, object);
                this.durationUs = Math.max(this.durationUs, ((Track)object3).durationUs);
            }
            this.maybeInitExtraTracks();
            this.extractorOutput.endTracks();
        } else {
            bl2 = this.trackBundles.size() == n5 ? bl : false;
            Assertions.checkState(bl2);
            for (n2 = n3; n2 < n5; ++n2) {
                object = (Track)containerAtom.valueAt(n2);
                ((TrackBundle)this.trackBundles.get(((Track)object).id)).init((Track)object, this.getDefaultSampleValues((SparseArray<DefaultSampleValues>)sparseArray, ((Track)object).id));
            }
        }
    }

    private void outputPendingMetadataSamples(long l2) {
        while (!this.pendingMetadataSampleInfos.isEmpty()) {
            MetadataSampleInfo metadataSampleInfo = this.pendingMetadataSampleInfos.removeFirst();
            this.pendingMetadataSampleBytes -= metadataSampleInfo.size;
            long l3 = metadataSampleInfo.presentationTimeDeltaUs + l2;
            TrackOutput[] trackOutputArray = this.timestampAdjuster;
            long l4 = l3;
            if (trackOutputArray != null) {
                l4 = trackOutputArray.adjustSampleTimestamp(l3);
            }
            trackOutputArray = this.emsgTrackOutputs;
            int n2 = trackOutputArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                trackOutputArray[i2].sampleMetadata(l4, 1, metadataSampleInfo.size, this.pendingMetadataSampleBytes, null);
            }
        }
    }

    private static long parseMehd(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        long l2 = Atom.parseFullAtomVersion((int)parsableByteArray.readInt()) == 0 ? parsableByteArray.readUnsignedInt() : parsableByteArray.readUnsignedLongToLong();
        return l2;
    }

    private static void parseMoof(Atom.ContainerAtom containerAtom, SparseArray<TrackBundle> sparseArray, int n2, byte[] byArray) throws ParserException {
        int n3 = containerAtom.containerChildren.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Atom.ContainerAtom containerAtom2 = (Atom.ContainerAtom)containerAtom.containerChildren.get(i2);
            if (containerAtom2.type != Atom.TYPE_traf) continue;
            FragmentedMp4Extractor.parseTraf(containerAtom2, sparseArray, n2, byArray);
        }
    }

    private static void parseSaio(ParsableByteArray object, TrackFragment trackFragment) throws ParserException {
        int n2;
        object.setPosition(8);
        int n3 = object.readInt();
        if ((Atom.parseFullAtomFlags((int)n3) & 1) == 1) {
            object.skipBytes(8);
        }
        if ((n2 = object.readUnsignedIntToInt()) == 1) {
            n2 = Atom.parseFullAtomVersion((int)n3);
            long l2 = trackFragment.auxiliaryDataPosition;
            long l3 = n2 == 0 ? object.readUnsignedInt() : object.readUnsignedLongToLong();
            trackFragment.auxiliaryDataPosition = l2 + l3;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unexpected saio entry count: ");
        ((StringBuilder)object).append(n2);
        throw new ParserException(((StringBuilder)object).toString());
    }

    private static void parseSaiz(TrackEncryptionBox object, ParsableByteArray parsableByteArray, TrackFragment trackFragment) throws ParserException {
        int n2 = ((TrackEncryptionBox)object).initializationVectorSize;
        parsableByteArray.setPosition(8);
        int n3 = Atom.parseFullAtomFlags((int)parsableByteArray.readInt());
        boolean bl = true;
        if ((n3 & 1) == 1) {
            parsableByteArray.skipBytes(8);
        }
        n3 = parsableByteArray.readUnsignedByte();
        int n4 = parsableByteArray.readUnsignedIntToInt();
        if (n4 == trackFragment.sampleCount) {
            int n5;
            if (n3 == 0) {
                object = trackFragment.sampleHasSubsampleEncryptionTable;
                int n6 = 0;
                n3 = 0;
                while (true) {
                    n5 = n3;
                    if (n6 < n4) {
                        n5 = parsableByteArray.readUnsignedByte();
                        n3 += n5;
                        bl = n5 > n2;
                        object[n6] = bl;
                        ++n6;
                        continue;
                    }
                    break;
                }
            } else {
                if (n3 <= n2) {
                    bl = false;
                }
                n5 = n3 * n4 + 0;
                Arrays.fill(trackFragment.sampleHasSubsampleEncryptionTable, 0, n4, bl);
            }
            trackFragment.initEncryptionData(n5);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Length mismatch: ");
        ((StringBuilder)object).append(n4);
        ((StringBuilder)object).append(", ");
        ((StringBuilder)object).append(trackFragment.sampleCount);
        object = new ParserException(((StringBuilder)object).toString());
        throw object;
    }

    private static void parseSenc(ParsableByteArray object, int n2, TrackFragment trackFragment) throws ParserException {
        object.setPosition(n2 + 8);
        n2 = Atom.parseFullAtomFlags((int)object.readInt());
        if ((n2 & 1) == 0) {
            boolean bl = (n2 & 2) != 0;
            n2 = object.readUnsignedIntToInt();
            if (n2 == trackFragment.sampleCount) {
                Arrays.fill(trackFragment.sampleHasSubsampleEncryptionTable, 0, n2, bl);
                trackFragment.initEncryptionData(object.bytesLeft());
                trackFragment.fillEncryptionData((ParsableByteArray)object);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Length mismatch: ");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(", ");
            ((StringBuilder)object).append(trackFragment.sampleCount);
            throw new ParserException(((StringBuilder)object).toString());
        }
        throw new ParserException("Overriding TrackEncryptionBox parameters is unsupported.");
    }

    private static void parseSenc(ParsableByteArray parsableByteArray, TrackFragment trackFragment) throws ParserException {
        FragmentedMp4Extractor.parseSenc(parsableByteArray, 0, trackFragment);
    }

    private static void parseSgpd(ParsableByteArray object, ParsableByteArray parsableByteArray, String string2, TrackFragment trackFragment) throws ParserException {
        object.setPosition(8);
        int n2 = object.readInt();
        if (object.readInt() != SAMPLE_GROUP_TYPE_seig) {
            return;
        }
        if (Atom.parseFullAtomVersion((int)n2) == 1) {
            object.skipBytes(4);
        }
        if (object.readInt() == 1) {
            parsableByteArray.setPosition(8);
            n2 = parsableByteArray.readInt();
            if (parsableByteArray.readInt() != SAMPLE_GROUP_TYPE_seig) {
                return;
            }
            if ((n2 = Atom.parseFullAtomVersion((int)n2)) == 1) {
                if (parsableByteArray.readUnsignedInt() == 0L) {
                    throw new ParserException("Variable length description in sgpd found (unsupported)");
                }
            } else if (n2 >= 2) {
                parsableByteArray.skipBytes(4);
            }
            if (parsableByteArray.readUnsignedInt() == 1L) {
                parsableByteArray.skipBytes(1);
                int n3 = parsableByteArray.readUnsignedByte();
                boolean bl = parsableByteArray.readUnsignedByte() == 1;
                if (!bl) {
                    return;
                }
                int n4 = parsableByteArray.readUnsignedByte();
                byte[] byArray = new byte[16];
                parsableByteArray.readBytes(byArray, 0, byArray.length);
                if (bl && n4 == 0) {
                    n2 = parsableByteArray.readUnsignedByte();
                    object = new byte[n2];
                    parsableByteArray.readBytes((byte[])object, 0, n2);
                } else {
                    object = null;
                }
                trackFragment.definesEncryptionData = true;
                trackFragment.trackEncryptionBox = new TrackEncryptionBox(bl, string2, n4, byArray, (n3 & 0xF0) >> 4, n3 & 0xF, (byte[])object);
                return;
            }
            throw new ParserException("Entry count in sgpd != 1 (unsupported).");
        }
        throw new ParserException("Entry count in sbgp != 1 (unsupported).");
    }

    private static Pair<Long, ChunkIndex> parseSidx(ParsableByteArray parsableByteArray, long l2) throws ParserException {
        long l3;
        long l4;
        parsableByteArray.setPosition(8);
        int n2 = Atom.parseFullAtomVersion((int)parsableByteArray.readInt());
        parsableByteArray.skipBytes(4);
        long l5 = parsableByteArray.readUnsignedInt();
        if (n2 == 0) {
            l4 = parsableByteArray.readUnsignedInt();
            l3 = parsableByteArray.readUnsignedInt();
        } else {
            l4 = parsableByteArray.readUnsignedLongToLong();
            l3 = parsableByteArray.readUnsignedLongToLong();
        }
        l2 += l3;
        long l6 = Util.scaleLargeTimestamp((long)l4, (long)1000000L, (long)l5);
        parsableByteArray.skipBytes(2);
        n2 = parsableByteArray.readUnsignedShort();
        int[] nArray = new int[n2];
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n2];
        long[] lArray3 = new long[n2];
        l3 = l4;
        l4 = l6;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = parsableByteArray.readInt();
            if ((n3 & Integer.MIN_VALUE) == 0) {
                long l7 = parsableByteArray.readUnsignedInt();
                nArray[i2] = n3 & Integer.MAX_VALUE;
                lArray[i2] = l2;
                lArray3[i2] = l4;
                l4 = Util.scaleLargeTimestamp((long)(l3 += l7), (long)1000000L, (long)l5);
                lArray2[i2] = l4 - lArray3[i2];
                parsableByteArray.skipBytes(4);
                l2 += (long)nArray[i2];
                continue;
            }
            throw new ParserException("Unhandled indirect reference");
        }
        return Pair.create((Object)l6, (Object)new ChunkIndex(nArray, lArray, lArray2, lArray3));
    }

    private static long parseTfdt(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        long l2 = Atom.parseFullAtomVersion((int)parsableByteArray.readInt()) == 1 ? parsableByteArray.readUnsignedLongToLong() : parsableByteArray.readUnsignedInt();
        return l2;
    }

    private static TrackBundle parseTfhd(ParsableByteArray parsableByteArray, SparseArray<TrackBundle> object) {
        parsableByteArray.setPosition(8);
        int n2 = Atom.parseFullAtomFlags((int)parsableByteArray.readInt());
        object = FragmentedMp4Extractor.getTrackBundle(object, parsableByteArray.readInt());
        if (object == null) {
            return null;
        }
        if ((n2 & 1) != 0) {
            long l2;
            object.fragment.dataPosition = l2 = parsableByteArray.readUnsignedLongToLong();
            object.fragment.auxiliaryDataPosition = l2;
        }
        DefaultSampleValues defaultSampleValues = object.defaultSampleValues;
        int n3 = (n2 & 2) != 0 ? parsableByteArray.readUnsignedIntToInt() - 1 : defaultSampleValues.sampleDescriptionIndex;
        int n4 = (n2 & 8) != 0 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.duration;
        int n5 = (n2 & 0x10) != 0 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.size;
        n2 = (n2 & 0x20) != 0 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.flags;
        object.fragment.header = new DefaultSampleValues(n3, n4, n5, n2);
        return object;
    }

    private static void parseTraf(Atom.ContainerAtom containerAtom, SparseArray<TrackBundle> object, int n2, byte[] byArray) throws ParserException {
        if ((object = FragmentedMp4Extractor.parseTfhd(containerAtom.getLeafAtomOfType((int)Atom.TYPE_tfhd).data, object)) == null) {
            return;
        }
        TrackFragment trackFragment = ((TrackBundle)object).fragment;
        long l2 = trackFragment.nextFragmentDecodeTime;
        ((TrackBundle)object).reset();
        long l3 = l2;
        if (containerAtom.getLeafAtomOfType(Atom.TYPE_tfdt) != null) {
            l3 = l2;
            if ((n2 & 2) == 0) {
                l3 = FragmentedMp4Extractor.parseTfdt(containerAtom.getLeafAtomOfType((int)Atom.TYPE_tfdt).data);
            }
        }
        FragmentedMp4Extractor.parseTruns(containerAtom, (TrackBundle)object, l3, n2);
        object = ((TrackBundle)object).track.getSampleDescriptionEncryptionBox(trackFragment.header.sampleDescriptionIndex);
        Atom.LeafAtom leafAtom = containerAtom.getLeafAtomOfType(Atom.TYPE_saiz);
        if (leafAtom != null) {
            FragmentedMp4Extractor.parseSaiz((TrackEncryptionBox)object, leafAtom.data, trackFragment);
        }
        if ((leafAtom = containerAtom.getLeafAtomOfType(Atom.TYPE_saio)) != null) {
            FragmentedMp4Extractor.parseSaio(leafAtom.data, trackFragment);
        }
        if ((leafAtom = containerAtom.getLeafAtomOfType(Atom.TYPE_senc)) != null) {
            FragmentedMp4Extractor.parseSenc(leafAtom.data, trackFragment);
        }
        leafAtom = containerAtom.getLeafAtomOfType(Atom.TYPE_sbgp);
        Atom.LeafAtom leafAtom2 = containerAtom.getLeafAtomOfType(Atom.TYPE_sgpd);
        if (leafAtom != null && leafAtom2 != null) {
            leafAtom = leafAtom.data;
            leafAtom2 = leafAtom2.data;
            object = object != null ? ((TrackEncryptionBox)object).schemeType : null;
            FragmentedMp4Extractor.parseSgpd((ParsableByteArray)leafAtom, (ParsableByteArray)leafAtom2, (String)object, trackFragment);
        }
        int n3 = containerAtom.leafChildren.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (Atom.LeafAtom)containerAtom.leafChildren.get(n2);
            if (((Atom.LeafAtom)object).type != Atom.TYPE_uuid) continue;
            FragmentedMp4Extractor.parseUuid(((Atom.LeafAtom)object).data, trackFragment, byArray);
        }
    }

    private static Pair<Integer, DefaultSampleValues> parseTrex(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(12);
        return Pair.create((Object)parsableByteArray.readInt(), (Object)new DefaultSampleValues(parsableByteArray.readUnsignedIntToInt() - 1, parsableByteArray.readUnsignedIntToInt(), parsableByteArray.readUnsignedIntToInt(), parsableByteArray.readInt()));
    }

    private static int parseTrun(TrackBundle trackBundle, int n2, long l2, int n3, ParsableByteArray parsableByteArray, int n4) {
        long l3;
        Object[] objectArray;
        parsableByteArray.setPosition(8);
        int n5 = Atom.parseFullAtomFlags((int)parsableByteArray.readInt());
        Track track = trackBundle.track;
        trackBundle = trackBundle.fragment;
        DefaultSampleValues defaultSampleValues = ((TrackFragment)trackBundle).header;
        ((TrackFragment)trackBundle).trunLength[n2] = parsableByteArray.readUnsignedIntToInt();
        ((TrackFragment)trackBundle).trunDataPosition[n2] = ((TrackFragment)trackBundle).dataPosition;
        if ((n5 & 1) != 0) {
            objectArray = ((TrackFragment)trackBundle).trunDataPosition;
            objectArray[n2] = objectArray[n2] + (long)parsableByteArray.readInt();
        }
        boolean bl = (n5 & 4) != 0;
        int n6 = defaultSampleValues.flags;
        if (bl) {
            n6 = parsableByteArray.readUnsignedIntToInt();
        }
        boolean bl2 = (n5 & 0x100) != 0;
        boolean bl3 = (n5 & 0x200) != 0;
        boolean bl4 = (n5 & 0x400) != 0;
        n5 = (n5 & 0x800) != 0 ? 1 : 0;
        objectArray = track.editListDurations;
        long l4 = l3 = 0L;
        if (objectArray != null) {
            l4 = l3;
            if (track.editListDurations.length == 1) {
                l4 = l3;
                if (track.editListDurations[0] == 0L) {
                    l4 = Util.scaleLargeTimestamp((long)track.editListMediaTimes[0], (long)1000L, (long)track.timescale);
                }
            }
        }
        int[] nArray = ((TrackFragment)trackBundle).sampleSizeTable;
        objectArray = ((TrackFragment)trackBundle).sampleCompositionTimeOffsetTable;
        long[] lArray = ((TrackFragment)trackBundle).sampleDecodingTimeTable;
        boolean[] blArray = ((TrackFragment)trackBundle).sampleIsSyncFrameTable;
        n3 = track.type == 2 && (n3 & 1) != 0 ? 1 : 0;
        int n7 = n4 + ((TrackFragment)trackBundle).trunLength[n2];
        l3 = track.timescale;
        if (n2 > 0) {
            l2 = ((TrackFragment)trackBundle).nextFragmentDecodeTime;
        }
        int n8 = n4;
        n4 = n7;
        while (n8 < n4) {
            n7 = bl2 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.duration;
            int n9 = bl3 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.size;
            n2 = n8 == 0 && bl ? n6 : (bl4 ? parsableByteArray.readInt() : defaultSampleValues.flags);
            objectArray[n8] = n5 != 0 ? (long)((int)((long)parsableByteArray.readInt() * 1000L / l3)) : (long)0;
            lArray[n8] = Util.scaleLargeTimestamp((long)l2, (long)1000L, (long)l3) - l4;
            nArray[n8] = n9;
            boolean bl5 = (n2 >> 16 & 1) == 0 && (n3 == 0 || n8 == 0);
            blArray[n8] = bl5;
            long l5 = n7;
            ++n8;
            l2 += l5;
        }
        ((TrackFragment)trackBundle).nextFragmentDecodeTime = l2;
        return n4;
    }

    private static void parseTruns(Atom.ContainerAtom object, TrackBundle trackBundle, long l2, int n2) {
        int n3;
        int n4;
        Atom.LeafAtom leafAtom;
        int n5;
        object = ((Atom.ContainerAtom)object).leafChildren;
        int n6 = object.size();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            leafAtom = (Atom.LeafAtom)object.get(n5);
            n4 = n8;
            n3 = n9;
            if (leafAtom.type == Atom.TYPE_trun) {
                leafAtom = leafAtom.data;
                leafAtom.setPosition(12);
                int n10 = leafAtom.readUnsignedIntToInt();
                n4 = n8;
                n3 = n9;
                if (n10 > 0) {
                    n3 = n9 + n10;
                    n4 = n8 + 1;
                }
            }
            n8 = n4;
            n9 = n3;
        }
        trackBundle.currentTrackRunIndex = 0;
        trackBundle.currentSampleInTrackRun = 0;
        trackBundle.currentSampleIndex = 0;
        trackBundle.fragment.initTables(n8, n9);
        n5 = 0;
        n3 = 0;
        for (n9 = n7; n9 < n6; ++n9) {
            leafAtom = (Atom.LeafAtom)object.get(n9);
            n4 = n5;
            n8 = n3;
            if (leafAtom.type == Atom.TYPE_trun) {
                n8 = FragmentedMp4Extractor.parseTrun(trackBundle, n5, l2, n2, leafAtom.data, n3);
                n4 = n5 + 1;
            }
            n5 = n4;
            n3 = n8;
        }
    }

    private static void parseUuid(ParsableByteArray parsableByteArray, TrackFragment trackFragment, byte[] byArray) throws ParserException {
        parsableByteArray.setPosition(8);
        parsableByteArray.readBytes(byArray, 0, 16);
        if (!Arrays.equals(byArray, PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE)) {
            return;
        }
        FragmentedMp4Extractor.parseSenc(parsableByteArray, 16, trackFragment);
    }

    private void processAtomEnded(long l2) throws ParserException {
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endPosition == l2) {
            this.onContainerAtomRead(this.containerAtoms.pop());
        }
        this.enterReadingAtomHeaderState();
    }

    private boolean readAtomHeader(ExtractorInput extractorInput) throws IOException, InterruptedException {
        block17: {
            block23: {
                block19: {
                    block20: {
                        block21: {
                            block22: {
                                long l2;
                                block18: {
                                    if (this.atomHeaderBytesRead == 0) {
                                        if (!extractorInput.readFully(this.atomHeader.data, 0, 8, true)) {
                                            return false;
                                        }
                                        this.atomHeaderBytesRead = 8;
                                        this.atomHeader.setPosition(0);
                                        this.atomSize = this.atomHeader.readUnsignedInt();
                                        this.atomType = this.atomHeader.readInt();
                                    }
                                    if ((l2 = this.atomSize) == 1L) {
                                        extractorInput.readFully(this.atomHeader.data, 8, 8);
                                        this.atomHeaderBytesRead += 8;
                                        this.atomSize = this.atomHeader.readUnsignedLongToLong();
                                    } else if (l2 == 0L) {
                                        long l3;
                                        l2 = l3 = extractorInput.getLength();
                                        if (l3 == -1L) {
                                            l2 = l3;
                                            if (!this.containerAtoms.isEmpty()) {
                                                l2 = this.containerAtoms.peek().endPosition;
                                            }
                                        }
                                        if (l2 != -1L) {
                                            this.atomSize = l2 - extractorInput.getPosition() + (long)this.atomHeaderBytesRead;
                                        }
                                    }
                                    if (this.atomSize < (long)this.atomHeaderBytesRead) break block17;
                                    l2 = extractorInput.getPosition() - (long)this.atomHeaderBytesRead;
                                    if (this.atomType == Atom.TYPE_moof) {
                                        int n2 = this.trackBundles.size();
                                        for (int i2 = 0; i2 < n2; ++i2) {
                                            TrackFragment trackFragment = ((TrackBundle)this.trackBundles.valueAt((int)i2)).fragment;
                                            trackFragment.atomPosition = l2;
                                            trackFragment.auxiliaryDataPosition = l2;
                                            trackFragment.dataPosition = l2;
                                        }
                                    }
                                    if (this.atomType == Atom.TYPE_mdat) {
                                        this.currentTrackBundle = null;
                                        this.endOfMdatPosition = this.atomSize + l2;
                                        if (!this.haveOutputSeekMap) {
                                            this.extractorOutput.seekMap((SeekMap)new SeekMap.Unseekable(this.durationUs, l2));
                                            this.haveOutputSeekMap = true;
                                        }
                                        this.parserState = 2;
                                        return true;
                                    }
                                    if (!FragmentedMp4Extractor.shouldParseContainerAtom(this.atomType)) break block18;
                                    l2 = extractorInput.getPosition() + this.atomSize - 8L;
                                    this.containerAtoms.push(new Atom.ContainerAtom(this.atomType, l2));
                                    if (this.atomSize == (long)this.atomHeaderBytesRead) {
                                        this.processAtomEnded(l2);
                                    } else {
                                        this.enterReadingAtomHeaderState();
                                    }
                                    break block19;
                                }
                                if (!FragmentedMp4Extractor.shouldParseLeafAtom(this.atomType)) break block20;
                                if (this.atomHeaderBytesRead != 8) break block21;
                                l2 = this.atomSize;
                                if (l2 > Integer.MAX_VALUE) break block22;
                                this.atomData = new ParsableByteArray((int)l2);
                                System.arraycopy(this.atomHeader.data, 0, this.atomData.data, 0, 8);
                                this.parserState = 1;
                                break block19;
                            }
                            throw new ParserException("Leaf atom with length > 2147483647 (unsupported).");
                        }
                        throw new ParserException("Leaf atom defines extended atom size (unsupported).");
                    }
                    if (this.atomSize > Integer.MAX_VALUE) break block23;
                    this.atomData = null;
                    this.parserState = 1;
                }
                return true;
            }
            throw new ParserException("Skipping atom with length > 2147483647 (unsupported).");
        }
        extractorInput = new ParserException("Atom size less than header length (unsupported).");
        throw extractorInput;
    }

    private void readAtomPayload(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n2 = (int)this.atomSize - this.atomHeaderBytesRead;
        ParsableByteArray parsableByteArray = this.atomData;
        if (parsableByteArray != null) {
            extractorInput.readFully(parsableByteArray.data, 8, n2);
            this.onLeafAtomRead(new Atom.LeafAtom(this.atomType, this.atomData), extractorInput.getPosition());
        } else {
            extractorInput.skipFully(n2);
        }
        this.processAtomEnded(extractorInput.getPosition());
    }

    private void readEncryptionData(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n2;
        int n3 = this.trackBundles.size();
        TrackBundle trackBundle = null;
        long l2 = Long.MAX_VALUE;
        for (n2 = 0; n2 < n3; ++n2) {
            TrackFragment trackFragment = ((TrackBundle)this.trackBundles.valueAt((int)n2)).fragment;
            TrackBundle trackBundle2 = trackBundle;
            long l3 = l2;
            if (trackFragment.sampleEncryptionDataNeedsFill) {
                trackBundle2 = trackBundle;
                l3 = l2;
                if (trackFragment.auxiliaryDataPosition < l2) {
                    l3 = trackFragment.auxiliaryDataPosition;
                    trackBundle2 = (TrackBundle)this.trackBundles.valueAt(n2);
                }
            }
            trackBundle = trackBundle2;
            l2 = l3;
        }
        if (trackBundle == null) {
            this.parserState = 3;
            return;
        }
        n2 = (int)(l2 - extractorInput.getPosition());
        if (n2 >= 0) {
            extractorInput.skipFully(n2);
            trackBundle.fragment.fillEncryptionData(extractorInput);
            return;
        }
        extractorInput = new ParserException("Offset to encryption data was negative.");
        throw extractorInput;
    }

    private boolean readSample(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n2;
        int n3;
        TrackBundle trackBundle;
        if (this.parserState == 3) {
            if (this.currentTrackBundle == null) {
                trackBundle = FragmentedMp4Extractor.getNextFragmentRun(this.trackBundles);
                if (trackBundle == null) {
                    int n4 = (int)(this.endOfMdatPosition - extractorInput.getPosition());
                    if (n4 >= 0) {
                        extractorInput.skipFully(n4);
                        this.enterReadingAtomHeaderState();
                        return false;
                    }
                    throw new ParserException("Offset to end of mdat was negative.");
                }
                n2 = n3 = (int)(trackBundle.fragment.trunDataPosition[trackBundle.currentTrackRunIndex] - extractorInput.getPosition());
                if (n3 < 0) {
                    Log.w((String)TAG, (String)"Ignoring negative offset to sample data.");
                    n2 = 0;
                }
                extractorInput.skipFully(n2);
                this.currentTrackBundle = trackBundle;
            }
            this.sampleSize = this.currentTrackBundle.fragment.sampleSizeTable[this.currentTrackBundle.currentSampleIndex];
            if (this.currentTrackBundle.currentSampleIndex < this.currentTrackBundle.firstSampleToOutputIndex) {
                extractorInput.skipFully(this.sampleSize);
                this.currentTrackBundle.skipSampleEncryptionData();
                if (!this.currentTrackBundle.next()) {
                    this.currentTrackBundle = null;
                }
                this.parserState = 3;
                return true;
            }
            if (this.currentTrackBundle.track.sampleTransformation == 1) {
                this.sampleSize -= 8;
                extractorInput.skipFully(8);
            }
            this.sampleBytesWritten = this.currentTrackBundle.outputSampleEncryptionData();
            this.sampleSize += this.sampleBytesWritten;
            this.parserState = 4;
            this.sampleCurrentNalBytesRemaining = 0;
        }
        TrackFragment trackFragment = this.currentTrackBundle.fragment;
        Track track = this.currentTrackBundle.track;
        trackBundle = this.currentTrackBundle.output;
        n3 = this.currentTrackBundle.currentSampleIndex;
        long l2 = trackFragment.getSamplePresentationTime(n3) * 1000L;
        Object object = this.timestampAdjuster;
        long l3 = l2;
        if (object != null) {
            l3 = object.adjustSampleTimestamp(l2);
        }
        if (track.nalUnitLengthFieldLength != 0) {
            object = this.nalPrefix.data;
            object[0] = (TimestampAdjuster)((byte)0);
            object[1] = (TimestampAdjuster)((byte)0);
            object[2] = (TimestampAdjuster)((byte)0);
            int n5 = track.nalUnitLengthFieldLength;
            int n6 = 4 - track.nalUnitLengthFieldLength;
            while (this.sampleBytesWritten < this.sampleSize) {
                n2 = this.sampleCurrentNalBytesRemaining;
                if (n2 == 0) {
                    extractorInput.readFully((byte[])object, n6, n5 + 1);
                    this.nalPrefix.setPosition(0);
                    this.sampleCurrentNalBytesRemaining = this.nalPrefix.readUnsignedIntToInt() - 1;
                    this.nalStartCode.setPosition(0);
                    trackBundle.sampleData(this.nalStartCode, 4);
                    trackBundle.sampleData(this.nalPrefix, 1);
                    boolean bl = this.cea608TrackOutputs.length > 0 && NalUnitUtil.isNalUnitSei((String)track.format.sampleMimeType, (byte)object[4]);
                    this.processSeiNalUnitPayload = bl;
                    this.sampleBytesWritten += 5;
                    this.sampleSize += n6;
                    continue;
                }
                if (this.processSeiNalUnitPayload) {
                    this.nalBuffer.reset(n2);
                    extractorInput.readFully(this.nalBuffer.data, 0, this.sampleCurrentNalBytesRemaining);
                    trackBundle.sampleData(this.nalBuffer, this.sampleCurrentNalBytesRemaining);
                    n2 = this.sampleCurrentNalBytesRemaining;
                    int n7 = NalUnitUtil.unescapeStream((byte[])this.nalBuffer.data, (int)this.nalBuffer.limit());
                    this.nalBuffer.setPosition("video/hevc".equals(track.format.sampleMimeType) ? 1 : 0);
                    this.nalBuffer.setLimit(n7);
                    CeaUtil.consume(l3, this.nalBuffer, this.cea608TrackOutputs);
                } else {
                    n2 = trackBundle.sampleData(extractorInput, n2, false);
                }
                this.sampleBytesWritten += n2;
                this.sampleCurrentNalBytesRemaining -= n2;
            }
        } else {
            int n8;
            while ((n2 = this.sampleBytesWritten) < (n8 = this.sampleSize)) {
                n2 = trackBundle.sampleData(extractorInput, n8 - n2, false);
                this.sampleBytesWritten += n2;
            }
        }
        n2 = trackFragment.sampleIsSyncFrameTable[n3];
        if (trackFragment.definesEncryptionData) {
            extractorInput = trackFragment.trackEncryptionBox != null ? trackFragment.trackEncryptionBox : track.getSampleDescriptionEncryptionBox(trackFragment.header.sampleDescriptionIndex);
            extractorInput = extractorInput.cryptoData;
            n2 |= 0x40000000;
        } else {
            extractorInput = null;
        }
        trackBundle.sampleMetadata(l3, n2, this.sampleSize, 0, (TrackOutput.CryptoData)extractorInput);
        this.outputPendingMetadataSamples(l3);
        if (!this.currentTrackBundle.next()) {
            this.currentTrackBundle = null;
        }
        this.parserState = 3;
        return true;
    }

    private static boolean shouldParseContainerAtom(int n2) {
        boolean bl = n2 == Atom.TYPE_moov || n2 == Atom.TYPE_trak || n2 == Atom.TYPE_mdia || n2 == Atom.TYPE_minf || n2 == Atom.TYPE_stbl || n2 == Atom.TYPE_moof || n2 == Atom.TYPE_traf || n2 == Atom.TYPE_mvex || n2 == Atom.TYPE_edts;
        return bl;
    }

    private static boolean shouldParseLeafAtom(int n2) {
        boolean bl = n2 == Atom.TYPE_hdlr || n2 == Atom.TYPE_mdhd || n2 == Atom.TYPE_mvhd || n2 == Atom.TYPE_sidx || n2 == Atom.TYPE_stsd || n2 == Atom.TYPE_tfdt || n2 == Atom.TYPE_tfhd || n2 == Atom.TYPE_tkhd || n2 == Atom.TYPE_trex || n2 == Atom.TYPE_trun || n2 == Atom.TYPE_pssh || n2 == Atom.TYPE_saiz || n2 == Atom.TYPE_saio || n2 == Atom.TYPE_senc || n2 == Atom.TYPE_uuid || n2 == Atom.TYPE_sbgp || n2 == Atom.TYPE_sgpd || n2 == Atom.TYPE_elst || n2 == Atom.TYPE_mehd || n2 == Atom.TYPE_emsg;
        return bl;
    }

    public final void init(ExtractorOutput object) {
        this.extractorOutput = object;
        Track track = this.sideloadedTrack;
        if (track != null) {
            object = new TrackBundle(object.track(0, track.type));
            ((TrackBundle)object).init(this.sideloadedTrack, new DefaultSampleValues(0, 0, 0, 0));
            this.trackBundles.put(0, object);
            this.maybeInitExtraTracks();
            this.extractorOutput.endTracks();
        }
    }

    public final int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        while (true) {
            int n2;
            if ((n2 = this.parserState) != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (!this.readSample(extractorInput)) continue;
                        return 0;
                    }
                    this.readEncryptionData(extractorInput);
                    continue;
                }
                this.readAtomPayload(extractorInput);
                continue;
            }
            if (!this.readAtomHeader(extractorInput)) break;
        }
        return -1;
    }

    public final void release() {
    }

    public final void seek(long l2, long l3) {
        int n2 = this.trackBundles.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((TrackBundle)this.trackBundles.valueAt(i2)).reset();
        }
        this.pendingMetadataSampleInfos.clear();
        this.pendingMetadataSampleBytes = 0;
        this.pendingSeekTimeUs = l3;
        this.containerAtoms.clear();
        this.enterReadingAtomHeaderState();
    }

    public final boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return Sniffer.sniffFragmented((ExtractorInput)extractorInput);
    }

    public static @interface Flags {
    }

    private static final class MetadataSampleInfo {
        public final long presentationTimeDeltaUs;
        public final int size;

        public MetadataSampleInfo(long l2, int n2) {
            this.presentationTimeDeltaUs = l2;
            this.size = n2;
        }
    }

    private static final class TrackBundle {
        public int currentSampleInTrackRun;
        public int currentSampleIndex;
        public int currentTrackRunIndex;
        private final ParsableByteArray defaultInitializationVector;
        public DefaultSampleValues defaultSampleValues;
        private final ParsableByteArray encryptionSignalByte;
        public int firstSampleToOutputIndex;
        public final TrackFragment fragment;
        public final TrackOutput output;
        public Track track;

        public TrackBundle(TrackOutput trackOutput) {
            this.output = trackOutput;
            this.fragment = new TrackFragment();
            this.encryptionSignalByte = new ParsableByteArray(1);
            this.defaultInitializationVector = new ParsableByteArray();
        }

        private TrackEncryptionBox getEncryptionBox() {
            int n2 = this.fragment.header.sampleDescriptionIndex;
            TrackEncryptionBox trackEncryptionBox = this.fragment.trackEncryptionBox != null ? this.fragment.trackEncryptionBox : this.track.getSampleDescriptionEncryptionBox(n2);
            return trackEncryptionBox;
        }

        private void skipSampleEncryptionData() {
            if (!this.fragment.definesEncryptionData) {
                return;
            }
            ParsableByteArray parsableByteArray = this.fragment.sampleEncryptionData;
            TrackEncryptionBox trackEncryptionBox = this.getEncryptionBox();
            if (trackEncryptionBox.initializationVectorSize != 0) {
                parsableByteArray.skipBytes(trackEncryptionBox.initializationVectorSize);
            }
            if (this.fragment.sampleHasSubsampleEncryptionTable[this.currentSampleIndex]) {
                parsableByteArray.skipBytes(parsableByteArray.readUnsignedShort() * 6);
            }
        }

        public final void init(Track track, DefaultSampleValues defaultSampleValues) {
            this.track = Assertions.checkNotNull(track);
            this.defaultSampleValues = Assertions.checkNotNull(defaultSampleValues);
            this.output.format(track.format);
            this.reset();
        }

        public final boolean next() {
            ++this.currentSampleIndex;
            ++this.currentSampleInTrackRun;
            int n2 = this.currentSampleInTrackRun;
            int[] nArray = this.fragment.trunLength;
            int n3 = this.currentTrackRunIndex;
            if (n2 == nArray[n3]) {
                this.currentTrackRunIndex = n3 + 1;
                this.currentSampleInTrackRun = 0;
                return false;
            }
            return true;
        }

        public final int outputSampleEncryptionData() {
            int n2;
            ParsableByteArray parsableByteArray;
            if (!this.fragment.definesEncryptionData) {
                return 0;
            }
            Object object = this.getEncryptionBox();
            if (object.initializationVectorSize != 0) {
                parsableByteArray = this.fragment.sampleEncryptionData;
                n2 = object.initializationVectorSize;
            } else {
                object = object.defaultInitializationVector;
                this.defaultInitializationVector.reset((byte[])object, ((TrackEncryptionBox)object).length);
                parsableByteArray = this.defaultInitializationVector;
                n2 = ((TrackEncryptionBox)object).length;
            }
            boolean bl = this.fragment.sampleHasSubsampleEncryptionTable[this.currentSampleIndex];
            object = this.encryptionSignalByte.data;
            int n3 = bl ? 128 : 0;
            object[0] = (TrackEncryptionBox)((byte)((byte)(n3 | n2)));
            this.encryptionSignalByte.setPosition(0);
            this.output.sampleData(this.encryptionSignalByte, 1);
            this.output.sampleData(parsableByteArray, n2);
            if (!bl) {
                return n2 + 1;
            }
            parsableByteArray = this.fragment.sampleEncryptionData;
            n3 = parsableByteArray.readUnsignedShort();
            parsableByteArray.skipBytes(-2);
            n3 = n3 * 6 + 2;
            this.output.sampleData(parsableByteArray, n3);
            return n2 + 1 + n3;
        }

        public final void reset() {
            this.fragment.reset();
            this.currentSampleIndex = 0;
            this.currentTrackRunIndex = 0;
            this.currentSampleInTrackRun = 0;
            this.firstSampleToOutputIndex = 0;
        }

        public final void seek(long l2) {
            l2 = C.usToMs(l2);
            for (int i2 = this.currentSampleIndex; i2 < this.fragment.sampleCount && this.fragment.getSamplePresentationTime(i2) < l2; ++i2) {
                if (!this.fragment.sampleIsSyncFrameTable[i2]) continue;
                this.firstSampleToOutputIndex = i2;
            }
        }

        public final void updateDrmInitData(DrmInitData drmInitData) {
            Object object = this.track.getSampleDescriptionEncryptionBox(this.fragment.header.sampleDescriptionIndex);
            object = object != null ? object.schemeType : null;
            this.output.format(this.track.format.copyWithDrmInitData(drmInitData.copyWithSchemeType((String)object)));
        }
    }
}

