/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.extractor.mp3;

import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.ParserException;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.Extractor;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorInput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorsFactory;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.GaplessInfoHolder;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.Id3Peeker;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.MpegAudioHeader;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.PositionHolder;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.SeekMap;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.TrackOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp3.ConstantBitrateSeeker;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp3.VbriSeeker;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp3.XingSeeker;
import com.mbridge.msdk.playercommon.exoplayer2.metadata.Metadata;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableByteArray;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;

public final class Mp3Extractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = new ExtractorsFactory(){

        public final Extractor[] createExtractors() {
            return new Extractor[]{new Mp3Extractor()};
        }
    };
    public static final int FLAG_DISABLE_ID3_METADATA = 2;
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING = 1;
    private static final int MAX_SNIFF_BYTES = 16384;
    private static final int MAX_SYNC_BYTES = 131072;
    private static final int MPEG_AUDIO_HEADER_MASK = -128000;
    private static final int SCRATCH_LENGTH = 10;
    private static final int SEEK_HEADER_INFO;
    private static final int SEEK_HEADER_UNSET = 0;
    private static final int SEEK_HEADER_VBRI;
    private static final int SEEK_HEADER_XING;
    private long basisTimeUs;
    private ExtractorOutput extractorOutput;
    private final int flags;
    private final long forcedFirstSampleTimestampUs;
    private final GaplessInfoHolder gaplessInfoHolder;
    private final Id3Peeker id3Peeker;
    private Metadata metadata;
    private int sampleBytesRemaining;
    private long samplesRead;
    private final ParsableByteArray scratch;
    private Seeker seeker;
    private final MpegAudioHeader synchronizedHeader;
    private int synchronizedHeaderData;
    private TrackOutput trackOutput;

    static {
        SEEK_HEADER_XING = Util.getIntegerCodeForString((String)"Xing");
        SEEK_HEADER_INFO = Util.getIntegerCodeForString((String)"Info");
        SEEK_HEADER_VBRI = Util.getIntegerCodeForString((String)"VBRI");
    }

    public Mp3Extractor() {
        this(0);
    }

    public Mp3Extractor(int n2) {
        this(n2, -9223372036854775807L);
    }

    public Mp3Extractor(int n2, long l2) {
        this.flags = n2;
        this.forcedFirstSampleTimestampUs = l2;
        this.scratch = new ParsableByteArray(10);
        this.synchronizedHeader = new MpegAudioHeader();
        this.gaplessInfoHolder = new GaplessInfoHolder();
        this.basisTimeUs = -9223372036854775807L;
        this.id3Peeker = new Id3Peeker();
    }

    private Seeker getConstantBitrateSeeker(ExtractorInput extractorInput) throws IOException, InterruptedException {
        extractorInput.peekFully(this.scratch.data, 0, 4);
        this.scratch.setPosition(0);
        MpegAudioHeader.populateHeader((int)this.scratch.readInt(), (MpegAudioHeader)this.synchronizedHeader);
        return new ConstantBitrateSeeker(extractorInput.getLength(), extractorInput.getPosition(), this.synchronizedHeader);
    }

    private static int getSeekFrameHeader(ParsableByteArray parsableByteArray, int n2) {
        if (parsableByteArray.limit() >= n2 + 4) {
            parsableByteArray.setPosition(n2);
            n2 = parsableByteArray.readInt();
            if (n2 == SEEK_HEADER_XING || n2 == SEEK_HEADER_INFO) {
                return n2;
            }
        }
        if (parsableByteArray.limit() >= 40) {
            parsableByteArray.setPosition(36);
            n2 = parsableByteArray.readInt();
            int n3 = SEEK_HEADER_VBRI;
            if (n2 == n3) {
                return n3;
            }
        }
        return 0;
    }

    private static boolean headersMatch(int n2, long l2) {
        boolean bl = (long)(n2 & 0xFFFE0C00) == (l2 & 0xFFFFFFFFFFFE0C00L);
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private Seeker maybeReadSeekFrame(ExtractorInput var1_1) throws IOException, InterruptedException {
        block11: {
            block10: {
                var2_2 = new ParsableByteArray(this.synchronizedHeader.frameSize);
                var1_1.peekFully(var2_2.data, 0, this.synchronizedHeader.frameSize);
                if ((this.synchronizedHeader.version & 1) == 0) break block10;
                if (this.synchronizedHeader.channels == 1) ** GOTO lbl-1000
                var3_3 = 36;
                break block11;
            }
            if (this.synchronizedHeader.channels != 1) lbl-1000:
            // 2 sources

            {
                var3_3 = 21;
            } else {
                var3_3 = 13;
            }
        }
        var4_4 = Mp3Extractor.getSeekFrameHeader(var2_2, var3_3);
        if (var4_4 != Mp3Extractor.SEEK_HEADER_XING && var4_4 != Mp3Extractor.SEEK_HEADER_INFO) {
            if (var4_4 == Mp3Extractor.SEEK_HEADER_VBRI) {
                var2_2 = VbriSeeker.create((long)var1_1.getLength(), (long)var1_1.getPosition(), (MpegAudioHeader)this.synchronizedHeader, (ParsableByteArray)var2_2);
                var1_1.skipFully(this.synchronizedHeader.frameSize);
            } else {
                var2_2 = null;
                var1_1.resetPeekPosition();
            }
        } else {
            var5_5 = XingSeeker.create((long)var1_1.getLength(), (long)var1_1.getPosition(), (MpegAudioHeader)this.synchronizedHeader, (ParsableByteArray)var2_2);
            if (var5_5 != null && !this.gaplessInfoHolder.hasGaplessInfo()) {
                var1_1.resetPeekPosition();
                var1_1.advancePeekPosition(var3_3 + 141);
                var1_1.peekFully(this.scratch.data, 0, 3);
                this.scratch.setPosition(0);
                this.gaplessInfoHolder.setFromXingHeaderValue(this.scratch.readUnsignedInt24());
            }
            var1_1.skipFully(this.synchronizedHeader.frameSize);
            var2_2 = var5_5;
            if (var5_5 != null) {
                var2_2 = var5_5;
                if (!var5_5.isSeekable()) {
                    var2_2 = var5_5;
                    if (var4_4 == Mp3Extractor.SEEK_HEADER_INFO) {
                        return this.getConstantBitrateSeeker(var1_1);
                    }
                }
            }
        }
        return var2_2;
    }

    private int readSample(ExtractorInput extractorInput) throws IOException, InterruptedException {
        long l2;
        int n2;
        if (this.sampleBytesRemaining == 0) {
            extractorInput.resetPeekPosition();
            if (!extractorInput.peekFully(this.scratch.data, 0, 4, true)) {
                return -1;
            }
            this.scratch.setPosition(0);
            n2 = this.scratch.readInt();
            if (Mp3Extractor.headersMatch(n2, this.synchronizedHeaderData) && MpegAudioHeader.getFrameSize((int)n2) != -1) {
                MpegAudioHeader.populateHeader((int)n2, (MpegAudioHeader)this.synchronizedHeader);
                if (this.basisTimeUs == -9223372036854775807L) {
                    this.basisTimeUs = this.seeker.getTimeUs(extractorInput.getPosition());
                    if (this.forcedFirstSampleTimestampUs != -9223372036854775807L) {
                        l2 = this.seeker.getTimeUs(0L);
                        this.basisTimeUs += this.forcedFirstSampleTimestampUs - l2;
                    }
                }
                this.sampleBytesRemaining = this.synchronizedHeader.frameSize;
            } else {
                extractorInput.skipFully(1);
                this.synchronizedHeaderData = 0;
                return 0;
            }
        }
        if ((n2 = this.trackOutput.sampleData(extractorInput, this.sampleBytesRemaining, true)) == -1) {
            return -1;
        }
        this.sampleBytesRemaining -= n2;
        if (this.sampleBytesRemaining > 0) {
            return 0;
        }
        long l3 = this.basisTimeUs;
        l2 = this.samplesRead * 1000000L / (long)this.synchronizedHeader.sampleRate;
        this.trackOutput.sampleMetadata(l3 + l2, 1, this.synchronizedHeader.frameSize, 0, null);
        this.samplesRead += (long)this.synchronizedHeader.samplesPerFrame;
        this.sampleBytesRemaining = 0;
        return 0;
    }

    private boolean synchronize(ExtractorInput extractorInput, boolean bl) throws IOException, InterruptedException {
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6 = bl ? 16384 : 131072;
        extractorInput.resetPeekPosition();
        if (extractorInput.getPosition() == 0L) {
            n5 = (this.flags & 2) != 0 ? 1 : 0;
            object = n5 != 0 ? GaplessInfoHolder.GAPLESS_INFO_ID3_FRAME_PREDICATE : null;
            this.metadata = this.id3Peeker.peekId3Data(extractorInput, object);
            object = this.metadata;
            if (object != null) {
                this.gaplessInfoHolder.setFromMetadata((Metadata)object);
            }
            n4 = (int)extractorInput.getPeekPosition();
            if (!bl) {
                extractorInput.skipFully(n4);
            }
            n3 = 0;
            n5 = 0;
            n2 = 0;
        } else {
            n3 = 0;
            n5 = 0;
            n2 = 0;
            n4 = 0;
        }
        while (true) {
            int n7;
            int n8;
            block17: {
                block15: {
                    block16: {
                        boolean bl2;
                        if (!extractorInput.peekFully((byte[])(object = (Object)this.scratch.data), 0, 4, bl2 = n3 > 0)) break block15;
                        this.scratch.setPosition(0);
                        n8 = this.scratch.readInt();
                        if (n5 != 0 && !Mp3Extractor.headersMatch(n8, n5) || (n7 = MpegAudioHeader.getFrameSize((int)n8)) == -1) {
                            n5 = n2 + 1;
                            if (n2 == n6) {
                                if (bl) {
                                    return false;
                                }
                                throw new ParserException("Searched too many bytes.");
                            }
                            if (bl) {
                                extractorInput.resetPeekPosition();
                                extractorInput.advancePeekPosition(n4 + n5);
                            } else {
                                extractorInput.skipFully(1);
                            }
                            n2 = n5;
                            n3 = 0;
                            n5 = 0;
                            continue;
                        }
                        if (++n3 != 1) break block16;
                        MpegAudioHeader.populateHeader((int)n8, (MpegAudioHeader)this.synchronizedHeader);
                        break block17;
                    }
                    n8 = n5;
                    if (n3 != 4) break block17;
                }
                if (bl) {
                    extractorInput.skipFully(n4 + n2);
                } else {
                    extractorInput.resetPeekPosition();
                }
                this.synchronizedHeaderData = n5;
                return true;
            }
            extractorInput.advancePeekPosition(n7 - 4);
            n5 = n8;
        }
    }

    public final void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
        this.trackOutput = this.extractorOutput.track(0, 1);
        this.extractorOutput.endTracks();
    }

    public final int read(ExtractorInput extractorInput, PositionHolder object) throws IOException, InterruptedException {
        if (this.synchronizedHeaderData == 0) {
            try {
                this.synchronize(extractorInput, false);
            }
            catch (EOFException eOFException) {
                return -1;
            }
        }
        if (this.seeker == null) {
            this.seeker = this.maybeReadSeekFrame(extractorInput);
            object = this.seeker;
            if (object == null || !object.isSeekable() && (this.flags & 1) != 0) {
                this.seeker = this.getConstantBitrateSeeker(extractorInput);
            }
            this.extractorOutput.seekMap((SeekMap)this.seeker);
            TrackOutput trackOutput = this.trackOutput;
            String string2 = this.synchronizedHeader.mimeType;
            int n2 = this.synchronizedHeader.channels;
            int n3 = this.synchronizedHeader.sampleRate;
            int n4 = this.gaplessInfoHolder.encoderDelay;
            int n5 = this.gaplessInfoHolder.encoderPadding;
            object = (this.flags & 2) != 0 ? null : this.metadata;
            trackOutput.format(Format.createAudioSampleFormat(null, (String)string2, null, (int)-1, (int)4096, (int)n2, (int)n3, (int)-1, (int)n4, (int)n5, null, null, (int)0, null, (Metadata)object));
        }
        return this.readSample(extractorInput);
    }

    public final void release() {
    }

    public final void seek(long l2, long l3) {
        this.synchronizedHeaderData = 0;
        this.basisTimeUs = -9223372036854775807L;
        this.samplesRead = 0L;
        this.sampleBytesRemaining = 0;
    }

    public final boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return this.synchronize(extractorInput, true);
    }

    public static @interface Flags {
    }

    static interface Seeker
    extends SeekMap {
        public long getTimeUs(long var1);
    }
}

