/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv;

import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.mbridge.msdk.playercommon.exoplayer2.C;
import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.ParserException;
import com.mbridge.msdk.playercommon.exoplayer2.audio.Ac3Util;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmInitData;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ChunkIndex;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.Extractor;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorInput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorsFactory;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.PositionHolder;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.SeekMap;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.TrackOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv.DefaultEbmlReader;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv.EbmlReader;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv.EbmlReaderOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv.Sniffer;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv.VarintReader;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.LongArray;
import com.mbridge.msdk.playercommon.exoplayer2.util.MimeTypes;
import com.mbridge.msdk.playercommon.exoplayer2.util.NalUnitUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableByteArray;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import com.mbridge.msdk.playercommon.exoplayer2.video.AvcConfig;
import com.mbridge.msdk.playercommon.exoplayer2.video.ColorInfo;
import com.mbridge.msdk.playercommon.exoplayer2.video.HevcConfig;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public final class MatroskaExtractor
implements Extractor {
    private static final int BLOCK_STATE_DATA = 2;
    private static final int BLOCK_STATE_HEADER = 1;
    private static final int BLOCK_STATE_START = 0;
    private static final String CODEC_ID_AAC = "A_AAC";
    private static final String CODEC_ID_AC3 = "A_AC3";
    private static final String CODEC_ID_ACM = "A_MS/ACM";
    private static final String CODEC_ID_ASS = "S_TEXT/ASS";
    private static final String CODEC_ID_DTS = "A_DTS";
    private static final String CODEC_ID_DTS_EXPRESS = "A_DTS/EXPRESS";
    private static final String CODEC_ID_DTS_LOSSLESS = "A_DTS/LOSSLESS";
    private static final String CODEC_ID_DVBSUB = "S_DVBSUB";
    private static final String CODEC_ID_E_AC3 = "A_EAC3";
    private static final String CODEC_ID_FLAC = "A_FLAC";
    private static final String CODEC_ID_FOURCC = "V_MS/VFW/FOURCC";
    private static final String CODEC_ID_H264 = "V_MPEG4/ISO/AVC";
    private static final String CODEC_ID_H265 = "V_MPEGH/ISO/HEVC";
    private static final String CODEC_ID_MP2 = "A_MPEG/L2";
    private static final String CODEC_ID_MP3 = "A_MPEG/L3";
    private static final String CODEC_ID_MPEG2 = "V_MPEG2";
    private static final String CODEC_ID_MPEG4_AP = "V_MPEG4/ISO/AP";
    private static final String CODEC_ID_MPEG4_ASP = "V_MPEG4/ISO/ASP";
    private static final String CODEC_ID_MPEG4_SP = "V_MPEG4/ISO/SP";
    private static final String CODEC_ID_OPUS = "A_OPUS";
    private static final String CODEC_ID_PCM_INT_LIT = "A_PCM/INT/LIT";
    private static final String CODEC_ID_PGS = "S_HDMV/PGS";
    private static final String CODEC_ID_SUBRIP = "S_TEXT/UTF8";
    private static final String CODEC_ID_THEORA = "V_THEORA";
    private static final String CODEC_ID_TRUEHD = "A_TRUEHD";
    private static final String CODEC_ID_VOBSUB = "S_VOBSUB";
    private static final String CODEC_ID_VORBIS = "A_VORBIS";
    private static final String CODEC_ID_VP8 = "V_VP8";
    private static final String CODEC_ID_VP9 = "V_VP9";
    private static final String DOC_TYPE_MATROSKA = "matroska";
    private static final String DOC_TYPE_WEBM = "webm";
    private static final int ENCRYPTION_IV_SIZE = 8;
    public static final ExtractorsFactory FACTORY = new ExtractorsFactory(){

        public final Extractor[] createExtractors() {
            return new Extractor[]{new MatroskaExtractor()};
        }
    };
    public static final int FLAG_DISABLE_SEEK_FOR_CUES = 1;
    private static final int FOURCC_COMPRESSION_DIVX = 1482049860;
    private static final int FOURCC_COMPRESSION_VC1 = 826496599;
    private static final int ID_AUDIO = 225;
    private static final int ID_AUDIO_BIT_DEPTH = 25188;
    private static final int ID_BLOCK = 161;
    private static final int ID_BLOCK_DURATION = 155;
    private static final int ID_BLOCK_GROUP = 160;
    private static final int ID_CHANNELS = 159;
    private static final int ID_CLUSTER = 524531317;
    private static final int ID_CODEC_DELAY = 22186;
    private static final int ID_CODEC_ID = 134;
    private static final int ID_CODEC_PRIVATE = 25506;
    private static final int ID_COLOUR = 21936;
    private static final int ID_COLOUR_PRIMARIES = 21947;
    private static final int ID_COLOUR_RANGE = 21945;
    private static final int ID_COLOUR_TRANSFER = 21946;
    private static final int ID_CONTENT_COMPRESSION = 20532;
    private static final int ID_CONTENT_COMPRESSION_ALGORITHM = 16980;
    private static final int ID_CONTENT_COMPRESSION_SETTINGS = 16981;
    private static final int ID_CONTENT_ENCODING = 25152;
    private static final int ID_CONTENT_ENCODINGS = 28032;
    private static final int ID_CONTENT_ENCODING_ORDER = 20529;
    private static final int ID_CONTENT_ENCODING_SCOPE = 20530;
    private static final int ID_CONTENT_ENCRYPTION = 20533;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS = 18407;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS_CIPHER_MODE = 18408;
    private static final int ID_CONTENT_ENCRYPTION_ALGORITHM = 18401;
    private static final int ID_CONTENT_ENCRYPTION_KEY_ID = 18402;
    private static final int ID_CUES = 475249515;
    private static final int ID_CUE_CLUSTER_POSITION = 241;
    private static final int ID_CUE_POINT = 187;
    private static final int ID_CUE_TIME = 179;
    private static final int ID_CUE_TRACK_POSITIONS = 183;
    private static final int ID_DEFAULT_DURATION = 2352003;
    private static final int ID_DISPLAY_HEIGHT = 21690;
    private static final int ID_DISPLAY_UNIT = 21682;
    private static final int ID_DISPLAY_WIDTH = 21680;
    private static final int ID_DOC_TYPE = 17026;
    private static final int ID_DOC_TYPE_READ_VERSION = 17029;
    private static final int ID_DURATION = 17545;
    private static final int ID_EBML = 440786851;
    private static final int ID_EBML_READ_VERSION = 17143;
    private static final int ID_FLAG_DEFAULT = 136;
    private static final int ID_FLAG_FORCED = 21930;
    private static final int ID_INFO = 357149030;
    private static final int ID_LANGUAGE = 2274716;
    private static final int ID_LUMNINANCE_MAX = 21977;
    private static final int ID_LUMNINANCE_MIN = 21978;
    private static final int ID_MASTERING_METADATA = 21968;
    private static final int ID_MAX_CLL = 21948;
    private static final int ID_MAX_FALL = 21949;
    private static final int ID_PIXEL_HEIGHT = 186;
    private static final int ID_PIXEL_WIDTH = 176;
    private static final int ID_PRIMARY_B_CHROMATICITY_X = 21973;
    private static final int ID_PRIMARY_B_CHROMATICITY_Y = 21974;
    private static final int ID_PRIMARY_G_CHROMATICITY_X = 21971;
    private static final int ID_PRIMARY_G_CHROMATICITY_Y = 21972;
    private static final int ID_PRIMARY_R_CHROMATICITY_X = 21969;
    private static final int ID_PRIMARY_R_CHROMATICITY_Y = 21970;
    private static final int ID_PROJECTION = 30320;
    private static final int ID_PROJECTION_PRIVATE = 30322;
    private static final int ID_REFERENCE_BLOCK = 251;
    private static final int ID_SAMPLING_FREQUENCY = 181;
    private static final int ID_SEEK = 19899;
    private static final int ID_SEEK_HEAD = 290298740;
    private static final int ID_SEEK_ID = 21419;
    private static final int ID_SEEK_POSITION = 21420;
    private static final int ID_SEEK_PRE_ROLL = 22203;
    private static final int ID_SEGMENT = 408125543;
    private static final int ID_SEGMENT_INFO = 357149030;
    private static final int ID_SIMPLE_BLOCK = 163;
    private static final int ID_STEREO_MODE = 21432;
    private static final int ID_TIMECODE_SCALE = 2807729;
    private static final int ID_TIME_CODE = 231;
    private static final int ID_TRACKS = 374648427;
    private static final int ID_TRACK_ENTRY = 174;
    private static final int ID_TRACK_NUMBER = 215;
    private static final int ID_TRACK_TYPE = 131;
    private static final int ID_VIDEO = 224;
    private static final int ID_WHITE_POINT_CHROMATICITY_X = 21975;
    private static final int ID_WHITE_POINT_CHROMATICITY_Y = 21976;
    private static final int LACING_EBML = 3;
    private static final int LACING_FIXED_SIZE = 2;
    private static final int LACING_NONE = 0;
    private static final int LACING_XIPH = 1;
    private static final int OPUS_MAX_INPUT_SIZE = 5760;
    private static final byte[] SSA_DIALOGUE_FORMAT;
    private static final byte[] SSA_PREFIX;
    private static final int SSA_PREFIX_END_TIMECODE_OFFSET = 21;
    private static final byte[] SSA_TIMECODE_EMPTY;
    private static final String SSA_TIMECODE_FORMAT = "%01d:%02d:%02d:%02d";
    private static final long SSA_TIMECODE_LAST_VALUE_SCALING_FACTOR = 10000L;
    private static final byte[] SUBRIP_PREFIX;
    private static final int SUBRIP_PREFIX_END_TIMECODE_OFFSET = 19;
    private static final byte[] SUBRIP_TIMECODE_EMPTY;
    private static final String SUBRIP_TIMECODE_FORMAT = "%02d:%02d:%02d,%03d";
    private static final long SUBRIP_TIMECODE_LAST_VALUE_SCALING_FACTOR = 1000L;
    private static final String TAG = "MatroskaExtractor";
    private static final int TRACK_TYPE_AUDIO = 2;
    private static final int UNSET_ENTRY_ID = -1;
    private static final int VORBIS_MAX_INPUT_SIZE = 8192;
    private static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private static final int WAVE_FORMAT_PCM = 1;
    private static final int WAVE_FORMAT_SIZE = 18;
    private static final UUID WAVE_SUBFORMAT_PCM;
    private long blockDurationUs;
    private int blockFlags;
    private int blockLacingSampleCount;
    private int blockLacingSampleIndex;
    private int[] blockLacingSampleSizes;
    private int blockState;
    private long blockTimeUs;
    private int blockTrackNumber;
    private int blockTrackNumberLength;
    private long clusterTimecodeUs = -9223372036854775807L;
    private LongArray cueClusterPositions;
    private LongArray cueTimesUs;
    private long cuesContentPosition = -1L;
    private Track currentTrack;
    private long durationTimecode = -9223372036854775807L;
    private long durationUs = -9223372036854775807L;
    private final ParsableByteArray encryptionInitializationVector;
    private final ParsableByteArray encryptionSubsampleData;
    private ByteBuffer encryptionSubsampleDataBuffer;
    private ExtractorOutput extractorOutput;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray nalStartCode;
    private final EbmlReader reader;
    private int sampleBytesRead;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private boolean sampleEncodingHandled;
    private boolean sampleInitializationVectorRead;
    private int samplePartitionCount;
    private boolean samplePartitionCountRead;
    private boolean sampleRead;
    private boolean sampleSeenReferenceBlock;
    private byte sampleSignalByte;
    private boolean sampleSignalByteRead;
    private final ParsableByteArray sampleStrippedBytes;
    private final ParsableByteArray scratch;
    private int seekEntryId;
    private final ParsableByteArray seekEntryIdBytes;
    private long seekEntryPosition;
    private boolean seekForCues;
    private final boolean seekForCuesEnabled;
    private long seekPositionAfterBuildingCues = -1L;
    private boolean seenClusterPositionForCurrentCuePoint;
    private long segmentContentPosition = -1L;
    private long segmentContentSize;
    private boolean sentSeekMap;
    private final ParsableByteArray subtitleSample;
    private long timecodeScale = -9223372036854775807L;
    private final SparseArray<Track> tracks;
    private final VarintReader varintReader;
    private final ParsableByteArray vorbisNumPageSamples;

    static {
        SUBRIP_PREFIX = new byte[]{49, 10, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 32, 45, 45, 62, 32, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 10};
        SUBRIP_TIMECODE_EMPTY = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        SSA_DIALOGUE_FORMAT = Util.getUtf8Bytes((String)"Format: Start, End, ReadOrder, Layer, Style, Name, MarginL, MarginR, MarginV, Effect, Text");
        SSA_PREFIX = new byte[]{68, 105, 97, 108, 111, 103, 117, 101, 58, 32, 48, 58, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 58, 48, 48, 58, 48, 48, 58, 48, 48, 44};
        SSA_TIMECODE_EMPTY = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        WAVE_SUBFORMAT_PCM = new UUID(0x100000000001000L, -9223371306706625679L);
    }

    public MatroskaExtractor() {
        this(0);
    }

    public MatroskaExtractor(int n2) {
        this(new DefaultEbmlReader(), n2);
    }

    MatroskaExtractor(EbmlReader ebmlReader, int n2) {
        this.reader = ebmlReader;
        this.reader.init((EbmlReaderOutput)new InnerEbmlReaderOutput());
        boolean bl = true;
        if ((n2 & 1) != 0) {
            bl = false;
        }
        this.seekForCuesEnabled = bl;
        this.varintReader = new VarintReader();
        this.tracks = new SparseArray();
        this.scratch = new ParsableByteArray(4);
        this.vorbisNumPageSamples = new ParsableByteArray(ByteBuffer.allocate(4).putInt(-1).array());
        this.seekEntryIdBytes = new ParsableByteArray(4);
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.sampleStrippedBytes = new ParsableByteArray();
        this.subtitleSample = new ParsableByteArray();
        this.encryptionInitializationVector = new ParsableByteArray(8);
        this.encryptionSubsampleData = new ParsableByteArray();
    }

    static /* synthetic */ byte[] access$300() {
        return SSA_DIALOGUE_FORMAT;
    }

    private SeekMap buildSeekMap() {
        Object object;
        if (this.segmentContentPosition != -1L && this.durationUs != -9223372036854775807L && (object = this.cueTimesUs) != null && object.size() != 0 && (object = this.cueClusterPositions) != null && object.size() == this.cueTimesUs.size()) {
            int n2;
            int n3 = this.cueTimesUs.size();
            object = new int[n3];
            long[] lArray = new long[n3];
            long[] lArray2 = new long[n3];
            long[] lArray3 = new long[n3];
            int n4 = 0;
            int n5 = 0;
            while (true) {
                n2 = n4;
                if (n5 >= n3) break;
                lArray3[n5] = this.cueTimesUs.get(n5);
                lArray[n5] = this.segmentContentPosition + this.cueClusterPositions.get(n5);
                ++n5;
            }
            while (n2 < (n5 = n3 - 1)) {
                n5 = n2 + 1;
                object[n2] = (LongArray)((int)(lArray[n5] - lArray[n2]));
                lArray2[n2] = lArray3[n5] - lArray3[n2];
                n2 = n5;
            }
            object[n5] = (LongArray)((int)(this.segmentContentPosition + this.segmentContentSize - lArray[n5]));
            lArray2[n5] = this.durationUs - lArray3[n5];
            this.cueTimesUs = null;
            this.cueClusterPositions = null;
            return new ChunkIndex((int[])object, lArray, lArray2, lArray3);
        }
        this.cueTimesUs = null;
        this.cueClusterPositions = null;
        return new SeekMap.Unseekable(this.durationUs);
    }

    private void commitSampleToOutput(Track track, long l2) {
        if (track.trueHdSampleRechunker != null) {
            track.trueHdSampleRechunker.sampleMetadata(track, l2);
        } else {
            if (CODEC_ID_SUBRIP.equals(track.codecId)) {
                this.commitSubtitleSample(track, SUBRIP_TIMECODE_FORMAT, 19, 1000L, SUBRIP_TIMECODE_EMPTY);
            } else if (CODEC_ID_ASS.equals(track.codecId)) {
                this.commitSubtitleSample(track, SSA_TIMECODE_FORMAT, 21, 10000L, SSA_TIMECODE_EMPTY);
            }
            track.output.sampleMetadata(l2, this.blockFlags, this.sampleBytesWritten, 0, track.cryptoData);
        }
        this.sampleRead = true;
        this.resetSample();
    }

    private void commitSubtitleSample(Track track, String string2, int n2, long l2, byte[] byArray) {
        MatroskaExtractor.setSampleDuration(this.subtitleSample.data, this.blockDurationUs, string2, n2, l2, byArray);
        track = track.output;
        string2 = this.subtitleSample;
        track.sampleData((ParsableByteArray)string2, string2.limit());
        this.sampleBytesWritten += this.subtitleSample.limit();
    }

    private static int[] ensureArrayCapacity(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        if (nArray.length >= n2) {
            return nArray;
        }
        return new int[Math.max(nArray.length * 2, n2)];
    }

    private static boolean isCodecSupported(String string2) {
        boolean bl = CODEC_ID_VP8.equals(string2) || CODEC_ID_VP9.equals(string2) || CODEC_ID_MPEG2.equals(string2) || CODEC_ID_MPEG4_SP.equals(string2) || CODEC_ID_MPEG4_ASP.equals(string2) || CODEC_ID_MPEG4_AP.equals(string2) || CODEC_ID_H264.equals(string2) || CODEC_ID_H265.equals(string2) || CODEC_ID_FOURCC.equals(string2) || CODEC_ID_THEORA.equals(string2) || CODEC_ID_OPUS.equals(string2) || CODEC_ID_VORBIS.equals(string2) || CODEC_ID_AAC.equals(string2) || CODEC_ID_MP2.equals(string2) || CODEC_ID_MP3.equals(string2) || CODEC_ID_AC3.equals(string2) || CODEC_ID_E_AC3.equals(string2) || CODEC_ID_TRUEHD.equals(string2) || CODEC_ID_DTS.equals(string2) || CODEC_ID_DTS_EXPRESS.equals(string2) || CODEC_ID_DTS_LOSSLESS.equals(string2) || CODEC_ID_FLAC.equals(string2) || CODEC_ID_ACM.equals(string2) || CODEC_ID_PCM_INT_LIT.equals(string2) || CODEC_ID_SUBRIP.equals(string2) || CODEC_ID_ASS.equals(string2) || CODEC_ID_VOBSUB.equals(string2) || CODEC_ID_PGS.equals(string2) || CODEC_ID_DVBSUB.equals(string2);
        return bl;
    }

    private boolean maybeSeekForCues(PositionHolder positionHolder, long l2) {
        if (this.seekForCues) {
            this.seekPositionAfterBuildingCues = l2;
            positionHolder.position = this.cuesContentPosition;
            this.seekForCues = false;
            return true;
        }
        if (this.sentSeekMap && (l2 = this.seekPositionAfterBuildingCues) != -1L) {
            positionHolder.position = l2;
            this.seekPositionAfterBuildingCues = -1L;
            return true;
        }
        return false;
    }

    private void readScratch(ExtractorInput extractorInput, int n2) throws IOException, InterruptedException {
        if (this.scratch.limit() >= n2) {
            return;
        }
        if (this.scratch.capacity() < n2) {
            ParsableByteArray parsableByteArray = this.scratch;
            parsableByteArray.reset(Arrays.copyOf(parsableByteArray.data, Math.max(this.scratch.data.length * 2, n2)), this.scratch.limit());
        }
        extractorInput.readFully(this.scratch.data, this.scratch.limit(), n2 - this.scratch.limit());
        this.scratch.setLimit(n2);
    }

    private int readToOutput(ExtractorInput extractorInput, TrackOutput trackOutput, int n2) throws IOException, InterruptedException {
        int n3 = this.sampleStrippedBytes.bytesLeft();
        if (n3 > 0) {
            n2 = Math.min(n2, n3);
            trackOutput.sampleData(this.sampleStrippedBytes, n2);
        } else {
            n2 = trackOutput.sampleData(extractorInput, n2, false);
        }
        this.sampleBytesRead += n2;
        this.sampleBytesWritten += n2;
        return n2;
    }

    private void readToTarget(ExtractorInput extractorInput, byte[] byArray, int n2, int n3) throws IOException, InterruptedException {
        int n4 = Math.min(n3, this.sampleStrippedBytes.bytesLeft());
        extractorInput.readFully(byArray, n2 + n4, n3 - n4);
        if (n4 > 0) {
            this.sampleStrippedBytes.readBytes(byArray, n2, n4);
        }
        this.sampleBytesRead += n3;
    }

    private void resetSample() {
        this.sampleBytesRead = 0;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        this.sampleEncodingHandled = false;
        this.sampleSignalByteRead = false;
        this.samplePartitionCountRead = false;
        this.samplePartitionCount = 0;
        this.sampleSignalByte = (byte)0;
        this.sampleInitializationVectorRead = false;
        this.sampleStrippedBytes.reset();
    }

    private long scaleTimecodeToUs(long l2) throws ParserException {
        long l3 = this.timecodeScale;
        if (l3 != -9223372036854775807L) {
            return Util.scaleLargeTimestamp((long)l2, (long)l3, (long)1000L);
        }
        throw new ParserException("Can't scale timecode prior to timecodeScale being set.");
    }

    private static void setSampleDuration(byte[] byArray, long l2, String object, int n2, long l3, byte[] byArray2) {
        if (l2 == -9223372036854775807L) {
            object = byArray2;
        } else {
            int n3 = (int)(l2 / 3600000000L);
            int n4 = (int)((l2 -= (long)(n3 * 3600) * 1000000L) / 60000000L);
            int n5 = (int)((l2 -= (long)(n4 * 60) * 1000000L) / 1000000L);
            int n6 = (int)((l2 - (long)n5 * 1000000L) / l3);
            object = Util.getUtf8Bytes((String)String.format(Locale.US, (String)object, n3, n4, n5, n6));
        }
        System.arraycopy(object, 0, byArray, n2, byArray2.length);
    }

    private void writeSampleData(ExtractorInput extractorInput, Track track, int n2) throws IOException, InterruptedException {
        int n3;
        Object object;
        int n4;
        int n5;
        if (CODEC_ID_SUBRIP.equals(track.codecId)) {
            this.writeSubtitleSampleData(extractorInput, SUBRIP_PREFIX, n2);
            return;
        }
        if (CODEC_ID_ASS.equals(track.codecId)) {
            this.writeSubtitleSampleData(extractorInput, SSA_PREFIX, n2);
            return;
        }
        TrackOutput trackOutput = track.output;
        boolean bl = this.sampleEncodingHandled;
        boolean bl2 = true;
        if (!bl) {
            if (track.hasContentEncryption) {
                this.blockFlags &= 0xBFFFFFFF;
                bl = this.sampleSignalByteRead;
                n5 = 128;
                if (!bl) {
                    extractorInput.readFully(this.scratch.data, 0, 1);
                    ++this.sampleBytesRead;
                    if ((this.scratch.data[0] & 0x80) != 128) {
                        this.sampleSignalByte = this.scratch.data[0];
                        this.sampleSignalByteRead = true;
                    } else {
                        throw new ParserException("Extension bit is set in signal byte");
                    }
                }
                if ((n4 = (this.sampleSignalByte & 1) == 1 ? 1 : 0) != 0) {
                    n4 = (this.sampleSignalByte & 2) == 2 ? 1 : 0;
                    this.blockFlags |= 0x40000000;
                    if (!this.sampleInitializationVectorRead) {
                        extractorInput.readFully(this.encryptionInitializationVector.data, 0, 8);
                        this.sampleBytesRead += 8;
                        this.sampleInitializationVectorRead = true;
                        object = this.scratch.data;
                        if (n4 == 0) {
                            n5 = 0;
                        }
                        object[0] = (byte)(n5 | 8);
                        this.scratch.setPosition(0);
                        trackOutput.sampleData(this.scratch, 1);
                        ++this.sampleBytesWritten;
                        this.encryptionInitializationVector.setPosition(0);
                        trackOutput.sampleData(this.encryptionInitializationVector, 8);
                        this.sampleBytesWritten += 8;
                    }
                    if (n4 != 0) {
                        if (!this.samplePartitionCountRead) {
                            extractorInput.readFully(this.scratch.data, 0, 1);
                            ++this.sampleBytesRead;
                            this.scratch.setPosition(0);
                            this.samplePartitionCount = this.scratch.readUnsignedByte();
                            this.samplePartitionCountRead = true;
                        }
                        n4 = this.samplePartitionCount * 4;
                        this.scratch.reset(n4);
                        extractorInput.readFully(this.scratch.data, 0, n4);
                        this.sampleBytesRead += n4;
                        short s2 = (short)(this.samplePartitionCount / 2 + 1);
                        int n6 = s2 * 6 + 2;
                        object = this.encryptionSubsampleDataBuffer;
                        if (object == null || ((Buffer)object).capacity() < n6) {
                            this.encryptionSubsampleDataBuffer = ByteBuffer.allocate(n6);
                        }
                        this.encryptionSubsampleDataBuffer.position(0);
                        this.encryptionSubsampleDataBuffer.putShort(s2);
                        n5 = 0;
                        for (n4 = 0; n4 < (n3 = this.samplePartitionCount); ++n4) {
                            n3 = this.scratch.readUnsignedIntToInt();
                            if (n4 % 2 == 0) {
                                this.encryptionSubsampleDataBuffer.putShort((short)(n3 - n5));
                            } else {
                                this.encryptionSubsampleDataBuffer.putInt(n3 - n5);
                            }
                            n5 = n3;
                        }
                        n4 = n2 - this.sampleBytesRead - n5;
                        if (n3 % 2 == 1) {
                            this.encryptionSubsampleDataBuffer.putInt(n4);
                        } else {
                            this.encryptionSubsampleDataBuffer.putShort((short)n4);
                            this.encryptionSubsampleDataBuffer.putInt(0);
                        }
                        this.encryptionSubsampleData.reset(this.encryptionSubsampleDataBuffer.array(), n6);
                        trackOutput.sampleData(this.encryptionSubsampleData, n6);
                        this.sampleBytesWritten += n6;
                    }
                }
            } else if (track.sampleStrippedBytes != null) {
                this.sampleStrippedBytes.reset(track.sampleStrippedBytes, track.sampleStrippedBytes.length);
            }
            this.sampleEncodingHandled = true;
        }
        n2 += this.sampleStrippedBytes.limit();
        if (!CODEC_ID_H264.equals(track.codecId) && !CODEC_ID_H265.equals(track.codecId)) {
            if (track.trueHdSampleRechunker != null) {
                if (this.sampleStrippedBytes.limit() != 0) {
                    bl2 = false;
                }
                Assertions.checkState(bl2);
                track.trueHdSampleRechunker.startSample(extractorInput, this.blockFlags, n2);
            }
            while ((n4 = this.sampleBytesRead) < n2) {
                this.readToOutput(extractorInput, trackOutput, n2 - n4);
            }
        } else {
            object = this.nalLength.data;
            object[0] = (byte)0;
            object[1] = (byte)0;
            object[2] = (byte)0;
            n5 = track.nalUnitLengthFieldLength;
            n3 = track.nalUnitLengthFieldLength;
            while (this.sampleBytesRead < n2) {
                n4 = this.sampleCurrentNalBytesRemaining;
                if (n4 == 0) {
                    this.readToTarget(extractorInput, (byte[])object, 4 - n3, n5);
                    this.nalLength.setPosition(0);
                    this.sampleCurrentNalBytesRemaining = this.nalLength.readUnsignedIntToInt();
                    this.nalStartCode.setPosition(0);
                    trackOutput.sampleData(this.nalStartCode, 4);
                    this.sampleBytesWritten += 4;
                    continue;
                }
                this.sampleCurrentNalBytesRemaining = n4 - this.readToOutput(extractorInput, trackOutput, n4);
            }
        }
        if (CODEC_ID_VORBIS.equals(track.codecId)) {
            this.vorbisNumPageSamples.setPosition(0);
            trackOutput.sampleData(this.vorbisNumPageSamples, 4);
            this.sampleBytesWritten += 4;
        }
    }

    private void writeSubtitleSampleData(ExtractorInput extractorInput, byte[] byArray, int n2) throws IOException, InterruptedException {
        int n3 = byArray.length + n2;
        if (this.subtitleSample.capacity() < n3) {
            this.subtitleSample.data = Arrays.copyOf(byArray, n3 + n2);
        } else {
            System.arraycopy(byArray, 0, this.subtitleSample.data, 0, byArray.length);
        }
        extractorInput.readFully(this.subtitleSample.data, byArray.length, n2);
        this.subtitleSample.reset(n3);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final void binaryElement(int var1_1, int var2_2, ExtractorInput var3_3) throws IOException, InterruptedException {
        block22: {
            block23: {
                block26: {
                    block25: {
                        block24: {
                            block18: {
                                block19: {
                                    block20: {
                                        block21: {
                                            if (var1_1 == 161 || var1_1 == 163) break block18;
                                            if (var1_1 == 16981) break block19;
                                            if (var1_1 == 18402) break block20;
                                            if (var1_1 == 21419) break block21;
                                            if (var1_1 == 25506) ** GOTO lbl17
                                            if (var1_1 == 30322) {
                                                var4_4 = this.currentTrack;
                                                var4_4.projectionData = new byte[var2_2];
                                                var3_3.readFully(var4_4.projectionData, 0, var2_2);
                                            } else {
                                                var3_3 = new StringBuilder();
                                                var3_3.append("Unexpected id: ");
                                                var3_3.append(var1_1);
                                                throw new ParserException(var3_3.toString());
lbl17:
                                                // 1 sources

                                                var4_5 = this.currentTrack;
                                                var4_5.codecPrivate = new byte[var2_2];
                                                var3_3.readFully(var4_5.codecPrivate, 0, var2_2);
                                            }
                                            break block22;
                                        }
                                        Arrays.fill(this.seekEntryIdBytes.data, (byte)0);
                                        var3_3.readFully(this.seekEntryIdBytes.data, 4 - var2_2, var2_2);
                                        this.seekEntryIdBytes.setPosition(0);
                                        this.seekEntryId = (int)this.seekEntryIdBytes.readUnsignedInt();
                                        break block22;
                                    }
                                    var4_6 = new byte[var2_2];
                                    var3_3.readFully(var4_6, 0, var2_2);
                                    this.currentTrack.cryptoData = new TrackOutput.CryptoData(1, var4_6, 0, 0);
                                    break block22;
                                }
                                var4_7 = this.currentTrack;
                                var4_7.sampleStrippedBytes = new byte[var2_2];
                                var3_3.readFully(var4_7.sampleStrippedBytes, 0, var2_2);
                                break block22;
                            }
                            if (this.blockState == 0) {
                                this.blockTrackNumber = (int)this.varintReader.readUnsignedVarint((ExtractorInput)var3_3, false, true, 8);
                                this.blockTrackNumberLength = this.varintReader.getLastLength();
                                this.blockDurationUs = -9223372036854775807L;
                                this.blockState = 1;
                                this.scratch.reset();
                            }
                            if ((var4_8 = (Track)this.tracks.get(this.blockTrackNumber)) == null) {
                                var3_3.skipFully(var2_2 - this.blockTrackNumberLength);
                                this.blockState = 0;
                                return;
                            }
                            if (this.blockState != 1) break block23;
                            this.readScratch((ExtractorInput)var3_3, 3);
                            var5_9 = (this.scratch.data[2] & 6) >> 1;
                            if (var5_9 != 0) break block24;
                            this.blockLacingSampleCount = 1;
                            this.blockLacingSampleSizes = MatroskaExtractor.ensureArrayCapacity(this.blockLacingSampleSizes, 1);
                            this.blockLacingSampleSizes[0] = var2_2 - this.blockTrackNumberLength - 3;
                            ** GOTO lbl133
                        }
                        if (var1_1 != 163) ** GOTO lbl149
                        this.readScratch((ExtractorInput)var3_3, 4);
                        this.blockLacingSampleCount = (this.scratch.data[3] & 255) + 1;
                        this.blockLacingSampleSizes = MatroskaExtractor.ensureArrayCapacity(this.blockLacingSampleSizes, this.blockLacingSampleCount);
                        if (var5_9 != 2) break block25;
                        var6_10 = this.blockTrackNumberLength;
                        var5_9 = this.blockLacingSampleCount;
                        var2_2 = (var2_2 - var6_10 - 4) / var5_9;
                        Arrays.fill(this.blockLacingSampleSizes, 0, var5_9, var2_2);
                        ** GOTO lbl133
                    }
                    if (var5_9 != 1) break block26;
                    var5_9 = 4;
                    var6_10 = 0;
                    for (var7_11 = 0; var7_11 < (var8_12 = this.blockLacingSampleCount) - 1; ++var7_11) {
                        this.blockLacingSampleSizes[var7_11] = 0;
                        var8_12 = var5_9;
                        do {
                            var5_9 = var8_12 + 1;
                            this.readScratch((ExtractorInput)var3_3, var5_9);
                            var9_13 = this.scratch.data[var5_9 - 1] & 255;
                            var10_14 /* !! */  = (byte[])this.blockLacingSampleSizes;
                            var10_14 /* !! */ [var7_11] = var10_14 /* !! */ [var7_11] + var9_13;
                            var8_12 = var5_9;
                        } while (var9_13 == 255);
                        var6_10 += var10_14 /* !! */ [var7_11];
                    }
                    this.blockLacingSampleSizes[var8_12 - 1] = var2_2 - this.blockTrackNumberLength - var5_9 - var6_10;
                    ** GOTO lbl133
                }
                if (var5_9 == 3) {
                    var5_9 = 4;
                    var6_10 = 0;
                    for (var7_11 = 0; var7_11 < (var8_12 = this.blockLacingSampleCount) - 1; ++var7_11) {
                        this.blockLacingSampleSizes[var7_11] = 0;
                        var9_13 = var5_9 + 1;
                        this.readScratch((ExtractorInput)var3_3, var9_13);
                        var10_14 /* !! */  = this.scratch.data;
                        var11_15 = var9_13 - 1;
                        if (var10_14 /* !! */ [var11_15] != 0) {
                            var12_16 = 0L;
                            var8_12 = 0;
                            while (true) {
                                var5_9 = var9_13;
                                var14_17 = var12_16;
                                if (var8_12 >= 8) break;
                                var5_9 = 1 << 7 - var8_12;
                                if ((this.scratch.data[var11_15] & var5_9) != 0) {
                                    this.readScratch((ExtractorInput)var3_3, var9_13 += var8_12);
                                    var14_17 = this.scratch.data[var11_15] & 255 & ~var5_9;
                                    var5_9 = var11_15 + 1;
                                    while (true) {
                                        var12_16 = var14_17;
                                        if (var5_9 >= var9_13) break;
                                        var14_17 = var12_16 << 8 | (long)(this.scratch.data[var5_9] & 255);
                                        ++var5_9;
                                    }
                                    var5_9 = var9_13;
                                    var14_17 = var12_16;
                                    if (var7_11 <= 0) break;
                                    var14_17 = var12_16 - ((1L << var8_12 * 7 + 6) - 1L);
                                    var5_9 = var9_13;
                                    break;
                                }
                                ++var8_12;
                            }
                            if (var14_17 >= -2147483648L && var14_17 <= 0x7FFFFFFFL) {
                                var8_12 = (int)var14_17;
                                var10_14 /* !! */  = (byte[])this.blockLacingSampleSizes;
                                if (var7_11 != 0) {
                                    var8_12 += var10_14 /* !! */ [var7_11 - 1];
                                }
                                var10_14 /* !! */ [var7_11] = var8_12;
                                var6_10 += this.blockLacingSampleSizes[var7_11];
                                continue;
                            }
                            throw new ParserException("EBML lacing sample size out of range.");
                        }
                        throw new ParserException("No valid varint length mask found");
                    }
                    this.blockLacingSampleSizes[var8_12 - 1] = var2_2 - this.blockTrackNumberLength - var5_9 - var6_10;
lbl133:
                    // 4 sources

                    var5_9 = this.scratch.data[0];
                    var2_2 = this.scratch.data[1];
                    this.blockTimeUs = this.clusterTimecodeUs + this.scaleTimecodeToUs(var5_9 << 8 | var2_2 & 255);
                    var5_9 = (this.scratch.data[2] & 8) == 8 ? 1 : 0;
                    var2_2 = var4_8.type != 2 && (var1_1 != 163 || (this.scratch.data[2] & 128) != 128) ? 0 : 1;
                    var5_9 = var5_9 != 0 ? -2147483648 : 0;
                    this.blockFlags = var2_2 | var5_9;
                    this.blockState = 2;
                    this.blockLacingSampleIndex = 0;
                } else {
                    var3_3 = new StringBuilder();
                    var3_3.append("Unexpected lacing value: ");
                    var3_3.append(var5_9);
                    throw new ParserException(var3_3.toString());
lbl149:
                    // 1 sources

                    throw new ParserException("Lacing only supported in SimpleBlocks.");
                }
            }
            if (var1_1 == 163) {
                while ((var1_1 = ++this.blockLacingSampleIndex) < this.blockLacingSampleCount) {
                    this.writeSampleData((ExtractorInput)var3_3, var4_8, this.blockLacingSampleSizes[var1_1]);
                    this.commitSampleToOutput(var4_8, this.blockTimeUs + (long)(this.blockLacingSampleIndex * var4_8.defaultSampleDurationNs / 1000));
                }
                this.blockState = 0;
            } else {
                this.writeSampleData((ExtractorInput)var3_3, var4_8, this.blockLacingSampleSizes[0]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void endMasterElement(int n2) throws ParserException {
        if (n2 != 160) {
            if (n2 != 174) {
                long l2;
                if (n2 == 19899) {
                    n2 = this.seekEntryId;
                    if (n2 == -1) throw new ParserException("Mandatory element SeekID or SeekPosition not found");
                    long l3 = this.seekEntryPosition;
                    if (l3 == -1L) throw new ParserException("Mandatory element SeekID or SeekPosition not found");
                    if (n2 != 475249515) return;
                    this.cuesContentPosition = l3;
                    return;
                }
                if (n2 == 25152) {
                    if (!this.currentTrack.hasContentEncryption) return;
                    if (this.currentTrack.cryptoData == null) throw new ParserException("Encrypted Track found but ContentEncKeyID was not found");
                    this.currentTrack.drmInitData = new DrmInitData(new DrmInitData.SchemeData(C.UUID_NIL, "video/webm", this.currentTrack.cryptoData.encryptionKey));
                    return;
                }
                if (n2 == 28032) {
                    if (!this.currentTrack.hasContentEncryption) return;
                    if (this.currentTrack.sampleStrippedBytes != null) throw new ParserException("Combining encryption and compression is not supported");
                    return;
                }
                if (n2 != 357149030) {
                    if (n2 == 374648427) {
                        if (this.tracks.size() == 0) throw new ParserException("No valid tracks were found");
                        this.extractorOutput.endTracks();
                        return;
                    }
                    if (n2 != 475249515) {
                        return;
                    }
                    if (this.sentSeekMap) return;
                    this.extractorOutput.seekMap(this.buildSeekMap());
                    this.sentSeekMap = true;
                    return;
                }
                if (this.timecodeScale == -9223372036854775807L) {
                    this.timecodeScale = 1000000L;
                }
                if ((l2 = this.durationTimecode) == -9223372036854775807L) return;
                this.durationUs = this.scaleTimecodeToUs(l2);
                return;
            }
            if (MatroskaExtractor.isCodecSupported(this.currentTrack.codecId)) {
                Track track = this.currentTrack;
                track.initializeOutput(this.extractorOutput, track.number);
                this.tracks.put(this.currentTrack.number, (Object)this.currentTrack);
            }
            this.currentTrack = null;
            return;
        }
        if (this.blockState != 2) {
            return;
        }
        if (!this.sampleSeenReferenceBlock) {
            this.blockFlags |= 1;
        }
        this.commitSampleToOutput((Track)this.tracks.get(this.blockTrackNumber), this.blockTimeUs);
        this.blockState = 0;
    }

    final void floatElement(int n2, double d2) {
        if (n2 != 181) {
            if (n2 != 17545) {
                switch (n2) {
                    default: {
                        break;
                    }
                    case 21978: {
                        this.currentTrack.minMasteringLuminance = (float)d2;
                        break;
                    }
                    case 21977: {
                        this.currentTrack.maxMasteringLuminance = (float)d2;
                        break;
                    }
                    case 21976: {
                        this.currentTrack.whitePointChromaticityY = (float)d2;
                        break;
                    }
                    case 21975: {
                        this.currentTrack.whitePointChromaticityX = (float)d2;
                        break;
                    }
                    case 21974: {
                        this.currentTrack.primaryBChromaticityY = (float)d2;
                        break;
                    }
                    case 21973: {
                        this.currentTrack.primaryBChromaticityX = (float)d2;
                        break;
                    }
                    case 21972: {
                        this.currentTrack.primaryGChromaticityY = (float)d2;
                        break;
                    }
                    case 21971: {
                        this.currentTrack.primaryGChromaticityX = (float)d2;
                        break;
                    }
                    case 21970: {
                        this.currentTrack.primaryRChromaticityY = (float)d2;
                        break;
                    }
                    case 21969: {
                        this.currentTrack.primaryRChromaticityX = (float)d2;
                        break;
                    }
                }
            } else {
                this.durationTimecode = (long)d2;
            }
        } else {
            this.currentTrack.sampleRate = (int)d2;
        }
    }

    public final void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void integerElement(int n2, long l2) throws ParserException {
        if (n2 != 20529) {
            if (n2 != 20530) {
                boolean bl = false;
                boolean bl2 = false;
                switch (n2) {
                    default: {
                        switch (n2) {
                            default: {
                                return;
                            }
                            case 21949: {
                                this.currentTrack.maxFrameAverageLuminance = (int)l2;
                                return;
                            }
                            case 21948: {
                                this.currentTrack.maxContentLuminance = (int)l2;
                                return;
                            }
                            case 21947: {
                                Track track = this.currentTrack;
                                track.hasColorInfo = true;
                                n2 = (int)l2;
                                if (n2 == 1) {
                                    track.colorSpace = 1;
                                    return;
                                }
                                if (n2 == 9) {
                                    track.colorSpace = 6;
                                    return;
                                }
                                if (n2 != 4 && n2 != 5 && n2 != 6 && n2 != 7) {
                                    return;
                                }
                                this.currentTrack.colorSpace = 2;
                                return;
                            }
                            case 21946: {
                                n2 = (int)l2;
                                if (n2 != 1) {
                                    if (n2 == 16) {
                                        this.currentTrack.colorTransfer = 6;
                                        return;
                                    }
                                    if (n2 == 18) {
                                        this.currentTrack.colorTransfer = 7;
                                        return;
                                    }
                                    if (n2 != 6 && n2 != 7) {
                                        return;
                                    }
                                }
                                this.currentTrack.colorTransfer = 3;
                                return;
                            }
                            case 21945: 
                        }
                        n2 = (int)l2;
                        if (n2 == 1) {
                            this.currentTrack.colorRange = 2;
                            return;
                        }
                        if (n2 != 2) {
                            return;
                        }
                        this.currentTrack.colorRange = 1;
                        return;
                    }
                    case 2807729: {
                        this.timecodeScale = l2;
                        return;
                    }
                    case 2352003: {
                        this.currentTrack.defaultSampleDurationNs = (int)l2;
                        return;
                    }
                    case 25188: {
                        this.currentTrack.audioBitDepth = (int)l2;
                        return;
                    }
                    case 22203: {
                        this.currentTrack.seekPreRollNs = l2;
                        return;
                    }
                    case 22186: {
                        this.currentTrack.codecDelayNs = l2;
                        return;
                    }
                    case 21930: {
                        Track track = this.currentTrack;
                        if (l2 == 1L) {
                            bl2 = true;
                        }
                        track.flagForced = bl2;
                        return;
                    }
                    case 21690: {
                        this.currentTrack.displayHeight = (int)l2;
                        return;
                    }
                    case 21682: {
                        this.currentTrack.displayUnit = (int)l2;
                        return;
                    }
                    case 21680: {
                        this.currentTrack.displayWidth = (int)l2;
                        return;
                    }
                    case 21432: {
                        n2 = (int)l2;
                        if (n2 == 0) {
                            this.currentTrack.stereoMode = 0;
                            return;
                        }
                        if (n2 == 1) {
                            this.currentTrack.stereoMode = 2;
                            return;
                        }
                        if (n2 == 3) {
                            this.currentTrack.stereoMode = 1;
                            return;
                        }
                        if (n2 != 15) {
                            return;
                        }
                        this.currentTrack.stereoMode = 3;
                        return;
                    }
                    case 21420: {
                        this.seekEntryPosition = l2 + this.segmentContentPosition;
                        return;
                    }
                    case 18408: {
                        if (l2 == 1L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("AESSettingsCipherMode ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 18401: {
                        if (l2 == 5L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("ContentEncAlgo ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 17143: {
                        if (l2 == 1L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("EBMLReadVersion ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 17029: {
                        if (l2 >= 1L && l2 <= 2L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("DocTypeReadVersion ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 16980: {
                        if (l2 == 3L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("ContentCompAlgo ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 251: {
                        this.sampleSeenReferenceBlock = true;
                        return;
                    }
                    case 241: {
                        if (this.seenClusterPositionForCurrentCuePoint) return;
                        this.cueClusterPositions.add(l2);
                        this.seenClusterPositionForCurrentCuePoint = true;
                        return;
                    }
                    case 231: {
                        this.clusterTimecodeUs = this.scaleTimecodeToUs(l2);
                        return;
                    }
                    case 215: {
                        this.currentTrack.number = (int)l2;
                        return;
                    }
                    case 186: {
                        this.currentTrack.height = (int)l2;
                        return;
                    }
                    case 179: {
                        this.cueTimesUs.add(this.scaleTimecodeToUs(l2));
                        return;
                    }
                    case 176: {
                        this.currentTrack.width = (int)l2;
                        return;
                    }
                    case 159: {
                        this.currentTrack.channelCount = (int)l2;
                        return;
                    }
                    case 155: {
                        this.blockDurationUs = this.scaleTimecodeToUs(l2);
                        return;
                    }
                    case 136: {
                        Track track = this.currentTrack;
                        bl2 = bl;
                        if (l2 == 1L) {
                            bl2 = true;
                        }
                        track.flagDefault = bl2;
                        return;
                    }
                    case 131: 
                }
                this.currentTrack.type = (int)l2;
                return;
            }
            if (l2 == 1L) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ContentEncodingScope ");
            stringBuilder.append(l2);
            stringBuilder.append(" not supported");
            throw new ParserException(stringBuilder.toString());
        }
        if (l2 == 0L) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ContentEncodingOrder ");
        stringBuilder.append(l2);
        stringBuilder.append(" not supported");
        throw new ParserException(stringBuilder.toString());
    }

    public final int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        int n2 = 0;
        this.sampleRead = false;
        boolean bl = true;
        while (bl && !this.sampleRead) {
            boolean bl2;
            bl = bl2 = this.reader.read(extractorInput);
            if (!bl2) continue;
            bl = bl2;
            if (!this.maybeSeekForCues(positionHolder, extractorInput.getPosition())) continue;
            return 1;
        }
        if (!bl) {
            while (n2 < this.tracks.size()) {
                ((Track)this.tracks.valueAt(n2)).outputPendingSampleMetadata();
                ++n2;
            }
            return -1;
        }
        return 0;
    }

    public final void release() {
    }

    public final void seek(long l2, long l3) {
        this.clusterTimecodeUs = -9223372036854775807L;
        this.blockState = 0;
        this.reader.reset();
        this.varintReader.reset();
        this.resetSample();
        for (int i2 = 0; i2 < this.tracks.size(); ++i2) {
            ((Track)this.tracks.valueAt(i2)).reset();
        }
    }

    public final boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return new Sniffer().sniff(extractorInput);
    }

    final void startMasterElement(int n2, long l2, long l3) throws ParserException {
        if (n2 != 160) {
            if (n2 != 174) {
                if (n2 != 187) {
                    if (n2 != 19899) {
                        if (n2 != 20533) {
                            if (n2 != 21968) {
                                if (n2 != 25152) {
                                    if (n2 != 408125543) {
                                        if (n2 != 475249515) {
                                            if (n2 == 524531317 && !this.sentSeekMap) {
                                                if (this.seekForCuesEnabled && this.cuesContentPosition != -1L) {
                                                    this.seekForCues = true;
                                                } else {
                                                    this.extractorOutput.seekMap((SeekMap)new SeekMap.Unseekable(this.durationUs));
                                                    this.sentSeekMap = true;
                                                }
                                            }
                                        } else {
                                            this.cueTimesUs = new LongArray();
                                            this.cueClusterPositions = new LongArray();
                                        }
                                    } else {
                                        long l4 = this.segmentContentPosition;
                                        if (l4 != -1L && l4 != l2) {
                                            throw new ParserException("Multiple Segment elements not supported");
                                        }
                                        this.segmentContentPosition = l2;
                                        this.segmentContentSize = l3;
                                    }
                                }
                            } else {
                                this.currentTrack.hasColorInfo = true;
                            }
                        } else {
                            this.currentTrack.hasContentEncryption = true;
                        }
                    } else {
                        this.seekEntryId = -1;
                        this.seekEntryPosition = -1L;
                    }
                } else {
                    this.seenClusterPositionForCurrentCuePoint = false;
                }
            } else {
                this.currentTrack = new Track();
            }
        } else {
            this.sampleSeenReferenceBlock = false;
        }
    }

    final void stringElement(int n2, String string2) throws ParserException {
        if (n2 != 134) {
            if (n2 != 17026) {
                if (n2 == 2274716) {
                    Track.access$202(this.currentTrack, string2);
                }
            } else if (!DOC_TYPE_WEBM.equals(string2) && !DOC_TYPE_MATROSKA.equals(string2)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("DocType ");
                stringBuilder.append(string2);
                stringBuilder.append(" not supported");
                throw new ParserException(stringBuilder.toString());
            }
        } else {
            this.currentTrack.codecId = string2;
        }
    }

    public static @interface Flags {
    }

    private final class InnerEbmlReaderOutput
    implements EbmlReaderOutput {
        private InnerEbmlReaderOutput() {
        }

        @Override
        public final void binaryElement(int n2, int n3, ExtractorInput extractorInput) throws IOException, InterruptedException {
            MatroskaExtractor.this.binaryElement(n2, n3, extractorInput);
        }

        @Override
        public final void endMasterElement(int n2) throws ParserException {
            MatroskaExtractor.this.endMasterElement(n2);
        }

        @Override
        public final void floatElement(int n2, double d2) throws ParserException {
            MatroskaExtractor.this.floatElement(n2, d2);
        }

        @Override
        public final int getElementType(int n2) {
            switch (n2) {
                default: {
                    return 0;
                }
                case 181: 
                case 17545: 
                case 21969: 
                case 21970: 
                case 21971: 
                case 21972: 
                case 21973: 
                case 21974: 
                case 21975: 
                case 21976: 
                case 21977: 
                case 21978: {
                    return 5;
                }
                case 161: 
                case 163: 
                case 16981: 
                case 18402: 
                case 21419: 
                case 25506: 
                case 30322: {
                    return 4;
                }
                case 160: 
                case 174: 
                case 183: 
                case 187: 
                case 224: 
                case 225: 
                case 18407: 
                case 19899: 
                case 20532: 
                case 20533: 
                case 21936: 
                case 21968: 
                case 25152: 
                case 28032: 
                case 30320: 
                case 290298740: 
                case 357149030: 
                case 374648427: 
                case 408125543: 
                case 440786851: 
                case 475249515: 
                case 524531317: {
                    return 1;
                }
                case 134: 
                case 17026: 
                case 2274716: {
                    return 3;
                }
                case 131: 
                case 136: 
                case 155: 
                case 159: 
                case 176: 
                case 179: 
                case 186: 
                case 215: 
                case 231: 
                case 241: 
                case 251: 
                case 16980: 
                case 17029: 
                case 17143: 
                case 18401: 
                case 18408: 
                case 20529: 
                case 20530: 
                case 21420: 
                case 21432: 
                case 21680: 
                case 21682: 
                case 21690: 
                case 21930: 
                case 21945: 
                case 21946: 
                case 21947: 
                case 21948: 
                case 21949: 
                case 22186: 
                case 22203: 
                case 25188: 
                case 2352003: 
                case 2807729: 
            }
            return 2;
        }

        @Override
        public final void integerElement(int n2, long l2) throws ParserException {
            MatroskaExtractor.this.integerElement(n2, l2);
        }

        @Override
        public final boolean isLevel1Element(int n2) {
            boolean bl = n2 == 357149030 || n2 == 524531317 || n2 == 475249515 || n2 == 374648427;
            return bl;
        }

        @Override
        public final void startMasterElement(int n2, long l2, long l3) throws ParserException {
            MatroskaExtractor.this.startMasterElement(n2, l2, l3);
        }

        @Override
        public final void stringElement(int n2, String string2) throws ParserException {
            MatroskaExtractor.this.stringElement(n2, string2);
        }
    }

    private static final class Track {
        private static final int DEFAULT_MAX_CLL = 1000;
        private static final int DEFAULT_MAX_FALL = 200;
        private static final int DISPLAY_UNIT_PIXELS = 0;
        private static final int MAX_CHROMATICITY = 50000;
        public int audioBitDepth = -1;
        public int channelCount = 1;
        public long codecDelayNs = 0L;
        public String codecId;
        public byte[] codecPrivate;
        public int colorRange = -1;
        public int colorSpace = -1;
        public int colorTransfer = -1;
        public TrackOutput.CryptoData cryptoData;
        public int defaultSampleDurationNs;
        public int displayHeight = -1;
        public int displayUnit = 0;
        public int displayWidth = -1;
        public DrmInitData drmInitData;
        public boolean flagDefault = true;
        public boolean flagForced;
        public boolean hasColorInfo = false;
        public boolean hasContentEncryption;
        public int height = -1;
        private String language = "eng";
        public int maxContentLuminance = 1000;
        public int maxFrameAverageLuminance = 200;
        public float maxMasteringLuminance = -1.0f;
        public float minMasteringLuminance = -1.0f;
        public int nalUnitLengthFieldLength;
        public int number;
        public TrackOutput output;
        public float primaryBChromaticityX = -1.0f;
        public float primaryBChromaticityY = -1.0f;
        public float primaryGChromaticityX = -1.0f;
        public float primaryGChromaticityY = -1.0f;
        public float primaryRChromaticityX = -1.0f;
        public float primaryRChromaticityY = -1.0f;
        public byte[] projectionData = null;
        public int sampleRate = 8000;
        public byte[] sampleStrippedBytes;
        public long seekPreRollNs = 0L;
        public int stereoMode = -1;
        public TrueHdSampleRechunker trueHdSampleRechunker;
        public int type;
        public float whitePointChromaticityX = -1.0f;
        public float whitePointChromaticityY = -1.0f;
        public int width = -1;

        private Track() {
        }

        static /* synthetic */ String access$202(Track track, String string2) {
            track.language = string2;
            return string2;
        }

        private byte[] getHdrStaticInfo() {
            if (this.primaryRChromaticityX != -1.0f && this.primaryRChromaticityY != -1.0f && this.primaryGChromaticityX != -1.0f && this.primaryGChromaticityY != -1.0f && this.primaryBChromaticityX != -1.0f && this.primaryBChromaticityY != -1.0f && this.whitePointChromaticityX != -1.0f && this.whitePointChromaticityY != -1.0f && this.maxMasteringLuminance != -1.0f && this.minMasteringLuminance != -1.0f) {
                byte[] byArray = new byte[25];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.put((byte)0);
                byteBuffer.putShort((short)(this.primaryRChromaticityX * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryRChromaticityY * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryGChromaticityX * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryGChromaticityY * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryBChromaticityX * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryBChromaticityY * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.whitePointChromaticityX * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.whitePointChromaticityY * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.maxMasteringLuminance + 0.5f));
                byteBuffer.putShort((short)(this.minMasteringLuminance + 0.5f));
                byteBuffer.putShort((short)this.maxContentLuminance);
                byteBuffer.putShort((short)this.maxFrameAverageLuminance);
                return byArray;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static Pair<String, List<byte[]>> parseFourCcPrivate(ParsableByteArray var0) throws ParserException {
            block9: {
                var0 /* !! */ .skipBytes(16);
                var1_3 = var0 /* !! */ .readLittleEndianUnsignedInt();
                if (var1_3 != 1482049860L) break block9;
                try {
                    return new Pair((Object)"video/3gpp", null);
                }
                catch (ArrayIndexOutOfBoundsException var0_1) {
                    var0_2 = new ParserException("Error parsing FourCC private data");
                    throw var0_2;
                }
            }
            if (var1_3 == 826496599L) {
                var3_4 = var0 /* !! */ .getPosition() + 20;
                var0 /* !! */  = (ParsableByteArray)var0 /* !! */ .data;
                ** while (var3_4 < ((ParsableByteArray)var0 /* !! */ ).length - 4)
lbl-1000:
                // 1 sources

                {
                    if (var0 /* !! */ [var3_4] == false && var0 /* !! */ [var3_4 + 1] == false && var0 /* !! */ [var3_4 + 2] == true && var0 /* !! */ [var3_4 + 3] == 15) {
                        return new Pair((Object)"video/wvc1", Collections.singletonList(Arrays.copyOfRange((byte[])var0 /* !! */ , var3_4, ((ParsableByteArray)var0 /* !! */ ).length)));
                    }
                    ++var3_4;
                    continue;
                }
lbl19:
                // 2 sources

                var0 /* !! */  = new ParserException("Failed to find FourCC VC1 initialization data");
                throw var0 /* !! */ ;
            }
            Log.w((String)"MatroskaExtractor", (String)"Unknown FourCC. Setting mimeType to video/x-unknown");
            return new Pair((Object)"video/x-unknown", null);
        }

        private static boolean parseMsAcmCodecPrivate(ParsableByteArray parsableByteArray) throws ParserException {
            block5: {
                long l2;
                long l3;
                boolean bl;
                try {
                    int n2 = parsableByteArray.readLittleEndianUnsignedShort();
                    bl = true;
                    if (n2 == 1) {
                        return true;
                    }
                    if (n2 != 65534) break block5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ParserException("Error parsing MS/ACM codec private");
                }
                parsableByteArray.setPosition(24);
                if (parsableByteArray.readLong() != WAVE_SUBFORMAT_PCM.getMostSignificantBits() || (l3 = parsableByteArray.readLong()) != (l2 = WAVE_SUBFORMAT_PCM.getLeastSignificantBits())) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        private static List<byte[]> parseVorbisCodecPrivate(byte[] var0) throws ParserException {
            if (var0[0] != 2) ** GOTO lbl48
            var1_3 = 1;
            var2_4 = 0;
            while (var0[var1_3] == -1) {
                var2_4 += 255;
                ++var1_3;
            }
            var3_5 = var1_3 + 1;
            var4_6 = var2_4 + var0[var1_3];
            var1_3 = 0;
            var2_4 = var3_5;
            while (var0[var2_4] == -1) {
                var1_3 += 255;
                ++var2_4;
            }
            var3_5 = var2_4 + 1;
            var2_4 = var0[var2_4];
            if (var0[var3_5] != 1) ** GOTO lbl45
            try {
                var5_7 = new byte[var4_6];
                System.arraycopy(var0, var3_5, var5_7, 0, var4_6);
            }
            catch (ArrayIndexOutOfBoundsException var0_1) {
                var0_2 = new ParserException("Error parsing vorbis codec private");
                throw var0_2;
            }
            if (var0[var3_5 += var4_6] != 3) ** GOTO lbl42
            if (var0[var1_3 = var3_5 + (var1_3 + var2_4)] == 5) {
                var6_8 = new byte[((byte[])var0).length - var1_3];
                System.arraycopy(var0, var1_3, var6_8, 0, ((byte[])var0).length - var1_3);
                var0 = new ArrayList;
                var0(2);
                var0.add(var5_7);
                var0.add(var6_8);
                return var0;
            }
            var0 = new ParserException;
            var0("Error parsing vorbis codec private");
            throw var0;
lbl42:
            // 1 sources

            var0 = new ParserException;
            var0("Error parsing vorbis codec private");
            throw var0;
lbl45:
            // 1 sources

            var0 = new ParserException;
            var0("Error parsing vorbis codec private");
            throw var0;
lbl48:
            // 1 sources

            var0 = new ParserException;
            var0("Error parsing vorbis codec private");
            throw var0;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public final void initializeOutput(ExtractorOutput var1_1, int var2_2) throws ParserException {
            block78: {
                block82: {
                    block81: {
                        block80: {
                            block79: {
                                var3_3 = this.codecId;
                                var4_4 = var3_3.hashCode();
                                var5_5 = 0;
                                var6_6 = 3;
                                switch (var4_4) {
                                    default: {
                                        break;
                                    }
                                    case 1951062397: {
                                        if (!var3_3.equals("A_OPUS")) break;
                                        var4_4 = 11;
                                        break block79;
                                    }
                                    case 1950789798: {
                                        if (!var3_3.equals("A_FLAC")) break;
                                        var4_4 = 21;
                                        break block79;
                                    }
                                    case 1950749482: {
                                        if (!var3_3.equals("A_EAC3")) break;
                                        var4_4 = 16;
                                        break block79;
                                    }
                                    case 1809237540: {
                                        if (!var3_3.equals("V_MPEG2")) break;
                                        var4_4 = 2;
                                        break block79;
                                    }
                                    case 1422270023: {
                                        if (!var3_3.equals("S_TEXT/UTF8")) break;
                                        var4_4 = 24;
                                        break block79;
                                    }
                                    case 855502857: {
                                        if (!var3_3.equals("V_MPEGH/ISO/HEVC")) break;
                                        var4_4 = 7;
                                        break block79;
                                    }
                                    case 738597099: {
                                        if (!var3_3.equals("S_TEXT/ASS")) break;
                                        var4_4 = 25;
                                        break block79;
                                    }
                                    case 725957860: {
                                        if (!var3_3.equals("A_PCM/INT/LIT")) break;
                                        var4_4 = 23;
                                        break block79;
                                    }
                                    case 542569478: {
                                        if (!var3_3.equals("A_DTS/EXPRESS")) break;
                                        var4_4 = 19;
                                        break block79;
                                    }
                                    case 444813526: {
                                        if (!var3_3.equals("V_THEORA")) break;
                                        var4_4 = 9;
                                        break block79;
                                    }
                                    case 99146302: {
                                        if (!var3_3.equals("S_HDMV/PGS")) break;
                                        var4_4 = 27;
                                        break block79;
                                    }
                                    case 82338134: {
                                        if (!var3_3.equals("V_VP9")) break;
                                        var4_4 = 1;
                                        break block79;
                                    }
                                    case 82338133: {
                                        if (!var3_3.equals("V_VP8")) break;
                                        var4_4 = 0;
                                        break block79;
                                    }
                                    case 62927045: {
                                        if (!var3_3.equals("A_DTS")) break;
                                        var4_4 = 18;
                                        break block79;
                                    }
                                    case 62923603: {
                                        if (!var3_3.equals("A_AC3")) break;
                                        var4_4 = 15;
                                        break block79;
                                    }
                                    case 62923557: {
                                        if (!var3_3.equals("A_AAC")) break;
                                        var4_4 = 12;
                                        break block79;
                                    }
                                    case -356037306: {
                                        if (!var3_3.equals("A_DTS/LOSSLESS")) break;
                                        var4_4 = 20;
                                        break block79;
                                    }
                                    case -425012669: {
                                        if (!var3_3.equals("S_VOBSUB")) break;
                                        var4_4 = 26;
                                        break block79;
                                    }
                                    case -538363109: {
                                        if (!var3_3.equals("V_MPEG4/ISO/AVC")) break;
                                        var4_4 = 6;
                                        break block79;
                                    }
                                    case -538363189: {
                                        if (!var3_3.equals("V_MPEG4/ISO/ASP")) break;
                                        var4_4 = 4;
                                        break block79;
                                    }
                                    case -933872740: {
                                        if (!var3_3.equals("S_DVBSUB")) break;
                                        var4_4 = 28;
                                        break block79;
                                    }
                                    case -1373388978: {
                                        if (!var3_3.equals("V_MS/VFW/FOURCC")) break;
                                        var4_4 = 8;
                                        break block79;
                                    }
                                    case -1482641357: {
                                        if (!var3_3.equals("A_MPEG/L3")) break;
                                        var4_4 = 14;
                                        break block79;
                                    }
                                    case -1482641358: {
                                        if (!var3_3.equals("A_MPEG/L2")) break;
                                        var4_4 = 13;
                                        break block79;
                                    }
                                    case -1730367663: {
                                        if (!var3_3.equals("A_VORBIS")) break;
                                        var4_4 = 10;
                                        break block79;
                                    }
                                    case -1784763192: {
                                        if (!var3_3.equals("A_TRUEHD")) break;
                                        var4_4 = 17;
                                        break block79;
                                    }
                                    case -1985379776: {
                                        if (!var3_3.equals("A_MS/ACM")) break;
                                        var4_4 = 22;
                                        break block79;
                                    }
                                    case -2095575984: {
                                        if (!var3_3.equals("V_MPEG4/ISO/SP")) break;
                                        var4_4 = 3;
                                        break block79;
                                    }
                                    case -2095576542: {
                                        if (!var3_3.equals("V_MPEG4/ISO/AP")) break;
                                        var4_4 = 5;
                                        break block79;
                                    }
                                }
                                var4_4 = -1;
                            }
                            switch (var4_4) {
                                default: {
                                    throw new ParserException("Unrecognized codec identifier.");
                                }
                                case 28: {
                                    var3_3 = this.codecPrivate;
                                    var3_3 = Collections.singletonList(new byte[]{(byte)var3_3[0], (byte)var3_3[1], (byte)var3_3[2], (byte)var3_3[3]});
                                    var7_7 = "application/dvbsubs";
                                    ** GOTO lbl248
                                }
                                case 27: {
                                    var3_3 = "application/pgs";
                                    break block80;
                                }
                                case 26: {
                                    var7_7 = Collections.singletonList(this.codecPrivate);
                                    var3_3 = "application/vobsub";
                                    break block81;
                                }
                                case 25: {
                                    var3_3 = "text/x-ssa";
                                    break block80;
                                }
                                case 24: {
                                    var3_3 = "application/x-subrip";
                                    break block80;
                                }
                                case 23: {
                                    var4_4 = var8_8 = Util.getPcmEncoding((int)this.audioBitDepth);
                                    if (var8_8 != 0) ** GOTO lbl162
                                    var3_3 = new StringBuilder();
                                    var3_3.append("Unsupported PCM bit depth: ");
                                    var3_3.append(this.audioBitDepth);
                                    var3_3.append(". Setting mimeType to ");
                                    var3_3.append("audio/x-unknown");
                                    Log.w((String)"MatroskaExtractor", (String)var3_3.toString());
                                    ** GOTO lbl191
lbl162:
                                    // 2 sources

                                    while (true) {
                                        var8_8 = var4_4;
                                        var3_3 = "audio/raw";
                                        var7_7 = null;
                                        var4_4 = -1;
                                        break block78;
                                        break;
                                    }
                                }
                                case 22: {
                                    if (Track.parseMsAcmCodecPrivate(new ParsableByteArray(this.codecPrivate))) {
                                        var4_4 = var8_8 = Util.getPcmEncoding((int)this.audioBitDepth);
                                        if (var8_8 != 0) ** continue;
                                        var3_3 = new StringBuilder();
                                        var3_3.append("Unsupported PCM bit depth: ");
                                        var3_3.append(this.audioBitDepth);
                                        var3_3.append(". Setting mimeType to ");
                                        var3_3.append("audio/x-unknown");
                                        Log.w((String)"MatroskaExtractor", (String)var3_3.toString());
                                    } else {
                                        var3_3 = new StringBuilder();
                                        var3_3.append("Non-PCM MS/ACM is unsupported. Setting mimeType to ");
                                        var3_3.append("audio/x-unknown");
                                        Log.w((String)"MatroskaExtractor", (String)var3_3.toString());
                                    }
lbl191:
                                    // 3 sources

                                    var3_3 = "audio/x-unknown";
                                    break block80;
                                }
                                case 21: {
                                    var3_3 = Collections.singletonList(this.codecPrivate);
                                    var7_7 = "audio/flac";
                                    ** GOTO lbl248
                                }
                                case 20: {
                                    var3_3 = "audio/vnd.dts.hd";
                                    break block80;
                                }
                                case 18: 
                                case 19: {
                                    var3_3 = "audio/vnd.dts";
                                    break block80;
                                }
                                case 17: {
                                    this.trueHdSampleRechunker = new TrueHdSampleRechunker();
                                    var3_3 = "audio/true-hd";
                                    break block80;
                                }
                                case 16: {
                                    var3_3 = "audio/eac3";
                                    break block80;
                                }
                                case 15: {
                                    var3_3 = "audio/ac3";
                                    break block80;
                                }
                                case 14: {
                                    var3_3 = "audio/mpeg";
                                    ** GOTO lbl218
                                }
                                case 13: {
                                    var3_3 = "audio/mpeg-L2";
lbl218:
                                    // 2 sources

                                    var7_7 = null;
                                    var4_4 = 4096;
                                    break block82;
                                }
                                case 12: {
                                    var3_3 = Collections.singletonList(this.codecPrivate);
                                    var7_7 = "audio/mp4a-latm";
                                    ** GOTO lbl248
                                }
                                case 11: {
                                    var7_7 = new ArrayList<byte[]>(3);
                                    var7_7.add(this.codecPrivate);
                                    var7_7.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.codecDelayNs).array());
                                    var7_7.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.seekPreRollNs).array());
                                    var3_3 = "audio/opus";
                                    var4_4 = 5760;
                                    break block82;
                                }
                                case 10: {
                                    var7_7 = Track.parseVorbisCodecPrivate(this.codecPrivate);
                                    var3_3 = "audio/vorbis";
                                    var4_4 = 8192;
                                    break block82;
                                }
                                case 9: {
                                    var3_3 = "video/x-unknown";
                                    break block80;
                                }
                                case 8: {
                                    var3_3 = Track.parseFourCcPrivate(new ParsableByteArray(this.codecPrivate));
                                    var7_7 = (String)var3_3.first;
                                    var3_3 = (List)var3_3.second;
lbl248:
                                    // 5 sources

                                    while (true) {
                                        var4_4 = -1;
                                        var8_8 = -1;
                                        var9_9 /* !! */  = var3_3;
                                        var3_3 = var7_7;
                                        var7_7 = var9_9 /* !! */ ;
                                        break block78;
                                        break;
                                    }
                                }
                                case 7: {
                                    var3_3 = HevcConfig.parse((ParsableByteArray)new ParsableByteArray(this.codecPrivate));
                                    var7_7 = var3_3.initializationData;
                                    this.nalUnitLengthFieldLength = var3_3.nalUnitLengthFieldLength;
                                    var3_3 = "video/hevc";
                                    break block81;
                                }
                                case 6: {
                                    var3_3 = AvcConfig.parse(new ParsableByteArray(this.codecPrivate));
                                    var7_7 = var3_3.initializationData;
                                    this.nalUnitLengthFieldLength = var3_3.nalUnitLengthFieldLength;
                                    var3_3 = "video/avc";
                                    break block81;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    var3_3 = this.codecPrivate;
                                    var3_3 = var3_3 == null ? null : Collections.singletonList(var3_3);
                                    var7_7 = "video/mp4v-es";
                                    ** continue;
                                }
                                case 2: {
                                    var3_3 = "video/mpeg2";
                                    break block80;
                                }
                                case 1: {
                                    var3_3 = "video/x-vnd.on2.vp9";
                                    break block80;
                                }
                                case 0: 
                            }
                            var3_3 = "video/x-vnd.on2.vp8";
                        }
                        var7_7 = null;
                    }
                    var4_4 = -1;
                }
                var8_8 = -1;
            }
            var10_10 = this.flagDefault;
            if (this.flagForced) {
                var5_5 = 2;
            }
            var5_5 |= var10_10 | 0;
            if (MimeTypes.isAudio((String)var3_3)) {
                var3_3 = Format.createAudioSampleFormat((String)Integer.toString(var2_2), (String)var3_3, null, (int)-1, (int)var4_4, (int)this.channelCount, (int)this.sampleRate, (int)var8_8, var7_7, (DrmInitData)this.drmInitData, (int)var5_5, (String)this.language);
                var2_2 = 1;
            } else if (MimeTypes.isVideo((String)var3_3)) {
                if (this.displayUnit == 0) {
                    var8_8 = var5_5 = this.displayWidth;
                    if (var5_5 == -1) {
                        var8_8 = this.width;
                    }
                    this.displayWidth = var8_8;
                    var8_8 = var5_5 = this.displayHeight;
                    if (var5_5 == -1) {
                        var8_8 = this.height;
                    }
                    this.displayHeight = var8_8;
                }
                var11_11 = (var5_5 = this.displayWidth) != -1 && (var8_8 = this.displayHeight) != -1 ? (float)(this.height * var5_5) / (float)(this.width * var8_8) : -1.0f;
                if (this.hasColorInfo) {
                    var9_9 /* !! */  = (HevcConfig)this.getHdrStaticInfo();
                    var9_9 /* !! */  = new ColorInfo(this.colorSpace, this.colorRange, this.colorTransfer, (byte[])var9_9 /* !! */ );
                } else {
                    var9_9 /* !! */  = null;
                }
                var3_3 = Format.createVideoSampleFormat((String)Integer.toString(var2_2), (String)var3_3, null, (int)-1, (int)var4_4, (int)this.width, (int)this.height, (float)-1.0f, var7_7, (int)-1, (float)var11_11, (byte[])this.projectionData, (int)this.stereoMode, (ColorInfo)var9_9 /* !! */ , (DrmInitData)this.drmInitData);
                var2_2 = 2;
            } else if ("application/x-subrip".equals(var3_3)) {
                var3_3 = Format.createTextSampleFormat((String)Integer.toString(var2_2), (String)var3_3, (int)var5_5, (String)this.language, (DrmInitData)this.drmInitData);
                var2_2 = var6_6;
            } else if ("text/x-ssa".equals(var3_3)) {
                var7_7 = new ArrayList<byte[]>(2);
                var7_7.add(MatroskaExtractor.access$300());
                var7_7.add(this.codecPrivate);
                var3_3 = Format.createTextSampleFormat((String)Integer.toString(var2_2), (String)var3_3, null, (int)-1, (int)var5_5, (String)this.language, (int)-1, (DrmInitData)this.drmInitData, (long)0x7FFFFFFFFFFFFFFFL, var7_7);
                var2_2 = var6_6;
            } else {
                if (!("application/vobsub".equals(var3_3) || "application/pgs".equals(var3_3) || "application/dvbsubs".equals(var3_3))) {
                    throw new ParserException("Unexpected MIME type.");
                }
                var3_3 = Format.createImageSampleFormat((String)Integer.toString(var2_2), (String)var3_3, null, (int)-1, (int)var5_5, var7_7, (String)this.language, (DrmInitData)this.drmInitData);
                var2_2 = var6_6;
            }
            this.output = var1_1.track(this.number, var2_2);
            this.output.format((Format)var3_3);
        }

        public final void outputPendingSampleMetadata() {
            TrueHdSampleRechunker trueHdSampleRechunker = this.trueHdSampleRechunker;
            if (trueHdSampleRechunker != null) {
                trueHdSampleRechunker.outputPendingSampleMetadata(this);
            }
        }

        public final void reset() {
            TrueHdSampleRechunker trueHdSampleRechunker = this.trueHdSampleRechunker;
            if (trueHdSampleRechunker != null) {
                trueHdSampleRechunker.reset();
            }
        }
    }

    private static final class TrueHdSampleRechunker {
        private int blockFlags;
        private int chunkSize;
        private boolean foundSyncframe;
        private int sampleCount;
        private final byte[] syncframePrefix = new byte[10];
        private long timeUs;

        public final void outputPendingSampleMetadata(Track track) {
            if (this.foundSyncframe && this.sampleCount > 0) {
                track.output.sampleMetadata(this.timeUs, this.blockFlags, this.chunkSize, 0, track.cryptoData);
                this.sampleCount = 0;
            }
        }

        public final void reset() {
            this.foundSyncframe = false;
        }

        public final void sampleMetadata(Track track, long l2) {
            if (!this.foundSyncframe) {
                return;
            }
            int n2 = this.sampleCount;
            this.sampleCount = n2 + 1;
            if (n2 == 0) {
                this.timeUs = l2;
            }
            if (this.sampleCount < 16) {
                return;
            }
            track.output.sampleMetadata(this.timeUs, this.blockFlags, this.chunkSize, 0, track.cryptoData);
            this.sampleCount = 0;
        }

        public final void startSample(ExtractorInput extractorInput, int n2, int n3) throws IOException, InterruptedException {
            if (!this.foundSyncframe) {
                extractorInput.peekFully(this.syncframePrefix, 0, 10);
                extractorInput.resetPeekPosition();
                if (Ac3Util.parseTrueHdSyncframeAudioSampleCount(this.syncframePrefix) == -1) {
                    return;
                }
                this.foundSyncframe = true;
                this.sampleCount = 0;
            }
            if (this.sampleCount == 0) {
                this.blockFlags = n2;
                this.chunkSize = 0;
            }
            this.chunkSize += n3;
        }
    }
}

