/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv;

import com.mbridge.msdk.playercommon.exoplayer2.ParserException;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorInput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv.EbmlReader;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv.EbmlReaderOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mkv.VarintReader;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayDeque;

final class DefaultEbmlReader
implements EbmlReader {
    private static final int ELEMENT_STATE_READ_CONTENT = 2;
    private static final int ELEMENT_STATE_READ_CONTENT_SIZE = 1;
    private static final int ELEMENT_STATE_READ_ID = 0;
    private static final int MAX_ID_BYTES = 4;
    private static final int MAX_INTEGER_ELEMENT_SIZE_BYTES = 8;
    private static final int MAX_LENGTH_BYTES = 8;
    private static final int VALID_FLOAT32_ELEMENT_SIZE_BYTES = 4;
    private static final int VALID_FLOAT64_ELEMENT_SIZE_BYTES = 8;
    private long elementContentSize;
    private int elementId;
    private int elementState;
    private final ArrayDeque<MasterElement> masterElementsStack;
    private EbmlReaderOutput output;
    private final byte[] scratch = new byte[8];
    private final VarintReader varintReader;

    public DefaultEbmlReader() {
        this.masterElementsStack = new ArrayDeque();
        this.varintReader = new VarintReader();
    }

    private long maybeResyncToNextLevel1Element(ExtractorInput extractorInput) throws IOException, InterruptedException {
        extractorInput.resetPeekPosition();
        while (true) {
            int n2;
            extractorInput.peekFully(this.scratch, 0, 4);
            int n3 = VarintReader.parseUnsignedVarintLength((int)this.scratch[0]);
            if (n3 != -1 && n3 <= 4 && this.output.isLevel1Element(n2 = (int)VarintReader.assembleVarint((byte[])this.scratch, (int)n3, (boolean)false))) {
                extractorInput.skipFully(n3);
                return n2;
            }
            extractorInput.skipFully(1);
        }
    }

    private double readFloat(ExtractorInput extractorInput, int n2) throws IOException, InterruptedException {
        long l2 = this.readInteger(extractorInput, n2);
        double d2 = n2 == 4 ? (double)Float.intBitsToFloat((int)l2) : Double.longBitsToDouble(l2);
        return d2;
    }

    private long readInteger(ExtractorInput extractorInput, int n2) throws IOException, InterruptedException {
        byte[] byArray = this.scratch;
        extractorInput.readFully(byArray, 0, n2);
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = l2 << 8 | (long)(this.scratch[i2] & 0xFF);
        }
        return l2;
    }

    private String readString(ExtractorInput extractorInput, int n2) throws IOException, InterruptedException {
        if (n2 == 0) {
            return "";
        }
        byte[] byArray = new byte[n2];
        extractorInput.readFully(byArray, 0, n2);
        while (n2 > 0 && byArray[n2 - 1] == 0) {
            --n2;
        }
        return new String(byArray, 0, n2);
    }

    public final void init(EbmlReaderOutput ebmlReaderOutput) {
        this.output = ebmlReaderOutput;
    }

    public final boolean read(ExtractorInput object) throws IOException, InterruptedException {
        boolean bl = this.output != null;
        Assertions.checkState(bl);
        while (true) {
            int n2;
            long l2;
            long l3;
            if (!this.masterElementsStack.isEmpty() && object.getPosition() >= this.masterElementsStack.peek().elementEndPosition) {
                this.output.endMasterElement(this.masterElementsStack.pop().elementId);
                return true;
            }
            if (this.elementState == 0) {
                l2 = l3 = this.varintReader.readUnsignedVarint((ExtractorInput)object, true, false, 4);
                if (l3 == -2L) {
                    l2 = this.maybeResyncToNextLevel1Element((ExtractorInput)object);
                }
                if (l2 == -1L) {
                    return false;
                }
                this.elementId = (int)l2;
                this.elementState = 1;
            }
            if (this.elementState == 1) {
                this.elementContentSize = this.varintReader.readUnsignedVarint((ExtractorInput)object, false, true, 8);
                this.elementState = 2;
            }
            if ((n2 = this.output.getElementType(this.elementId)) != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 != 3) {
                            if (n2 != 4) {
                                if (n2 == 5) {
                                    l2 = this.elementContentSize;
                                    if (l2 != 4L && l2 != 8L) {
                                        object = new StringBuilder();
                                        ((StringBuilder)object).append("Invalid float size: ");
                                        ((StringBuilder)object).append(this.elementContentSize);
                                        throw new ParserException(((StringBuilder)object).toString());
                                    }
                                    this.output.floatElement(this.elementId, this.readFloat((ExtractorInput)object, (int)this.elementContentSize));
                                    this.elementState = 0;
                                    return true;
                                }
                                object = new StringBuilder();
                                ((StringBuilder)object).append("Invalid element type ");
                                ((StringBuilder)object).append(n2);
                                throw new ParserException(((StringBuilder)object).toString());
                            }
                            this.output.binaryElement(this.elementId, (int)this.elementContentSize, (ExtractorInput)object);
                            this.elementState = 0;
                            return true;
                        }
                        l2 = this.elementContentSize;
                        if (l2 <= Integer.MAX_VALUE) {
                            this.output.stringElement(this.elementId, this.readString((ExtractorInput)object, (int)l2));
                            this.elementState = 0;
                            return true;
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("String element size: ");
                        ((StringBuilder)object).append(this.elementContentSize);
                        throw new ParserException(((StringBuilder)object).toString());
                    }
                    l2 = this.elementContentSize;
                    if (l2 <= 8L) {
                        this.output.integerElement(this.elementId, this.readInteger((ExtractorInput)object, (int)l2));
                        this.elementState = 0;
                        return true;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Invalid integer size: ");
                    ((StringBuilder)object).append(this.elementContentSize);
                    throw new ParserException(((StringBuilder)object).toString());
                }
                l3 = object.getPosition();
                l2 = this.elementContentSize;
                this.masterElementsStack.push(new MasterElement(this.elementId, l2 + l3));
                this.output.startMasterElement(this.elementId, l3, this.elementContentSize);
                this.elementState = 0;
                return true;
            }
            object.skipFully((int)this.elementContentSize);
            this.elementState = 0;
        }
    }

    public final void reset() {
        this.elementState = 0;
        this.masterElementsStack.clear();
        this.varintReader.reset();
    }

    private static @interface ElementState {
    }

    private static final class MasterElement {
        private final long elementEndPosition;
        private final int elementId;

        private MasterElement(int n2, long l2) {
            this.elementId = n2;
            this.elementEndPosition = l2;
        }
    }
}

