/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.extractor.flv;

import com.mbridge.msdk.playercommon.exoplayer2.ParserException;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.flv.TagPayloadReader;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

final class ScriptTagPayloadReader
extends TagPayloadReader {
    private static final int AMF_TYPE_BOOLEAN = 1;
    private static final int AMF_TYPE_DATE = 11;
    private static final int AMF_TYPE_ECMA_ARRAY = 8;
    private static final int AMF_TYPE_END_MARKER = 9;
    private static final int AMF_TYPE_NUMBER = 0;
    private static final int AMF_TYPE_OBJECT = 3;
    private static final int AMF_TYPE_STRICT_ARRAY = 10;
    private static final int AMF_TYPE_STRING = 2;
    private static final String KEY_DURATION = "duration";
    private static final String NAME_METADATA = "onMetaData";
    private long durationUs = -9223372036854775807L;

    public ScriptTagPayloadReader() {
        super(null);
    }

    private static Boolean readAmfBoolean(ParsableByteArray parsableByteArray) {
        int n2 = parsableByteArray.readUnsignedByte();
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    private static Object readAmfData(ParsableByteArray parsableByteArray, int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 8) {
                            if (n2 != 10) {
                                if (n2 != 11) {
                                    return null;
                                }
                                return ScriptTagPayloadReader.readAmfDate(parsableByteArray);
                            }
                            return ScriptTagPayloadReader.readAmfStrictArray(parsableByteArray);
                        }
                        return ScriptTagPayloadReader.readAmfEcmaArray(parsableByteArray);
                    }
                    return ScriptTagPayloadReader.readAmfObject(parsableByteArray);
                }
                return ScriptTagPayloadReader.readAmfString(parsableByteArray);
            }
            return ScriptTagPayloadReader.readAmfBoolean(parsableByteArray);
        }
        return ScriptTagPayloadReader.readAmfDouble(parsableByteArray);
    }

    private static Date readAmfDate(ParsableByteArray parsableByteArray) {
        Date date = new Date((long)ScriptTagPayloadReader.readAmfDouble(parsableByteArray).doubleValue());
        parsableByteArray.skipBytes(2);
        return date;
    }

    private static Double readAmfDouble(ParsableByteArray parsableByteArray) {
        return Double.longBitsToDouble(parsableByteArray.readLong());
    }

    private static HashMap<String, Object> readAmfEcmaArray(ParsableByteArray parsableByteArray) {
        int n2 = parsableByteArray.readUnsignedIntToInt();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            hashMap.put(ScriptTagPayloadReader.readAmfString(parsableByteArray), ScriptTagPayloadReader.readAmfData(parsableByteArray, ScriptTagPayloadReader.readAmfType(parsableByteArray)));
        }
        return hashMap;
    }

    private static HashMap<String, Object> readAmfObject(ParsableByteArray parsableByteArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (true) {
            String string2 = ScriptTagPayloadReader.readAmfString(parsableByteArray);
            int n2 = ScriptTagPayloadReader.readAmfType(parsableByteArray);
            if (n2 == 9) {
                return hashMap;
            }
            hashMap.put(string2, ScriptTagPayloadReader.readAmfData(parsableByteArray, n2));
        }
    }

    private static ArrayList<Object> readAmfStrictArray(ParsableByteArray parsableByteArray) {
        int n2 = parsableByteArray.readUnsignedIntToInt();
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(ScriptTagPayloadReader.readAmfData(parsableByteArray, ScriptTagPayloadReader.readAmfType(parsableByteArray)));
        }
        return arrayList;
    }

    private static String readAmfString(ParsableByteArray parsableByteArray) {
        int n2 = parsableByteArray.readUnsignedShort();
        int n3 = parsableByteArray.getPosition();
        parsableByteArray.skipBytes(n2);
        return new String(parsableByteArray.data, n3, n2);
    }

    private static int readAmfType(ParsableByteArray parsableByteArray) {
        return parsableByteArray.readUnsignedByte();
    }

    public final long getDurationUs() {
        return this.durationUs;
    }

    protected final boolean parseHeader(ParsableByteArray parsableByteArray) {
        return true;
    }

    protected final void parsePayload(ParsableByteArray object, long l2) throws ParserException {
        if (ScriptTagPayloadReader.readAmfType((ParsableByteArray)object) == 2) {
            double d2;
            if (!NAME_METADATA.equals(ScriptTagPayloadReader.readAmfString((ParsableByteArray)object))) {
                return;
            }
            if (ScriptTagPayloadReader.readAmfType((ParsableByteArray)object) != 8) {
                return;
            }
            if ((object = ScriptTagPayloadReader.readAmfEcmaArray((ParsableByteArray)object)).containsKey(KEY_DURATION) && (d2 = ((Double)object.get(KEY_DURATION)).doubleValue()) > 0.0) {
                this.durationUs = (long)(d2 * 1000000.0);
            }
            return;
        }
        throw new ParserException();
    }

    public final void seek() {
    }
}

