/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.extractor.amr;

import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.ParserException;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.Extractor;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorInput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorOutput;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.ExtractorsFactory;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.PositionHolder;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.SeekMap;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.TrackOutput;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;

public final class AmrExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = new ExtractorsFactory(){

        public final Extractor[] createExtractors() {
            return new Extractor[]{new AmrExtractor()};
        }
    };
    private static final int MAX_FRAME_SIZE_BYTES;
    private static final int SAMPLE_RATE_NB = 8000;
    private static final int SAMPLE_RATE_WB = 16000;
    private static final int SAMPLE_TIME_PER_FRAME_US = 20000;
    private static final byte[] amrSignatureNb;
    private static final byte[] amrSignatureWb;
    private static final int[] frameSizeBytesByTypeNb;
    private static final int[] frameSizeBytesByTypeWb;
    private int currentSampleBytesRemaining;
    private long currentSampleTimeUs;
    private int currentSampleTotalBytes;
    private boolean hasOutputFormat;
    private boolean isWideBand;
    private final byte[] scratch = new byte[1];
    private TrackOutput trackOutput;

    static {
        frameSizeBytesByTypeNb = new int[]{13, 14, 16, 18, 20, 21, 27, 32, 6, 7, 6, 6, 1, 1, 1, 1};
        frameSizeBytesByTypeWb = new int[]{18, 24, 33, 37, 41, 47, 51, 59, 61, 6, 1, 1, 1, 1, 1, 1};
        amrSignatureNb = Util.getUtf8Bytes((String)"#!AMR\n");
        amrSignatureWb = Util.getUtf8Bytes((String)"#!AMR-WB\n");
        MAX_FRAME_SIZE_BYTES = frameSizeBytesByTypeWb[8];
    }

    static byte[] amrSignatureNb() {
        byte[] byArray = amrSignatureNb;
        return Arrays.copyOf(byArray, byArray.length);
    }

    static byte[] amrSignatureWb() {
        byte[] byArray = amrSignatureWb;
        return Arrays.copyOf(byArray, byArray.length);
    }

    static int frameSizeBytesByTypeNb(int n2) {
        return frameSizeBytesByTypeNb[n2];
    }

    static int frameSizeBytesByTypeWb(int n2) {
        return frameSizeBytesByTypeWb[n2];
    }

    private int getFrameSizeInBytes(int n2) throws ParserException {
        if (!this.isValidFrameType(n2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Illegal AMR ");
            String string2 = this.isWideBand ? "WB" : "NB";
            stringBuilder.append(string2);
            stringBuilder.append(" frame type ");
            stringBuilder.append(n2);
            throw new ParserException(stringBuilder.toString());
        }
        n2 = this.isWideBand ? frameSizeBytesByTypeWb[n2] : frameSizeBytesByTypeNb[n2];
        return n2;
    }

    private boolean isNarrowBandValidFrameType(int n2) {
        boolean bl = !this.isWideBand && (n2 < 12 || n2 > 14);
        return bl;
    }

    private boolean isValidFrameType(int n2) {
        boolean bl = n2 >= 0 && n2 <= 15 && (this.isWideBandValidFrameType(n2) || this.isNarrowBandValidFrameType(n2));
        return bl;
    }

    private boolean isWideBandValidFrameType(int n2) {
        boolean bl = this.isWideBand && (n2 < 10 || n2 > 13);
        return bl;
    }

    private void maybeOutputFormat() {
        if (!this.hasOutputFormat) {
            this.hasOutputFormat = true;
            String string2 = this.isWideBand ? "audio/amr-wb" : "audio/3gpp";
            int n2 = this.isWideBand ? 16000 : 8000;
            this.trackOutput.format(Format.createAudioSampleFormat(null, (String)string2, null, (int)-1, (int)MAX_FRAME_SIZE_BYTES, (int)1, (int)n2, (int)-1, null, null, (int)0, null));
        }
    }

    private boolean peekAmrSignature(ExtractorInput extractorInput, byte[] byArray) throws IOException, InterruptedException {
        extractorInput.resetPeekPosition();
        byte[] byArray2 = new byte[byArray.length];
        extractorInput.peekFully(byArray2, 0, byArray.length);
        return Arrays.equals(byArray2, byArray);
    }

    private boolean readAmrHeader(ExtractorInput extractorInput) throws IOException, InterruptedException {
        if (this.peekAmrSignature(extractorInput, amrSignatureNb)) {
            this.isWideBand = false;
            extractorInput.skipFully(amrSignatureNb.length);
            return true;
        }
        if (this.peekAmrSignature(extractorInput, amrSignatureWb)) {
            this.isWideBand = true;
            extractorInput.skipFully(amrSignatureWb.length);
            return true;
        }
        return false;
    }

    private int readNextSampleSize(ExtractorInput object) throws IOException, InterruptedException {
        object.resetPeekPosition();
        object.peekFully(this.scratch, 0, 1);
        byte by2 = this.scratch[0];
        if ((by2 & 0x83) <= 0) {
            return this.getFrameSizeInBytes(by2 >> 3 & 0xF);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Invalid padding bits for frame header ");
        ((StringBuilder)object).append(by2);
        throw new ParserException(((StringBuilder)object).toString());
    }

    private int readSample(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n2;
        if (this.currentSampleBytesRemaining == 0) {
            try {
                this.currentSampleBytesRemaining = this.currentSampleTotalBytes = this.readNextSampleSize(extractorInput);
            }
            catch (EOFException eOFException) {
                return -1;
            }
        }
        if ((n2 = this.trackOutput.sampleData(extractorInput, this.currentSampleBytesRemaining, true)) == -1) {
            return -1;
        }
        this.currentSampleBytesRemaining -= n2;
        if (this.currentSampleBytesRemaining > 0) {
            return 0;
        }
        this.trackOutput.sampleMetadata(this.currentSampleTimeUs, 1, this.currentSampleTotalBytes, 0, null);
        this.currentSampleTimeUs += 20000L;
        return 0;
    }

    public final void init(ExtractorOutput extractorOutput) {
        extractorOutput.seekMap((SeekMap)new SeekMap.Unseekable(-9223372036854775807L));
        this.trackOutput = extractorOutput.track(0, 1);
        extractorOutput.endTracks();
    }

    public final int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        if (extractorInput.getPosition() == 0L && !this.readAmrHeader(extractorInput)) {
            throw new ParserException("Could not find AMR header.");
        }
        this.maybeOutputFormat();
        return this.readSample(extractorInput);
    }

    public final void release() {
    }

    public final void seek(long l2, long l3) {
        this.currentSampleTimeUs = 0L;
        this.currentSampleTotalBytes = 0;
        this.currentSampleBytesRemaining = 0;
    }

    public final boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return this.readAmrHeader(extractorInput);
    }
}

