/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.drm;

import android.os.Parcel;
import android.os.Parcelable;
import com.mbridge.msdk.playercommon.exoplayer2.C;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public final class DrmInitData
implements Parcelable,
Comparator<SchemeData> {
    public static final Parcelable.Creator<DrmInitData> CREATOR = new Parcelable.Creator<DrmInitData>(){

        public final DrmInitData createFromParcel(Parcel parcel) {
            return new DrmInitData(parcel);
        }

        public final DrmInitData[] newArray(int n2) {
            return new DrmInitData[n2];
        }
    };
    private int hashCode;
    public final int schemeDataCount;
    private final SchemeData[] schemeDatas;
    public final String schemeType;

    DrmInitData(Parcel parcel) {
        this.schemeType = parcel.readString();
        this.schemeDatas = (SchemeData[])parcel.createTypedArray(SchemeData.CREATOR);
        this.schemeDataCount = this.schemeDatas.length;
    }

    public DrmInitData(String string2, List<SchemeData> list) {
        this(string2, false, list.toArray(new SchemeData[list.size()]));
    }

    private DrmInitData(String schemeDataArray, boolean bl, SchemeData ... schemeDataArray2) {
        this.schemeType = schemeDataArray;
        schemeDataArray = schemeDataArray2;
        if (bl) {
            schemeDataArray = (SchemeData[])schemeDataArray2.clone();
        }
        Arrays.sort(schemeDataArray, this);
        this.schemeDatas = schemeDataArray;
        this.schemeDataCount = schemeDataArray.length;
    }

    public DrmInitData(String string2, SchemeData ... schemeDataArray) {
        this(string2, true, schemeDataArray);
    }

    public DrmInitData(List<SchemeData> list) {
        this(null, false, list.toArray(new SchemeData[list.size()]));
    }

    public DrmInitData(SchemeData ... schemeDataArray) {
        this((String)null, schemeDataArray);
    }

    private static boolean containsSchemeDataWithUuid(ArrayList<SchemeData> arrayList, int n2, UUID uUID) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!arrayList.get(i2).uuid.equals(uUID)) continue;
            return true;
        }
        return false;
    }

    public static DrmInitData createSessionCreationData(DrmInitData object, DrmInitData object2) {
        int n2;
        int n3;
        SchemeData[] schemeDataArray;
        Object object3;
        ArrayList<SchemeData> arrayList = new ArrayList<SchemeData>();
        int n4 = 0;
        Object var4_4 = null;
        if (object != null) {
            object3 = ((DrmInitData)object).schemeType;
            schemeDataArray = ((DrmInitData)object).schemeDatas;
            n3 = schemeDataArray.length;
            n2 = 0;
            while (true) {
                object = object3;
                if (n2 < n3) {
                    object = schemeDataArray[n2];
                    if (((SchemeData)object).hasData()) {
                        arrayList.add((SchemeData)object);
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            object = null;
        }
        schemeDataArray = object;
        if (object2 != null) {
            object3 = object;
            if (object == null) {
                object3 = ((DrmInitData)object2).schemeType;
            }
            int n5 = arrayList.size();
            object = ((DrmInitData)object2).schemeDatas;
            n3 = ((SchemeData[])object).length;
            n2 = n4;
            while (true) {
                schemeDataArray = object3;
                if (n2 >= n3) break;
                object2 = object[n2];
                if (((SchemeData)object2).hasData() && !DrmInitData.containsSchemeDataWithUuid(arrayList, n5, ((SchemeData)object2).uuid)) {
                    arrayList.add((SchemeData)object2);
                }
                ++n2;
            }
        }
        object = arrayList.isEmpty() ? var4_4 : new DrmInitData((String)schemeDataArray, arrayList);
        return object;
    }

    @Override
    public final int compare(SchemeData schemeData, SchemeData schemeData2) {
        int n2 = C.UUID_NIL.equals(schemeData.uuid) ? (C.UUID_NIL.equals(schemeData2.uuid) ? 0 : 1) : schemeData.uuid.compareTo(schemeData2.uuid);
        return n2;
    }

    public final DrmInitData copyWithSchemeType(String string2) {
        if (Util.areEqual((Object)this.schemeType, (Object)string2)) {
            return this;
        }
        return new DrmInitData(string2, false, this.schemeDatas);
    }

    public final int describeContents() {
        return 0;
    }

    @Override
    public final boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (DrmInitData)object;
            if (!Util.areEqual((Object)this.schemeType, (Object)((DrmInitData)object).schemeType) || !Arrays.equals(this.schemeDatas, ((DrmInitData)object).schemeDatas)) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public final SchemeData get(int n2) {
        return this.schemeDatas[n2];
    }

    public final SchemeData get(UUID uUID) {
        for (SchemeData schemeData : this.schemeDatas) {
            if (!schemeData.matches(uUID)) continue;
            return schemeData;
        }
        return null;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            String string2 = this.schemeType;
            int n2 = string2 == null ? 0 : string2.hashCode();
            this.hashCode = n2 * 31 + Arrays.hashCode(this.schemeDatas);
        }
        return this.hashCode;
    }

    public final void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.schemeType);
        parcel.writeTypedArray((Parcelable[])this.schemeDatas, 0);
    }

    public static final class SchemeData
    implements Parcelable {
        public static final Parcelable.Creator<SchemeData> CREATOR = new Parcelable.Creator<SchemeData>(){

            public final SchemeData createFromParcel(Parcel parcel) {
                return new SchemeData(parcel);
            }

            public final SchemeData[] newArray(int n2) {
                return new SchemeData[n2];
            }
        };
        public final byte[] data;
        private int hashCode;
        public final String licenseServerUrl;
        public final String mimeType;
        public final boolean requiresSecureDecryption;
        private final UUID uuid;

        SchemeData(Parcel parcel) {
            this.uuid = new UUID(parcel.readLong(), parcel.readLong());
            this.licenseServerUrl = parcel.readString();
            this.mimeType = parcel.readString();
            this.data = parcel.createByteArray();
            boolean bl = parcel.readByte() != 0;
            this.requiresSecureDecryption = bl;
        }

        public SchemeData(UUID uUID, String string2, String string3, byte[] byArray, boolean bl) {
            this.uuid = Assertions.checkNotNull(uUID);
            this.licenseServerUrl = string2;
            this.mimeType = Assertions.checkNotNull(string3);
            this.data = byArray;
            this.requiresSecureDecryption = bl;
        }

        public SchemeData(UUID uUID, String string2, byte[] byArray) {
            this(uUID, string2, byArray, false);
        }

        public SchemeData(UUID uUID, String string2, byte[] byArray, boolean bl) {
            this(uUID, null, string2, byArray, bl);
        }

        public final boolean canReplace(SchemeData schemeData) {
            boolean bl = this.hasData() && !schemeData.hasData() && this.matches(schemeData.uuid);
            return bl;
        }

        public final int describeContents() {
            return 0;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof SchemeData)) {
                return false;
            }
            boolean bl = true;
            if (object == this) {
                return true;
            }
            object = (SchemeData)object;
            if (!(Util.areEqual((Object)this.licenseServerUrl, (Object)((SchemeData)object).licenseServerUrl) && Util.areEqual((Object)this.mimeType, (Object)((SchemeData)object).mimeType) && Util.areEqual((Object)this.uuid, (Object)((SchemeData)object).uuid) && Arrays.equals(this.data, ((SchemeData)object).data))) {
                bl = false;
            }
            return bl;
        }

        public final boolean hasData() {
            boolean bl = this.data != null;
            return bl;
        }

        public final int hashCode() {
            if (this.hashCode == 0) {
                int n2 = this.uuid.hashCode();
                String string2 = this.licenseServerUrl;
                int n3 = string2 == null ? 0 : string2.hashCode();
                this.hashCode = ((n2 * 31 + n3) * 31 + this.mimeType.hashCode()) * 31 + Arrays.hashCode(this.data);
            }
            return this.hashCode;
        }

        public final boolean matches(UUID uUID) {
            boolean bl = C.UUID_NIL.equals(this.uuid) || uUID.equals(this.uuid);
            return bl;
        }

        public final void writeToParcel(Parcel parcel, int n2) {
            parcel.writeLong(this.uuid.getMostSignificantBits());
            parcel.writeLong(this.uuid.getLeastSignificantBits());
            parcel.writeString(this.licenseServerUrl);
            parcel.writeString(this.mimeType);
            parcel.writeByteArray(this.data);
            parcel.writeByte((byte)(this.requiresSecureDecryption ? 1 : 0));
        }
    }
}

