/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.drm;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.mbridge.msdk.playercommon.exoplayer2.C;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DefaultDrmSession;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DefaultDrmSessionEventListener;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmInitData;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmSession;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmSessionManager;
import com.mbridge.msdk.playercommon.exoplayer2.drm.ErrorStateDrmSession;
import com.mbridge.msdk.playercommon.exoplayer2.drm.ExoMediaCrypto;
import com.mbridge.msdk.playercommon.exoplayer2.drm.ExoMediaDrm;
import com.mbridge.msdk.playercommon.exoplayer2.drm.FrameworkMediaCrypto;
import com.mbridge.msdk.playercommon.exoplayer2.drm.FrameworkMediaDrm;
import com.mbridge.msdk.playercommon.exoplayer2.drm.MediaDrmCallback;
import com.mbridge.msdk.playercommon.exoplayer2.drm.UnsupportedDrmException;
import com.mbridge.msdk.playercommon.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class DefaultDrmSessionManager<T extends ExoMediaCrypto>
implements DefaultDrmSession.ProvisioningManager<T>,
DrmSessionManager<T> {
    public static final int INITIAL_DRM_REQUEST_RETRY_COUNT = 3;
    public static final int MODE_DOWNLOAD = 2;
    public static final int MODE_PLAYBACK = 0;
    public static final int MODE_QUERY = 1;
    public static final int MODE_RELEASE = 3;
    public static final String PLAYREADY_CUSTOM_DATA_KEY = "PRCustomData";
    private static final String TAG = "DefaultDrmSessionMgr";
    private final MediaDrmCallback callback;
    private final DefaultDrmSessionEventListener.EventDispatcher eventDispatcher;
    private final int initialDrmRequestRetryCount;
    private final ExoMediaDrm<T> mediaDrm;
    volatile MediaDrmHandler mediaDrmHandler;
    private int mode;
    private final boolean multiSession;
    private byte[] offlineLicenseKeySetId;
    private final HashMap<String, String> optionalKeyRequestParameters;
    private Looper playbackLooper;
    private final List<DefaultDrmSession<T>> provisioningSessions;
    private final List<DefaultDrmSession<T>> sessions;
    private final UUID uuid;

    public DefaultDrmSessionManager(UUID uUID, ExoMediaDrm<T> exoMediaDrm, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap) {
        this(uUID, exoMediaDrm, mediaDrmCallback, hashMap, false, 3);
    }

    public DefaultDrmSessionManager(UUID uUID, ExoMediaDrm<T> exoMediaDrm, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap, Handler handler, DefaultDrmSessionEventListener defaultDrmSessionEventListener) {
        this(uUID, exoMediaDrm, mediaDrmCallback, hashMap);
        if (handler != null && defaultDrmSessionEventListener != null) {
            this.addListener(handler, defaultDrmSessionEventListener);
        }
    }

    public DefaultDrmSessionManager(UUID uUID, ExoMediaDrm<T> exoMediaDrm, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap, Handler handler, DefaultDrmSessionEventListener defaultDrmSessionEventListener, boolean bl) {
        this(uUID, exoMediaDrm, mediaDrmCallback, hashMap, bl);
        if (handler != null && defaultDrmSessionEventListener != null) {
            this.addListener(handler, defaultDrmSessionEventListener);
        }
    }

    public DefaultDrmSessionManager(UUID uUID, ExoMediaDrm<T> exoMediaDrm, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap, Handler handler, DefaultDrmSessionEventListener defaultDrmSessionEventListener, boolean bl, int n2) {
        this(uUID, exoMediaDrm, mediaDrmCallback, hashMap, bl, n2);
        if (handler != null && defaultDrmSessionEventListener != null) {
            this.addListener(handler, defaultDrmSessionEventListener);
        }
    }

    public DefaultDrmSessionManager(UUID uUID, ExoMediaDrm<T> exoMediaDrm, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap, boolean bl) {
        this(uUID, exoMediaDrm, mediaDrmCallback, hashMap, bl, 3);
    }

    public DefaultDrmSessionManager(UUID uUID, ExoMediaDrm<T> exoMediaDrm, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap, boolean bl, int n2) {
        Assertions.checkNotNull(uUID);
        Assertions.checkNotNull(exoMediaDrm);
        Assertions.checkArgument(C.COMMON_PSSH_UUID.equals(uUID) ^ true, "Use C.CLEARKEY_UUID instead");
        this.uuid = uUID;
        this.mediaDrm = exoMediaDrm;
        this.callback = mediaDrmCallback;
        this.optionalKeyRequestParameters = hashMap;
        this.eventDispatcher = new DefaultDrmSessionEventListener.EventDispatcher();
        this.multiSession = bl;
        this.initialDrmRequestRetryCount = n2;
        this.mode = 0;
        this.sessions = new ArrayList<DefaultDrmSession<T>>();
        this.provisioningSessions = new ArrayList<DefaultDrmSession<T>>();
        if (bl) {
            exoMediaDrm.setPropertyString("sessionSharing", "enable");
        }
        exoMediaDrm.setOnEventListener((ExoMediaDrm.OnEventListener)new MediaDrmEventListener());
    }

    private static DrmInitData.SchemeData getSchemeData(DrmInitData parcelable, UUID uUID, boolean bl) {
        int n2;
        ArrayList<DrmInitData.SchemeData> arrayList = new ArrayList<DrmInitData.SchemeData>(parcelable.schemeDataCount);
        int n3 = 0;
        while (true) {
            n2 = parcelable.schemeDataCount;
            int n4 = 1;
            if (n3 >= n2) break;
            DrmInitData.SchemeData schemeData = parcelable.get(n3);
            n2 = n4;
            if (!schemeData.matches(uUID)) {
                n2 = C.CLEARKEY_UUID.equals(uUID) && schemeData.matches(C.COMMON_PSSH_UUID) ? n4 : 0;
            }
            if (n2 != 0 && (schemeData.data != null || bl)) {
                arrayList.add(schemeData);
            }
            ++n3;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (C.WIDEVINE_UUID.equals(uUID)) {
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                parcelable = (DrmInitData.SchemeData)arrayList.get(n3);
                n2 = parcelable.hasData() ? PsshAtomUtil.parseVersion((byte[])parcelable.data) : -1;
                if (Util.SDK_INT < 23 && n2 == 0) {
                    return parcelable;
                }
                if (Util.SDK_INT < 23 || n2 != 1) continue;
                return parcelable;
            }
        }
        return (DrmInitData.SchemeData)arrayList.get(0);
    }

    public static DefaultDrmSessionManager<FrameworkMediaCrypto> newFrameworkInstance(UUID uUID, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap) throws UnsupportedDrmException {
        return new DefaultDrmSessionManager<FrameworkMediaCrypto>(uUID, (ExoMediaDrm<FrameworkMediaCrypto>)FrameworkMediaDrm.newInstance((UUID)uUID), mediaDrmCallback, hashMap, false, 3);
    }

    public static DefaultDrmSessionManager<FrameworkMediaCrypto> newFrameworkInstance(UUID object, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap, Handler handler, DefaultDrmSessionEventListener defaultDrmSessionEventListener) throws UnsupportedDrmException {
        object = DefaultDrmSessionManager.newFrameworkInstance((UUID)object, mediaDrmCallback, hashMap);
        if (handler != null && defaultDrmSessionEventListener != null) {
            ((DefaultDrmSessionManager)object).addListener(handler, defaultDrmSessionEventListener);
        }
        return object;
    }

    public static DefaultDrmSessionManager<FrameworkMediaCrypto> newPlayReadyInstance(MediaDrmCallback mediaDrmCallback, String object) throws UnsupportedDrmException {
        if (!TextUtils.isEmpty((CharSequence)object)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(PLAYREADY_CUSTOM_DATA_KEY, (String)object);
            object = hashMap;
        } else {
            object = null;
        }
        return DefaultDrmSessionManager.newFrameworkInstance(C.PLAYREADY_UUID, mediaDrmCallback, (HashMap<String, String>)object);
    }

    public static DefaultDrmSessionManager<FrameworkMediaCrypto> newPlayReadyInstance(MediaDrmCallback object, String string2, Handler handler, DefaultDrmSessionEventListener defaultDrmSessionEventListener) throws UnsupportedDrmException {
        object = DefaultDrmSessionManager.newPlayReadyInstance((MediaDrmCallback)object, string2);
        if (handler != null && defaultDrmSessionEventListener != null) {
            ((DefaultDrmSessionManager)object).addListener(handler, defaultDrmSessionEventListener);
        }
        return object;
    }

    public static DefaultDrmSessionManager<FrameworkMediaCrypto> newWidevineInstance(MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap) throws UnsupportedDrmException {
        return DefaultDrmSessionManager.newFrameworkInstance(C.WIDEVINE_UUID, mediaDrmCallback, hashMap);
    }

    public static DefaultDrmSessionManager<FrameworkMediaCrypto> newWidevineInstance(MediaDrmCallback object, HashMap<String, String> hashMap, Handler handler, DefaultDrmSessionEventListener defaultDrmSessionEventListener) throws UnsupportedDrmException {
        object = DefaultDrmSessionManager.newWidevineInstance((MediaDrmCallback)object, hashMap);
        if (handler != null && defaultDrmSessionEventListener != null) {
            ((DefaultDrmSessionManager)object).addListener(handler, defaultDrmSessionEventListener);
        }
        return object;
    }

    public DrmSession<T> acquireSession(Looper defaultDrmSession, DrmInitData object) {
        Object object2 = this.playbackLooper;
        boolean bl = object2 == null || object2 == defaultDrmSession;
        Assertions.checkState(bl);
        if (this.sessions.isEmpty()) {
            this.playbackLooper = defaultDrmSession;
            if (this.mediaDrmHandler == null) {
                this.mediaDrmHandler = new MediaDrmHandler((Looper)defaultDrmSession);
            }
        }
        object2 = this.offlineLicenseKeySetId;
        Object var5_5 = null;
        if (object2 == null) {
            object2 = DefaultDrmSessionManager.getSchemeData((DrmInitData)object, this.uuid, false);
            if (object2 == null) {
                defaultDrmSession = new MissingSchemeDataException(this.uuid);
                this.eventDispatcher.drmSessionManagerError((Exception)defaultDrmSession);
                return new ErrorStateDrmSession(new DrmSession.DrmSessionException((Throwable)defaultDrmSession));
            }
        } else {
            object2 = null;
        }
        if (!this.multiSession) {
            object = this.sessions.isEmpty() ? var5_5 : this.sessions.get(0);
        } else {
            byte[] byArray = object2 != null ? object2.data : null;
            Iterator<DefaultDrmSession<T>> iterator2 = this.sessions.iterator();
            do {
                object = var5_5;
            } while (iterator2.hasNext() && !(object = iterator2.next()).hasInitData(byArray));
        }
        if (object == null) {
            defaultDrmSession = new DefaultDrmSession(this.uuid, this.mediaDrm, (DefaultDrmSession.ProvisioningManager)this, (DrmInitData.SchemeData)object2, this.mode, this.offlineLicenseKeySetId, this.optionalKeyRequestParameters, this.callback, defaultDrmSession, this.eventDispatcher, this.initialDrmRequestRetryCount);
            this.sessions.add(defaultDrmSession);
        } else {
            defaultDrmSession = object;
        }
        defaultDrmSession.acquire();
        return defaultDrmSession;
    }

    public final void addListener(Handler handler, DefaultDrmSessionEventListener defaultDrmSessionEventListener) {
        this.eventDispatcher.addListener(handler, defaultDrmSessionEventListener);
    }

    public boolean canAcquireSession(DrmInitData object) {
        Object object2 = this.offlineLicenseKeySetId;
        boolean bl = true;
        if (object2 != null) {
            return true;
        }
        if (DefaultDrmSessionManager.getSchemeData((DrmInitData)object, this.uuid, true) == null) {
            if (((DrmInitData)object).schemeDataCount == 1 && ((DrmInitData)object).get(0).matches(C.COMMON_PSSH_UUID)) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("DrmInitData only contains common PSSH SchemeData. Assuming support for: ");
                ((StringBuilder)object2).append(this.uuid);
                Log.w((String)TAG, (String)((StringBuilder)object2).toString());
            } else {
                return false;
            }
        }
        object = ((DrmInitData)object).schemeType;
        boolean bl2 = bl;
        if (object != null) {
            if ("cenc".equals(object)) {
                bl2 = bl;
            } else {
                if (!("cbc1".equals(object) || "cbcs".equals(object) || "cens".equals(object))) {
                    return true;
                }
                bl2 = Util.SDK_INT >= 25 ? bl : false;
            }
        }
        return bl2;
    }

    public final byte[] getPropertyByteArray(String string2) {
        return this.mediaDrm.getPropertyByteArray(string2);
    }

    public final String getPropertyString(String string2) {
        return this.mediaDrm.getPropertyString(string2);
    }

    public void onProvisionCompleted() {
        Iterator<DefaultDrmSession<T>> iterator2 = this.provisioningSessions.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onProvisionCompleted();
        }
        this.provisioningSessions.clear();
    }

    public void onProvisionError(Exception exception) {
        Iterator<DefaultDrmSession<T>> iterator2 = this.provisioningSessions.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onProvisionError(exception);
        }
        this.provisioningSessions.clear();
    }

    public void provisionRequired(DefaultDrmSession<T> defaultDrmSession) {
        this.provisioningSessions.add(defaultDrmSession);
        if (this.provisioningSessions.size() == 1) {
            defaultDrmSession.provision();
        }
    }

    public void releaseSession(DrmSession<T> defaultDrmSession) {
        if (defaultDrmSession instanceof ErrorStateDrmSession) {
            return;
        }
        if ((defaultDrmSession = (DefaultDrmSession)defaultDrmSession).release()) {
            this.sessions.remove(defaultDrmSession);
            if (this.provisioningSessions.size() > 1 && this.provisioningSessions.get(0) == defaultDrmSession) {
                this.provisioningSessions.get(1).provision();
            }
            this.provisioningSessions.remove(defaultDrmSession);
        }
    }

    public final void removeListener(DefaultDrmSessionEventListener defaultDrmSessionEventListener) {
        this.eventDispatcher.removeListener(defaultDrmSessionEventListener);
    }

    public void setMode(int n2, byte[] byArray) {
        Assertions.checkState(this.sessions.isEmpty());
        if (n2 == 1 || n2 == 3) {
            Assertions.checkNotNull(byArray);
        }
        this.mode = n2;
        this.offlineLicenseKeySetId = byArray;
    }

    public final void setPropertyByteArray(String string2, byte[] byArray) {
        this.mediaDrm.setPropertyByteArray(string2, byArray);
    }

    public final void setPropertyString(String string2, String string3) {
        this.mediaDrm.setPropertyString(string2, string3);
    }

    public static interface EventListener
    extends DefaultDrmSessionEventListener {
    }

    private class MediaDrmEventListener
    implements ExoMediaDrm.OnEventListener<T> {
        private MediaDrmEventListener() {
        }

        public void onEvent(ExoMediaDrm<? extends T> exoMediaDrm, byte[] byArray, int n2, int n3, byte[] byArray2) {
            if (DefaultDrmSessionManager.this.mode == 0) {
                DefaultDrmSessionManager.this.mediaDrmHandler.obtainMessage(n2, byArray).sendToTarget();
            }
        }
    }

    private class MediaDrmHandler
    extends Handler {
        public MediaDrmHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            byte[] byArray = (byte[])message.obj;
            for (DefaultDrmSession defaultDrmSession : DefaultDrmSessionManager.this.sessions) {
                if (!defaultDrmSession.hasSessionId(byArray)) continue;
                defaultDrmSession.onMediaDrmEvent(message.what);
                break;
            }
        }
    }

    public static final class MissingSchemeDataException
    extends Exception {
        private MissingSchemeDataException(UUID uUID) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Media does not support uuid: ");
            stringBuilder.append(uUID);
            super(stringBuilder.toString());
        }
    }

    public static @interface Mode {
    }
}

