/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.drm;

import android.os.Handler;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import java.util.concurrent.CopyOnWriteArrayList;

public interface DefaultDrmSessionEventListener {
    public void onDrmKeysLoaded();

    public void onDrmKeysRemoved();

    public void onDrmKeysRestored();

    public void onDrmSessionManagerError(Exception var1);

    public static final class EventDispatcher {
        private final CopyOnWriteArrayList<HandlerAndListener> listeners = new CopyOnWriteArrayList();

        public final void addListener(Handler handler, DefaultDrmSessionEventListener defaultDrmSessionEventListener) {
            boolean bl = handler != null && defaultDrmSessionEventListener != null;
            Assertions.checkArgument(bl);
            this.listeners.add(new HandlerAndListener(handler, defaultDrmSessionEventListener));
        }

        public final void drmKeysLoaded() {
            for (HandlerAndListener handlerAndListener : this.listeners) {
                final DefaultDrmSessionEventListener defaultDrmSessionEventListener = handlerAndListener.listener;
                handlerAndListener.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        defaultDrmSessionEventListener.onDrmKeysLoaded();
                    }
                });
            }
        }

        public final void drmKeysRemoved() {
            for (HandlerAndListener handlerAndListener : this.listeners) {
                final DefaultDrmSessionEventListener defaultDrmSessionEventListener = handlerAndListener.listener;
                handlerAndListener.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        defaultDrmSessionEventListener.onDrmKeysRemoved();
                    }
                });
            }
        }

        public final void drmKeysRestored() {
            for (HandlerAndListener handlerAndListener : this.listeners) {
                final DefaultDrmSessionEventListener defaultDrmSessionEventListener = handlerAndListener.listener;
                handlerAndListener.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        defaultDrmSessionEventListener.onDrmKeysRestored();
                    }
                });
            }
        }

        public final void drmSessionManagerError(final Exception exception) {
            for (HandlerAndListener handlerAndListener : this.listeners) {
                final DefaultDrmSessionEventListener defaultDrmSessionEventListener = handlerAndListener.listener;
                handlerAndListener.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        defaultDrmSessionEventListener.onDrmSessionManagerError(exception);
                    }
                });
            }
        }

        public final void removeListener(DefaultDrmSessionEventListener defaultDrmSessionEventListener) {
            for (HandlerAndListener handlerAndListener : this.listeners) {
                if (handlerAndListener.listener != defaultDrmSessionEventListener) continue;
                this.listeners.remove(handlerAndListener);
            }
        }

        private static final class HandlerAndListener {
            public final Handler handler;
            public final DefaultDrmSessionEventListener listener;

            public HandlerAndListener(Handler handler, DefaultDrmSessionEventListener defaultDrmSessionEventListener) {
                this.handler = handler;
                this.listener = defaultDrmSessionEventListener;
            }
        }
    }
}

