/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.decoder;

import com.mbridge.msdk.playercommon.exoplayer2.decoder.Buffer;
import com.mbridge.msdk.playercommon.exoplayer2.decoder.CryptoInfo;
import java.nio.ByteBuffer;

public class DecoderInputBuffer
extends Buffer {
    public static final int BUFFER_REPLACEMENT_MODE_DIRECT = 2;
    public static final int BUFFER_REPLACEMENT_MODE_DISABLED = 0;
    public static final int BUFFER_REPLACEMENT_MODE_NORMAL = 1;
    private final int bufferReplacementMode;
    public final CryptoInfo cryptoInfo = new CryptoInfo();
    public ByteBuffer data;
    public long timeUs;

    public DecoderInputBuffer(int n2) {
        this.bufferReplacementMode = n2;
    }

    private ByteBuffer createReplacementByteBuffer(int n2) {
        int n3 = this.bufferReplacementMode;
        if (n3 == 1) {
            return ByteBuffer.allocate(n2);
        }
        if (n3 == 2) {
            return ByteBuffer.allocateDirect(n2);
        }
        Comparable<ByteBuffer> comparable = this.data;
        n3 = comparable == null ? 0 : ((java.nio.Buffer)((Object)comparable)).capacity();
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append("Buffer too small (");
        ((StringBuilder)comparable).append(n3);
        ((StringBuilder)comparable).append(" < ");
        ((StringBuilder)comparable).append(n2);
        ((StringBuilder)comparable).append(")");
        throw new IllegalStateException(((StringBuilder)comparable).toString());
    }

    public static DecoderInputBuffer newFlagsOnlyInstance() {
        return new DecoderInputBuffer(0);
    }

    public void clear() {
        super.clear();
        ByteBuffer byteBuffer = this.data;
        if (byteBuffer != null) {
            byteBuffer.clear();
        }
    }

    public void ensureSpaceForWrite(int n2) throws IllegalStateException {
        int n3;
        ByteBuffer byteBuffer = this.data;
        if (byteBuffer == null) {
            this.data = this.createReplacementByteBuffer(n2);
            return;
        }
        int n4 = byteBuffer.capacity();
        if (n4 >= (n2 += (n3 = this.data.position()))) {
            return;
        }
        byteBuffer = this.createReplacementByteBuffer(n2);
        if (n3 > 0) {
            this.data.position(0);
            this.data.limit(n3);
            byteBuffer.put(this.data);
        }
        this.data = byteBuffer;
    }

    public final void flip() {
        this.data.flip();
    }

    public final boolean isEncrypted() {
        return this.getFlag(0x40000000);
    }

    public final boolean isFlagsOnly() {
        boolean bl = this.data == null && this.bufferReplacementMode == 0;
        return bl;
    }

    public static @interface BufferReplacementMode {
    }
}

