/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.audio;

import com.mbridge.msdk.playercommon.exoplayer2.audio.AudioProcessor;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class FloatResamplingAudioProcessor
implements AudioProcessor {
    private static final int FLOAT_NAN_AS_INT = Float.floatToIntBits(Float.NaN);
    private static final double PCM_32_BIT_INT_TO_PCM_32_BIT_FLOAT_FACTOR = 4.656612875245797E-10;
    private ByteBuffer buffer = EMPTY_BUFFER;
    private int channelCount = -1;
    private boolean inputEnded;
    private ByteBuffer outputBuffer = EMPTY_BUFFER;
    private int sampleRateHz = -1;
    private int sourceEncoding = 0;

    private static void writePcm32BitFloat(int n2, ByteBuffer byteBuffer) {
        int n3;
        double d2 = n2;
        Double.isNaN(d2);
        n2 = n3 = Float.floatToIntBits((float)(d2 * 4.656612875245797E-10));
        if (n3 == FLOAT_NAN_AS_INT) {
            n2 = Float.floatToIntBits(0.0f);
        }
        byteBuffer.putInt(n2);
    }

    public final boolean configure(int n2, int n3, int n4) throws AudioProcessor.UnhandledFormatException {
        if (Util.isEncodingHighResolutionIntegerPcm((int)n4)) {
            if (this.sampleRateHz == n2 && this.channelCount == n3 && this.sourceEncoding == n4) {
                return false;
            }
            this.sampleRateHz = n2;
            this.channelCount = n3;
            this.sourceEncoding = n4;
            return true;
        }
        throw new AudioProcessor.UnhandledFormatException(n2, n3, n4);
    }

    public final void flush() {
        this.outputBuffer = EMPTY_BUFFER;
        this.inputEnded = false;
    }

    public final ByteBuffer getOutput() {
        ByteBuffer byteBuffer = this.outputBuffer;
        this.outputBuffer = EMPTY_BUFFER;
        return byteBuffer;
    }

    public final int getOutputChannelCount() {
        return this.channelCount;
    }

    public final int getOutputEncoding() {
        return 4;
    }

    public final int getOutputSampleRateHz() {
        return this.sampleRateHz;
    }

    public final boolean isActive() {
        return Util.isEncodingHighResolutionIntegerPcm((int)this.sourceEncoding);
    }

    public final boolean isEnded() {
        boolean bl = this.inputEnded && this.outputBuffer == EMPTY_BUFFER;
        return bl;
    }

    public final void queueEndOfStream() {
        this.inputEnded = true;
    }

    public final void queueInput(ByteBuffer byteBuffer) {
        boolean bl = this.sourceEncoding == 0x40000000;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        int n4 = n3 - n2;
        if (!bl) {
            n4 = n4 / 3 * 4;
        }
        if (this.buffer.capacity() < n4) {
            this.buffer = ByteBuffer.allocateDirect(n4).order(ByteOrder.nativeOrder());
        } else {
            this.buffer.clear();
        }
        if (bl) {
            while (n2 < n3) {
                FloatResamplingAudioProcessor.writePcm32BitFloat(byteBuffer.get(n2) & 0xFF | (byteBuffer.get(n2 + 1) & 0xFF) << 8 | (byteBuffer.get(n2 + 2) & 0xFF) << 16 | (byteBuffer.get(n2 + 3) & 0xFF) << 24, this.buffer);
                n2 += 4;
            }
        } else {
            for (n4 = n2; n4 < n3; n4 += 3) {
                FloatResamplingAudioProcessor.writePcm32BitFloat((byteBuffer.get(n4) & 0xFF) << 8 | (byteBuffer.get(n4 + 1) & 0xFF) << 16 | (byteBuffer.get(n4 + 2) & 0xFF) << 24, this.buffer);
            }
        }
        byteBuffer.position(byteBuffer.limit());
        this.buffer.flip();
        this.outputBuffer = this.buffer;
    }

    public final void reset() {
        this.flush();
        this.sampleRateHz = -1;
        this.channelCount = -1;
        this.sourceEncoding = 0;
        this.buffer = EMPTY_BUFFER;
    }
}

