/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.audio;

import android.media.AudioTimestamp;
import android.media.AudioTrack;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;

final class AudioTimestampPoller {
    private static final int ERROR_POLL_INTERVAL_US = 500000;
    private static final int FAST_POLL_INTERVAL_US = 5000;
    private static final int INITIALIZING_DURATION_US = 500000;
    private static final int SLOW_POLL_INTERVAL_US = 10000000;
    private static final int STATE_ERROR = 4;
    private static final int STATE_INITIALIZING = 0;
    private static final int STATE_NO_TIMESTAMP = 3;
    private static final int STATE_TIMESTAMP = 1;
    private static final int STATE_TIMESTAMP_ADVANCING = 2;
    private final AudioTimestampV19 audioTimestamp;
    private long initialTimestampPositionFrames;
    private long initializeSystemTimeUs;
    private long lastTimestampSampleTimeUs;
    private long sampleIntervalUs;
    private int state;

    public AudioTimestampPoller(AudioTrack audioTrack) {
        if (Util.SDK_INT >= 19) {
            this.audioTimestamp = new AudioTimestampV19(audioTrack);
            this.reset();
        } else {
            this.audioTimestamp = null;
            this.updateState(3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateState(int n2) {
        this.state = n2;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2 && n2 != 3) {
                    if (n2 != 4) throw new IllegalStateException();
                    this.sampleIntervalUs = 500000L;
                    return;
                } else {
                    this.sampleIntervalUs = 10000000L;
                }
                return;
            } else {
                this.sampleIntervalUs = 5000L;
            }
            return;
        } else {
            this.lastTimestampSampleTimeUs = 0L;
            this.initialTimestampPositionFrames = -1L;
            this.initializeSystemTimeUs = System.nanoTime() / 1000L;
            this.sampleIntervalUs = 5000L;
        }
    }

    public final void acceptTimestamp() {
        if (this.state == 4) {
            this.reset();
        }
    }

    public final long getTimestampPositionFrames() {
        AudioTimestampV19 audioTimestampV19 = this.audioTimestamp;
        long l2 = audioTimestampV19 != null ? audioTimestampV19.getTimestampPositionFrames() : -1L;
        return l2;
    }

    public final long getTimestampSystemTimeUs() {
        AudioTimestampV19 audioTimestampV19 = this.audioTimestamp;
        long l2 = audioTimestampV19 != null ? audioTimestampV19.getTimestampSystemTimeUs() : -9223372036854775807L;
        return l2;
    }

    public final boolean hasTimestamp() {
        boolean bl;
        int n2 = this.state;
        boolean bl2 = bl = true;
        if (n2 != 1) {
            bl2 = n2 == 2 ? bl : false;
        }
        return bl2;
    }

    public final boolean isTimestampAdvancing() {
        boolean bl = this.state == 2;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean maybePollTimestamp(long l2) {
        boolean bl;
        AudioTimestampV19 audioTimestampV19 = this.audioTimestamp;
        if (audioTimestampV19 == null) return false;
        if (l2 - this.lastTimestampSampleTimeUs < this.sampleIntervalUs) return false;
        this.lastTimestampSampleTimeUs = l2;
        boolean bl2 = audioTimestampV19.maybeUpdateTimestamp();
        int n2 = this.state;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 4) throw new IllegalStateException();
                        return bl2;
                    }
                    bl = bl2;
                    if (!bl2) return bl;
                    this.reset();
                    return bl2;
                }
                bl = bl2;
                if (bl2) return bl;
                this.reset();
                return bl2;
            }
            if (bl2) {
                bl = bl2;
                if (this.audioTimestamp.getTimestampPositionFrames() <= this.initialTimestampPositionFrames) return bl;
                this.updateState(2);
                return bl2;
            }
            this.reset();
            return bl2;
        }
        if (bl2) {
            if (this.audioTimestamp.getTimestampSystemTimeUs() < this.initializeSystemTimeUs) return false;
            this.initialTimestampPositionFrames = this.audioTimestamp.getTimestampPositionFrames();
            this.updateState(1);
            return bl2;
        }
        bl = bl2;
        if (l2 - this.initializeSystemTimeUs <= 500000L) return bl;
        this.updateState(3);
        return bl2;
    }

    public final void rejectTimestamp() {
        this.updateState(4);
    }

    public final void reset() {
        if (this.audioTimestamp != null) {
            this.updateState(0);
        }
    }

    private static final class AudioTimestampV19 {
        private final AudioTimestamp audioTimestamp;
        private final AudioTrack audioTrack;
        private long lastTimestampPositionFrames;
        private long lastTimestampRawPositionFrames;
        private long rawTimestampFramePositionWrapCount;

        public AudioTimestampV19(AudioTrack audioTrack) {
            this.audioTrack = audioTrack;
            this.audioTimestamp = new AudioTimestamp();
        }

        public final long getTimestampPositionFrames() {
            return this.lastTimestampPositionFrames;
        }

        public final long getTimestampSystemTimeUs() {
            return this.audioTimestamp.nanoTime / 1000L;
        }

        public final boolean maybeUpdateTimestamp() {
            boolean bl = this.audioTrack.getTimestamp(this.audioTimestamp);
            if (bl) {
                long l2 = this.audioTimestamp.framePosition;
                if (this.lastTimestampRawPositionFrames > l2) {
                    ++this.rawTimestampFramePositionWrapCount;
                }
                this.lastTimestampRawPositionFrames = l2;
                this.lastTimestampPositionFrames = l2 + (this.rawTimestampFramePositionWrapCount << 32);
            }
            return bl;
        }
    }

    private static @interface State {
    }
}

