/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2;

import android.graphics.SurfaceTexture;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import com.mbridge.msdk.playercommon.exoplayer2.ExoPlaybackException;
import com.mbridge.msdk.playercommon.exoplayer2.ExoPlayer;
import com.mbridge.msdk.playercommon.exoplayer2.ExoPlayerImpl;
import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.LoadControl;
import com.mbridge.msdk.playercommon.exoplayer2.PlaybackParameters;
import com.mbridge.msdk.playercommon.exoplayer2.Player;
import com.mbridge.msdk.playercommon.exoplayer2.PlayerMessage;
import com.mbridge.msdk.playercommon.exoplayer2.Renderer;
import com.mbridge.msdk.playercommon.exoplayer2.RenderersFactory;
import com.mbridge.msdk.playercommon.exoplayer2.SeekParameters;
import com.mbridge.msdk.playercommon.exoplayer2.Timeline;
import com.mbridge.msdk.playercommon.exoplayer2.analytics.AnalyticsCollector;
import com.mbridge.msdk.playercommon.exoplayer2.analytics.AnalyticsListener;
import com.mbridge.msdk.playercommon.exoplayer2.audio.AudioAttributes;
import com.mbridge.msdk.playercommon.exoplayer2.audio.AudioRendererEventListener;
import com.mbridge.msdk.playercommon.exoplayer2.decoder.DecoderCounters;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DefaultDrmSessionEventListener;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DefaultDrmSessionManager;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmSessionManager;
import com.mbridge.msdk.playercommon.exoplayer2.drm.FrameworkMediaCrypto;
import com.mbridge.msdk.playercommon.exoplayer2.metadata.Metadata;
import com.mbridge.msdk.playercommon.exoplayer2.metadata.MetadataOutput;
import com.mbridge.msdk.playercommon.exoplayer2.source.MediaSource;
import com.mbridge.msdk.playercommon.exoplayer2.source.MediaSourceEventListener;
import com.mbridge.msdk.playercommon.exoplayer2.source.TrackGroupArray;
import com.mbridge.msdk.playercommon.exoplayer2.text.Cue;
import com.mbridge.msdk.playercommon.exoplayer2.text.TextOutput;
import com.mbridge.msdk.playercommon.exoplayer2.trackselection.TrackSelectionArray;
import com.mbridge.msdk.playercommon.exoplayer2.trackselection.TrackSelector;
import com.mbridge.msdk.playercommon.exoplayer2.util.Clock;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import com.mbridge.msdk.playercommon.exoplayer2.video.VideoRendererEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeoutException;

public class SimpleExoPlayer
implements ExoPlayer,
Player.TextComponent,
Player.VideoComponent {
    private static final String TAG = "SimpleExoPlayer";
    private final AnalyticsCollector analyticsCollector;
    private AudioAttributes audioAttributes;
    private final CopyOnWriteArraySet<AudioRendererEventListener> audioDebugListeners;
    private DecoderCounters audioDecoderCounters;
    private Format audioFormat;
    private int audioSessionId;
    private float audioVolume;
    private final ComponentListener componentListener = new ComponentListener();
    private List<Cue> currentCues;
    private final Handler eventHandler;
    private MediaSource mediaSource;
    private final CopyOnWriteArraySet<MetadataOutput> metadataOutputs;
    private boolean ownsSurface;
    private final ExoPlayer player;
    protected final Renderer[] renderers;
    private Surface surface;
    private SurfaceHolder surfaceHolder;
    private final CopyOnWriteArraySet<TextOutput> textOutputs;
    private TextureView textureView;
    private final CopyOnWriteArraySet<VideoRendererEventListener> videoDebugListeners;
    private DecoderCounters videoDecoderCounters;
    private Format videoFormat;
    private final CopyOnWriteArraySet<com.mbridge.msdk.playercommon.exoplayer2.video.VideoListener> videoListeners = new CopyOnWriteArraySet();
    private int videoScalingMode;

    protected SimpleExoPlayer(RenderersFactory renderersFactory, TrackSelector trackSelector, LoadControl loadControl, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager) {
        this(renderersFactory, trackSelector, loadControl, drmSessionManager, new AnalyticsCollector.Factory());
    }

    protected SimpleExoPlayer(RenderersFactory renderersFactory, TrackSelector trackSelector, LoadControl loadControl, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, AnalyticsCollector.Factory factory) {
        this(renderersFactory, trackSelector, loadControl, drmSessionManager, factory, Clock.DEFAULT);
    }

    protected SimpleExoPlayer(RenderersFactory renderersFactory, TrackSelector trackSelector, LoadControl loadControl, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, AnalyticsCollector.Factory factory, Clock clock) {
        this.textOutputs = new CopyOnWriteArraySet();
        this.metadataOutputs = new CopyOnWriteArraySet();
        this.videoDebugListeners = new CopyOnWriteArraySet();
        this.audioDebugListeners = new CopyOnWriteArraySet();
        Object object = Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper();
        Handler handler = this.eventHandler = new Handler(object);
        object = this.componentListener;
        this.renderers = renderersFactory.createRenderers(handler, (VideoRendererEventListener)object, (AudioRendererEventListener)object, (TextOutput)object, (MetadataOutput)object, drmSessionManager);
        this.audioVolume = 1.0f;
        this.audioSessionId = 0;
        this.audioAttributes = AudioAttributes.DEFAULT;
        this.videoScalingMode = 1;
        this.currentCues = Collections.emptyList();
        this.player = this.createExoPlayerImpl(this.renderers, trackSelector, loadControl, clock);
        this.analyticsCollector = factory.createAnalyticsCollector((Player)this.player, clock);
        this.addListener((Player.EventListener)this.analyticsCollector);
        this.videoDebugListeners.add((VideoRendererEventListener)this.analyticsCollector);
        this.audioDebugListeners.add((AudioRendererEventListener)this.analyticsCollector);
        this.addMetadataOutput((MetadataOutput)this.analyticsCollector);
        if (drmSessionManager instanceof DefaultDrmSessionManager) {
            ((DefaultDrmSessionManager)drmSessionManager).addListener(this.eventHandler, (DefaultDrmSessionEventListener)this.analyticsCollector);
        }
    }

    static /* synthetic */ List access$1002(SimpleExoPlayer simpleExoPlayer, List list) {
        simpleExoPlayer.currentCues = list;
        return list;
    }

    static /* synthetic */ DecoderCounters access$102(SimpleExoPlayer simpleExoPlayer, DecoderCounters decoderCounters) {
        simpleExoPlayer.videoDecoderCounters = decoderCounters;
        return decoderCounters;
    }

    static /* synthetic */ Format access$302(SimpleExoPlayer simpleExoPlayer, Format format) {
        simpleExoPlayer.videoFormat = format;
        return format;
    }

    static /* synthetic */ DecoderCounters access$602(SimpleExoPlayer simpleExoPlayer, DecoderCounters decoderCounters) {
        simpleExoPlayer.audioDecoderCounters = decoderCounters;
        return decoderCounters;
    }

    static /* synthetic */ int access$802(SimpleExoPlayer simpleExoPlayer, int n2) {
        simpleExoPlayer.audioSessionId = n2;
        return n2;
    }

    static /* synthetic */ Format access$902(SimpleExoPlayer simpleExoPlayer, Format format) {
        simpleExoPlayer.audioFormat = format;
        return format;
    }

    private void removeSurfaceCallbacks() {
        TextureView textureView = this.textureView;
        if (textureView != null) {
            if (textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w((String)TAG, (String)"SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if ((textureView = this.surfaceHolder) != null) {
            textureView.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setVideoSurfaceInternal(Surface surface, boolean bl) {
        Object object = new ArrayList<PlayerMessage>();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            object.add(this.player.createMessage(renderer).setType(1).setPayload((Object)surface).send());
        }
        Surface surface2 = this.surface;
        if (surface2 != null && surface2 != surface) {
            try {
                object = object.iterator();
                while (object.hasNext()) {
                    ((PlayerMessage)object.next()).blockUntilDelivered();
                }
            }
            catch (TimeoutException timeoutException) {
                this.player.stop(false);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (this.ownsSurface) {
                this.surface.release();
            }
        }
        this.surface = surface;
        this.ownsSurface = bl;
    }

    public void addAnalyticsListener(AnalyticsListener analyticsListener) {
        this.analyticsCollector.addListener(analyticsListener);
    }

    public void addAudioDebugListener(AudioRendererEventListener audioRendererEventListener) {
        this.audioDebugListeners.add(audioRendererEventListener);
    }

    @Override
    public void addListener(Player.EventListener eventListener) {
        this.player.addListener(eventListener);
    }

    public void addMetadataOutput(MetadataOutput metadataOutput) {
        this.metadataOutputs.add(metadataOutput);
    }

    @Override
    public void addTextOutput(TextOutput textOutput) {
        if (!this.currentCues.isEmpty()) {
            textOutput.onCues(this.currentCues);
        }
        this.textOutputs.add(textOutput);
    }

    public void addVideoDebugListener(VideoRendererEventListener videoRendererEventListener) {
        this.videoDebugListeners.add(videoRendererEventListener);
    }

    @Override
    public void addVideoListener(com.mbridge.msdk.playercommon.exoplayer2.video.VideoListener videoListener) {
        this.videoListeners.add(videoListener);
    }

    @Override
    public void blockingSendMessages(ExoPlayer.ExoPlayerMessage ... exoPlayerMessageArray) {
        this.player.blockingSendMessages(exoPlayerMessageArray);
    }

    public void clearMetadataOutput(MetadataOutput metadataOutput) {
        this.removeMetadataOutput(metadataOutput);
    }

    public void clearTextOutput(TextOutput textOutput) {
        this.removeTextOutput(textOutput);
    }

    public void clearVideoListener(VideoListener videoListener) {
        this.removeVideoListener(videoListener);
    }

    @Override
    public void clearVideoSurface() {
        this.setVideoSurface(null);
    }

    @Override
    public void clearVideoSurface(Surface surface) {
        if (surface != null && surface == this.surface) {
            this.setVideoSurface(null);
        }
    }

    @Override
    public void clearVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.setVideoSurfaceHolder(null);
        }
    }

    @Override
    public void clearVideoSurfaceView(SurfaceView object) {
        object = object == null ? null : object.getHolder();
        this.clearVideoSurfaceHolder((SurfaceHolder)object);
    }

    @Override
    public void clearVideoTextureView(TextureView textureView) {
        if (textureView != null && textureView == this.textureView) {
            this.setVideoTextureView(null);
        }
    }

    protected ExoPlayer createExoPlayerImpl(Renderer[] rendererArray, TrackSelector trackSelector, LoadControl loadControl, Clock clock) {
        return new ExoPlayerImpl(rendererArray, trackSelector, loadControl, clock);
    }

    @Override
    public PlayerMessage createMessage(PlayerMessage.Target target) {
        return this.player.createMessage(target);
    }

    public AnalyticsCollector getAnalyticsCollector() {
        return this.analyticsCollector;
    }

    public AudioAttributes getAudioAttributes() {
        return this.audioAttributes;
    }

    public DecoderCounters getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    public Format getAudioFormat() {
        return this.audioFormat;
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public int getAudioStreamType() {
        return Util.getStreamTypeForAudioUsage((int)this.audioAttributes.usage);
    }

    @Override
    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    @Override
    public long getBufferedPosition() {
        return this.player.getBufferedPosition();
    }

    @Override
    public long getContentPosition() {
        return this.player.getContentPosition();
    }

    @Override
    public int getCurrentAdGroupIndex() {
        return this.player.getCurrentAdGroupIndex();
    }

    @Override
    public int getCurrentAdIndexInAdGroup() {
        return this.player.getCurrentAdIndexInAdGroup();
    }

    @Override
    public Object getCurrentManifest() {
        return this.player.getCurrentManifest();
    }

    @Override
    public int getCurrentPeriodIndex() {
        return this.player.getCurrentPeriodIndex();
    }

    @Override
    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    @Override
    public Object getCurrentTag() {
        return this.player.getCurrentTag();
    }

    @Override
    public Timeline getCurrentTimeline() {
        return this.player.getCurrentTimeline();
    }

    @Override
    public TrackGroupArray getCurrentTrackGroups() {
        return this.player.getCurrentTrackGroups();
    }

    @Override
    public TrackSelectionArray getCurrentTrackSelections() {
        return this.player.getCurrentTrackSelections();
    }

    @Override
    public int getCurrentWindowIndex() {
        return this.player.getCurrentWindowIndex();
    }

    @Override
    public long getDuration() {
        return this.player.getDuration();
    }

    @Override
    public int getNextWindowIndex() {
        return this.player.getNextWindowIndex();
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    @Override
    public ExoPlaybackException getPlaybackError() {
        return this.player.getPlaybackError();
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.player.getPlaybackParameters();
    }

    @Override
    public int getPlaybackState() {
        return this.player.getPlaybackState();
    }

    @Override
    public int getPreviousWindowIndex() {
        return this.player.getPreviousWindowIndex();
    }

    @Override
    public int getRendererCount() {
        return this.player.getRendererCount();
    }

    @Override
    public int getRendererType(int n2) {
        return this.player.getRendererType(n2);
    }

    @Override
    public int getRepeatMode() {
        return this.player.getRepeatMode();
    }

    @Override
    public boolean getShuffleModeEnabled() {
        return this.player.getShuffleModeEnabled();
    }

    @Override
    public Player.TextComponent getTextComponent() {
        return this;
    }

    @Override
    public Player.VideoComponent getVideoComponent() {
        return this;
    }

    public DecoderCounters getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    public Format getVideoFormat() {
        return this.videoFormat;
    }

    @Override
    public int getVideoScalingMode() {
        return this.videoScalingMode;
    }

    public float getVolume() {
        return this.audioVolume;
    }

    @Override
    public boolean isCurrentWindowDynamic() {
        return this.player.isCurrentWindowDynamic();
    }

    @Override
    public boolean isCurrentWindowSeekable() {
        return this.player.isCurrentWindowSeekable();
    }

    @Override
    public boolean isLoading() {
        return this.player.isLoading();
    }

    public final boolean isPlaying() {
        boolean bl = this.getPlaybackState() == 3 && this.getPlayWhenReady();
        return bl;
    }

    @Override
    public boolean isPlayingAd() {
        return this.player.isPlayingAd();
    }

    @Override
    public void prepare(MediaSource mediaSource) {
        this.prepare(mediaSource, true, true);
    }

    @Override
    public void prepare(MediaSource mediaSource, boolean bl, boolean bl2) {
        MediaSource mediaSource2 = this.mediaSource;
        if (mediaSource2 != mediaSource) {
            if (mediaSource2 != null) {
                mediaSource2.removeEventListener((MediaSourceEventListener)this.analyticsCollector);
                this.analyticsCollector.resetForNewMediaSource();
            }
            mediaSource.addEventListener(this.eventHandler, (MediaSourceEventListener)this.analyticsCollector);
            this.mediaSource = mediaSource;
        }
        this.player.prepare(mediaSource, bl, bl2);
    }

    @Override
    public void release() {
        this.player.release();
        this.removeSurfaceCallbacks();
        Object object = this.surface;
        if (object != null) {
            if (this.ownsSurface) {
                object.release();
            }
            this.surface = null;
        }
        if ((object = this.mediaSource) != null) {
            object.removeEventListener((MediaSourceEventListener)this.analyticsCollector);
        }
        this.currentCues = Collections.emptyList();
    }

    public void removeAnalyticsListener(AnalyticsListener analyticsListener) {
        this.analyticsCollector.removeListener(analyticsListener);
    }

    public void removeAudioDebugListener(AudioRendererEventListener audioRendererEventListener) {
        this.audioDebugListeners.remove(audioRendererEventListener);
    }

    @Override
    public void removeListener(Player.EventListener eventListener) {
        this.player.removeListener(eventListener);
    }

    public void removeMetadataOutput(MetadataOutput metadataOutput) {
        this.metadataOutputs.remove(metadataOutput);
    }

    @Override
    public void removeTextOutput(TextOutput textOutput) {
        this.textOutputs.remove(textOutput);
    }

    public void removeVideoDebugListener(VideoRendererEventListener videoRendererEventListener) {
        this.videoDebugListeners.remove(videoRendererEventListener);
    }

    @Override
    public void removeVideoListener(com.mbridge.msdk.playercommon.exoplayer2.video.VideoListener videoListener) {
        this.videoListeners.remove(videoListener);
    }

    @Override
    public void seekTo(int n2, long l2) {
        this.analyticsCollector.notifySeekStarted();
        this.player.seekTo(n2, l2);
    }

    @Override
    public void seekTo(long l2) {
        this.analyticsCollector.notifySeekStarted();
        this.player.seekTo(l2);
    }

    @Override
    public void seekToDefaultPosition() {
        this.analyticsCollector.notifySeekStarted();
        this.player.seekToDefaultPosition();
    }

    @Override
    public void seekToDefaultPosition(int n2) {
        this.analyticsCollector.notifySeekStarted();
        this.player.seekToDefaultPosition(n2);
    }

    @Override
    public void sendMessages(ExoPlayer.ExoPlayerMessage ... exoPlayerMessageArray) {
        this.player.sendMessages(exoPlayerMessageArray);
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) {
        this.audioAttributes = audioAttributes;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 1) continue;
            this.player.createMessage(renderer).setType(3).setPayload((Object)audioAttributes).send();
        }
    }

    public void setAudioDebugListener(AudioRendererEventListener audioRendererEventListener) {
        this.audioDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (audioRendererEventListener != null) {
            this.addAudioDebugListener(audioRendererEventListener);
        }
    }

    public void setAudioStreamType(int n2) {
        int n3 = Util.getAudioUsageForStreamType((int)n2);
        n2 = Util.getAudioContentTypeForStreamType((int)n2);
        this.setAudioAttributes(new AudioAttributes.Builder().setUsage(n3).setContentType(n2).build());
    }

    public void setMetadataOutput(MetadataOutput metadataOutput) {
        this.metadataOutputs.retainAll(Collections.singleton(this.analyticsCollector));
        if (metadataOutput != null) {
            this.addMetadataOutput(metadataOutput);
        }
    }

    @Override
    public void setPlayWhenReady(boolean bl) {
        this.player.setPlayWhenReady(bl);
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.player.setPlaybackParameters(playbackParameters);
    }

    public void setPlaybackParams(PlaybackParams playbackParams) {
        if (playbackParams != null) {
            playbackParams.allowDefaults();
            playbackParams = new PlaybackParameters(playbackParams.getSpeed(), playbackParams.getPitch());
        } else {
            playbackParams = null;
        }
        this.setPlaybackParameters((PlaybackParameters)playbackParams);
    }

    @Override
    public void setRepeatMode(int n2) {
        this.player.setRepeatMode(n2);
    }

    @Override
    public void setSeekParameters(SeekParameters seekParameters) {
        this.player.setSeekParameters(seekParameters);
    }

    @Override
    public void setShuffleModeEnabled(boolean bl) {
        this.player.setShuffleModeEnabled(bl);
    }

    public void setTextOutput(TextOutput textOutput) {
        this.textOutputs.clear();
        if (textOutput != null) {
            this.addTextOutput(textOutput);
        }
    }

    public void setVideoDebugListener(VideoRendererEventListener videoRendererEventListener) {
        this.videoDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (videoRendererEventListener != null) {
            this.addVideoDebugListener(videoRendererEventListener);
        }
    }

    public void setVideoListener(VideoListener videoListener) {
        this.videoListeners.clear();
        if (videoListener != null) {
            this.addVideoListener(videoListener);
        }
    }

    @Override
    public void setVideoScalingMode(int n2) {
        this.videoScalingMode = n2;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            this.player.createMessage(renderer).setType(4).setPayload((Object)n2).send();
        }
    }

    @Override
    public void setVideoSurface(Surface surface) {
        this.removeSurfaceCallbacks();
        this.setVideoSurfaceInternal(surface, false);
    }

    @Override
    public void setVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        block3: {
            block2: {
                this.removeSurfaceCallbacks();
                this.surfaceHolder = surfaceHolder;
                if (surfaceHolder == null) break block2;
                surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
                surfaceHolder = surfaceHolder.getSurface();
                if (surfaceHolder != null && surfaceHolder.isValid()) break block3;
            }
            surfaceHolder = null;
        }
        this.setVideoSurfaceInternal((Surface)surfaceHolder, false);
    }

    @Override
    public void setVideoSurfaceView(SurfaceView object) {
        object = object == null ? null : object.getHolder();
        this.setVideoSurfaceHolder((SurfaceHolder)object);
    }

    @Override
    public void setVideoTextureView(TextureView object) {
        this.removeSurfaceCallbacks();
        this.textureView = object;
        Object var2_2 = null;
        if (object == null) {
            object = var2_2;
        } else {
            if (object.getSurfaceTextureListener() != null) {
                Log.w((String)TAG, (String)"Replacing existing SurfaceTextureListener.");
            }
            object.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            object = object.isAvailable() ? object.getSurfaceTexture() : null;
            object = object == null ? var2_2 : new Surface((SurfaceTexture)object);
        }
        this.setVideoSurfaceInternal((Surface)object, true);
    }

    public void setVolume(float f2) {
        this.audioVolume = f2;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 1) continue;
            this.player.createMessage(renderer).setType(2).setPayload((Object)Float.valueOf(f2)).send();
        }
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void stop(boolean bl) {
        this.player.stop(bl);
        MediaSource mediaSource = this.mediaSource;
        if (mediaSource != null) {
            mediaSource.removeEventListener((MediaSourceEventListener)this.analyticsCollector);
            this.mediaSource = null;
            this.analyticsCollector.resetForNewMediaSource();
        }
        this.currentCues = Collections.emptyList();
    }

    private final class ComponentListener
    implements SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    AudioRendererEventListener,
    MetadataOutput,
    TextOutput,
    VideoRendererEventListener {
        private ComponentListener() {
        }

        public final void onAudioDecoderInitialized(String string2, long l2, long l3) {
            Iterator iterator2 = SimpleExoPlayer.this.audioDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((AudioRendererEventListener)iterator2.next()).onAudioDecoderInitialized(string2, l2, l3);
            }
        }

        public final void onAudioDisabled(DecoderCounters decoderCounters) {
            Iterator iterator2 = SimpleExoPlayer.this.audioDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((AudioRendererEventListener)iterator2.next()).onAudioDisabled(decoderCounters);
            }
            SimpleExoPlayer.access$902(SimpleExoPlayer.this, null);
            SimpleExoPlayer.access$602(SimpleExoPlayer.this, null);
            SimpleExoPlayer.access$802(SimpleExoPlayer.this, 0);
        }

        public final void onAudioEnabled(DecoderCounters decoderCounters) {
            SimpleExoPlayer.access$602(SimpleExoPlayer.this, decoderCounters);
            Iterator iterator2 = SimpleExoPlayer.this.audioDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((AudioRendererEventListener)iterator2.next()).onAudioEnabled(decoderCounters);
            }
        }

        public final void onAudioInputFormatChanged(Format format) {
            SimpleExoPlayer.access$902(SimpleExoPlayer.this, format);
            Iterator iterator2 = SimpleExoPlayer.this.audioDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((AudioRendererEventListener)iterator2.next()).onAudioInputFormatChanged(format);
            }
        }

        public final void onAudioSessionId(int n2) {
            SimpleExoPlayer.access$802(SimpleExoPlayer.this, n2);
            Iterator iterator2 = SimpleExoPlayer.this.audioDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((AudioRendererEventListener)iterator2.next()).onAudioSessionId(n2);
            }
        }

        public final void onAudioSinkUnderrun(int n2, long l2, long l3) {
            Iterator iterator2 = SimpleExoPlayer.this.audioDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((AudioRendererEventListener)iterator2.next()).onAudioSinkUnderrun(n2, l2, l3);
            }
        }

        public final void onCues(List<Cue> list) {
            SimpleExoPlayer.access$1002(SimpleExoPlayer.this, list);
            Iterator iterator2 = SimpleExoPlayer.this.textOutputs.iterator();
            while (iterator2.hasNext()) {
                ((TextOutput)iterator2.next()).onCues(list);
            }
        }

        public final void onDroppedFrames(int n2, long l2) {
            Iterator iterator2 = SimpleExoPlayer.this.videoDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((VideoRendererEventListener)iterator2.next()).onDroppedFrames(n2, l2);
            }
        }

        public final void onMetadata(Metadata metadata) {
            Iterator iterator2 = SimpleExoPlayer.this.metadataOutputs.iterator();
            while (iterator2.hasNext()) {
                ((MetadataOutput)iterator2.next()).onMetadata(metadata);
            }
        }

        public final void onRenderedFirstFrame(Surface surface) {
            Iterator iterator2;
            if (SimpleExoPlayer.this.surface == surface) {
                iterator2 = SimpleExoPlayer.this.videoListeners.iterator();
                while (iterator2.hasNext()) {
                    ((com.mbridge.msdk.playercommon.exoplayer2.video.VideoListener)iterator2.next()).onRenderedFirstFrame();
                }
            }
            iterator2 = SimpleExoPlayer.this.videoDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((VideoRendererEventListener)iterator2.next()).onRenderedFirstFrame(surface);
            }
        }

        public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
        }

        public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, true);
            return true;
        }

        public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        }

        public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        public final void onVideoDecoderInitialized(String string2, long l2, long l3) {
            Iterator iterator2 = SimpleExoPlayer.this.videoDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((VideoRendererEventListener)iterator2.next()).onVideoDecoderInitialized(string2, l2, l3);
            }
        }

        public final void onVideoDisabled(DecoderCounters decoderCounters) {
            Iterator iterator2 = SimpleExoPlayer.this.videoDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((VideoRendererEventListener)iterator2.next()).onVideoDisabled(decoderCounters);
            }
            SimpleExoPlayer.access$302(SimpleExoPlayer.this, null);
            SimpleExoPlayer.access$102(SimpleExoPlayer.this, null);
        }

        public final void onVideoEnabled(DecoderCounters decoderCounters) {
            SimpleExoPlayer.access$102(SimpleExoPlayer.this, decoderCounters);
            Iterator iterator2 = SimpleExoPlayer.this.videoDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((VideoRendererEventListener)iterator2.next()).onVideoEnabled(decoderCounters);
            }
        }

        public final void onVideoInputFormatChanged(Format format) {
            SimpleExoPlayer.access$302(SimpleExoPlayer.this, format);
            Iterator iterator2 = SimpleExoPlayer.this.videoDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((VideoRendererEventListener)iterator2.next()).onVideoInputFormatChanged(format);
            }
        }

        public final void onVideoSizeChanged(int n2, int n3, int n4, float f2) {
            Iterator iterator2 = SimpleExoPlayer.this.videoListeners.iterator();
            while (iterator2.hasNext()) {
                ((com.mbridge.msdk.playercommon.exoplayer2.video.VideoListener)iterator2.next()).onVideoSizeChanged(n2, n3, n4, f2);
            }
            iterator2 = SimpleExoPlayer.this.videoDebugListeners.iterator();
            while (iterator2.hasNext()) {
                ((VideoRendererEventListener)iterator2.next()).onVideoSizeChanged(n2, n3, n4, f2);
            }
        }

        public final void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
        }

        public final void surfaceCreated(SurfaceHolder surfaceHolder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(surfaceHolder.getSurface(), false);
        }

        public final void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, false);
        }
    }

    public static interface VideoListener
    extends com.mbridge.msdk.playercommon.exoplayer2.video.VideoListener {
    }
}

