/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.mbridge.msdk.playercommon.exoplayer2.Renderer;
import com.mbridge.msdk.playercommon.exoplayer2.RenderersFactory;
import com.mbridge.msdk.playercommon.exoplayer2.audio.AudioCapabilities;
import com.mbridge.msdk.playercommon.exoplayer2.audio.AudioProcessor;
import com.mbridge.msdk.playercommon.exoplayer2.audio.AudioRendererEventListener;
import com.mbridge.msdk.playercommon.exoplayer2.audio.MediaCodecAudioRenderer;
import com.mbridge.msdk.playercommon.exoplayer2.drm.DrmSessionManager;
import com.mbridge.msdk.playercommon.exoplayer2.drm.FrameworkMediaCrypto;
import com.mbridge.msdk.playercommon.exoplayer2.mediacodec.MediaCodecSelector;
import com.mbridge.msdk.playercommon.exoplayer2.metadata.MetadataOutput;
import com.mbridge.msdk.playercommon.exoplayer2.metadata.MetadataRenderer;
import com.mbridge.msdk.playercommon.exoplayer2.text.TextOutput;
import com.mbridge.msdk.playercommon.exoplayer2.text.TextRenderer;
import com.mbridge.msdk.playercommon.exoplayer2.video.MediaCodecVideoRenderer;
import com.mbridge.msdk.playercommon.exoplayer2.video.VideoRendererEventListener;
import java.util.ArrayList;

public class DefaultRenderersFactory
implements RenderersFactory {
    public static final long DEFAULT_ALLOWED_VIDEO_JOINING_TIME_MS = 5000L;
    public static final int EXTENSION_RENDERER_MODE_OFF = 0;
    public static final int EXTENSION_RENDERER_MODE_ON = 1;
    public static final int EXTENSION_RENDERER_MODE_PREFER = 2;
    protected static final int MAX_DROPPED_VIDEO_FRAME_COUNT_TO_NOTIFY = 50;
    private static final String TAG = "DefaultRenderersFactory";
    private final long allowedVideoJoiningTimeMs;
    private final Context context;
    private final DrmSessionManager<FrameworkMediaCrypto> drmSessionManager;
    private final int extensionRendererMode;

    public DefaultRenderersFactory(Context context) {
        this(context, 0);
    }

    public DefaultRenderersFactory(Context context, int n2) {
        this(context, null, n2, 5000L);
    }

    public DefaultRenderersFactory(Context context, int n2, long l2) {
        this(context, null, n2, l2);
    }

    public DefaultRenderersFactory(Context context, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager) {
        this(context, drmSessionManager, 0);
    }

    public DefaultRenderersFactory(Context context, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, int n2) {
        this(context, drmSessionManager, n2, 5000L);
    }

    public DefaultRenderersFactory(Context context, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, int n2, long l2) {
        this.context = context;
        this.extensionRendererMode = n2;
        this.allowedVideoJoiningTimeMs = l2;
        this.drmSessionManager = drmSessionManager;
    }

    protected AudioProcessor[] buildAudioProcessors() {
        return new AudioProcessor[0];
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buildAudioRenderers(Context object, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, AudioProcessor[] audioProcessorArray, Handler handler, AudioRendererEventListener audioRendererEventListener, int n2, ArrayList<Renderer> arrayList) {
        int n3;
        void var3_15;
        void var5_17;
        void var4_16;
        void var7_19;
        block18: {
            int n4;
            block17: {
                int n5;
                void var2_14;
                var7_19.add(new MediaCodecAudioRenderer(object, MediaCodecSelector.DEFAULT, (DrmSessionManager)var2_14, false, (Handler)var4_16, (AudioRendererEventListener)var5_17, AudioCapabilities.getCapabilities((Context)object), (AudioProcessor[])var3_15));
                if (n3 == 0) {
                    return;
                }
                n4 = n5 = var7_19.size();
                if (n3 == 2) {
                    n4 = n5 - 1;
                }
                try {
                    Renderer renderer;
                    try {
                        renderer = (Renderer)Class.forName("com.mbridge.msdk.playercommon.exoplayer2.ext.opus.LibopusAudioRenderer").getConstructor(Handler.class, AudioRendererEventListener.class, AudioProcessor[].class).newInstance(var4_16, var5_17, var3_15);
                        n3 = n4 + 1;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        n3 = n4;
                        break block17;
                    }
                    try {}
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    var7_19.add(n4, renderer);
                    Log.i((String)TAG, (String)"Loaded LibopusAudioRenderer.");
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error instantiating Opus extension", exception);
                }
            }
            try {
                Renderer renderer;
                try {
                    renderer = (Renderer)Class.forName("com.mbridge.msdk.playercommon.exoplayer2.ext.flac.LibflacAudioRenderer").getConstructor(Handler.class, AudioRendererEventListener.class, AudioProcessor[].class).newInstance(var4_16, var5_17, var3_15);
                    n4 = n3 + 1;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                    break block18;
                }
                try {}
                catch (ClassNotFoundException classNotFoundException) {
                    n3 = n4;
                }
                var7_19.add(n3, renderer);
                Log.i((String)TAG, (String)"Loaded LibflacAudioRenderer.");
                n3 = n4;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error instantiating FLAC extension", exception);
            }
        }
        try {
            var7_19.add(n3, (Renderer)Class.forName("com.mbridge.msdk.playercommon.exoplayer2.ext.ffmpeg.FfmpegAudioRenderer").getConstructor(Handler.class, AudioRendererEventListener.class, AudioProcessor[].class).newInstance(var4_16, var5_17, var3_15));
            Log.i((String)TAG, (String)"Loaded FfmpegAudioRenderer.");
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error instantiating FFmpeg extension", exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    protected void buildMetadataRenderers(Context context, MetadataOutput metadataOutput, Looper looper, int n2, ArrayList<Renderer> arrayList) {
        arrayList.add((Renderer)new MetadataRenderer(metadataOutput, looper));
    }

    protected void buildMiscellaneousRenderers(Context context, Handler handler, int n2, ArrayList<Renderer> arrayList) {
    }

    protected void buildTextRenderers(Context context, TextOutput textOutput, Looper looper, int n2, ArrayList<Renderer> arrayList) {
        arrayList.add((Renderer)((Object)new TextRenderer(textOutput, looper)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buildVideoRenderers(Context context, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, long l2, Handler handler, VideoRendererEventListener videoRendererEventListener, int n2, ArrayList<Renderer> arrayList) {
        int n3;
        arrayList.add((Renderer)new MediaCodecVideoRenderer(context, MediaCodecSelector.DEFAULT, l2, drmSessionManager, false, handler, videoRendererEventListener, 50));
        if (n2 == 0) {
            return;
        }
        int n4 = n3 = arrayList.size();
        if (n2 == 2) {
            n4 = n3 - 1;
        }
        try {
            arrayList.add(n4, (Renderer)Class.forName("com.mbridge.msdk.playercommon.exoplayer2.ext.vp9.LibvpxVideoRenderer").getConstructor(Boolean.TYPE, Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE).newInstance(true, l2, handler, videoRendererEventListener, 50));
            Log.i((String)TAG, (String)"Loaded LibvpxVideoRenderer.");
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error instantiating VP9 extension", exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    public Renderer[] createRenderers(Handler handler, VideoRendererEventListener videoRendererEventListener, AudioRendererEventListener audioRendererEventListener, TextOutput textOutput, MetadataOutput metadataOutput, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager) {
        if (drmSessionManager == null) {
            drmSessionManager = this.drmSessionManager;
        }
        ArrayList<Renderer> arrayList = new ArrayList<Renderer>();
        this.buildVideoRenderers(this.context, drmSessionManager, this.allowedVideoJoiningTimeMs, handler, videoRendererEventListener, this.extensionRendererMode, arrayList);
        this.buildAudioRenderers(this.context, drmSessionManager, this.buildAudioProcessors(), handler, audioRendererEventListener, this.extensionRendererMode, arrayList);
        this.buildTextRenderers(this.context, textOutput, handler.getLooper(), this.extensionRendererMode, arrayList);
        this.buildMetadataRenderers(this.context, metadataOutput, handler.getLooper(), this.extensionRendererMode, arrayList);
        this.buildMiscellaneousRenderers(this.context, handler, this.extensionRendererMode, arrayList);
        return arrayList.toArray(new Renderer[arrayList.size()]);
    }

    public static @interface ExtensionRendererMode {
    }
}

