/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.foundation.download.core;

import android.text.TextUtils;
import com.mbridge.msdk.foundation.download.DownloadError;
import com.mbridge.msdk.foundation.download.DownloadMessage;
import com.mbridge.msdk.foundation.download.DownloadProgress;
import com.mbridge.msdk.foundation.download.DownloadResourceType;
import com.mbridge.msdk.foundation.download.DownloadResponse;
import com.mbridge.msdk.foundation.download.DownloadStatus;
import com.mbridge.msdk.foundation.download.core.DownloadRequest;
import com.mbridge.msdk.foundation.download.core.GlobalComponent;
import com.mbridge.msdk.foundation.download.core.IDownloadTask;
import com.mbridge.msdk.foundation.download.database.DownloadModel;
import com.mbridge.msdk.foundation.download.database.IDatabaseHelper;
import com.mbridge.msdk.foundation.download.resource.MBResourceManager;
import com.mbridge.msdk.foundation.download.resource.stream.DownloadFileOutputStream;
import com.mbridge.msdk.foundation.download.utils.Objects;
import com.mbridge.msdk.foundation.download.utils.Utils;
import com.mbridge.msdk.thrid.okhttp.CacheControl;
import com.mbridge.msdk.thrid.okhttp.Call;
import com.mbridge.msdk.thrid.okhttp.Interceptor;
import com.mbridge.msdk.thrid.okhttp.OkHttpClient;
import com.mbridge.msdk.thrid.okhttp.Request;
import com.mbridge.msdk.thrid.okhttp.Response;
import com.mbridge.msdk.thrid.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

class OkHTTPFileDownloadTask
implements IDownloadTask {
    private final IDatabaseHelper databaseHelper;
    private volatile DownloadMessage downloadMessage;
    private DownloadModel downloadModel;
    private final DownloadRequest downloadRequest;
    private DownloadResponse downloadResponse;
    private String etag = "";
    private InputStream inputStream;
    private DownloadFileOutputStream outputStream;
    private ResponseBody responseBody;

    private OkHTTPFileDownloadTask(DownloadRequest downloadRequest, DownloadModel downloadModel, IDatabaseHelper iDatabaseHelper, DownloadMessage downloadMessage) {
        this.downloadRequest = downloadRequest;
        this.downloadModel = downloadModel;
        this.databaseHelper = iDatabaseHelper;
        this.downloadMessage = downloadMessage;
    }

    public static IDownloadTask create(DownloadRequest downloadRequest, DownloadModel downloadModel, IDatabaseHelper iDatabaseHelper, DownloadMessage downloadMessage) {
        return new OkHTTPFileDownloadTask(downloadRequest, downloadModel, iDatabaseHelper, downloadMessage);
    }

    private void handelInputStream(String string2, String string3, String string4, String string5) throws IOException, IllegalAccessException {
        int n2;
        String string6 = string3;
        if (Objects.isNull((Object)this.downloadModel)) {
            this.downloadModel = DownloadModel.create((String)this.downloadRequest.getDownloadId(), (String)this.downloadMessage.getDownloadUrl(), (String)this.downloadMessage.getResourceUrl(), (String)string5, (String)string3, (String)this.downloadMessage.getSaveFileName(), (long)this.downloadRequest.getTotalBytes(), (long)0L, (int)this.downloadMessage.getDownloadRate(), (int)1, (DownloadResourceType)this.downloadMessage.getDownloadResourceType());
            this.databaseHelper.insert(this.downloadModel);
        } else {
            this.downloadModel = DownloadModel.create((String)this.downloadModel.getDownloadId(), (String)this.downloadModel.getDownloadUrl(), (String)this.downloadMessage.getResourceUrl(), (String)this.downloadModel.getEtag(), (String)this.downloadModel.getSaveDirectorPath(), (String)this.downloadModel.getSaveFileName(), (long)this.downloadRequest.getTotalBytes(), (long)this.downloadModel.getDownloadedBytes(), (int)this.downloadMessage.getDownloadRate(), (int)(this.downloadModel.getUsageCounter() + 1), (DownloadResourceType)this.downloadMessage.getDownloadResourceType());
            this.databaseHelper.update(this.downloadModel, string6);
        }
        this.outputStream = MBResourceManager.getInstance().getDownloadFileOutputStream(new File(string6, string2));
        this.outputStream.seek(this.downloadRequest.getDownloadedBytes());
        byte[] byArray = new byte[GlobalComponent.getInstance().getByteBufferSize()];
        string2 = string6;
        while ((n2 = this.inputStream.read(byArray)) != -1) {
            this.outputStream.write(byArray, 0, n2);
            string6 = this.downloadRequest;
            string6.setDownloadedBytes(string6.getDownloadedBytes() + (long)n2);
            this.outputStream.flushAndSync();
            n2 = Utils.getDownloadRate((long)this.downloadRequest.getTotalBytes(), (long)this.downloadRequest.getDownloadedBytes());
            this.sendProgress(this.downloadRequest, this.downloadMessage, this.downloadRequest.getDownloadedBytes(), this.downloadRequest.getTotalBytes(), n2);
            if (this.downloadMessage.getDownloadRate() != 100 && n2 >= this.downloadMessage.getDownloadRate()) break;
            if (this.downloadRequest.getStatus() != DownloadStatus.CANCELLED) continue;
            this.downloadResponse.setCancelled(true);
            break;
        }
        GlobalComponent.getInstance().getDatabaseHelper().updateProgress(string4, string2, DownloadModel.create((String)string4, (String)this.downloadMessage.getDownloadUrl(), (String)this.downloadMessage.getResourceUrl(), (String)string5, (String)string3, (String)this.downloadMessage.getSaveFileName(), (long)this.downloadRequest.getTotalBytes(), (long)this.downloadRequest.getDownloadedBytes(), (int)this.downloadMessage.getDownloadRate(), (int)this.downloadModel.getUsageCounter(), (DownloadResourceType)this.downloadMessage.getDownloadResourceType()));
        if (!this.downloadResponse.isCancelled()) {
            this.downloadResponse.setSuccessful(true);
        }
    }

    private void handlerException(String string2, String string3, String string4, Exception exception) {
        if (Objects.isNotNull((Object)this.databaseHelper)) {
            this.databaseHelper.remove(string4, string3);
        }
        string2 = new DownloadError(exception);
        this.downloadResponse.setError((DownloadError)string2);
        this.downloadResponse.setSuccessful(false);
    }

    private void handlerRequestSuccessful(String string2, String string3, String string4, Response response, int n2) throws IOException, IllegalAccessException {
        boolean bl = this.isSupportResume(n2, this.downloadModel) ^ true;
        if (bl && response != null && this.downloadRequest != null && n2 == 206 && response.body() != null && response.body().contentLength() != this.downloadRequest.getTotalBytes() - this.downloadRequest.getDownloadedBytes()) {
            Object object = GlobalComponent.getInstance().getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u79fb\u9664\uff1a handlerRequestSuccessful\uff1a isSupportResume ");
            stringBuilder.append(bl);
            stringBuilder.append(" etag: ");
            stringBuilder.append(this.etag);
            stringBuilder.append(" etag: ");
            Object object2 = this.downloadModel;
            object2 = object2 == null ? "null" : object2.getEtag();
            stringBuilder.append((String)object2);
            stringBuilder.append(" responseCode: ");
            stringBuilder.append(n2);
            object.log("DownloadTask", stringBuilder.toString());
            this.downloadRequest.setDownloadedBytes(0L);
            this.downloadRequest.setTotalBytes(0L);
            if (Objects.isNotNull((Object)this.databaseHelper)) {
                this.databaseHelper.remove(string4, string3);
            }
            this.downloadModel = null;
            object2 = MBResourceManager.getInstance();
            object = new StringBuilder();
            ((StringBuilder)object).append(this.downloadRequest.getCacheDirectoryPath());
            ((StringBuilder)object).append(this.downloadMessage.getSaveFileName());
            object2.deleteFile(new File(((StringBuilder)object).toString()));
        }
        this.responseBody = response.body();
        if (Objects.isNull((Object)this.responseBody)) {
            string2 = new DownloadError((Exception)new IOException("response body is null"));
            this.downloadResponse.setError((DownloadError)string2);
            this.downloadRequest.setTotalBytes(0L);
            this.downloadRequest.setDownloadedBytes(0L);
            this.downloadResponse.setSuccessful(false);
        } else {
            long l2 = this.responseBody.contentLength();
            if (this.downloadRequest.getTotalBytes() == 0L) {
                this.downloadRequest.setTotalBytes(l2);
            }
            this.inputStream = this.responseBody.byteStream();
            if (Objects.isNotNull((Object)this.inputStream)) {
                this.handelInputStream(string2, string3, string4, this.etag);
            } else {
                string2 = new DownloadError((Exception)new IOException("response inputStream is null"));
                this.downloadResponse.setError((DownloadError)string2);
                this.downloadResponse.setSuccessful(false);
            }
        }
    }

    private boolean isSupportResume(int n2, DownloadModel downloadModel) {
        boolean bl = n2 == 206 && (downloadModel == null || TextUtils.equals((CharSequence)this.etag, (CharSequence)downloadModel.getEtag()));
        return bl;
    }

    private void sendProgress(DownloadRequest downloadRequest, DownloadMessage downloadMessage, long l2, long l3, int n2) {
        if (downloadRequest.getStatus() != DownloadStatus.CANCELLED) {
            downloadRequest.handlerProcessEvent(downloadMessage, new DownloadProgress(l2, l3, n2));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DownloadResponse run() {
        void var5_8;
        Call call2;
        Object object;
        block82: {
            block87: {
                Object object2;
                OkHttpClient okHttpClient;
                String string2;
                String string3;
                String string4;
                block86: {
                    block85: {
                        block84: {
                            block83: {
                                block81: {
                                    this.downloadResponse = new DownloadResponse();
                                    string4 = this.downloadMessage.getSaveFileName();
                                    string3 = this.downloadRequest.getCacheDirectoryPath();
                                    string2 = this.downloadRequest.getDownloadId();
                                    okHttpClient = GlobalComponent.getInstance().getOkHttpClient().newBuilder().connectTimeout(this.downloadRequest.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(this.downloadRequest.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout(this.downloadRequest.getWriteTimeout(), TimeUnit.MILLISECONDS).callTimeout(this.downloadRequest.getTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).addNetworkInterceptor(new Interceptor(){

                                        @Override
                                        public Response intercept(Interceptor.Chain chain) throws IOException {
                                            return chain.proceed(chain.request());
                                        }
                                    }).build();
                                    object2 = new CacheControl.Builder().noCache().build();
                                    object = String.format(Locale.ENGLISH, "bytes=%d-", this.downloadRequest.getDownloadedBytes());
                                    if (this.downloadRequest.getStatus() == DownloadStatus.CANCELLED) {
                                        this.downloadResponse.setCancelled(true);
                                        return this.downloadResponse;
                                    }
                                    call2 = okHttpClient.newCall(new Request.Builder().url(this.downloadMessage.getDownloadUrl()).cacheControl((CacheControl)object2).addHeader("Range", (String)object).build());
                                    object = object2 = call2.execute();
                                    try {
                                        if (!Objects.isNull((Object)object2)) {
                                            object = object2;
                                            if (!Objects.isNull((Object)((Response)object2).body())) {
                                                object = object2;
                                                int n2 = ((Response)object2).code();
                                                object = object2;
                                                if (!((Response)object2).isSuccessful()) {
                                                    object = object2;
                                                    object = object2;
                                                    object = object2;
                                                    object = object2;
                                                    StringBuilder stringBuilder = new StringBuilder();
                                                    object = object2;
                                                    stringBuilder.append("responseCode ");
                                                    object = object2;
                                                    stringBuilder.append(n2);
                                                    object = object2;
                                                    stringBuilder.append("\n");
                                                    object = object2;
                                                    stringBuilder.append(((Response)object2).body().string());
                                                    object = object2;
                                                    IOException iOException = new IOException(stringBuilder.toString());
                                                    object = object2;
                                                    DownloadError downloadError = new DownloadError((Exception)iOException);
                                                    object = object2;
                                                    this.downloadResponse.setError(downloadError);
                                                    object = object2;
                                                    this.downloadResponse.setSuccessful(false);
                                                    break block81;
                                                } else {
                                                    object = object2;
                                                    this.etag = ((Response)object2).header("ETag", "");
                                                    object = object2;
                                                    this.handlerRequestSuccessful(string4, string3, string2, (Response)object2, n2);
                                                }
                                                break block81;
                                            }
                                        }
                                        object = object2;
                                        object = object2;
                                        object = object2;
                                        IOException iOException = new IOException("response is null");
                                        object = object2;
                                        DownloadError downloadError = new DownloadError((Exception)iOException);
                                        object = object2;
                                        this.downloadResponse.setError(downloadError);
                                        object = object2;
                                        this.downloadResponse.setSuccessful(false);
                                    }
                                    catch (Throwable throwable) {
                                        break block82;
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                    }
                                    catch (IOException iOException) {
                                        break block84;
                                    }
                                    catch (UnknownHostException unknownHostException) {
                                        break block85;
                                    }
                                    catch (SocketTimeoutException socketTimeoutException) {
                                        break block86;
                                    }
                                }
                                if (Objects.isNotNull((Object)this.inputStream)) {
                                    try {
                                        this.inputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (Objects.isNotNull((Object)this.outputStream)) {
                                    try {
                                        this.outputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (Objects.isNotNull((Object)object2)) {
                                    try {
                                        ((Response)object2).body().close();
                                        ((Response)object2).close();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                                if (Objects.isNotNull((Object)this.responseBody)) {
                                    this.responseBody.close();
                                }
                                if (call2.isCanceled()) return this.downloadResponse;
                                break block87;
                                catch (Throwable throwable) {
                                    object = null;
                                    break block82;
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    object2 = null;
                                    break block83;
                                }
                                catch (IOException iOException) {
                                    object2 = null;
                                    break block84;
                                }
                                catch (UnknownHostException unknownHostException) {
                                    object2 = null;
                                    break block85;
                                }
                                catch (SocketTimeoutException socketTimeoutException) {
                                    object2 = null;
                                    break block86;
                                }
                            }
                            object = object2;
                            {
                                void var9_35;
                                this.handlerException(string4, string3, string2, (Exception)var9_35);
                            }
                            if (Objects.isNotNull((Object)this.inputStream)) {
                                try {
                                    this.inputStream.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (Objects.isNotNull((Object)this.outputStream)) {
                                try {
                                    this.outputStream.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (Objects.isNotNull((Object)object2)) {
                                try {
                                    ((Response)object2).body().close();
                                    ((Response)object2).close();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            if (Objects.isNotNull((Object)this.responseBody)) {
                                this.responseBody.close();
                            }
                            if (call2.isCanceled()) return this.downloadResponse;
                            break block87;
                        }
                        object = object2;
                        {
                            void var9_37;
                            this.handlerException(string4, string3, string2, (Exception)var9_37);
                        }
                        if (Objects.isNotNull((Object)this.inputStream)) {
                            try {
                                this.inputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (Objects.isNotNull((Object)this.outputStream)) {
                            try {
                                this.outputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (Objects.isNotNull((Object)object2)) {
                            try {
                                ((Response)object2).body().close();
                                ((Response)object2).close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (Objects.isNotNull((Object)this.responseBody)) {
                            this.responseBody.close();
                        }
                        if (call2.isCanceled()) return this.downloadResponse;
                        break block87;
                    }
                    object = object2;
                    {
                        void var9_39;
                        okHttpClient.connectionPool().evictAll();
                        object = object2;
                        this.handlerException(string4, string3, string2, (Exception)var9_39);
                    }
                    if (Objects.isNotNull((Object)this.inputStream)) {
                        try {
                            this.inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (Objects.isNotNull((Object)this.outputStream)) {
                        try {
                            this.outputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (Objects.isNotNull((Object)object2)) {
                        try {
                            ((Response)object2).body().close();
                            ((Response)object2).close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (Objects.isNotNull((Object)this.responseBody)) {
                        this.responseBody.close();
                    }
                    if (call2.isCanceled()) return this.downloadResponse;
                    break block87;
                }
                object = object2;
                {
                    void var9_41;
                    okHttpClient.connectionPool().evictAll();
                    object = object2;
                    this.handlerException(string4, string3, string2, (Exception)var9_41);
                }
                if (Objects.isNotNull((Object)this.inputStream)) {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (Objects.isNotNull((Object)this.outputStream)) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (Objects.isNotNull((Object)object2)) {
                    try {
                        ((Response)object2).body().close();
                        ((Response)object2).close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (Objects.isNotNull((Object)this.responseBody)) {
                    this.responseBody.close();
                }
                if (call2.isCanceled()) return this.downloadResponse;
            }
            call2.cancel();
            return this.downloadResponse;
        }
        if (Objects.isNotNull((Object)this.inputStream)) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (Objects.isNotNull((Object)this.outputStream)) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (Objects.isNotNull((Object)object)) {
            try {
                ((Response)object).body().close();
                ((Response)object).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (Objects.isNotNull((Object)this.responseBody)) {
            this.responseBody.close();
        }
        if (call2.isCanceled()) throw var5_8;
        call2.cancel();
        throw var5_8;
    }
}

