/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.foundation.download.core;

import com.mbridge.msdk.foundation.download.DownloadMessage;
import com.mbridge.msdk.foundation.download.DownloadResponse;
import com.mbridge.msdk.foundation.download.core.DownloadRequest;
import com.mbridge.msdk.foundation.download.core.IDownloadTask;
import com.mbridge.msdk.foundation.download.database.DownloadModel;
import com.mbridge.msdk.foundation.download.database.IDatabaseHelper;
import com.mbridge.msdk.foundation.download.resource.MBResourceManager;
import com.mbridge.msdk.foundation.download.utils.Objects;
import com.mbridge.msdk.foundation.download.utils.Utils;
import java.io.File;

class FindFileFromCache
implements IDownloadTask {
    private final IDatabaseHelper databaseHelper;
    private final String downloadId;
    private DownloadMessage downloadMessage;
    private final DownloadModel downloadModel;
    private final DownloadRequest request;

    private FindFileFromCache(DownloadRequest downloadRequest, DownloadModel downloadModel, IDatabaseHelper iDatabaseHelper, String string2, DownloadMessage downloadMessage) {
        this.request = downloadRequest;
        this.downloadModel = downloadModel;
        this.databaseHelper = iDatabaseHelper;
        this.downloadId = string2;
        this.downloadMessage = downloadMessage;
    }

    static IDownloadTask create(DownloadRequest downloadRequest, DownloadModel downloadModel, IDatabaseHelper iDatabaseHelper, String string2, DownloadMessage downloadMessage) {
        return new FindFileFromCache(downloadRequest, downloadModel, iDatabaseHelper, string2, downloadMessage);
    }

    public DownloadResponse run() {
        if (Objects.isNull((Object)this.downloadModel)) {
            return null;
        }
        DownloadResponse downloadResponse = new DownloadResponse();
        Comparable<StringBuilder> comparable = new StringBuilder();
        ((StringBuilder)comparable).append(this.request.getCacheDirectoryPath());
        ((StringBuilder)comparable).append(this.downloadMessage.getSaveFileName());
        comparable = new File(((StringBuilder)comparable).toString());
        if (((File)comparable).exists()) {
            if (MBResourceManager.getInstance().getFileSize(comparable) == this.downloadModel.getDownloadedBytes()) {
                if (Utils.getDownloadRate((long)this.downloadModel.getTotalBytes(), (long)this.downloadModel.getDownloadedBytes()) >= this.downloadMessage.getDownloadRate()) {
                    this.request.setTotalBytes(this.downloadModel.getTotalBytes());
                    this.request.setDownloadedBytes(this.downloadModel.getDownloadedBytes());
                    downloadResponse.setSuccessful(true);
                } else {
                    this.request.setTotalBytes(this.downloadModel.getTotalBytes());
                    this.request.setDownloadedBytes(this.downloadModel.getDownloadedBytes());
                    downloadResponse.setSuccessful(false);
                }
            } else {
                this.request.setDownloadedBytes(0L);
                this.databaseHelper.remove(this.downloadId);
                MBResourceManager.getInstance().deleteFile(comparable);
                downloadResponse.setSuccessful(false);
            }
        } else {
            this.request.setDownloadedBytes(0L);
            this.databaseHelper.remove(this.downloadId);
            MBResourceManager.getInstance().deleteFile(comparable);
            downloadResponse.setSuccessful(false);
        }
        return downloadResponse;
    }
}

