/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import com.google.zxing.oned.UPCEReader;
import java.util.Map;

public final class UPCEWriter
extends UPCEANWriter {
    private static final int CODE_WIDTH = 51;

    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.UPC_E) {
            return super.encode(string2, barcodeFormat, n2, n3, map);
        }
        throw new IllegalArgumentException("Can only encode UPC_E, but got ".concat(String.valueOf(barcodeFormat)));
    }

    public boolean[] encode(String object) {
        Object object2;
        int n2;
        block10: {
            n2 = ((String)object).length();
            if (n2 != 7) {
                if (n2 == 8) {
                    try {
                        if (!UPCEANReader.checkStandardUPCEANChecksum((CharSequence)object)) {
                            object = new IllegalArgumentException("Contents do not pass checksum");
                            throw object;
                        }
                        break block10;
                    }
                    catch (FormatException formatException) {
                        throw new IllegalArgumentException("Illegal contents");
                    }
                }
                throw new IllegalArgumentException("Requested contents should be 8 digits long, but got ".concat(String.valueOf(n2)));
            }
            try {
                n2 = UPCEANReader.getStandardUPCEANChecksum((CharSequence)UPCEReader.convertUPCEtoUPCA((String)object));
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
            }
            catch (FormatException formatException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException((Throwable)((Object)formatException));
                throw illegalArgumentException;
            }
            ((StringBuilder)object2).append(n2);
            object = ((StringBuilder)object2).toString();
        }
        n2 = Character.digit(((String)object).charAt(0), 10);
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Number system must be 0 or 1");
        }
        int n3 = Character.digit(((String)object).charAt(7), 10);
        int n4 = UPCEReader.NUMSYS_AND_CHECK_DIGIT_PATTERNS[n2][n3];
        object2 = new boolean[51];
        n3 = UPCEWriter.appendPattern((boolean[])object2, (int)0, (int[])UPCEANReader.START_END_PATTERN, (boolean)true) + 0;
        for (n2 = 1; n2 <= 6; ++n2) {
            int n5;
            int n6 = n5 = Character.digit(((String)object).charAt(n2), 10);
            if ((n4 >> 6 - n2 & 1) == 1) {
                n6 = n5 + 10;
            }
            n3 += UPCEWriter.appendPattern((boolean[])object2, (int)n3, (int[])UPCEANReader.L_AND_G_PATTERNS[n6], (boolean)false);
        }
        UPCEWriter.appendPattern((boolean[])object2, (int)n3, (int[])UPCEANReader.END_PATTERN, (boolean)false);
        return object2;
    }
}

