/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;

public class JsonReader
implements Closeable {
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_EOF = 17;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private final char[] buffer = new char[1024];
    private final Reader in;
    private boolean lenient = false;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    private int[] pathIndices;
    private String[] pathNames;
    int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int pos = 0;
    private int[] stack = new int[32];
    private int stackSize = 0;

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            public void promoteNameToValue(JsonReader jsonReader) throws IOException {
                block8: {
                    block6: {
                        int n2;
                        block7: {
                            block5: {
                                int n3;
                                if (jsonReader instanceof JsonTreeReader) {
                                    ((JsonTreeReader)jsonReader).promoteNameToValue();
                                    return;
                                }
                                n2 = n3 = jsonReader.peeked;
                                if (n3 == 0) {
                                    n2 = jsonReader.doPeek();
                                }
                                if (n2 != 13) break block5;
                                jsonReader.peeked = 9;
                                break block6;
                            }
                            if (n2 != 12) break block7;
                            jsonReader.peeked = 8;
                            break block6;
                        }
                        if (n2 != 14) break block8;
                        jsonReader.peeked = 10;
                    }
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected a name but was ");
                stringBuilder.append(jsonReader.peek());
                stringBuilder.append(jsonReader.locationString());
                throw new IllegalStateException(stringBuilder.toString());
            }
        };
    }

    public JsonReader(Reader reader) {
        int[] nArray = this.stack;
        int n2 = this.stackSize;
        this.stackSize = n2 + 1;
        nArray[n2] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        if (reader != null) {
            this.in = reader;
            return;
        }
        throw new NullPointerException("in == null");
    }

    private void checkLenient() throws IOException {
        if (this.lenient) {
            return;
        }
        throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
    }

    private void consumeNonExecutePrefix() throws IOException {
        this.nextNonWhitespace(true);
        --this.pos;
        int n2 = this.pos;
        char[] cArray = NON_EXECUTE_PREFIX;
        if (n2 + cArray.length > this.limit && !this.fillBuffer(cArray.length)) {
            return;
        }
        for (n2 = 0; n2 < (cArray = NON_EXECUTE_PREFIX).length; ++n2) {
            if (this.buffer[this.pos + n2] == cArray[n2]) continue;
            return;
        }
        this.pos += cArray.length;
    }

    private boolean fillBuffer(int n2) throws IOException {
        block7: {
            char[] cArray = this.buffer;
            int n3 = this.lineStart;
            int n4 = this.pos;
            this.lineStart = n3 - n4;
            n3 = this.limit;
            if (n3 != n4) {
                this.limit = n3 - n4;
                System.arraycopy(cArray, n4, cArray, 0, this.limit);
            } else {
                this.limit = 0;
            }
            this.pos = 0;
            do {
                Reader reader = this.in;
                n4 = this.limit;
                if ((n4 = reader.read(cArray, n4, cArray.length - n4)) == -1) break block7;
                this.limit += n4;
                n4 = n2;
                if (this.lineNumber == 0) {
                    n3 = this.lineStart;
                    n4 = n2;
                    if (n3 == 0) {
                        n4 = n2;
                        if (this.limit > 0) {
                            n4 = n2;
                            if (cArray[0] == '\ufeff') {
                                ++this.pos;
                                this.lineStart = n3 + 1;
                                n4 = n2 + 1;
                            }
                        }
                    }
                }
                n2 = n4;
            } while (this.limit < n4);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isLiteral(char var1_1) throws IOException {
        block4: {
            if (var1_1 == '\t' || var1_1 == '\n' || var1_1 == '\f' || var1_1 == '\r' || var1_1 == ' ') break block4;
            if (var1_1 == '#') ** GOTO lbl-1000
            if (var1_1 == ',') break block4;
            if (var1_1 == '/' || var1_1 == '=') ** GOTO lbl-1000
            if (var1_1 == '{' || var1_1 == '}' || var1_1 == ':') break block4;
            if (var1_1 == ';') ** GOTO lbl-1000
            switch (var1_1) {
                default: {
                    return true;
                }
                case '\\': lbl-1000:
                // 4 sources

                {
                    this.checkLenient();
                }
                case '[': 
                case ']': 
            }
        }
        return false;
    }

    private int nextNonWhitespace(boolean bl) throws IOException {
        Object object = this.buffer;
        Object object2 = this.pos;
        int n2 = this.limit;
        while (true) {
            int n3 = object2;
            int n4 = n2;
            if (object2 == n2) {
                this.pos = object2;
                if (!this.fillBuffer(1)) {
                    if (!bl) {
                        return -1;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("End of input");
                    ((StringBuilder)object).append(this.locationString());
                    throw new EOFException(((StringBuilder)object).toString());
                }
                n3 = this.pos;
                n4 = this.limit;
            }
            object2 = n3 + 1;
            n2 = object[n3];
            if (n2 == 10) {
                ++this.lineNumber;
                this.lineStart = object2;
            } else if (n2 != 32 && n2 != 13 && n2 != 9) {
                if (n2 == 47) {
                    this.pos = object2;
                    if (object2 == n4) {
                        --this.pos;
                        boolean bl2 = this.fillBuffer(2);
                        ++this.pos;
                        if (!bl2) {
                            return n2;
                        }
                    }
                    this.checkLenient();
                    n4 = this.pos;
                    object2 = object[n4];
                    if (object2 != 42) {
                        if (object2 != 47) {
                            return n2;
                        }
                        this.pos = n4 + 1;
                        this.skipToEndOfLine();
                        object2 = this.pos;
                        n2 = this.limit;
                        continue;
                    }
                    this.pos = n4 + 1;
                    if (this.skipTo("*/")) {
                        object2 = this.pos + 2;
                        n2 = this.limit;
                        continue;
                    }
                    throw this.syntaxError("Unterminated comment");
                }
                if (n2 == 35) {
                    this.pos = object2;
                    this.checkLenient();
                    this.skipToEndOfLine();
                    object2 = this.pos;
                    n2 = this.limit;
                    continue;
                }
                this.pos = object2;
                return n2;
            }
            n2 = n4;
        }
    }

    private String nextQuotedValue(char c2) throws IOException {
        char[] cArray = this.buffer;
        Serializable serializable = null;
        while (true) {
            StringBuilder stringBuilder;
            int n2;
            int n3 = this.pos;
            int n4 = this.limit;
            block1: while (true) {
                int n5 = n3;
                while ((n2 = n5) < n4) {
                    n5 = n2 + 1;
                    if ((n2 = cArray[n2]) == c2) {
                        this.pos = n5;
                        c2 = (char)(n5 - n3 - 1);
                        if (serializable == null) {
                            return new String(cArray, n3, (int)c2);
                        }
                        ((StringBuilder)serializable).append(cArray, n3, c2);
                        return ((StringBuilder)serializable).toString();
                    }
                    if (n2 == 92) {
                        this.pos = n5;
                        n5 = n5 - n3 - 1;
                        stringBuilder = serializable;
                        if (serializable == null) {
                            stringBuilder = new StringBuilder(Math.max((n5 + 1) * 2, 16));
                        }
                        stringBuilder.append(cArray, n3, n5);
                        stringBuilder.append(this.readEscapeCharacter());
                        n3 = this.pos;
                        n4 = this.limit;
                        serializable = stringBuilder;
                        continue block1;
                    }
                    if (n2 != 10) continue;
                    ++this.lineNumber;
                    this.lineStart = n5;
                }
                break;
            }
            stringBuilder = serializable;
            if (serializable == null) {
                stringBuilder = new StringBuilder(Math.max((n2 - n3) * 2, 16));
            }
            stringBuilder.append(cArray, n3, n2 - n3);
            this.pos = n2;
            if (!this.fillBuffer(1)) break;
            serializable = stringBuilder;
        }
        serializable = this.syntaxError("Unterminated string");
        throw serializable;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private String nextUnquotedValue() throws IOException {
        block11: {
            var1_1 = 0;
            var2_2 /* !! */  = null;
            do {
                block10: {
                    var3_3 = 0;
                    block5: while (true) {
                        if ((var4_4 = this.pos) + var3_3 >= this.limit) ** GOTO lbl20
                        if ((var4_4 = this.buffer[var4_4 + var3_3]) == 9 || var4_4 == 10 || var4_4 == 12 || var4_4 == 13 || var4_4 == 32) break;
                        if (var4_4 == 35) ** GOTO lbl-1000
                        if (var4_4 == 44) break;
                        if (var4_4 == 47 || var4_4 == 61) ** GOTO lbl-1000
                        if (var4_4 == 123 || var4_4 == 125 || var4_4 == 58) break;
                        if (var4_4 == 59) ** GOTO lbl-1000
                        switch (var4_4) {
                            default: {
                                ++var3_3;
                                continue block5;
                            }
                            case 92: lbl-1000:
                            // 4 sources

                            {
                                this.checkLenient();
                                break block5;
                            }
lbl20:
                            // 1 sources

                            if (var3_3 < this.buffer.length) {
                                if (!this.fillBuffer(var3_3 + 1)) break block5;
                                continue block5;
                            }
                            break block10;
                            case 91: 
                            case 93: 
                        }
                        break;
                    }
                    var5_5 = var2_2 /* !! */ ;
                    break block11;
                }
                var5_5 = var2_2 /* !! */ ;
                if (var2_2 /* !! */  == null) {
                    var5_5 = new StringBuilder(Math.max(var3_3, 16));
                }
                var5_5.append(this.buffer, this.pos, var3_3);
                this.pos += var3_3;
                var2_2 /* !! */  = var5_5;
            } while (this.fillBuffer(1));
            var3_3 = var1_1;
        }
        if (var5_5 == null) {
            var5_5 = new String(this.buffer, this.pos, var3_3);
        } else {
            var5_5.append(this.buffer, this.pos, var3_3);
            var5_5 = var5_5.toString();
        }
        this.pos += var3_3;
        return var5_5;
    }

    private int peekKeyword() throws IOException {
        String string2;
        String string3;
        int n2 = this.buffer[this.pos];
        if (n2 != 116 && n2 != 84) {
            if (n2 != 102 && n2 != 70) {
                if (n2 != 110 && n2 != 78) {
                    return 0;
                }
                n2 = 7;
                string3 = "null";
                string2 = "NULL";
            } else {
                n2 = 6;
                string3 = "false";
                string2 = "FALSE";
            }
        } else {
            n2 = 5;
            string3 = "true";
            string2 = "TRUE";
        }
        int n3 = string3.length();
        for (int i2 = 1; i2 < n3; ++i2) {
            if (this.pos + i2 >= this.limit && !this.fillBuffer(i2 + 1)) {
                return 0;
            }
            char c2 = this.buffer[this.pos + i2];
            if (c2 == string3.charAt(i2) || c2 == string2.charAt(i2)) continue;
            return 0;
        }
        if ((this.pos + n3 < this.limit || this.fillBuffer(n3 + 1)) && this.isLiteral(this.buffer[this.pos + n3])) {
            return 0;
        }
        this.pos += n3;
        this.peeked = n2;
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    private int peekNumber() throws IOException {
        var1_1 = this.buffer;
        var2_2 = this.pos;
        var3_3 = this.limit;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 1;
        var7_7 = 0L;
        var9_8 = false;
        while (true) {
            block25: {
                block29: {
                    block17: {
                        block18: {
                            block28: {
                                block19: {
                                    block27: {
                                        block20: {
                                            block26: {
                                                block16: {
                                                    block21: {
                                                        block22: {
                                                            block24: {
                                                                block23: {
                                                                    block15: {
                                                                        var10_9 = var2_2;
                                                                        var11_10 = var3_3;
                                                                        if (var2_2 + var4_4 != var3_3) break block15;
                                                                        if (var4_4 == var1_1.length) {
                                                                            return 0;
                                                                        }
                                                                        if (!this.fillBuffer(var4_4 + 1)) break block16;
                                                                        var10_9 = this.pos;
                                                                        var11_10 = this.limit;
                                                                    }
                                                                    if ((var12_11 = var1_1[var10_9 + var4_4]) == '+') break block17;
                                                                    if (var12_11 == 'E' || var12_11 == 'e') break block18;
                                                                    if (var12_11 == '-') break block19;
                                                                    if (var12_11 == '.') break block20;
                                                                    if (var12_11 < '0' || var12_11 > '9') break block21;
                                                                    if (var5_5 == 1 || var5_5 == 0) break block22;
                                                                    if (var5_5 != 2) break block23;
                                                                    if (var7_7 == 0L) {
                                                                        return 0;
                                                                    }
                                                                    var13_12 = 10L * var7_7 - (long)(var12_11 - 48);
                                                                    var3_3 = var7_7 <= -922337203685477580L && (var7_7 != -922337203685477580L || var13_12 >= var7_7) ? 0 : 1;
                                                                    var3_3 &= var6_6;
                                                                    ** GOTO lbl-1000
                                                                }
                                                                if (var5_5 != 3) break block24;
                                                                var5_5 = 4;
                                                                break block25;
                                                            }
                                                            if (var5_5 != 5) {
                                                                var3_3 = var6_6;
                                                                var13_12 = var7_7;
                                                                ** if (var5_5 == 6) goto lbl-1000
                                                            }
                                                            ** GOTO lbl-1000
lbl-1000:
                                                            // 2 sources

                                                            {
                                                                var6_6 = var3_3;
                                                                var7_7 = var13_12;
                                                                ** GOTO lbl92
                                                            }
lbl-1000:
                                                            // 2 sources

                                                            {
                                                                var5_5 = 7;
                                                            }
                                                            break block25;
                                                        }
                                                        var7_7 = -(var12_11 - 48);
                                                        var5_5 = 2;
                                                        break block25;
                                                    }
                                                    if (this.isLiteral(var12_11)) break block26;
                                                }
                                                if (!(var5_5 != 2 || var6_6 == 0 || var7_7 == -9223372036854775808L && !var9_8 || var7_7 == 0L && var9_8)) {
                                                    if (!var9_8) {
                                                        var7_7 = -var7_7;
                                                    }
                                                    this.peekedLong = var7_7;
                                                    this.pos += var4_4;
                                                    this.peeked = 15;
                                                    return 15;
                                                }
                                                if (var5_5 != 2 && var5_5 != 4 && var5_5 != 7) {
                                                    return 0;
                                                }
                                                this.peekedNumberLength = var4_4;
                                                this.peeked = 16;
                                                return 16;
                                            }
                                            return 0;
                                        }
                                        if (var5_5 != 2) break block27;
                                        var5_5 = 3;
                                        break block25;
                                    }
                                    return 0;
                                }
                                if (var5_5 != 0) break block28;
                                var5_5 = 1;
                                var9_8 = true;
                                break block25;
                            }
                            if (var5_5 != 5) {
                                return 0;
                            }
                            break block29;
                        }
                        if (var5_5 != 2 && var5_5 != 4) {
                            return 0;
                        }
                        var5_5 = 5;
                        break block25;
                    }
                    if (var5_5 != 5) break;
                }
                var5_5 = 6;
            }
            ++var4_4;
            var2_2 = var10_9;
            var3_3 = var11_10;
        }
        return 0;
    }

    private void push(int n2) {
        Object[] objectArray;
        int n3 = this.stackSize;
        int[] nArray = this.stack;
        if (n3 == nArray.length) {
            int[] nArray2 = new int[n3 * 2];
            int[] nArray3 = new int[n3 * 2];
            objectArray = new String[n3 * 2];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            System.arraycopy(this.pathIndices, 0, nArray3, 0, this.stackSize);
            System.arraycopy(this.pathNames, 0, objectArray, 0, this.stackSize);
            this.stack = nArray2;
            this.pathIndices = nArray3;
            this.pathNames = (String[])objectArray;
        }
        objectArray = this.stack;
        n3 = this.stackSize;
        this.stackSize = n3 + 1;
        objectArray[n3] = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private char readEscapeCharacter() throws IOException {
        int n2;
        int n3;
        int n4;
        Object object;
        block16: {
            block15: {
                block14: {
                    if (this.pos == this.limit && !this.fillBuffer(1)) {
                        throw this.syntaxError("Unterminated escape sequence");
                    }
                    object = this.buffer;
                    n4 = this.pos;
                    this.pos = n4 + 1;
                    n3 = object[n4];
                    if (n3 == 10) break block14;
                    if (n3 == 34 || n3 == 39 || n3 == 47 || n3 == 92) break block15;
                    if (n3 == 98) {
                        return '\b';
                    }
                    if (n3 == 102) {
                        return '\f';
                    }
                    if (n3 == 110) {
                        return '\n';
                    }
                    if (n3 == 114) {
                        return '\r';
                    }
                    if (n3 == 116) {
                        return '\t';
                    }
                    if (n3 != 117) {
                        throw this.syntaxError("Invalid escape sequence");
                    }
                    if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                        throw this.syntaxError("Unterminated escape sequence");
                    }
                    break block16;
                }
                ++this.lineNumber;
                this.lineStart = this.pos;
            }
            return (char)n3;
        }
        int n5 = 0;
        n4 = n2 = this.pos;
        n3 = n5;
        while (true) {
            if ((n5 = n4) >= n2 + 4) {
                this.pos += 4;
                return (char)n3;
            }
            n4 = this.buffer[n5];
            char c2 = (char)(n3 << 4);
            if (n4 >= 48 && n4 <= 57) {
                n4 -= 48;
            } else {
                if (n4 >= 97 && n4 <= 102) {
                    n4 -= 97;
                } else {
                    if (n4 < 65 || n4 > 70) break;
                    n4 -= 65;
                }
                n4 += 10;
            }
            c2 = (char)(c2 + n4);
            n4 = n5 + 1;
            n3 = c2;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("\\u");
        ((StringBuilder)object).append(new String(this.buffer, this.pos, 4));
        throw new NumberFormatException(((StringBuilder)object).toString());
    }

    private void skipQuotedValue(char c2) throws IOException {
        Object object = this.buffer;
        do {
            int n2 = this.pos;
            int n3 = this.limit;
            while (n2 < n3) {
                int n4 = n2 + 1;
                if ((n2 = object[n2]) == c2) {
                    this.pos = n4;
                    return;
                }
                if (n2 == 92) {
                    this.pos = n4;
                    this.readEscapeCharacter();
                    n2 = this.pos;
                    n3 = this.limit;
                    continue;
                }
                if (n2 == 10) {
                    ++this.lineNumber;
                    this.lineStart = n4;
                }
                n2 = n4;
            }
            this.pos = n2;
        } while (this.fillBuffer(1));
        object = this.syntaxError("Unterminated string");
        throw object;
    }

    /*
     * Unable to fully structure code
     */
    private boolean skipTo(String var1_1) throws IOException {
        var2_2 = var1_1.length();
        block0: while (true) {
            block3: {
                var3_3 = this.pos;
                var4_4 = this.limit;
                if (var3_3 + var2_2 > var4_4 && !this.fillBuffer(var2_2)) {
                    return false;
                }
                var6_6 = this.buffer;
                var3_3 = this.pos;
                if (var6_6[var3_3] != '\n') break block3;
                ++this.lineNumber;
                this.lineStart = var3_3 + 1;
                ** GOTO lbl16
            }
            for (var5_5 = 0; var5_5 < var2_2; ++var5_5) {
                if (this.buffer[this.pos + var5_5] == var1_1.charAt(var5_5)) continue;
lbl16:
                // 2 sources

                ++this.pos;
                continue block0;
            }
            break;
        }
        return true;
    }

    private void skipToEndOfLine() throws IOException {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char[] cArray = this.buffer;
            int n2 = this.pos;
            this.pos = n2 + 1;
            if ((n2 = cArray[n2]) == 10) {
                ++this.lineNumber;
                this.lineStart = this.pos;
                break;
            }
            if (n2 != 13) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void skipUnquotedValue() throws IOException {
        do {
            var1_1 = 0;
            block5: while ((var2_2 = this.pos) + var1_1 < this.limit) {
                block6: {
                    if ((var2_2 = this.buffer[var2_2 + var1_1]) == 9 || var2_2 == 10 || var2_2 == 12 || var2_2 == 13 || var2_2 == 32) break block6;
                    if (var2_2 == 35) ** GOTO lbl-1000
                    if (var2_2 == 44) break block6;
                    if (var2_2 == 47 || var2_2 == 61) ** GOTO lbl-1000
                    if (var2_2 == 123 || var2_2 == 125 || var2_2 == 58) break block6;
                    if (var2_2 == 59) ** GOTO lbl-1000
                    switch (var2_2) {
                        default: {
                            ++var1_1;
                            continue block5;
                        }
                        case 92: lbl-1000:
                        // 4 sources

                        {
                            this.checkLenient();
                        }
                        case 91: 
                        case 93: 
                    }
                }
                this.pos += var1_1;
                return;
            }
            this.pos = var2_2 + var1_1;
        } while (this.fillBuffer(1));
    }

    private IOException syntaxError(String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(this.locationString());
        throw new MalformedJsonException(stringBuilder.toString());
    }

    public void beginArray() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        if (n3 == 3) {
            this.push(1);
            this.pathIndices[this.stackSize - 1] = 0;
            this.peeked = 0;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected BEGIN_ARRAY but was ");
        stringBuilder.append(this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void beginObject() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        if (n3 == 1) {
            this.push(3);
            this.peeked = 0;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected BEGIN_OBJECT but was ");
        stringBuilder.append(this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    int doPeek() throws IOException {
        int n2;
        int n3;
        block32: {
            block37: {
                block30: {
                    block36: {
                        block35: {
                            block33: {
                                block34: {
                                    Object[] objectArray;
                                    block31: {
                                        block29: {
                                            objectArray = this.stack;
                                            n3 = this.stackSize;
                                            n2 = objectArray[n3 - 1];
                                            if (n2 != 1) break block29;
                                            objectArray[n3 - 1] = 2;
                                            break block30;
                                        }
                                        if (n2 != 2) break block31;
                                        n3 = this.nextNonWhitespace(true);
                                        if (n3 != 44) {
                                            if (n3 != 59) {
                                                if (n3 == 93) {
                                                    this.peeked = 4;
                                                    return 4;
                                                }
                                                throw this.syntaxError("Unterminated array");
                                            }
                                            this.checkLenient();
                                        }
                                        break block30;
                                    }
                                    if (n2 == 3 || n2 == 5) break block32;
                                    if (n2 != 4) break block33;
                                    objectArray[n3 - 1] = 5;
                                    n3 = this.nextNonWhitespace(true);
                                    if (n3 == 58) break block30;
                                    if (n3 != 61) break block34;
                                    this.checkLenient();
                                    if ((this.pos < this.limit || this.fillBuffer(1)) && (objectArray = (Object[])this.buffer)[n3 = this.pos] == 62) {
                                        this.pos = n3 + 1;
                                    }
                                    break block30;
                                }
                                throw this.syntaxError("Expected ':'");
                            }
                            if (n2 != 6) break block35;
                            if (this.lenient) {
                                this.consumeNonExecutePrefix();
                            }
                            this.stack[this.stackSize - 1] = 7;
                            break block30;
                        }
                        if (n2 != 7) break block36;
                        if (this.nextNonWhitespace(false) == -1) {
                            this.peeked = 17;
                            return 17;
                        }
                        this.checkLenient();
                        --this.pos;
                        break block30;
                    }
                    if (n2 == 8) break block37;
                }
                n3 = this.nextNonWhitespace(true);
                if (n3 != 34) {
                    if (n3 != 39) {
                        if (n3 != 44 && n3 != 59) {
                            if (n3 != 91) {
                                if (n3 != 93) {
                                    if (n3 != 123) {
                                        --this.pos;
                                        n2 = this.peekKeyword();
                                        if (n2 != 0) {
                                            return n2;
                                        }
                                        n2 = this.peekNumber();
                                        if (n2 != 0) {
                                            return n2;
                                        }
                                        if (this.isLiteral(this.buffer[this.pos])) {
                                            this.checkLenient();
                                            this.peeked = 10;
                                            return 10;
                                        }
                                        throw this.syntaxError("Expected value");
                                    }
                                    this.peeked = 1;
                                    return 1;
                                }
                                if (n2 == 1) {
                                    this.peeked = 4;
                                    return 4;
                                }
                            } else {
                                this.peeked = 3;
                                return 3;
                            }
                        }
                        if (n2 != 1 && n2 != 2) {
                            throw this.syntaxError("Unexpected value");
                        }
                        this.checkLenient();
                        --this.pos;
                        this.peeked = 7;
                        return 7;
                    }
                    this.checkLenient();
                    this.peeked = 8;
                    return 8;
                }
                this.peeked = 9;
                return 9;
            }
            throw new IllegalStateException("JsonReader is closed");
        }
        this.stack[this.stackSize - 1] = 4;
        if (n2 == 5 && (n3 = this.nextNonWhitespace(true)) != 44) {
            if (n3 != 59) {
                if (n3 == 125) {
                    this.peeked = 2;
                    return 2;
                }
                throw this.syntaxError("Unterminated object");
            }
            this.checkLenient();
        }
        if ((n3 = this.nextNonWhitespace(true)) != 34) {
            if (n3 != 39) {
                if (n3 != 125) {
                    this.checkLenient();
                    --this.pos;
                    if (this.isLiteral((char)n3)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.syntaxError("Expected name");
                }
                if (n2 != 5) {
                    this.peeked = 2;
                    return 2;
                }
                throw this.syntaxError("Expected name");
            }
            this.checkLenient();
            this.peeked = 12;
            return 12;
        }
        this.peeked = 13;
        return 13;
    }

    public void endArray() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        if (n3 == 4) {
            --this.stackSize;
            int[] nArray = this.pathIndices;
            n3 = this.stackSize - 1;
            nArray[n3] = nArray[n3] + 1;
            this.peeked = 0;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected END_ARRAY but was ");
        stringBuilder.append(this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void endObject() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        if (n3 == 2) {
            --this.stackSize;
            Object[] objectArray = this.pathNames;
            n3 = this.stackSize;
            objectArray[n3] = null;
            objectArray = this.pathIndices;
            objectArray[--n3] = objectArray[n3] + true;
            this.peeked = 0;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected END_OBJECT but was ");
        stringBuilder.append(this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('$');
        int n2 = this.stackSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.stack[i2];
            if (n3 != 1 && n3 != 2) {
                if (n3 != 3 && n3 != 4 && n3 != 5) continue;
                stringBuilder.append('.');
                String[] stringArray = this.pathNames;
                if (stringArray[i2] == null) continue;
                stringBuilder.append(stringArray[i2]);
                continue;
            }
            stringBuilder.append('[');
            stringBuilder.append(this.pathIndices[i2]);
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public boolean hasNext() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        boolean bl = n3 != 2 && n3 != 4;
        return bl;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    String locationString() {
        int n2 = this.lineNumber;
        int n3 = this.pos;
        int n4 = this.lineStart;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" at line ");
        stringBuilder.append(n2 + 1);
        stringBuilder.append(" column ");
        stringBuilder.append(n3 - n4 + 1);
        stringBuilder.append(" path ");
        stringBuilder.append(this.getPath());
        return stringBuilder.toString();
    }

    public boolean nextBoolean() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        if (n3 == 5) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n3 = this.stackSize - 1;
            nArray[n3] = nArray[n3] + 1;
            return true;
        }
        if (n3 == 6) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n3 = this.stackSize - 1;
            nArray[n3] = nArray[n3] + 1;
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a boolean but was ");
        stringBuilder.append(this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public double nextDouble() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        if (n3 == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n3 = this.stackSize - 1;
            nArray[n3] = nArray[n3] + 1;
            return this.peekedLong;
        }
        if (n3 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n3 != 8 && n3 != 9) {
            if (n3 == 10) {
                this.peekedString = this.nextUnquotedValue();
            } else if (n3 != 11) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected a double but was ");
                stringBuilder.append(this.peek());
                stringBuilder.append(this.locationString());
                throw new IllegalStateException(stringBuilder.toString());
            }
        } else {
            int n4 = n3 == 8 ? (n3 = 39) : (n3 = 34);
            this.peekedString = this.nextQuotedValue((char)n4);
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        if (!this.lenient && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSON forbids NaN and infinities: ");
            stringBuilder.append(d2);
            stringBuilder.append(this.locationString());
            throw new MalformedJsonException(stringBuilder.toString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        n3 = this.stackSize - 1;
        nArray[n3] = nArray[n3] + 1;
        return d2;
    }

    public int nextInt() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        if (n3 == 15) {
            long l2 = this.peekedLong;
            n2 = (int)l2;
            if (l2 == (long)n2) {
                this.peeked = 0;
                int[] nArray = this.pathIndices;
                n3 = this.stackSize - 1;
                nArray[n3] = nArray[n3] + 1;
                return n2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Expected an int but was ");
            stringBuilder.append(this.peekedLong);
            stringBuilder.append(this.locationString());
            throw new NumberFormatException(stringBuilder.toString());
        }
        if (n3 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            int[] nArray;
            if (n3 != 8 && n3 != 9 && n3 != 10) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected an int but was ");
                stringBuilder.append(this.peek());
                stringBuilder.append(this.locationString());
                throw new IllegalStateException(stringBuilder.toString());
            }
            if (n3 == 10) {
                this.peekedString = this.nextUnquotedValue();
            } else {
                int n4 = n3 == 8 ? (n3 = 39) : (n3 = 34);
                this.peekedString = this.nextQuotedValue((char)n4);
            }
            try {
                n2 = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                nArray = this.pathIndices;
                n3 = this.stackSize - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            nArray[n3] = nArray[n3] + 1;
            return n2;
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        n2 = (int)d2;
        if ((double)n2 == d2) {
            this.peekedString = null;
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n3 = this.stackSize - 1;
            nArray[n3] = nArray[n3] + 1;
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected an int but was ");
        stringBuilder.append(this.peekedString);
        stringBuilder.append(this.locationString());
        throw new NumberFormatException(stringBuilder.toString());
    }

    public long nextLong() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        if (n3 == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n3 = this.stackSize - 1;
            nArray[n3] = nArray[n3] + 1;
            return this.peekedLong;
        }
        if (n3 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            int[] nArray;
            long l2;
            if (n3 != 8 && n3 != 9 && n3 != 10) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected a long but was ");
                stringBuilder.append(this.peek());
                stringBuilder.append(this.locationString());
                throw new IllegalStateException(stringBuilder.toString());
            }
            if (n3 == 10) {
                this.peekedString = this.nextUnquotedValue();
            } else {
                int n4 = n3 == 8 ? (n3 = 39) : (n3 = 34);
                this.peekedString = this.nextQuotedValue((char)n4);
            }
            try {
                l2 = Long.parseLong(this.peekedString);
                this.peeked = 0;
                nArray = this.pathIndices;
                n3 = this.stackSize - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            nArray[n3] = nArray[n3] + 1;
            return l2;
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        long l3 = (long)d2;
        if ((double)l3 == d2) {
            this.peekedString = null;
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n3 = this.stackSize - 1;
            nArray[n3] = nArray[n3] + 1;
            return l3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a long but was ");
        stringBuilder.append(this.peekedString);
        stringBuilder.append(this.locationString());
        throw new NumberFormatException(stringBuilder.toString());
    }

    public String nextName() throws IOException {
        block7: {
            String string2;
            block5: {
                int n2;
                block6: {
                    block4: {
                        int n3;
                        n2 = n3 = this.peeked;
                        if (n3 == 0) {
                            n2 = this.doPeek();
                        }
                        if (n2 != 14) break block4;
                        string2 = this.nextUnquotedValue();
                        break block5;
                    }
                    if (n2 != 12) break block6;
                    string2 = this.nextQuotedValue('\'');
                    break block5;
                }
                if (n2 != 13) break block7;
                string2 = this.nextQuotedValue('\"');
            }
            this.peeked = 0;
            this.pathNames[this.stackSize - 1] = string2;
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a name but was ");
        stringBuilder.append(this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void nextNull() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        if (n3 == 7) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n3 = this.stackSize - 1;
            nArray[n3] = nArray[n3] + 1;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected null but was ");
        stringBuilder.append(this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public String nextString() throws IOException {
        block10: {
            String string2;
            int n2;
            block5: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    int n3;
                                    n2 = n3 = this.peeked;
                                    if (n3 == 0) {
                                        n2 = this.doPeek();
                                    }
                                    if (n2 != 10) break block4;
                                    string2 = this.nextUnquotedValue();
                                    break block5;
                                }
                                if (n2 != 8) break block6;
                                string2 = this.nextQuotedValue('\'');
                                break block5;
                            }
                            if (n2 != 9) break block7;
                            string2 = this.nextQuotedValue('\"');
                            break block5;
                        }
                        if (n2 != 11) break block8;
                        string2 = this.peekedString;
                        this.peekedString = null;
                        break block5;
                    }
                    if (n2 != 15) break block9;
                    string2 = Long.toString(this.peekedLong);
                    break block5;
                }
                if (n2 != 16) break block10;
                string2 = new String(this.buffer, this.pos, this.peekedNumberLength);
                this.pos += this.peekedNumberLength;
            }
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n2 = this.stackSize - 1;
            nArray[n2] = nArray[n2] + 1;
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a string but was ");
        stringBuilder.append(this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public JsonToken peek() throws IOException {
        int n2;
        int n3 = n2 = this.peeked;
        if (n2 == 0) {
            n3 = this.doPeek();
        }
        switch (n3) {
            default: {
                throw new AssertionError();
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 1: 
        }
        return JsonToken.BEGIN_OBJECT;
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void skipValue() throws IOException {
        int n2;
        int n3 = 0;
        do {
            block8: {
                block12: {
                    block13: {
                        int n4;
                        block11: {
                            block10: {
                                block9: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                n4 = n2 = this.peeked;
                                                if (n2 == 0) {
                                                    n4 = this.doPeek();
                                                }
                                                if (n4 != 3) break block5;
                                                this.push(1);
                                                break block6;
                                            }
                                            if (n4 != 1) break block7;
                                            this.push(3);
                                        }
                                        n2 = n3 + 1;
                                        break block8;
                                    }
                                    if (n4 != 4) break block9;
                                    --this.stackSize;
                                    break block10;
                                }
                                if (n4 != 2) break block11;
                                --this.stackSize;
                            }
                            n2 = n3 - 1;
                            break block8;
                        }
                        if (n4 == 14 || n4 == 10) break block12;
                        if (n4 == 8 || n4 == 12) break block13;
                        if (n4 != 9 && n4 != 13) {
                            n2 = n3;
                            if (n4 == 16) {
                                this.pos += this.peekedNumberLength;
                                n2 = n3;
                            }
                            break block8;
                        } else {
                            this.skipQuotedValue('\"');
                            n2 = n3;
                        }
                        break block8;
                    }
                    this.skipQuotedValue('\'');
                    n2 = n3;
                    break block8;
                }
                this.skipUnquotedValue();
                n2 = n3;
            }
            this.peeked = 0;
            n3 = n2;
        } while (n2 != 0);
        int[] nArray = this.pathIndices;
        n2 = this.stackSize;
        n3 = n2 - 1;
        nArray[n3] = nArray[n3] + 1;
        this.pathNames[n2 - 1] = "null";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.locationString());
        return stringBuilder.toString();
    }
}

