/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class TypeAdapters {
    public static final TypeAdapter<AtomicBoolean> ATOMIC_BOOLEAN;
    public static final TypeAdapterFactory ATOMIC_BOOLEAN_FACTORY;
    public static final TypeAdapter<AtomicInteger> ATOMIC_INTEGER;
    public static final TypeAdapter<AtomicIntegerArray> ATOMIC_INTEGER_ARRAY;
    public static final TypeAdapterFactory ATOMIC_INTEGER_ARRAY_FACTORY;
    public static final TypeAdapterFactory ATOMIC_INTEGER_FACTORY;
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL;
    public static final TypeAdapter<BigInteger> BIG_INTEGER;
    public static final TypeAdapter<BitSet> BIT_SET;
    public static final TypeAdapterFactory BIT_SET_FACTORY;
    public static final TypeAdapter<Boolean> BOOLEAN;
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING;
    public static final TypeAdapterFactory BOOLEAN_FACTORY;
    public static final TypeAdapter<Number> BYTE;
    public static final TypeAdapterFactory BYTE_FACTORY;
    public static final TypeAdapter<Calendar> CALENDAR;
    public static final TypeAdapterFactory CALENDAR_FACTORY;
    public static final TypeAdapter<Character> CHARACTER;
    public static final TypeAdapterFactory CHARACTER_FACTORY;
    public static final TypeAdapter<Class> CLASS;
    public static final TypeAdapterFactory CLASS_FACTORY;
    public static final TypeAdapter<Currency> CURRENCY;
    public static final TypeAdapterFactory CURRENCY_FACTORY;
    public static final TypeAdapter<Number> DOUBLE;
    public static final TypeAdapterFactory ENUM_FACTORY;
    public static final TypeAdapter<Number> FLOAT;
    public static final TypeAdapter<InetAddress> INET_ADDRESS;
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY;
    public static final TypeAdapter<Number> INTEGER;
    public static final TypeAdapterFactory INTEGER_FACTORY;
    public static final TypeAdapter<JsonElement> JSON_ELEMENT;
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY;
    public static final TypeAdapter<Locale> LOCALE;
    public static final TypeAdapterFactory LOCALE_FACTORY;
    public static final TypeAdapter<Number> LONG;
    public static final TypeAdapter<Number> NUMBER;
    public static final TypeAdapterFactory NUMBER_FACTORY;
    public static final TypeAdapter<Number> SHORT;
    public static final TypeAdapterFactory SHORT_FACTORY;
    public static final TypeAdapter<String> STRING;
    public static final TypeAdapter<StringBuffer> STRING_BUFFER;
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY;
    public static final TypeAdapter<StringBuilder> STRING_BUILDER;
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY;
    public static final TypeAdapterFactory STRING_FACTORY;
    public static final TypeAdapterFactory TIMESTAMP_FACTORY;
    public static final TypeAdapter<URI> URI;
    public static final TypeAdapterFactory URI_FACTORY;
    public static final TypeAdapter<URL> URL;
    public static final TypeAdapterFactory URL_FACTORY;
    public static final TypeAdapter<UUID> UUID;
    public static final TypeAdapterFactory UUID_FACTORY;

    static {
        CLASS = new TypeAdapter<Class>(){

            public Class read(JsonReader jsonReader) throws IOException {
                throw new UnsupportedOperationException("Attempted to deserialize a java.lang.Class. Forgot to register a type adapter?");
            }

            public void write(JsonWriter object, Class clazz) throws IOException {
                object = new StringBuilder();
                ((StringBuilder)object).append("Attempted to serialize java.lang.Class: ");
                ((StringBuilder)object).append(clazz.getName());
                ((StringBuilder)object).append(". Forgot to register a type adapter?");
                throw new UnsupportedOperationException(((StringBuilder)object).toString());
            }
        }.nullSafe();
        CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
        BIT_SET = new TypeAdapter<BitSet>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public BitSet read(JsonReader object) throws IOException {
                BitSet bitSet = new BitSet();
                ((JsonReader)object).beginArray();
                JsonToken jsonToken = ((JsonReader)object).peek();
                int n2 = 0;
                while (true) {
                    boolean bl;
                    block15: {
                        block13: {
                            block14: {
                                void var3_6;
                                if (var3_6 == JsonToken.END_ARRAY) {
                                    ((JsonReader)object).endArray();
                                    return bitSet;
                                }
                                int n3 = 36.$SwitchMap$com$google$gson$stream$JsonToken[var3_6.ordinal()];
                                bl = true;
                                if (n3 == 1) break block14;
                                if (n3 != 2) {
                                    if (n3 != 3) {
                                        object = new StringBuilder();
                                        ((StringBuilder)object).append("Invalid bitset value type: ");
                                        ((StringBuilder)object).append(var3_6);
                                        throw new JsonSyntaxException(((StringBuilder)object).toString());
                                    }
                                    String string2 = ((JsonReader)object).nextString();
                                    try {
                                        n3 = Integer.parseInt(string2);
                                        if (n3 != 0) {
                                        }
                                        break block13;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        StringBuilder stringBuilder = new StringBuilder();
                                        stringBuilder.append("Error: Expecting: bitset number value (1, 0), Found: ");
                                        stringBuilder.append(string2);
                                        throw new JsonSyntaxException(stringBuilder.toString());
                                    }
                                }
                                bl = ((JsonReader)object).nextBoolean();
                                break block15;
                            }
                            if (((JsonReader)object).nextInt() != 0) break block15;
                        }
                        bl = false;
                    }
                    if (bl) {
                        bitSet.set(n2);
                    }
                    ++n2;
                    JsonToken jsonToken2 = ((JsonReader)object).peek();
                }
            }

            public void write(JsonWriter jsonWriter, BitSet bitSet) throws IOException {
                jsonWriter.beginArray();
                int n2 = bitSet.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    jsonWriter.value((long)bitSet.get(i2));
                }
                jsonWriter.endArray();
            }
        }.nullSafe();
        BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
        BOOLEAN = new TypeAdapter<Boolean>(){

            public Boolean read(JsonReader jsonReader) throws IOException {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                if (jsonToken == JsonToken.STRING) {
                    return Boolean.parseBoolean(jsonReader.nextString());
                }
                return jsonReader.nextBoolean();
            }

            public void write(JsonWriter jsonWriter, Boolean bl) throws IOException {
                jsonWriter.value(bl);
            }
        };
        BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

            public Boolean read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Boolean.valueOf(jsonReader.nextString());
            }

            public void write(JsonWriter jsonWriter, Boolean object) throws IOException {
                object = object == null ? "null" : ((Boolean)object).toString();
                jsonWriter.value((String)object);
            }
        };
        BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
        BYTE = new TypeAdapter<Number>(){

            public Number read(JsonReader jsonReader) throws IOException {
                byte by2;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    by2 = (byte)jsonReader.nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException((Throwable)numberFormatException);
                }
                return by2;
            }

            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
        SHORT = new TypeAdapter<Number>(){

            public Number read(JsonReader jsonReader) throws IOException {
                short s2;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    s2 = (short)jsonReader.nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException((Throwable)numberFormatException);
                }
                return s2;
            }

            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
        INTEGER = new TypeAdapter<Number>(){

            public Number read(JsonReader jsonReader) throws IOException {
                int n2;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    n2 = jsonReader.nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException((Throwable)numberFormatException);
                }
                return n2;
            }

            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
        ATOMIC_INTEGER = new TypeAdapter<AtomicInteger>(){

            public AtomicInteger read(JsonReader object) throws IOException {
                try {
                    object = new AtomicInteger(((JsonReader)object).nextInt());
                    return object;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException((Throwable)numberFormatException);
                }
            }

            public void write(JsonWriter jsonWriter, AtomicInteger atomicInteger) throws IOException {
                jsonWriter.value((long)atomicInteger.get());
            }
        }.nullSafe();
        ATOMIC_INTEGER_FACTORY = TypeAdapters.newFactory(AtomicInteger.class, ATOMIC_INTEGER);
        ATOMIC_BOOLEAN = new TypeAdapter<AtomicBoolean>(){

            public AtomicBoolean read(JsonReader jsonReader) throws IOException {
                return new AtomicBoolean(jsonReader.nextBoolean());
            }

            public void write(JsonWriter jsonWriter, AtomicBoolean atomicBoolean) throws IOException {
                jsonWriter.value(atomicBoolean.get());
            }
        }.nullSafe();
        ATOMIC_BOOLEAN_FACTORY = TypeAdapters.newFactory(AtomicBoolean.class, ATOMIC_BOOLEAN);
        ATOMIC_INTEGER_ARRAY = new TypeAdapter<AtomicIntegerArray>(){

            public AtomicIntegerArray read(JsonReader object) throws IOException {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ((JsonReader)object).beginArray();
                while (((JsonReader)object).hasNext()) {
                    try {
                        arrayList.add(((JsonReader)object).nextInt());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JsonSyntaxException((Throwable)numberFormatException);
                    }
                }
                ((JsonReader)object).endArray();
                int n2 = arrayList.size();
                object = new AtomicIntegerArray(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((AtomicIntegerArray)object).set(i2, (Integer)arrayList.get(i2));
                }
                return object;
            }

            public void write(JsonWriter jsonWriter, AtomicIntegerArray atomicIntegerArray) throws IOException {
                jsonWriter.beginArray();
                int n2 = atomicIntegerArray.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    jsonWriter.value((long)atomicIntegerArray.get(i2));
                }
                jsonWriter.endArray();
            }
        }.nullSafe();
        ATOMIC_INTEGER_ARRAY_FACTORY = TypeAdapters.newFactory(AtomicIntegerArray.class, ATOMIC_INTEGER_ARRAY);
        LONG = new TypeAdapter<Number>(){

            public Number read(JsonReader jsonReader) throws IOException {
                long l2;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    l2 = jsonReader.nextLong();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException((Throwable)numberFormatException);
                }
                return l2;
            }

            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        FLOAT = new TypeAdapter<Number>(){

            public Number read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        DOUBLE = new TypeAdapter<Number>(){

            public Number read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        NUMBER = new TypeAdapter<Number>(){

            public Number read(JsonReader object) throws IOException {
                JsonToken jsonToken = ((JsonReader)object).peek();
                int n2 = 36.$SwitchMap$com$google$gson$stream$JsonToken[jsonToken.ordinal()];
                if (n2 != 1 && n2 != 3) {
                    if (n2 == 4) {
                        ((JsonReader)object).nextNull();
                        return null;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Expecting number, got: ");
                    ((StringBuilder)object).append(jsonToken);
                    throw new JsonSyntaxException(((StringBuilder)object).toString());
                }
                return new LazilyParsedNumber(((JsonReader)object).nextString());
            }

            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        NUMBER_FACTORY = TypeAdapters.newFactory(Number.class, NUMBER);
        CHARACTER = new TypeAdapter<Character>(){

            public Character read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                if (((String)(object = ((JsonReader)object).nextString())).length() == 1) {
                    return Character.valueOf(((String)object).charAt(0));
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expecting character, got: ");
                stringBuilder.append((String)object);
                throw new JsonSyntaxException(stringBuilder.toString());
            }

            public void write(JsonWriter jsonWriter, Character object) throws IOException {
                object = object == null ? null : String.valueOf(object);
                jsonWriter.value((String)object);
            }
        };
        CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
        STRING = new TypeAdapter<String>(){

            public String read(JsonReader jsonReader) throws IOException {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                if (jsonToken == JsonToken.BOOLEAN) {
                    return Boolean.toString(jsonReader.nextBoolean());
                }
                return jsonReader.nextString();
            }

            public void write(JsonWriter jsonWriter, String string2) throws IOException {
                jsonWriter.value(string2);
            }
        };
        BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

            public BigDecimal read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    object = new BigDecimal(((JsonReader)object).nextString());
                    return object;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException((Throwable)numberFormatException);
                }
            }

            public void write(JsonWriter jsonWriter, BigDecimal bigDecimal) throws IOException {
                jsonWriter.value((Number)bigDecimal);
            }
        };
        BIG_INTEGER = new TypeAdapter<BigInteger>(){

            public BigInteger read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    object = new BigInteger(((JsonReader)object).nextString());
                    return object;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException((Throwable)numberFormatException);
                }
            }

            public void write(JsonWriter jsonWriter, BigInteger bigInteger) throws IOException {
                jsonWriter.value((Number)bigInteger);
            }
        };
        STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
        STRING_BUILDER = new TypeAdapter<StringBuilder>(){

            public StringBuilder read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return new StringBuilder(jsonReader.nextString());
            }

            public void write(JsonWriter jsonWriter, StringBuilder charSequence) throws IOException {
                charSequence = charSequence == null ? null : charSequence.toString();
                jsonWriter.value((String)charSequence);
            }
        };
        STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
        STRING_BUFFER = new TypeAdapter<StringBuffer>(){

            public StringBuffer read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return new StringBuffer(jsonReader.nextString());
            }

            public void write(JsonWriter jsonWriter, StringBuffer charSequence) throws IOException {
                charSequence = charSequence == null ? null : charSequence.toString();
                jsonWriter.value((String)charSequence);
            }
        };
        STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
        URL = new TypeAdapter<URL>(){

            public URL read(JsonReader object) throws IOException {
                JsonToken jsonToken = ((JsonReader)object).peek();
                JsonToken jsonToken2 = JsonToken.NULL;
                Object var4_4 = null;
                if (jsonToken == jsonToken2) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                object = "null".equals(object = ((JsonReader)object).nextString()) ? var4_4 : new URL((String)object);
                return object;
            }

            public void write(JsonWriter jsonWriter, URL object) throws IOException {
                object = object == null ? null : ((URL)object).toExternalForm();
                jsonWriter.value((String)object);
            }
        };
        URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
        URI = new TypeAdapter<URI>(){

            public URI read(JsonReader object) throws IOException {
                block5: {
                    block4: {
                        JsonToken jsonToken = ((JsonReader)object).peek();
                        JsonToken jsonToken2 = JsonToken.NULL;
                        Object var4_5 = null;
                        if (jsonToken == jsonToken2) {
                            ((JsonReader)object).nextNull();
                            return null;
                        }
                        try {
                            object = ((JsonReader)object).nextString();
                            if (!"null".equals(object)) break block4;
                            object = var4_5;
                            break block5;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new JsonIOException((Throwable)uRISyntaxException);
                        }
                    }
                    object = new URI((String)object);
                }
                return object;
            }

            public void write(JsonWriter jsonWriter, URI object) throws IOException {
                object = object == null ? null : ((URI)object).toASCIIString();
                jsonWriter.value((String)object);
            }
        };
        URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
        INET_ADDRESS = new TypeAdapter<InetAddress>(){

            public InetAddress read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return InetAddress.getByName(jsonReader.nextString());
            }

            public void write(JsonWriter jsonWriter, InetAddress object) throws IOException {
                object = object == null ? null : ((InetAddress)object).getHostAddress();
                jsonWriter.value((String)object);
            }
        };
        INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
        UUID = new TypeAdapter<UUID>(){

            public UUID read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return java.util.UUID.fromString(jsonReader.nextString());
            }

            public void write(JsonWriter jsonWriter, UUID object) throws IOException {
                object = object == null ? null : ((UUID)object).toString();
                jsonWriter.value((String)object);
            }
        };
        UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
        CURRENCY = new TypeAdapter<Currency>(){

            public Currency read(JsonReader jsonReader) throws IOException {
                return Currency.getInstance(jsonReader.nextString());
            }

            public void write(JsonWriter jsonWriter, Currency currency) throws IOException {
                jsonWriter.value(currency.getCurrencyCode());
            }
        }.nullSafe();
        CURRENCY_FACTORY = TypeAdapters.newFactory(Currency.class, CURRENCY);
        TIMESTAMP_FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.getRawType() != Timestamp.class) {
                    return null;
                }
                return new TypeAdapter<Timestamp>(gson.getAdapter(Date.class)){
                    final /* synthetic */ TypeAdapter val$dateTypeAdapter;
                    {
                        this.val$dateTypeAdapter = typeAdapter;
                    }

                    public Timestamp read(JsonReader object) throws IOException {
                        object = (object = (Date)this.val$dateTypeAdapter.read((JsonReader)object)) != null ? new Timestamp(((Date)object).getTime()) : null;
                        return object;
                    }

                    public void write(JsonWriter jsonWriter, Timestamp timestamp) throws IOException {
                        this.val$dateTypeAdapter.write(jsonWriter, (Object)timestamp);
                    }
                };
            }
        };
        CALENDAR = new TypeAdapter<Calendar>(){
            private static final String DAY_OF_MONTH = "dayOfMonth";
            private static final String HOUR_OF_DAY = "hourOfDay";
            private static final String MINUTE = "minute";
            private static final String MONTH = "month";
            private static final String SECOND = "second";
            private static final String YEAR = "year";

            public Calendar read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                jsonReader.beginObject();
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (jsonReader.peek() != JsonToken.END_OBJECT) {
                    String string2 = jsonReader.nextName();
                    int n8 = jsonReader.nextInt();
                    if (YEAR.equals(string2)) {
                        n2 = n8;
                        continue;
                    }
                    if (MONTH.equals(string2)) {
                        n3 = n8;
                        continue;
                    }
                    if (DAY_OF_MONTH.equals(string2)) {
                        n4 = n8;
                        continue;
                    }
                    if (HOUR_OF_DAY.equals(string2)) {
                        n5 = n8;
                        continue;
                    }
                    if (MINUTE.equals(string2)) {
                        n6 = n8;
                        continue;
                    }
                    if (!SECOND.equals(string2)) continue;
                    n7 = n8;
                }
                jsonReader.endObject();
                return new GregorianCalendar(n2, n3, n4, n5, n6, n7);
            }

            public void write(JsonWriter jsonWriter, Calendar calendar) throws IOException {
                if (calendar == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.beginObject();
                jsonWriter.name(YEAR);
                jsonWriter.value((long)calendar.get(1));
                jsonWriter.name(MONTH);
                jsonWriter.value((long)calendar.get(2));
                jsonWriter.name(DAY_OF_MONTH);
                jsonWriter.value((long)calendar.get(5));
                jsonWriter.name(HOUR_OF_DAY);
                jsonWriter.value((long)calendar.get(11));
                jsonWriter.name(MINUTE);
                jsonWriter.value((long)calendar.get(12));
                jsonWriter.name(SECOND);
                jsonWriter.value((long)calendar.get(13));
                jsonWriter.endObject();
            }
        };
        CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, CALENDAR);
        LOCALE = new TypeAdapter<Locale>(){

            public Locale read(JsonReader object) throws IOException {
                Object object2 = ((JsonReader)object).peek();
                Object object3 = JsonToken.NULL;
                String string2 = null;
                if (object2 == object3) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                object3 = new StringTokenizer(((JsonReader)object).nextString(), "_");
                object = ((StringTokenizer)object3).hasMoreElements() ? ((StringTokenizer)object3).nextToken() : null;
                object2 = ((StringTokenizer)object3).hasMoreElements() ? ((StringTokenizer)object3).nextToken() : null;
                if (((StringTokenizer)object3).hasMoreElements()) {
                    string2 = ((StringTokenizer)object3).nextToken();
                }
                if (object2 == null && string2 == null) {
                    return new Locale((String)object);
                }
                if (string2 == null) {
                    return new Locale((String)object, (String)object2);
                }
                return new Locale((String)object, (String)object2, string2);
            }

            public void write(JsonWriter jsonWriter, Locale object) throws IOException {
                object = object == null ? null : ((Locale)object).toString();
                jsonWriter.value((String)object);
            }
        };
        LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
        JSON_ELEMENT = new TypeAdapter<JsonElement>(){

            public JsonElement read(JsonReader jsonReader) throws IOException {
                switch (jsonReader.peek()) {
                    default: {
                        throw new IllegalArgumentException();
                    }
                    case BEGIN_OBJECT: {
                        JsonObject jsonObject = new JsonObject();
                        jsonReader.beginObject();
                        while (jsonReader.hasNext()) {
                            jsonObject.add(jsonReader.nextName(), this.read(jsonReader));
                        }
                        jsonReader.endObject();
                        return jsonObject;
                    }
                    case BEGIN_ARRAY: {
                        JsonArray jsonArray = new JsonArray();
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            jsonArray.add(this.read(jsonReader));
                        }
                        jsonReader.endArray();
                        return jsonArray;
                    }
                    case NULL: {
                        jsonReader.nextNull();
                        return JsonNull.INSTANCE;
                    }
                    case STRING: {
                        return new JsonPrimitive(jsonReader.nextString());
                    }
                    case BOOLEAN: {
                        return new JsonPrimitive(Boolean.valueOf(jsonReader.nextBoolean()));
                    }
                    case NUMBER: 
                }
                return new JsonPrimitive((Number)new LazilyParsedNumber(jsonReader.nextString()));
            }

            /*
             * Enabled aggressive block sorting
             */
            public void write(JsonWriter object, JsonElement object2) throws IOException {
                if (object2 != null && !object2.isJsonNull()) {
                    if (object2.isJsonPrimitive()) {
                        if ((object2 = object2.getAsJsonPrimitive()).isNumber()) {
                            object.value(object2.getAsNumber());
                            return;
                        }
                        if (object2.isBoolean()) {
                            object.value(object2.getAsBoolean());
                            return;
                        }
                        object.value(object2.getAsString());
                        return;
                    }
                    if (object2.isJsonArray()) {
                        object.beginArray();
                        object2 = object2.getAsJsonArray().iterator();
                        while (true) {
                            if (!object2.hasNext()) {
                                object.endArray();
                                return;
                            }
                            this.write((JsonWriter)object, (JsonElement)object2.next());
                        }
                    }
                    if (!object2.isJsonObject()) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Couldn't write ");
                        ((StringBuilder)object).append(object2.getClass());
                        throw new IllegalArgumentException(((StringBuilder)object).toString());
                    }
                    object.beginObject();
                    object2 = object2.getAsJsonObject().entrySet().iterator();
                    while (true) {
                        if (!object2.hasNext()) {
                            object.endObject();
                            return;
                        }
                        Map.Entry entry = (Map.Entry)object2.next();
                        object.name((String)entry.getKey());
                        this.write((JsonWriter)object, (JsonElement)entry.getValue());
                    }
                }
                object.nullValue();
            }
        };
        JSON_ELEMENT_FACTORY = TypeAdapters.newTypeHierarchyFactory(JsonElement.class, JSON_ELEMENT);
        ENUM_FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> object2) {
                if (Enum.class.isAssignableFrom((Class<?>)(object2 = object2.getRawType())) && object2 != Enum.class) {
                    object = object2;
                    if (!((Class)object2).isEnum()) {
                        object = ((Class)object2).getSuperclass();
                    }
                    return new EnumTypeAdapter(object);
                }
                return null;
            }
        };
    }

    private TypeAdapters() {
        throw new UnsupportedOperationException();
    }

    public static <TT> TypeAdapterFactory newFactory(final TypeToken<TT> typeToken, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken2) {
                gson = typeToken2.equals((Object)typeToken) ? typeAdapter : null;
                return gson;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                gson = typeToken.getRawType() == clazz ? typeAdapter : null;
                return gson;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[type=");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final Class<TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
                object = typeToken.getRawType();
                object = object != clazz && object != clazz2 ? null : typeAdapter;
                return object;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[type=");
                stringBuilder.append(clazz2.getName());
                stringBuilder.append("+");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(final Class<TT> clazz, final Class<? extends TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
                object = typeToken.getRawType();
                object = object != clazz && object != clazz2 ? null : typeAdapter;
                return object;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[type=");
                stringBuilder.append(clazz.getName());
                stringBuilder.append("+");
                stringBuilder.append(clazz2.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    public static <T1> TypeAdapterFactory newTypeHierarchyFactory(final Class<T1> clazz, final TypeAdapter<T1> typeAdapter) {
        return new TypeAdapterFactory(){

            public <T2> TypeAdapter<T2> create(Gson object, TypeToken<T2> typeToken) {
                object = typeToken.getRawType();
                if (!clazz.isAssignableFrom((Class<?>)object)) {
                    return null;
                }
                return new TypeAdapter<T1>((Class)object){
                    final /* synthetic */ Class val$requestedType;
                    {
                        this.val$requestedType = clazz;
                    }

                    public T1 read(JsonReader object) throws IOException {
                        Object object2 = typeAdapter.read((JsonReader)object);
                        if (object2 != null && !this.val$requestedType.isInstance(object2)) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Expected a ");
                            ((StringBuilder)object).append(this.val$requestedType.getName());
                            ((StringBuilder)object).append(" but was ");
                            ((StringBuilder)object).append(object2.getClass().getName());
                            throw new JsonSyntaxException(((StringBuilder)object).toString());
                        }
                        return object2;
                    }

                    public void write(JsonWriter jsonWriter, T1 T1) throws IOException {
                        typeAdapter.write(jsonWriter, T1);
                    }
                };
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[typeHierarchy=");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<T, String> constantToName;
        private final Map<String, T> nameToConstant = new HashMap<String, T>();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public EnumTypeAdapter(Class<T> clazz) {
            int n2;
            int n3;
            Enum[] enumArray;
            this.constantToName = new HashMap<T, String>();
            try {
                enumArray = (Enum[])clazz.getEnumConstants();
                n3 = enumArray.length;
                n2 = 0;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                AssertionError assertionError = new AssertionError((Object)noSuchFieldException);
                throw assertionError;
            }
            while (n2 < n3) {
                String string2;
                Enum enum_;
                block7: {
                    enum_ = enumArray[n2];
                    string2 = enum_.name();
                    String[] stringArray = clazz.getField(string2).getAnnotation(SerializedName.class);
                    if (stringArray == null) break block7;
                    String string3 = stringArray.value();
                    stringArray = stringArray.alternate();
                    int n4 = stringArray.length;
                    int n5 = 0;
                    while (true) {
                        string2 = string3;
                        if (n5 >= n4) break;
                        string2 = stringArray[n5];
                        this.nameToConstant.put(string2, enum_);
                        ++n5;
                        continue;
                        break;
                    }
                }
                this.nameToConstant.put(string2, enum_);
                this.constantToName.put(enum_, string2);
                ++n2;
            }
            return;
        }

        public T read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return (T)((Enum)this.nameToConstant.get(jsonReader.nextString()));
        }

        public void write(JsonWriter jsonWriter, T object) throws IOException {
            object = object == null ? null : this.constantToName.get(object);
            jsonWriter.value(object);
        }
    }
}

