/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class MapTypeAdapterFactory
implements TypeAdapterFactory {
    final boolean complexMapKeySerialization;
    private final ConstructorConstructor constructorConstructor;

    public MapTypeAdapterFactory(ConstructorConstructor constructorConstructor, boolean bl) {
        this.constructorConstructor = constructorConstructor;
        this.complexMapKeySerialization = bl;
    }

    private TypeAdapter<?> getKeyAdapter(Gson object, Type type) {
        object = type != Boolean.TYPE && type != Boolean.class ? object.getAdapter(TypeToken.get((Type)type)) : TypeAdapters.BOOLEAN_AS_STRING;
        return object;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> objectConstructor) {
        TypeAdapter<?> typeAdapter = objectConstructor.getType();
        if (!Map.class.isAssignableFrom(objectConstructor.getRawType())) {
            return null;
        }
        Type[] typeArray = .Gson.Types.getMapKeyAndValueTypes((Type)typeAdapter, (Class).Gson.Types.getRawType((Type)typeAdapter));
        typeAdapter = this.getKeyAdapter(gson, typeArray[0]);
        TypeAdapter typeAdapter2 = gson.getAdapter(TypeToken.get((Type)typeArray[1]));
        objectConstructor = this.constructorConstructor.get(objectConstructor);
        return new Adapter(gson, typeArray[0], typeAdapter, typeArray[1], typeAdapter2, objectConstructor);
    }

    private final class Adapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private final ObjectConstructor<? extends Map<K, V>> constructor;
        private final TypeAdapter<K> keyTypeAdapter;
        private final TypeAdapter<V> valueTypeAdapter;

        public Adapter(Gson gson, Type type, TypeAdapter<K> typeAdapter, Type type2, TypeAdapter<V> typeAdapter2, ObjectConstructor<? extends Map<K, V>> objectConstructor) {
            this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper(gson, typeAdapter, type);
            this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper(gson, typeAdapter2, type2);
            this.constructor = objectConstructor;
        }

        private String keyToString(JsonElement jsonElement) {
            if (jsonElement.isJsonPrimitive()) {
                if ((jsonElement = jsonElement.getAsJsonPrimitive()).isNumber()) {
                    return String.valueOf(jsonElement.getAsNumber());
                }
                if (jsonElement.isBoolean()) {
                    return Boolean.toString(jsonElement.getAsBoolean());
                }
                if (jsonElement.isString()) {
                    return jsonElement.getAsString();
                }
                throw new AssertionError();
            }
            if (jsonElement.isJsonNull()) {
                return "null";
            }
            throw new AssertionError();
        }

        public Map<K, V> read(JsonReader object) throws IOException {
            Object object2 = ((JsonReader)object).peek();
            if (object2 == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            Map map = (Map)this.constructor.construct();
            if (object2 == JsonToken.BEGIN_ARRAY) {
                ((JsonReader)object).beginArray();
                while (((JsonReader)object).hasNext()) {
                    ((JsonReader)object).beginArray();
                    object2 = this.keyTypeAdapter.read((JsonReader)object);
                    if (map.put(object2, this.valueTypeAdapter.read((JsonReader)object)) == null) {
                        ((JsonReader)object).endArray();
                        continue;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("duplicate key: ");
                    ((StringBuilder)object).append(object2);
                    throw new JsonSyntaxException(((StringBuilder)object).toString());
                }
                ((JsonReader)object).endArray();
            } else {
                ((JsonReader)object).beginObject();
                while (((JsonReader)object).hasNext()) {
                    JsonReaderInternalAccess.INSTANCE.promoteNameToValue((JsonReader)object);
                    object2 = this.keyTypeAdapter.read((JsonReader)object);
                    if (map.put(object2, this.valueTypeAdapter.read((JsonReader)object)) == null) continue;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("duplicate key: ");
                    ((StringBuilder)object).append(object2);
                    throw new JsonSyntaxException(((StringBuilder)object).toString());
                }
                ((JsonReader)object).endObject();
            }
            return map;
        }

        public void write(JsonWriter jsonWriter, Map<K, V> iterator22) throws IOException {
            int n2;
            if (iterator22 == null) {
                jsonWriter.nullValue();
                return;
            }
            if (!MapTypeAdapterFactory.this.complexMapKeySerialization) {
                jsonWriter.beginObject();
                for (Map.Entry entry : iterator22.entrySet()) {
                    jsonWriter.name(String.valueOf(entry.getKey()));
                    this.valueTypeAdapter.write(jsonWriter, entry.getValue());
                }
                jsonWriter.endObject();
                return;
            }
            ArrayList<JsonElement> arrayList = new ArrayList<JsonElement>(iterator22.size());
            ArrayList arrayList2 = new ArrayList(iterator22.size());
            Iterator iterator2 = iterator22.entrySet().iterator();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                JsonElement jsonElement = this.keyTypeAdapter.toJsonTree(entry.getKey());
                arrayList.add(jsonElement);
                arrayList2.add(entry.getValue());
                n2 = !jsonElement.isJsonArray() && !jsonElement.isJsonObject() ? 0 : 1;
                n5 |= n2;
            }
            if (n5 != 0) {
                jsonWriter.beginArray();
                n2 = arrayList.size();
                for (n5 = n4; n5 < n2; ++n5) {
                    jsonWriter.beginArray();
                    Streams.write((JsonElement)((JsonElement)arrayList.get(n5)), (JsonWriter)jsonWriter);
                    this.valueTypeAdapter.write(jsonWriter, arrayList2.get(n5));
                    jsonWriter.endArray();
                }
                jsonWriter.endArray();
            } else {
                jsonWriter.beginObject();
                n2 = arrayList.size();
                for (n5 = n3; n5 < n2; ++n5) {
                    jsonWriter.name(this.keyToString((JsonElement)arrayList.get(n5)));
                    this.valueTypeAdapter.write(jsonWriter, arrayList2.get(n5));
                }
                jsonWriter.endObject();
            }
        }
    }
}

