/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class LinkedHashTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final Comparator<Comparable> NATURAL_ORDER = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable comparable, Comparable comparable2) {
            return comparable.compareTo(comparable2);
        }
    };
    Comparator<? super K> comparator;
    private EntrySet entrySet;
    final Node<K, V> header;
    private KeySet keySet;
    int modCount = 0;
    int size = 0;
    Node<K, V>[] table;
    int threshold;

    public LinkedHashTreeMap() {
        this(NATURAL_ORDER);
    }

    public LinkedHashTreeMap(Comparator<? super K> nodeArray) {
        if (nodeArray == null) {
            nodeArray = NATURAL_ORDER;
        }
        this.comparator = nodeArray;
        this.header = new Node();
        nodeArray = this.table = new Node[16];
        this.threshold = nodeArray.length / 2 + nodeArray.length / 4;
    }

    private void doubleCapacity() {
        Node<K, V>[] nodeArray = this.table = LinkedHashTreeMap.doubleCapacity(this.table);
        this.threshold = nodeArray.length / 2 + nodeArray.length / 4;
    }

    static <K, V> Node<K, V>[] doubleCapacity(Node<K, V>[] nodeArray) {
        int n2 = nodeArray.length;
        Node[] nodeArray2 = new Node[n2 * 2];
        AvlIterator<K, V> avlIterator = new AvlIterator<K, V>();
        AvlBuilder<K, V> avlBuilder = new AvlBuilder<K, V>();
        AvlBuilder<K, V> avlBuilder2 = new AvlBuilder<K, V>();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node;
            Node<K, V> node2 = nodeArray[i2];
            if (node2 == null) continue;
            avlIterator.reset(node2);
            int n3 = 0;
            int n4 = 0;
            while ((node = avlIterator.next()) != null) {
                if ((node.hash & n2) == 0) {
                    ++n3;
                    continue;
                }
                ++n4;
            }
            avlBuilder.reset(n3);
            avlBuilder2.reset(n4);
            avlIterator.reset(node2);
            while ((node2 = avlIterator.next()) != null) {
                if ((node2.hash & n2) == 0) {
                    avlBuilder.add(node2);
                    continue;
                }
                avlBuilder2.add(node2);
            }
            node = null;
            node2 = n3 > 0 ? avlBuilder.root() : null;
            nodeArray2[i2] = node2;
            node2 = node;
            if (n4 > 0) {
                node2 = avlBuilder2.root();
            }
            nodeArray2[i2 + n2] = node2;
        }
        return nodeArray2;
    }

    private boolean equal(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    private void rebalance(Node<K, V> node, boolean bl) {
        while (node != null) {
            Node node2;
            int n2;
            Node node3 = node.left;
            Node node4 = node.right;
            int n3 = 0;
            int n4 = 0;
            int n5 = node3 != null ? node3.height : 0;
            int n6 = n5 - (n2 = node4 != null ? node4.height : 0);
            if (n6 == -2) {
                node2 = node4.left;
                node3 = node4.right;
                n5 = node3 != null ? node3.height : 0;
                n2 = n4;
                if (node2 != null) {
                    n2 = node2.height;
                }
                if ((n5 = n2 - n5) != -1 && (n5 != 0 || bl)) {
                    this.rotateRight(node4);
                    this.rotateLeft(node);
                } else {
                    this.rotateLeft(node);
                }
                if (bl) {
                    break;
                }
            } else if (n6 == 2) {
                node4 = node3.left;
                node2 = node3.right;
                n5 = node2 != null ? node2.height : 0;
                n2 = n3;
                if (node4 != null) {
                    n2 = node4.height;
                }
                if ((n5 = n2 - n5) != 1 && (n5 != 0 || bl)) {
                    this.rotateLeft(node3);
                    this.rotateRight(node);
                } else {
                    this.rotateRight(node);
                }
                if (bl) {
                    break;
                }
            } else if (n6 == 0) {
                node.height = n5 + 1;
                if (bl) {
                    break;
                }
            } else {
                node.height = Math.max(n5, n2) + 1;
                if (!bl) break;
            }
            node = node.parent;
        }
    }

    private void replaceInParent(Node<K, V> nodeArray, Node<K, V> node) {
        Node node2 = nodeArray.parent;
        nodeArray.parent = null;
        if (node != null) {
            node.parent = node2;
        }
        if (node2 != null) {
            if (node2.left == nodeArray) {
                node2.left = node;
            } else {
                node2.right = node;
            }
        } else {
            int n2 = nodeArray.hash;
            nodeArray = this.table;
            nodeArray[n2 & nodeArray.length - 1] = node;
        }
    }

    private void rotateLeft(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node3.left;
        Node node5 = node3.right;
        node.right = node4;
        if (node4 != null) {
            node4.parent = node;
        }
        this.replaceInParent(node, node3);
        node3.left = node;
        node.parent = node3;
        int n2 = 0;
        int n3 = node2 != null ? node2.height : 0;
        int n4 = node4 != null ? node4.height : 0;
        n4 = node.height = Math.max(n3, n4) + 1;
        n3 = n2;
        if (node5 != null) {
            n3 = node5.height;
        }
        node3.height = Math.max(n4, n3) + 1;
    }

    private void rotateRight(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node2.left;
        Node node5 = node2.right;
        node.left = node5;
        if (node5 != null) {
            node5.parent = node;
        }
        this.replaceInParent(node, node2);
        node2.right = node;
        node.parent = node2;
        int n2 = 0;
        int n3 = node3 != null ? node3.height : 0;
        int n4 = node5 != null ? node5.height : 0;
        n4 = node.height = Math.max(n3, n4) + 1;
        n3 = n2;
        if (node4 != null) {
            n3 = node4.height;
        }
        node2.height = Math.max(n4, n3) + 1;
    }

    private static int secondaryHash(int n2) {
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 >>> 4 ^ (n2 >>> 7 ^ n2);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap(this);
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        ++this.modCount;
        Node<K, V> node = this.header;
        Node node2 = node.next;
        while (node2 != node) {
            Node node3 = node2.next;
            node2.prev = null;
            node2.next = null;
            node2 = node3;
        }
        node.prev = node;
        node.next = node;
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl = this.findByObject(object) != null;
        return bl;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet();
        }
        return entrySet;
    }

    Node<K, V> find(K object, boolean bl) {
        Node<K, V> node;
        int n2;
        Comparator<K> comparator = this.comparator;
        Node<K, V>[] nodeArray = this.table;
        int n3 = LinkedHashTreeMap.secondaryHash(object.hashCode());
        int n4 = nodeArray.length - 1 & n3;
        Node<K, V> node2 = nodeArray[n4];
        if (node2 != null) {
            Comparable comparable = comparator == NATURAL_ORDER ? (Comparable)object : null;
            while (true) {
                if ((n2 = comparable != null ? comparable.compareTo(node2.key) : comparator.compare(object, node2.key)) == 0) {
                    return node2;
                }
                node = n2 < 0 ? node2.left : node2.right;
                if (node != null) {
                    node2 = node;
                    continue;
                }
                break;
            }
        } else {
            n2 = 0;
        }
        if (!bl) {
            return null;
        }
        node = this.header;
        if (node2 == null) {
            if (comparator == NATURAL_ORDER && !(object instanceof Comparable)) {
                node2 = new StringBuilder();
                ((StringBuilder)((Object)node2)).append(object.getClass().getName());
                ((StringBuilder)((Object)node2)).append(" is not Comparable");
                throw new ClassCastException(((StringBuilder)((Object)node2)).toString());
            }
            nodeArray[n4] = object = new Node<K, V>(node2, object, n3, node, node.prev);
        } else {
            object = new Node<K, V>(node2, object, n3, node, node.prev);
            if (n2 < 0) {
                node2.left = object;
            } else {
                node2.right = object;
            }
            this.rebalance(node2, true);
        }
        n2 = this.size;
        this.size = n2 + 1;
        if (n2 > this.threshold) {
            this.doubleCapacity();
        }
        ++this.modCount;
        return object;
    }

    Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        Node<?, ?> node = this.findByObject(entry.getKey());
        boolean bl = node != null && this.equal(node.value, entry.getValue());
        entry = bl ? node : null;
        return entry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Node<K, V> findByObject(Object object) {
        Node<Object, V> node;
        Node<Object, V> node2 = node = null;
        if (object == null) return node2;
        try {
            return this.find(object, false);
        }
        catch (ClassCastException classCastException) {
            return node;
        }
    }

    @Override
    public V get(Object node) {
        node = (node = this.findByObject(node)) != null ? node.value : null;
        return (V)node;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        if (keySet == null) {
            this.keySet = keySet = new KeySet();
        }
        return keySet;
    }

    @Override
    public V put(K object, V v2) {
        if (object != null) {
            Node<K, V> node = this.find(object, true);
            object = node.value;
            node.value = v2;
            return (V)object;
        }
        throw new NullPointerException("key == null");
    }

    @Override
    public V remove(Object node) {
        node = (node = this.removeInternalByKey(node)) != null ? node.value : null;
        return (V)node;
    }

    void removeInternal(Node<K, V> node, boolean bl) {
        if (bl) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
            node.prev = null;
            node.next = null;
        }
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node.parent;
        int n2 = 0;
        if (node2 != null && node3 != null) {
            int n3;
            node4 = node2.height > node3.height ? node2.last() : node3.first();
            this.removeInternal(node4, false);
            node2 = node.left;
            if (node2 != null) {
                n3 = node2.height;
                node4.left = node2;
                node2.parent = node4;
                node.left = null;
            } else {
                n3 = 0;
            }
            node2 = node.right;
            if (node2 != null) {
                n2 = node2.height;
                node4.right = node2;
                node2.parent = node4;
                node.right = null;
            }
            node4.height = Math.max(n3, n2) + 1;
            this.replaceInParent(node, node4);
            return;
        }
        if (node2 != null) {
            this.replaceInParent(node, node2);
            node.left = null;
        } else if (node3 != null) {
            this.replaceInParent(node, node3);
            node.right = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(node4, false);
        --this.size;
        ++this.modCount;
    }

    Node<K, V> removeInternalByKey(Object node) {
        if ((node = this.findByObject(node)) != null) {
            this.removeInternal(node, true);
        }
        return node;
    }

    @Override
    public int size() {
        return this.size;
    }

    static final class AvlBuilder<K, V> {
        private int leavesSkipped;
        private int leavesToSkip;
        private int size;
        private Node<K, V> stack;

        AvlBuilder() {
        }

        void add(Node<K, V> node) {
            int n2;
            int n3;
            node.right = null;
            node.parent = null;
            node.left = null;
            node.height = 1;
            int n4 = this.leavesToSkip;
            if (n4 > 0 && ((n3 = this.size) & 1) == 0) {
                this.size = n3 + 1;
                this.leavesToSkip = n4 - 1;
                ++this.leavesSkipped;
            }
            node.parent = this.stack;
            this.stack = node;
            ++this.size;
            n3 = this.leavesToSkip;
            if (n3 > 0 && ((n4 = this.size) & 1) == 0) {
                this.size = n4 + 1;
                this.leavesToSkip = n3 - 1;
                ++this.leavesSkipped;
            }
            n4 = 4;
            while (((n2 = this.size) & (n3 = n4 - 1)) == n3) {
                Node<K, V> node2;
                n3 = this.leavesSkipped;
                if (n3 == 0) {
                    node = this.stack;
                    Node node3 = node.parent;
                    node2 = node3.parent;
                    node3.parent = node2.parent;
                    this.stack = node3;
                    node3.left = node2;
                    node3.right = node;
                    node3.height = node.height + 1;
                    node2.parent = node3;
                    node.parent = node3;
                } else if (n3 == 1) {
                    node2 = this.stack;
                    node = node2.parent;
                    this.stack = node;
                    node.right = node2;
                    node.height = node2.height + 1;
                    node2.parent = node;
                    this.leavesSkipped = 0;
                } else if (n3 == 2) {
                    this.leavesSkipped = 0;
                }
                n4 *= 2;
            }
        }

        void reset(int n2) {
            this.leavesToSkip = Integer.highestOneBit(n2) * 2 - 1 - n2;
            this.size = 0;
            this.leavesSkipped = 0;
            this.stack = null;
        }

        Node<K, V> root() {
            Node<K, V> node = this.stack;
            if (node.parent == null) {
                return node;
            }
            throw new IllegalStateException();
        }
    }

    static class AvlIterator<K, V> {
        private Node<K, V> stackTop;

        AvlIterator() {
        }

        public Node<K, V> next() {
            Node node;
            Node<K, V> node2 = this.stackTop;
            if (node2 == null) {
                return null;
            }
            Node node3 = node2.parent;
            node2.parent = null;
            Node node4 = node2.right;
            while (true) {
                node = node3;
                node3 = node4;
                if (node3 == null) break;
                node3.parent = node;
                node4 = node3.left;
            }
            this.stackTop = node;
            return node2;
        }

        void reset(Node<K, V> node) {
            Node<K, V> node2 = null;
            while (node != null) {
                node.parent = node2;
                Node node3 = node.left;
                node2 = node;
                node = node3;
            }
            this.stackTop = node2;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public void clear() {
            LinkedHashTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Map.Entry && LinkedHashTreeMap.this.findByEntry((Map.Entry)object) != null;
            return bl;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedTreeMapIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextNode();
                }
            };
        }

        @Override
        public boolean remove(Object node) {
            if (!(node instanceof Map.Entry)) {
                return false;
            }
            if ((node = LinkedHashTreeMap.this.findByEntry(node)) == null) {
                return false;
            }
            LinkedHashTreeMap.this.removeInternal(node, true);
            return true;
        }

        @Override
        public int size() {
            return LinkedHashTreeMap.this.size;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public void clear() {
            LinkedHashTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return LinkedHashTreeMap.this.containsKey(object);
        }

        @Override
        public Iterator<K> iterator() {
            return new LinkedTreeMapIterator<K>(){

                @Override
                public K next() {
                    return this.nextNode().key;
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = LinkedHashTreeMap.this.removeInternalByKey(object) != null;
            return bl;
        }

        @Override
        public int size() {
            return LinkedHashTreeMap.this.size;
        }
    }

    private abstract class LinkedTreeMapIterator<T>
    implements Iterator<T> {
        int expectedModCount;
        Node<K, V> lastReturned;
        Node<K, V> next;

        LinkedTreeMapIterator() {
            this.next = LinkedHashTreeMap.this.header.next;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashTreeMap.this.modCount;
        }

        @Override
        public final boolean hasNext() {
            boolean bl = this.next != LinkedHashTreeMap.this.header;
            return bl;
        }

        final Node<K, V> nextNode() {
            Node node = this.next;
            if (node != LinkedHashTreeMap.this.header) {
                if (LinkedHashTreeMap.this.modCount == this.expectedModCount) {
                    this.next = node.next;
                    this.lastReturned = node;
                    return node;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            Node node = this.lastReturned;
            if (node != null) {
                LinkedHashTreeMap.this.removeInternal(node, true);
                this.lastReturned = null;
                this.expectedModCount = LinkedHashTreeMap.this.modCount;
                return;
            }
            throw new IllegalStateException();
        }
    }

    static final class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        int height;
        final K key;
        Node<K, V> left;
        Node<K, V> next;
        Node<K, V> parent;
        Node<K, V> prev;
        Node<K, V> right;
        V value;

        Node() {
            this.key = null;
            this.hash = -1;
            this.prev = this;
            this.next = this;
        }

        Node(Node<K, V> node, K k2, int n2, Node<K, V> node2, Node<K, V> node3) {
            this.parent = node;
            this.key = k2;
            this.hash = n2;
            this.height = 1;
            this.next = node2;
            this.prev = node3;
            node3.next = this;
            node2.prev = this;
        }

        @Override
        public boolean equals(Object object) {
            boolean bl;
            block2: {
                block6: {
                    Object object2;
                    boolean bl2;
                    block5: {
                        block4: {
                            block3: {
                                boolean bl3 = object instanceof Map.Entry;
                                bl = bl2 = false;
                                if (!bl3) break block2;
                                object = (Map.Entry)object;
                                object2 = this.key;
                                if (object2 != null) break block3;
                                bl = bl2;
                                if (object.getKey() != null) break block2;
                                break block4;
                            }
                            bl = bl2;
                            if (!object2.equals(object.getKey())) break block2;
                        }
                        object2 = this.value;
                        if (object2 != null) break block5;
                        bl = bl2;
                        if (object.getValue() != null) break block2;
                        break block6;
                    }
                    bl = bl2;
                    if (!object2.equals(object.getValue())) break block2;
                }
                bl = true;
            }
            return bl;
        }

        public Node<K, V> first() {
            Node<K, V> node = this.left;
            Node<K, V> node2 = this;
            while (node != null) {
                Node<K, V> node3 = node.left;
                node2 = node;
                node = node3;
            }
            return node2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            Object object = this.key;
            int n2 = 0;
            int n3 = object == null ? 0 : object.hashCode();
            object = this.value;
            if (object != null) {
                n2 = object.hashCode();
            }
            return n3 ^ n2;
        }

        public Node<K, V> last() {
            Node<K, V> node = this.right;
            Node<K, V> node2 = this;
            while (node != null) {
                Node<K, V> node3 = node.right;
                node2 = node;
                node = node3;
            }
            return node2;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }
}

