/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

public final class JavaVersion {
    private static final int majorJavaVersion = JavaVersion.determineMajorJavaVersion();

    private JavaVersion() {
    }

    private static int determineMajorJavaVersion() {
        return JavaVersion.getMajorJavaVersion(System.getProperty("java.version"));
    }

    private static int extractBeginningInt(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (true) {
            char c2;
            if (n2 >= string2.length() || !Character.isDigit(c2 = string2.charAt(n2))) break;
            stringBuilder.append(c2);
            ++n2;
            continue;
            break;
        }
        try {
            n2 = Integer.parseInt(stringBuilder.toString());
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int getMajorJavaVersion() {
        return majorJavaVersion;
    }

    static int getMajorJavaVersion(String string2) {
        int n2;
        int n3 = n2 = JavaVersion.parseDotted(string2);
        if (n2 == -1) {
            n3 = JavaVersion.extractBeginningInt(string2);
        }
        if (n3 == -1) {
            return 6;
        }
        return n3;
    }

    public static boolean isJava9OrLater() {
        boolean bl = majorJavaVersion >= 9;
        return bl;
    }

    private static int parseDotted(String stringArray) {
        int n2;
        block3: {
            try {
                stringArray = stringArray.split("[._]");
                n2 = Integer.parseInt(stringArray[0]);
                if (n2 != 1) break block3;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            if (stringArray.length <= 1) break block3;
            n2 = Integer.parseInt(stringArray[1]);
            return n2;
        }
        return n2;
    }
}

