/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class TimeoutFuture<V>
extends FluentFuture.TrustedFuture<V> {
    @NullableDecl
    private ListenableFuture<V> delegateRef;
    @NullableDecl
    private ScheduledFuture<?> timer;

    private TimeoutFuture(ListenableFuture<V> listenableFuture) {
        this.delegateRef = Preconditions.checkNotNull(listenableFuture);
    }

    static /* synthetic */ ScheduledFuture access$102(TimeoutFuture timeoutFuture, ScheduledFuture scheduledFuture) {
        timeoutFuture.timer = scheduledFuture;
        return scheduledFuture;
    }

    static <V> ListenableFuture<V> create(ListenableFuture<V> listenableFuture, long l2, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        TimeoutFuture<V> timeoutFuture = new TimeoutFuture<V>(listenableFuture);
        Fire<V> fire = new Fire<V>(timeoutFuture);
        timeoutFuture.timer = scheduledExecutorService.schedule(fire, l2, timeUnit);
        listenableFuture.addListener(fire, MoreExecutors.directExecutor());
        return timeoutFuture;
    }

    @Override
    protected void afterDone() {
        this.maybePropagateCancellationTo(this.delegateRef);
        ScheduledFuture<?> scheduledFuture = this.timer;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.delegateRef = null;
        this.timer = null;
    }

    @Override
    protected String pendingToString() {
        Object object = this.delegateRef;
        ScheduledFuture<?> scheduledFuture = this.timer;
        if (object != null) {
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append("inputFuture=[");
            ((StringBuilder)object2).append(object);
            ((StringBuilder)object2).append("]");
            object2 = object = ((StringBuilder)object2).toString();
            if (scheduledFuture != null) {
                long l2 = scheduledFuture.getDelay(TimeUnit.MILLISECONDS);
                object2 = object;
                if (l2 > 0L) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object);
                    ((StringBuilder)object2).append(", remaining delay=[");
                    ((StringBuilder)object2).append(l2);
                    ((StringBuilder)object2).append(" ms]");
                    object2 = ((StringBuilder)object2).toString();
                }
            }
            return object2;
        }
        return null;
    }

    private static final class Fire<V>
    implements Runnable {
        @NullableDecl
        TimeoutFuture<V> timeoutFutureRef;

        Fire(TimeoutFuture<V> timeoutFuture) {
            this.timeoutFutureRef = timeoutFuture;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            TimeoutFuture<V> timeoutFuture = this.timeoutFutureRef;
            if (timeoutFuture == null) {
                return;
            }
            ListenableFuture listenableFuture = ((TimeoutFuture)timeoutFuture).delegateRef;
            if (listenableFuture == null) {
                return;
            }
            this.timeoutFutureRef = null;
            if (listenableFuture.isDone()) {
                timeoutFuture.setFuture(listenableFuture);
                return;
            }
            try {
                Comparable<Delayed> comparable = ((TimeoutFuture)timeoutFuture).timer;
                Object object = "Timed out";
                CharSequence charSequence = object;
                if (comparable != null) {
                    long l2 = Math.abs(comparable.getDelay(TimeUnit.MILLISECONDS));
                    charSequence = object;
                    if (l2 > 10L) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("Timed out");
                        ((StringBuilder)charSequence).append(" (timeout delayed by ");
                        ((StringBuilder)charSequence).append(l2);
                        ((StringBuilder)charSequence).append(" ms after scheduled time)");
                        charSequence = ((StringBuilder)charSequence).toString();
                    }
                }
                TimeoutFuture.access$102(timeoutFuture, null);
                comparable = new Comparable<Delayed>();
                ((StringBuilder)comparable).append((String)charSequence);
                ((StringBuilder)comparable).append(": ");
                ((StringBuilder)comparable).append(listenableFuture);
                object = new TimeoutFutureException(((StringBuilder)comparable).toString());
                timeoutFuture.setException((Throwable)object);
                return;
            }
            finally {
                listenableFuture.cancel(true);
            }
        }
    }

    private static final class TimeoutFutureException
    extends TimeoutException {
        private TimeoutFutureException(String string2) {
            super(string2);
        }

        @Override
        public Throwable fillInStackTrace() {
            synchronized (this) {
                this.setStackTrace(new StackTraceElement[0]);
                return this;
            }
        }
    }
}

