/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.SmoothRateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;

public abstract class RateLimiter {
    @MonotonicNonNullDecl
    private volatile Object mutexDoNotUseDirectly;
    private final SleepingStopwatch stopwatch;

    RateLimiter(SleepingStopwatch sleepingStopwatch) {
        this.stopwatch = Preconditions.checkNotNull(sleepingStopwatch);
    }

    private boolean canAcquire(long l2, long l3) {
        boolean bl = this.queryEarliestAvailable(l2) - l3 <= l2;
        return bl;
    }

    private static void checkPermits(int n2) {
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl, "Requested permits (%s) must be positive", n2);
    }

    public static RateLimiter create(double d2) {
        return RateLimiter.create(d2, SleepingStopwatch.createFromSystemTimer());
    }

    public static RateLimiter create(double d2, long l2, TimeUnit timeUnit) {
        boolean bl = l2 >= 0L;
        Preconditions.checkArgument(bl, "warmupPeriod must not be negative: %s", l2);
        return RateLimiter.create(d2, l2, timeUnit, 3.0, SleepingStopwatch.createFromSystemTimer());
    }

    static RateLimiter create(double d2, long l2, TimeUnit timeUnit, double d3, SleepingStopwatch sleepingStopwatch) {
        timeUnit = new SmoothRateLimiter.SmoothWarmingUp(sleepingStopwatch, l2, timeUnit, d3);
        ((RateLimiter)((Object)timeUnit)).setRate(d2);
        return timeUnit;
    }

    static RateLimiter create(double d2, SleepingStopwatch sleepingStopwatch) {
        sleepingStopwatch = new SmoothRateLimiter.SmoothBursty(sleepingStopwatch, 1.0);
        ((RateLimiter)((Object)sleepingStopwatch)).setRate(d2);
        return sleepingStopwatch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object mutex() {
        Object object;
        Object object2 = object = this.mutexDoNotUseDirectly;
        if (object != null) return object2;
        synchronized (this) {
            object2 = object = this.mutexDoNotUseDirectly;
            if (object != null) return object2;
            this.mutexDoNotUseDirectly = object2 = new Object();
            return object2;
        }
    }

    public double acquire() {
        return this.acquire(1);
    }

    public double acquire(int n2) {
        long l2 = this.reserve(n2);
        this.stopwatch.sleepMicrosUninterruptibly(l2);
        double d2 = l2;
        Double.isNaN(d2);
        double d3 = TimeUnit.SECONDS.toMicros(1L);
        Double.isNaN(d3);
        return d2 * 1.0 / d3;
    }

    abstract double doGetRate();

    abstract void doSetRate(double var1, long var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final double getRate() {
        Object object = this.mutex();
        synchronized (object) {
            return this.doGetRate();
        }
    }

    abstract long queryEarliestAvailable(long var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final long reserve(int n2) {
        RateLimiter.checkPermits(n2);
        Object object = this.mutex();
        synchronized (object) {
            return this.reserveAndGetWaitLength(n2, this.stopwatch.readMicros());
        }
    }

    final long reserveAndGetWaitLength(int n2, long l2) {
        return Math.max(this.reserveEarliestAvailable(n2, l2) - l2, 0L);
    }

    abstract long reserveEarliestAvailable(int var1, long var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setRate(double d2) {
        boolean bl = d2 > 0.0 && !Double.isNaN(d2);
        Preconditions.checkArgument(bl, "rate must be positive");
        Object object = this.mutex();
        synchronized (object) {
            this.doSetRate(d2, this.stopwatch.readMicros());
            return;
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "RateLimiter[stableRate=%3.1fqps]", this.getRate());
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1, 0L, TimeUnit.MICROSECONDS);
    }

    public boolean tryAcquire(int n2) {
        return this.tryAcquire(n2, 0L, TimeUnit.MICROSECONDS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryAcquire(int n2, long l2, TimeUnit timeUnit) {
        long l3 = Math.max(timeUnit.toMicros(l2), 0L);
        RateLimiter.checkPermits(n2);
        Object object = this.mutex();
        synchronized (object) {
            l2 = this.stopwatch.readMicros();
            if (!this.canAcquire(l2, l3)) {
                return false;
            }
            l2 = this.reserveAndGetWaitLength(n2, l2);
        }
        this.stopwatch.sleepMicrosUninterruptibly(l2);
        return true;
    }

    public boolean tryAcquire(long l2, TimeUnit timeUnit) {
        return this.tryAcquire(1, l2, timeUnit);
    }

    static abstract class SleepingStopwatch {
        protected SleepingStopwatch() {
        }

        public static SleepingStopwatch createFromSystemTimer() {
            return new SleepingStopwatch(){
                final Stopwatch stopwatch = Stopwatch.createStarted();

                @Override
                protected long readMicros() {
                    return this.stopwatch.elapsed(TimeUnit.MICROSECONDS);
                }

                @Override
                protected void sleepMicrosUninterruptibly(long l2) {
                    if (l2 > 0L) {
                        Uninterruptibles.sleepUninterruptibly((long)l2, (TimeUnit)TimeUnit.MICROSECONDS);
                    }
                }
            };
        }

        protected abstract long readMicros();

        protected abstract void sleepMicrosUninterruptibly(long var1);
    }
}

