/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Monitor {
    private Guard activeGuards = null;
    private final boolean fair;
    private final ReentrantLock lock;

    public Monitor() {
        this(false);
    }

    public Monitor(boolean bl) {
        this.fair = bl;
        this.lock = new ReentrantLock(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void await(Guard guard, boolean bl) throws InterruptedException {
        if (bl) {
            this.signalNextWaiter();
        }
        this.beginWaitingFor(guard);
        try {
            do {
                guard.condition.await();
            } while (!(bl = guard.isSatisfied()));
            this.endWaitingFor(guard);
            return;
        }
        catch (Throwable throwable) {
            this.endWaitingFor(guard);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean awaitNanos(Guard var1_1, long var2_2, boolean var4_3) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void awaitUninterruptibly(Guard guard, boolean bl) {
        if (bl) {
            this.signalNextWaiter();
        }
        this.beginWaitingFor(guard);
        try {
            do {
                guard.condition.awaitUninterruptibly();
            } while (!(bl = guard.isSatisfied()));
            this.endWaitingFor(guard);
            return;
        }
        catch (Throwable throwable) {
            this.endWaitingFor(guard);
            throw throwable;
        }
    }

    private void beginWaitingFor(Guard guard) {
        int n2 = guard.waiterCount;
        guard.waiterCount = n2 + 1;
        if (n2 == 0) {
            guard.next = this.activeGuards;
            this.activeGuards = guard;
        }
    }

    private void endWaitingFor(Guard guard) {
        int n2;
        guard.waiterCount = n2 = guard.waiterCount - 1;
        if (n2 == 0) {
            Guard guard2 = this.activeGuards;
            Guard guard3 = null;
            while (true) {
                if (guard2 == guard) {
                    if (guard3 == null) {
                        this.activeGuards = guard2.next;
                    } else {
                        guard3.next = guard2.next;
                    }
                    guard2.next = null;
                    break;
                }
                Guard guard4 = guard2.next;
                guard3 = guard2;
                guard2 = guard4;
            }
        }
    }

    private static long initNanoTime(long l2) {
        long l3;
        if (l2 <= 0L) {
            return 0L;
        }
        l2 = l3 = System.nanoTime();
        if (l3 == 0L) {
            l2 = 1L;
        }
        return l2;
    }

    private boolean isSatisfied(Guard guard) {
        try {
            boolean bl = guard.isSatisfied();
            return bl;
        }
        catch (Throwable throwable) {
            this.signalAllWaiters();
            throw throwable;
        }
    }

    private static long remainingNanos(long l2, long l3) {
        long l4 = 0L;
        l2 = l3 <= 0L ? l4 : l3 - (System.nanoTime() - l2);
        return l2;
    }

    private void signalAllWaiters() {
        Guard guard = this.activeGuards;
        while (guard != null) {
            guard.condition.signalAll();
            guard = guard.next;
        }
    }

    private void signalNextWaiter() {
        Guard guard = this.activeGuards;
        while (guard != null) {
            if (this.isSatisfied(guard)) {
                guard.condition.signal();
                break;
            }
            guard = guard.next;
        }
    }

    private static long toSafeNanos(long l2, TimeUnit timeUnit) {
        long l3 = timeUnit.toNanos(l2);
        if (l3 <= 0L) {
            l2 = 0L;
        } else {
            l2 = l3;
            if (l3 > 0x5FFFFFFFFFFFFFFDL) {
                l2 = 0x5FFFFFFFFFFFFFFDL;
            }
        }
        return l2;
    }

    public void enter() {
        this.lock.lock();
    }

    /*
     * WARNING - void declaration
     */
    public boolean enter(long l2, TimeUnit object) {
        void var3_5;
        block10: {
            long l3;
            boolean bl;
            long l4 = Monitor.toSafeNanos(l2, (TimeUnit)((Object)object));
            object = this.lock;
            if (!this.fair && ((ReentrantLock)object).tryLock()) {
                return true;
            }
            boolean bl2 = bl = Thread.interrupted();
            try {
                l3 = System.nanoTime();
                l2 = l4;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (true) {
                bl2 = bl;
                try {
                    boolean bl3 = ((ReentrantLock)object).tryLock(l2, TimeUnit.NANOSECONDS);
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                    return bl3;
                }
                catch (InterruptedException interruptedException) {
                    try {
                        l2 = Monitor.remainingNanos(l3, l4);
                        return (boolean)l2;
                    }
                    finally {
                        bl = true;
                        continue;
                    }
                }
                break;
            }
            if (!bl2) break block10;
            Thread.currentThread().interrupt();
        }
        throw var3_5;
    }

    public boolean enterIf(Guard guard) {
        if (guard.monitor == this) {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean bl = guard.isSatisfied();
                if (!bl) {
                    reentrantLock.unlock();
                }
                return bl;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
        }
        throw new IllegalMonitorStateException();
    }

    public boolean enterIf(Guard guard, long l2, TimeUnit timeUnit) {
        if (guard.monitor == this) {
            if (!this.enter(l2, timeUnit)) {
                return false;
            }
            try {
                boolean bl = guard.isSatisfied();
                if (!bl) {
                    this.lock.unlock();
                }
                return bl;
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                throw throwable;
            }
        }
        throw new IllegalMonitorStateException();
    }

    public boolean enterIfInterruptibly(Guard guard) throws InterruptedException {
        if (guard.monitor == this) {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lockInterruptibly();
            try {
                boolean bl = guard.isSatisfied();
                if (!bl) {
                    reentrantLock.unlock();
                }
                return bl;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
        }
        throw new IllegalMonitorStateException();
    }

    public boolean enterIfInterruptibly(Guard guard, long l2, TimeUnit timeUnit) throws InterruptedException {
        if (guard.monitor == this) {
            ReentrantLock reentrantLock = this.lock;
            if (!reentrantLock.tryLock(l2, timeUnit)) {
                return false;
            }
            try {
                boolean bl = guard.isSatisfied();
                if (!bl) {
                    reentrantLock.unlock();
                }
                return bl;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
        }
        throw new IllegalMonitorStateException();
    }

    public void enterInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    public boolean enterInterruptibly(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.lock.tryLock(l2, timeUnit);
    }

    public void enterWhen(Guard guard) throws InterruptedException {
        if (guard.monitor == this) {
            ReentrantLock reentrantLock = this.lock;
            boolean bl = reentrantLock.isHeldByCurrentThread();
            reentrantLock.lockInterruptibly();
            try {
                if (!guard.isSatisfied()) {
                    this.await(guard, bl);
                }
                return;
            }
            catch (Throwable throwable) {
                this.leave();
                throw throwable;
            }
        }
        throw new IllegalMonitorStateException();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean enterWhen(Guard guard, long l2, TimeUnit timeUnit) throws InterruptedException {
        block10: {
            long l3;
            boolean bl;
            boolean bl2;
            boolean bl3;
            ReentrantLock reentrantLock;
            long l4;
            block13: {
                block11: {
                    block12: {
                        l4 = Monitor.toSafeNanos(l2, timeUnit);
                        if (guard.monitor != this) break block10;
                        reentrantLock = this.lock;
                        bl3 = reentrantLock.isHeldByCurrentThread();
                        bl2 = this.fair;
                        bl = false;
                        if (bl2) break block11;
                        if (Thread.interrupted()) break block12;
                        if (!reentrantLock.tryLock()) break block11;
                        l3 = 0L;
                        break block13;
                    }
                    throw new InterruptedException();
                }
                l3 = Monitor.initNanoTime(l4);
                if (!reentrantLock.tryLock(l2, timeUnit)) {
                    return false;
                }
            }
            try {
                if (guard.isSatisfied() || (bl2 = this.awaitNanos(guard, l2 = l3 == 0L ? l4 : Monitor.remainingNanos(l3, l4), bl3))) {
                    bl = true;
                }
                if (!bl) {
                    reentrantLock.unlock();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (!bl3) {
                    try {
                        this.signalNextWaiter();
                    }
                    finally {
                        reentrantLock.unlock();
                    }
                }
                throw throwable;
            }
        }
        throw new IllegalMonitorStateException();
    }

    public void enterWhenUninterruptibly(Guard guard) {
        if (guard.monitor == this) {
            ReentrantLock reentrantLock = this.lock;
            boolean bl = reentrantLock.isHeldByCurrentThread();
            reentrantLock.lock();
            try {
                if (!guard.isSatisfied()) {
                    this.awaitUninterruptibly(guard, bl);
                }
                return;
            }
            catch (Throwable throwable) {
                this.leave();
                throw throwable;
            }
        }
        throw new IllegalMonitorStateException();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean enterWhenUninterruptibly(Guard object, long l2, TimeUnit object2) {
        void var1_5;
        long l3;
        boolean bl;
        boolean bl2;
        boolean bl3;
        long l4;
        block21: {
            l4 = Monitor.toSafeNanos(l2, (TimeUnit)((Object)object2));
            if (((Guard)object).monitor != this) {
                object = new IllegalMonitorStateException();
                throw object;
            }
            object2 = this.lock;
            boolean bl4 = ((ReentrantLock)object2).isHeldByCurrentThread();
            bl3 = Thread.interrupted();
            bl2 = true;
            bl = bl3;
            if (!this.fair) {
                bl = bl3;
                if (((ReentrantLock)object2).tryLock()) {
                    l2 = 0L;
                    bl = bl4;
                    break block21;
                }
            }
            bl = bl3;
            l3 = Monitor.initNanoTime(l4);
            l2 = l4;
            while (true) {
                bl = bl3;
                try {
                    boolean bl52 = ((ReentrantLock)object2).tryLock(l2, TimeUnit.NANOSECONDS);
                    if (bl52) {
                        l2 = l3;
                        bl = bl4;
                        break;
                    }
                    if (!bl3) return false;
                    Thread.currentThread().interrupt();
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    try {
                        l2 = Monitor.remainingNanos(l3, l4);
                        return (boolean)l2;
                    }
                    finally {
                        bl3 = true;
                        continue;
                    }
                }
                break;
            }
        }
        while (true) {
            block22: {
                l3 = l2;
                if (!((Guard)object).isSatisfied()) {
                    long l5;
                    if (l2 == 0L) {
                        l3 = l2;
                        l2 = Monitor.initNanoTime(l4);
                        l5 = l4;
                    } else {
                        l3 = l2;
                        l5 = Monitor.remainingNanos(l2, l4);
                    }
                    l3 = l2;
                    bl2 = bl = this.awaitNanos((Guard)object, l5, bl);
                }
                if (bl2) break block22;
                bl = bl3;
                ((ReentrantLock)object2).unlock();
            }
            if (!bl3) return bl2;
            Thread.currentThread().interrupt();
            return bl2;
            catch (Throwable throwable) {
                bl = bl3;
                ((ReentrantLock)object2).unlock();
                bl = bl3;
                throw throwable;
                catch (InterruptedException interruptedException) {
                    bl = false;
                    bl3 = true;
                    l2 = l3;
                    continue;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            break;
        }
        if (!bl) throw var1_5;
        Thread.currentThread().interrupt();
        throw var1_5;
    }

    public int getOccupiedDepth() {
        return this.lock.getHoldCount();
    }

    public int getQueueLength() {
        return this.lock.getQueueLength();
    }

    public int getWaitQueueLength(Guard guard) {
        if (guard.monitor == this) {
            this.lock.lock();
            try {
                int n2 = guard.waiterCount;
                return n2;
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new IllegalMonitorStateException();
    }

    public boolean hasQueuedThread(Thread thread) {
        return this.lock.hasQueuedThread(thread);
    }

    public boolean hasQueuedThreads() {
        return this.lock.hasQueuedThreads();
    }

    public boolean hasWaiters(Guard guard) {
        boolean bl = this.getWaitQueueLength(guard) > 0;
        return bl;
    }

    public boolean isFair() {
        return this.fair;
    }

    public boolean isOccupied() {
        return this.lock.isLocked();
    }

    public boolean isOccupiedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public void leave() {
        ReentrantLock reentrantLock = this.lock;
        try {
            if (reentrantLock.getHoldCount() == 1) {
                this.signalNextWaiter();
            }
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean tryEnter() {
        return this.lock.tryLock();
    }

    public boolean tryEnterIf(Guard guard) {
        if (guard.monitor == this) {
            ReentrantLock reentrantLock = this.lock;
            if (!reentrantLock.tryLock()) {
                return false;
            }
            try {
                boolean bl = guard.isSatisfied();
                if (!bl) {
                    reentrantLock.unlock();
                }
                return bl;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
        }
        throw new IllegalMonitorStateException();
    }

    public void waitFor(Guard guard) throws InterruptedException {
        boolean bl = guard.monitor == this;
        if (bl & this.lock.isHeldByCurrentThread()) {
            if (!guard.isSatisfied()) {
                this.await(guard, true);
            }
            return;
        }
        throw new IllegalMonitorStateException();
    }

    public boolean waitFor(Guard guard, long l2, TimeUnit timeUnit) throws InterruptedException {
        l2 = Monitor.toSafeNanos(l2, timeUnit);
        boolean bl = guard.monitor == this;
        if (bl & this.lock.isHeldByCurrentThread()) {
            if (guard.isSatisfied()) {
                return true;
            }
            if (!Thread.interrupted()) {
                return this.awaitNanos(guard, l2, true);
            }
            throw new InterruptedException();
        }
        throw new IllegalMonitorStateException();
    }

    public void waitForUninterruptibly(Guard guard) {
        boolean bl = guard.monitor == this;
        if (bl & this.lock.isHeldByCurrentThread()) {
            if (!guard.isSatisfied()) {
                this.awaitUninterruptibly(guard, true);
            }
            return;
        }
        throw new IllegalMonitorStateException();
    }

    /*
     * WARNING - void declaration
     */
    public boolean waitForUninterruptibly(Guard object, long l2, TimeUnit object2) {
        long l3 = Monitor.toSafeNanos(l2, object2);
        object2 = ((Guard)object).monitor;
        boolean bl = true;
        boolean bl2 = object2 == this;
        if (bl2 & this.lock.isHeldByCurrentThread()) {
            void var1_4;
            if (((Guard)object).isSatisfied()) {
                return true;
            }
            long l4 = Monitor.initNanoTime(l3);
            boolean bl3 = Thread.interrupted();
            l2 = l3;
            boolean bl4 = true;
            while (true) {
                try {
                    bl4 = this.awaitNanos((Guard)object, l2, bl4);
                    if (bl3) {
                        Thread.currentThread().interrupt();
                    }
                    return bl4;
                }
                catch (Throwable throwable) {
                }
                catch (InterruptedException interruptedException) {
                    block11: {
                        bl3 = ((Guard)object).isSatisfied();
                        if (!bl3) break block11;
                        Thread.currentThread().interrupt();
                        return true;
                    }
                    try {
                        l2 = Monitor.remainingNanos(l4, l3);
                        bl4 = false;
                        bl3 = true;
                        continue;
                    }
                    catch (Throwable throwable) {
                        bl3 = bl;
                    }
                }
                break;
            }
            if (bl3) {
                Thread.currentThread().interrupt();
            }
            throw var1_4;
        }
        object = new IllegalMonitorStateException();
        throw object;
    }

    public static abstract class Guard {
        final Condition condition;
        final Monitor monitor;
        @NullableDecl
        Guard next;
        int waiterCount = 0;

        protected Guard(Monitor monitor) {
            this.monitor = Preconditions.checkNotNull(monitor, "monitor");
            this.condition = monitor.lock.newCondition();
        }

        public abstract boolean isSatisfied();
    }
}

