/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE = new DoNothingRunnable();
    private static final Runnable INTERRUPTING = new DoNothingRunnable();
    private static final int MAX_BUSY_WAIT_SPINS = 1000;
    private static final Runnable PARKED = new DoNothingRunnable();

    InterruptibleTask() {
    }

    abstract void afterRanInterruptibly(@NullableDecl T var1, @NullableDecl Throwable var2);

    final void interruptTask() {
        Runnable runnable2 = (Runnable)this.get();
        if (runnable2 instanceof Thread && this.compareAndSet(runnable2, INTERRUPTING)) {
            try {
                ((Thread)runnable2).interrupt();
            }
            finally {
                if (this.getAndSet(DONE) == PARKED) {
                    LockSupport.unpark((Thread)runnable2);
                }
            }
        }
    }

    abstract boolean isDone();

    @Override
    public final void run() {
        block14: {
            T t2;
            boolean bl;
            block20: {
                Thread thread;
                block13: {
                    block15: {
                        thread = Thread.currentThread();
                        if (!this.compareAndSet(null, thread)) {
                            return;
                        }
                        bl = this.isDone() ^ true;
                        if (!bl) break block15;
                        try {
                            t2 = this.runInterruptibly();
                            break block13;
                        }
                        catch (Throwable throwable) {
                            block16: {
                                if (this.compareAndSet(thread, DONE)) break block16;
                                Runnable runnable2 = (Runnable)this.get();
                                int n2 = 0;
                                int n3 = 0;
                                while (true) {
                                    int n4;
                                    block19: {
                                        block17: {
                                            block18: {
                                                if (runnable2 != INTERRUPTING && runnable2 != PARKED) {
                                                    if (n2 == 0) break;
                                                    thread.interrupt();
                                                    break;
                                                }
                                                n4 = n3 + 1;
                                                if (n4 <= 1000) break block17;
                                                Runnable runnable3 = PARKED;
                                                if (runnable2 == runnable3) break block18;
                                                n3 = n2;
                                                if (!this.compareAndSet(INTERRUPTING, runnable3)) break block19;
                                            }
                                            n2 = !Thread.interrupted() && n2 == 0 ? 0 : 1;
                                            LockSupport.park(this);
                                            n3 = n2;
                                            break block19;
                                        }
                                        Thread.yield();
                                        n3 = n2;
                                    }
                                    runnable2 = (Runnable)this.get();
                                    n2 = n3;
                                    n3 = n4;
                                }
                            }
                            if (bl) {
                                this.afterRanInterruptibly(null, throwable);
                            }
                            break block14;
                        }
                    }
                    t2 = null;
                }
                if (this.compareAndSet(thread, DONE)) break block20;
                Runnable runnable4 = (Runnable)this.get();
                int n5 = 0;
                int n6 = 0;
                while (true) {
                    int n7;
                    block23: {
                        block21: {
                            block22: {
                                if (runnable4 != INTERRUPTING && runnable4 != PARKED) {
                                    if (n5 == 0) break;
                                    thread.interrupt();
                                    break;
                                }
                                n7 = n6 + 1;
                                if (n7 <= 1000) break block21;
                                Runnable runnable5 = PARKED;
                                if (runnable4 == runnable5) break block22;
                                n6 = n5;
                                if (!this.compareAndSet(INTERRUPTING, runnable5)) break block23;
                            }
                            n5 = !Thread.interrupted() && n5 == 0 ? 0 : 1;
                            LockSupport.park(this);
                            n6 = n5;
                            break block23;
                        }
                        Thread.yield();
                        n6 = n5;
                    }
                    runnable4 = (Runnable)this.get();
                    n5 = n6;
                    n6 = n7;
                }
            }
            if (bl) {
                this.afterRanInterruptibly(t2, null);
            }
        }
    }

    abstract T runInterruptibly() throws Exception;

    abstract String toPendingString();

    @Override
    public final String toString() {
        StringBuilder stringBuilder;
        Object object = (Runnable)this.get();
        if (object == DONE) {
            object = "running=[DONE]";
        } else if (object == INTERRUPTING) {
            object = "running=[INTERRUPTED]";
        } else if (object instanceof Thread) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("running=[RUNNING ON ");
            stringBuilder.append(((Thread)object).getName());
            stringBuilder.append("]");
            object = stringBuilder.toString();
        } else {
            object = "running=[NOT STARTED YET]";
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append((String)object);
        stringBuilder.append(", ");
        stringBuilder.append(this.toPendingString());
        return stringBuilder.toString();
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

