/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class FuturesGetChecked {
    private static final Ordering<Constructor<?>> WITH_STRING_PARAM_FIRST = Ordering.natural().onResultOf(new Function<Constructor<?>, Boolean>(){

        @Override
        public Boolean apply(Constructor<?> constructor) {
            return Arrays.asList(constructor.getParameterTypes()).contains(String.class);
        }
    }).reverse();

    private FuturesGetChecked() {
    }

    private static GetCheckedTypeValidator bestGetCheckedTypeValidator() {
        return GetCheckedTypeValidatorHolder.BEST_VALIDATOR;
    }

    static void checkExceptionClassValidity(Class<? extends Exception> clazz) {
        Preconditions.checkArgument(FuturesGetChecked.isCheckedException(clazz), "Futures.getChecked exception type (%s) must not be a RuntimeException", clazz);
        Preconditions.checkArgument(FuturesGetChecked.hasConstructorUsableByGetChecked(clazz), "Futures.getChecked exception type (%s) must be an accessible class with an accessible constructor whose parameters (if any) must be of type String and/or Throwable", clazz);
    }

    static GetCheckedTypeValidator classValueValidator() {
        return GetCheckedTypeValidatorHolder.ClassValueValidator.INSTANCE;
    }

    static <V, X extends Exception> V getChecked(GetCheckedTypeValidator getCheckedTypeValidator, Future<V> future, Class<X> clazz) throws X {
        getCheckedTypeValidator.validateClass(clazz);
        try {
            getCheckedTypeValidator = future.get();
        }
        catch (ExecutionException executionException) {
            FuturesGetChecked.wrapAndThrowExceptionOrError(executionException.getCause(), clazz);
            throw new AssertionError();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw FuturesGetChecked.newWithCause(clazz, interruptedException);
        }
        return (V)getCheckedTypeValidator;
    }

    static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz) throws X {
        return FuturesGetChecked.getChecked(FuturesGetChecked.bestGetCheckedTypeValidator(), future, clazz);
    }

    static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz, long l2, TimeUnit timeUnit) throws X {
        FuturesGetChecked.bestGetCheckedTypeValidator().validateClass(clazz);
        try {
            future = future.get(l2, timeUnit);
        }
        catch (ExecutionException executionException) {
            FuturesGetChecked.wrapAndThrowExceptionOrError(executionException.getCause(), clazz);
            throw new AssertionError();
        }
        catch (TimeoutException timeoutException) {
            throw FuturesGetChecked.newWithCause(clazz, timeoutException);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw FuturesGetChecked.newWithCause(clazz, interruptedException);
        }
        return (V)future;
    }

    private static boolean hasConstructorUsableByGetChecked(Class<? extends Exception> clazz) {
        try {
            Exception exception = new Exception();
            FuturesGetChecked.newWithCause(clazz, exception);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean isCheckedException(Class<? extends Exception> clazz) {
        return RuntimeException.class.isAssignableFrom(clazz) ^ true;
    }

    @NullableDecl
    private static <X> X newFromConstructor(Constructor<X> constructor, Throwable throwable) {
        Class<?>[] classArray = constructor.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class<?> clazz = classArray[i2];
            if (clazz.equals(String.class)) {
                objectArray[i2] = throwable.toString();
                continue;
            }
            if (clazz.equals(Throwable.class)) {
                objectArray[i2] = throwable;
                continue;
            }
            return null;
        }
        try {
            constructor = constructor.newInstance(objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            return null;
        }
        return (X)constructor;
    }

    private static <X extends Exception> X newWithCause(Class<X> serializable, Throwable throwable) {
        Serializable serializable2;
        Iterator<Constructor<X>> iterator2 = FuturesGetChecked.preferringStrings(Arrays.asList(serializable.getConstructors())).iterator();
        while (iterator2.hasNext()) {
            serializable2 = (Exception)FuturesGetChecked.newFromConstructor(iterator2.next(), throwable);
            if (serializable2 == null) continue;
            if (((Throwable)serializable2).getCause() == null) {
                ((Throwable)serializable2).initCause(throwable);
            }
            return (X)serializable2;
        }
        serializable2 = new StringBuilder();
        ((StringBuilder)serializable2).append("No appropriate constructor for exception of type ");
        ((StringBuilder)serializable2).append(serializable);
        ((StringBuilder)serializable2).append(" in response to chained exception");
        serializable = new IllegalArgumentException(((StringBuilder)serializable2).toString(), throwable);
        throw serializable;
    }

    private static <X extends Exception> List<Constructor<X>> preferringStrings(List<Constructor<X>> list) {
        return WITH_STRING_PARAM_FIRST.sortedCopy(list);
    }

    static GetCheckedTypeValidator weakSetValidator() {
        return GetCheckedTypeValidatorHolder.WeakSetValidator.INSTANCE;
    }

    private static <X extends Exception> void wrapAndThrowExceptionOrError(Throwable throwable, Class<X> clazz) throws X {
        if (!(throwable instanceof Error)) {
            if (throwable instanceof RuntimeException) {
                throw new UncheckedExecutionException(throwable);
            }
            throw FuturesGetChecked.newWithCause(clazz, throwable);
        }
        throw new ExecutionError((Error)throwable);
    }

    static interface GetCheckedTypeValidator {
        public void validateClass(Class<? extends Exception> var1);
    }

    static class GetCheckedTypeValidatorHolder {
        static final GetCheckedTypeValidator BEST_VALIDATOR;
        static final String CLASS_VALUE_VALIDATOR_NAME;

        static {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(GetCheckedTypeValidatorHolder.class.getName());
            stringBuilder.append("$ClassValueValidator");
            CLASS_VALUE_VALIDATOR_NAME = stringBuilder.toString();
            BEST_VALIDATOR = GetCheckedTypeValidatorHolder.getBestValidator();
        }

        GetCheckedTypeValidatorHolder() {
        }

        static GetCheckedTypeValidator getBestValidator() {
            try {
                GetCheckedTypeValidator getCheckedTypeValidator = (GetCheckedTypeValidator)Class.forName(CLASS_VALUE_VALIDATOR_NAME).getEnumConstants()[0];
                return getCheckedTypeValidator;
            }
            catch (Throwable throwable) {
                return FuturesGetChecked.weakSetValidator();
            }
        }

        static enum ClassValueValidator implements GetCheckedTypeValidator
        {
            INSTANCE;

            private static final ClassValue<Boolean> isValidClass;

            static {
                isValidClass = new ClassValue<Boolean>(){

                    @Override
                    protected Boolean computeValue(Class<?> clazz) {
                        FuturesGetChecked.checkExceptionClassValidity(clazz.asSubclass(Exception.class));
                        return true;
                    }
                };
            }

            @Override
            public void validateClass(Class<? extends Exception> clazz) {
                isValidClass.get(clazz);
            }
        }

        static enum WeakSetValidator implements GetCheckedTypeValidator
        {
            INSTANCE;

            private static final Set<WeakReference<Class<? extends Exception>>> validClasses;

            static {
                validClasses = new CopyOnWriteArraySet<WeakReference<Class<? extends Exception>>>();
            }

            @Override
            public void validateClass(Class<? extends Exception> clazz) {
                Iterator<WeakReference<Class<? extends Exception>>> iterator2 = validClasses.iterator();
                while (iterator2.hasNext()) {
                    if (!clazz.equals(iterator2.next().get())) continue;
                    return;
                }
                FuturesGetChecked.checkExceptionClassValidity(clazz);
                if (validClasses.size() > 1000) {
                    validClasses.clear();
                }
                validClasses.add(new WeakReference<Class<? extends Exception>>(clazz));
            }
        }
    }
}

