/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractCatchingFuture;
import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractTransformFuture;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.CollectionFuture;
import com.google.common.util.concurrent.CombinedFuture;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.FuturesGetChecked;
import com.google.common.util.concurrent.GwtFuturesCatchingSpecialization;
import com.google.common.util.concurrent.ImmediateFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.TimeoutFuture;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Futures
extends GwtFuturesCatchingSpecialization {
    private Futures() {
    }

    public static <V> void addCallback(ListenableFuture<V> listenableFuture, FutureCallback<? super V> futureCallback, Executor executor) {
        Preconditions.checkNotNull(futureCallback);
        listenableFuture.addListener(new CallbackListener<V>(listenableFuture, futureCallback), executor);
    }

    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new CollectionFuture.ListFuture(ImmutableList.copyOf(iterable), true);
    }

    @SafeVarargs
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new CollectionFuture.ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), true);
    }

    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        return AbstractCatchingFuture.create(listenableFuture, clazz, function, executor);
    }

    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        return AbstractCatchingFuture.create(listenableFuture, clazz, asyncFunction, executor);
    }

    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz) throws X {
        return FuturesGetChecked.getChecked(future, clazz);
    }

    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz, long l2, TimeUnit timeUnit) throws X {
        return FuturesGetChecked.getChecked(future, clazz, l2, timeUnit);
    }

    public static <V> V getDone(Future<V> future) throws ExecutionException {
        Preconditions.checkState(future.isDone(), "Future was expected to be done: %s", future);
        return (V)Uninterruptibles.getUninterruptibly(future);
    }

    public static <V> V getUnchecked(Future<V> object) {
        Preconditions.checkNotNull(object);
        try {
            object = Uninterruptibles.getUninterruptibly(object);
        }
        catch (ExecutionException executionException) {
            Futures.wrapAndThrowUnchecked(executionException.getCause());
            throw new AssertionError();
        }
        return (V)object;
    }

    public static <V> ListenableFuture<V> immediateCancelledFuture() {
        return new ImmediateFuture.ImmediateCancelledFuture();
    }

    @Deprecated
    public static <V, X extends Exception> CheckedFuture<V, X> immediateCheckedFuture(@NullableDecl V v2) {
        return new ImmediateFuture.ImmediateSuccessfulCheckedFuture(v2);
    }

    @Deprecated
    public static <V, X extends Exception> CheckedFuture<V, X> immediateFailedCheckedFuture(X x2) {
        Preconditions.checkNotNull(x2);
        return new ImmediateFuture.ImmediateFailedCheckedFuture(x2);
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFuture.ImmediateFailedFuture(throwable);
    }

    public static <V> ListenableFuture<V> immediateFuture(@NullableDecl V v2) {
        if (v2 == null) {
            return ImmediateFuture.ImmediateSuccessfulFuture.NULL;
        }
        return new ImmediateFuture.ImmediateSuccessfulFuture<V>(v2);
    }

    public static <T> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> immutableList) {
        int n2;
        immutableList = immutableList instanceof Collection ? (ImmutableList<ListenableFuture<ListenableFuture>>)immutableList : ImmutableList.copyOf(immutableList);
        ListenableFuture[] listenableFutureArray = immutableList.toArray(new ListenableFuture[immutableList.size()]);
        immutableList = new InCompletionOrderState(listenableFutureArray);
        Object object = ImmutableList.builder();
        int n3 = 0;
        for (n2 = 0; n2 < listenableFutureArray.length; ++n2) {
            ((ImmutableList.Builder)object).add(new InCompletionOrderFuture((InCompletionOrderState)((Object)immutableList)));
        }
        object = ((ImmutableList.Builder)object).build();
        for (n2 = n3; n2 < listenableFutureArray.length; ++n2) {
            listenableFutureArray[n2].addListener(new Runnable((InCompletionOrderState)((Object)immutableList), (ImmutableList)object, n2){
                final /* synthetic */ ImmutableList val$delegates;
                final /* synthetic */ int val$localI;
                final /* synthetic */ InCompletionOrderState val$state;
                {
                    this.val$state = inCompletionOrderState;
                    this.val$delegates = immutableList;
                    this.val$localI = n2;
                }

                @Override
                public void run() {
                    this.val$state.recordInputCompletion(this.val$delegates, this.val$localI);
                }
            }, MoreExecutors.directExecutor());
        }
        return object;
    }

    public static <I, O> Future<O> lazyTransform(final Future<I> future, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(function);
        return new Future<O>(){

            private O applyTransformation(I object) throws ExecutionException {
                try {
                    object = function.apply(object);
                }
                catch (Throwable throwable) {
                    throw new ExecutionException(throwable);
                }
                return object;
            }

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.applyTransformation(future.get());
            }

            @Override
            public O get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.applyTransformation(future.get(l2, timeUnit));
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }
        };
    }

    @Deprecated
    public static <V, X extends Exception> CheckedFuture<V, X> makeChecked(ListenableFuture<V> listenableFuture, Function<? super Exception, X> function) {
        return new MappingCheckedFuture<V, X>(Preconditions.checkNotNull(listenableFuture), function);
    }

    public static <V> ListenableFuture<V> nonCancellationPropagating(ListenableFuture<V> listenableFuture) {
        if (listenableFuture.isDone()) {
            return listenableFuture;
        }
        NonCancellationPropagatingFuture<V> nonCancellationPropagatingFuture = new NonCancellationPropagatingFuture<V>(listenableFuture);
        listenableFuture.addListener(nonCancellationPropagatingFuture, MoreExecutors.directExecutor());
        return nonCancellationPropagatingFuture;
    }

    public static <O> ListenableFuture<O> scheduleAsync(AsyncCallable<O> object, long l2, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        object = TrustedListenableFutureTask.create(object);
        ((FluentFuture.TrustedFuture)object).addListener(new Runnable(scheduledExecutorService.schedule((Runnable)object, l2, timeUnit)){
            final /* synthetic */ Future val$scheduled;
            {
                this.val$scheduled = future;
            }

            @Override
            public void run() {
                this.val$scheduled.cancel(false);
            }
        }, MoreExecutors.directExecutor());
        return object;
    }

    public static <O> ListenableFuture<O> submitAsync(AsyncCallable<O> object, Executor executor) {
        object = TrustedListenableFutureTask.create(object);
        executor.execute((Runnable)object);
        return object;
    }

    public static <V> ListenableFuture<List<V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new CollectionFuture.ListFuture(ImmutableList.copyOf(iterable), false);
    }

    @SafeVarargs
    public static <V> ListenableFuture<List<V>> successfulAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new CollectionFuture.ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), false);
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, function, executor);
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, asyncFunction, executor);
    }

    public static <V> FutureCombiner<V> whenAllComplete(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new FutureCombiner(false, ImmutableList.copyOf(iterable));
    }

    @SafeVarargs
    public static <V> FutureCombiner<V> whenAllComplete(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new FutureCombiner(false, ImmutableList.copyOf(listenableFutureArray));
    }

    public static <V> FutureCombiner<V> whenAllSucceed(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new FutureCombiner(true, ImmutableList.copyOf(iterable));
    }

    @SafeVarargs
    public static <V> FutureCombiner<V> whenAllSucceed(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new FutureCombiner(true, ImmutableList.copyOf(listenableFutureArray));
    }

    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> listenableFuture, long l2, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        if (listenableFuture.isDone()) {
            return listenableFuture;
        }
        return TimeoutFuture.create(listenableFuture, l2, timeUnit, scheduledExecutorService);
    }

    private static void wrapAndThrowUnchecked(Throwable throwable) {
        if (throwable instanceof Error) {
            throw new ExecutionError((Error)throwable);
        }
        throw new UncheckedExecutionException(throwable);
    }

    private static final class CallbackListener<V>
    implements Runnable {
        final FutureCallback<? super V> callback;
        final Future<V> future;

        CallbackListener(Future<V> future, FutureCallback<? super V> futureCallback) {
            this.future = future;
            this.callback = futureCallback;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            void var1_4;
            block4: {
                V v2;
                try {
                    v2 = Futures.getDone(this.future);
                }
                catch (Error error) {
                    break block4;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                    break block4;
                }
                catch (ExecutionException executionException) {
                    this.callback.onFailure(executionException.getCause());
                    return;
                }
                this.callback.onSuccess(v2);
                return;
            }
            this.callback.onFailure((Throwable)var1_4);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.callback).toString();
        }
    }

    public static final class FutureCombiner<V> {
        private final boolean allMustSucceed;
        private final ImmutableList<ListenableFuture<? extends V>> futures;

        private FutureCombiner(boolean bl, ImmutableList<ListenableFuture<? extends V>> immutableList) {
            this.allMustSucceed = bl;
            this.futures = immutableList;
        }

        public <C> ListenableFuture<C> call(Callable<C> callable, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, callable);
        }

        public <C> ListenableFuture<C> callAsync(AsyncCallable<C> asyncCallable, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, asyncCallable);
        }

        public ListenableFuture<?> run(final Runnable runnable2, Executor executor) {
            return this.call(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    runnable2.run();
                    return null;
                }
            }, executor);
        }
    }

    private static final class InCompletionOrderFuture<T>
    extends AbstractFuture<T> {
        private InCompletionOrderState<T> state;

        private InCompletionOrderFuture(InCompletionOrderState<T> inCompletionOrderState) {
            this.state = inCompletionOrderState;
        }

        @Override
        protected void afterDone() {
            this.state = null;
        }

        @Override
        public boolean cancel(boolean bl) {
            InCompletionOrderState<T> inCompletionOrderState = this.state;
            if (super.cancel(bl)) {
                ((InCompletionOrderState)inCompletionOrderState).recordOutputCancellation(bl);
                return true;
            }
            return false;
        }

        @Override
        protected String pendingToString() {
            InCompletionOrderState<T> inCompletionOrderState = this.state;
            if (inCompletionOrderState != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("inputCount=[");
                stringBuilder.append(((InCompletionOrderState)inCompletionOrderState).inputFutures.length);
                stringBuilder.append("], remaining=[");
                stringBuilder.append(((InCompletionOrderState)inCompletionOrderState).incompleteOutputCount.get());
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
            return null;
        }
    }

    private static final class InCompletionOrderState<T> {
        private volatile int delegateIndex = 0;
        private final AtomicInteger incompleteOutputCount;
        private final ListenableFuture<? extends T>[] inputFutures;
        private boolean shouldInterrupt = true;
        private boolean wasCancelled = false;

        private InCompletionOrderState(ListenableFuture<? extends T>[] listenableFutureArray) {
            this.inputFutures = listenableFutureArray;
            this.incompleteOutputCount = new AtomicInteger(listenableFutureArray.length);
        }

        private void recordCompletion() {
            if (this.incompleteOutputCount.decrementAndGet() == 0 && this.wasCancelled) {
                for (ListenableFuture<T> listenableFuture : this.inputFutures) {
                    if (listenableFuture == null) continue;
                    listenableFuture.cancel(this.shouldInterrupt);
                }
            }
        }

        private void recordInputCompletion(ImmutableList<AbstractFuture<T>> immutableList, int n2) {
            ListenableFuture<? extends T>[] listenableFutureArray = this.inputFutures;
            ListenableFuture<? extends T> listenableFuture = listenableFutureArray[n2];
            listenableFutureArray[n2] = null;
            for (n2 = this.delegateIndex; n2 < immutableList.size(); ++n2) {
                if (!((AbstractFuture)immutableList.get(n2)).setFuture(listenableFuture)) continue;
                this.recordCompletion();
                this.delegateIndex = n2 + 1;
                return;
            }
            this.delegateIndex = immutableList.size();
        }

        private void recordOutputCancellation(boolean bl) {
            this.wasCancelled = true;
            if (!bl) {
                this.shouldInterrupt = false;
            }
            this.recordCompletion();
        }
    }

    private static class MappingCheckedFuture<V, X extends Exception>
    extends AbstractCheckedFuture<V, X> {
        final Function<? super Exception, X> mapper;

        MappingCheckedFuture(ListenableFuture<V> listenableFuture, Function<? super Exception, X> function) {
            super(listenableFuture);
            this.mapper = Preconditions.checkNotNull(function);
        }

        protected X mapException(Exception exception) {
            return (X)((Exception)this.mapper.apply(exception));
        }
    }

    private static final class NonCancellationPropagatingFuture<V>
    extends AbstractFuture.TrustedFuture<V>
    implements Runnable {
        private ListenableFuture<V> delegate;

        NonCancellationPropagatingFuture(ListenableFuture<V> listenableFuture) {
            this.delegate = listenableFuture;
        }

        @Override
        protected void afterDone() {
            this.delegate = null;
        }

        @Override
        protected String pendingToString() {
            ListenableFuture<V> listenableFuture = this.delegate;
            if (listenableFuture != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("delegate=[");
                stringBuilder.append(listenableFuture);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
            return null;
        }

        @Override
        public void run() {
            ListenableFuture<V> listenableFuture = this.delegate;
            if (listenableFuture != null) {
                this.setFuture(listenableFuture);
            }
        }
    }
}

