/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class ExecutionList {
    private static final Logger log = Logger.getLogger(ExecutionList.class.getName());
    private boolean executed;
    @NullableDecl
    private RunnableExecutorPair runnables;

    private static void executeListener(Runnable runnable2, Executor executor) {
        try {
            executor.execute(runnable2);
        }
        catch (RuntimeException runtimeException) {
            Logger logger = log;
            Level level = Level.SEVERE;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RuntimeException while executing runnable ");
            stringBuilder.append(runnable2);
            stringBuilder.append(" with executor ");
            stringBuilder.append(executor);
            logger.log(level, stringBuilder.toString(), runtimeException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Runnable runnable2, Executor executor) {
        Preconditions.checkNotNull(runnable2, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        synchronized (this) {
            if (!this.executed) {
                RunnableExecutorPair runnableExecutorPair;
                this.runnables = runnableExecutorPair = new RunnableExecutorPair(runnable2, executor, this.runnables);
                return;
            }
        }
        ExecutionList.executeListener(runnable2, executor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        RunnableExecutorPair runnableExecutorPair;
        RunnableExecutorPair runnableExecutorPair2;
        synchronized (this) {
            if (this.executed) {
                return;
            }
            this.executed = true;
            runnableExecutorPair2 = this.runnables;
            this.runnables = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            runnableExecutorPair = null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        while (true) {
            RunnableExecutorPair runnableExecutorPair3 = runnableExecutorPair;
            if (runnableExecutorPair2 == null) {
                while (runnableExecutorPair3 != null) {
                    ExecutionList.executeListener(runnableExecutorPair3.runnable, runnableExecutorPair3.executor);
                    runnableExecutorPair3 = runnableExecutorPair3.next;
                }
                return;
            }
            runnableExecutorPair3 = runnableExecutorPair2.next;
            runnableExecutorPair2.next = runnableExecutorPair;
            runnableExecutorPair = runnableExecutorPair2;
            runnableExecutorPair2 = runnableExecutorPair3;
        }
    }

    private static final class RunnableExecutorPair {
        final Executor executor;
        @NullableDecl
        RunnableExecutorPair next;
        final Runnable runnable;

        RunnableExecutorPair(Runnable runnable2, Executor executor, RunnableExecutorPair runnableExecutorPair) {
            this.runnable = runnable2;
            this.executor = executor;
            this.next = runnableExecutorPair;
        }
    }
}

