/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class CycleDetectingLockFactory {
    private static final ThreadLocal<ArrayList<LockGraphNode>> acquiredLocks;
    private static final ConcurrentMap<Class<? extends Enum>, Map<? extends Enum, LockGraphNode>> lockGraphNodesPerType;
    private static final Logger logger;
    final Policy policy;

    static {
        lockGraphNodesPerType = new MapMaker().weakKeys().makeMap();
        logger = Logger.getLogger(CycleDetectingLockFactory.class.getName());
        acquiredLocks = new ThreadLocal<ArrayList<LockGraphNode>>(){

            @Override
            protected ArrayList<LockGraphNode> initialValue() {
                return Lists.newArrayListWithCapacity(3);
            }
        };
    }

    private CycleDetectingLockFactory(Policy policy) {
        this.policy = Preconditions.checkNotNull(policy);
    }

    private void aboutToAcquire(CycleDetectingLock object) {
        if (!object.isAcquiredByCurrentThread()) {
            ArrayList<LockGraphNode> arrayList = acquiredLocks.get();
            object = object.getLockGraphNode();
            ((LockGraphNode)object).checkAcquiredLocks(this.policy, arrayList);
            arrayList.add((LockGraphNode)object);
        }
    }

    static <E extends Enum<E>> Map<E, LockGraphNode> createNodes(Class<E> serializable) {
        Object object;
        int n2;
        EnumMap<E, LockGraphNode> enumMap = Maps.newEnumMap(serializable);
        Object object2 = (Enum[])((Class)serializable).getEnumConstants();
        int n3 = ((Enum[])object2).length;
        serializable = Lists.newArrayListWithCapacity(n3);
        int n4 = ((Enum[])object2).length;
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            object = object2[n2];
            LockGraphNode lockGraphNode = new LockGraphNode(CycleDetectingLockFactory.getLockName(object));
            ((ArrayList)serializable).add(lockGraphNode);
            enumMap.put(object, lockGraphNode);
        }
        n4 = 1;
        while (true) {
            n2 = n5;
            if (n4 >= n3) break;
            ((LockGraphNode)((ArrayList)serializable).get(n4)).checkAcquiredLocks(Policies.THROW, ((ArrayList)serializable).subList(0, n4));
            ++n4;
        }
        while (n2 < n3 - 1) {
            object = (LockGraphNode)((ArrayList)serializable).get(n2);
            object2 = Policies.DISABLED;
            ((LockGraphNode)object).checkAcquiredLocks((Policy)object2, ((ArrayList)serializable).subList(++n2, n3));
        }
        return Collections.unmodifiableMap(enumMap);
    }

    private static String getLockName(Enum<?> enum_) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(enum_.getDeclaringClass().getSimpleName());
        stringBuilder.append(".");
        stringBuilder.append(enum_.name());
        return stringBuilder.toString();
    }

    private static Map<? extends Enum, LockGraphNode> getOrCreateNodes(Class<? extends Enum> clazz) {
        Map<? extends Enum, LockGraphNode> map = (Map<? extends Enum, LockGraphNode>)lockGraphNodesPerType.get(clazz);
        if (map != null) {
            return map;
        }
        map = CycleDetectingLockFactory.createNodes(clazz);
        return MoreObjects.firstNonNull(lockGraphNodesPerType.putIfAbsent(clazz, map), map);
    }

    private static void lockStateChanged(CycleDetectingLock object) {
        if (!object.isAcquiredByCurrentThread()) {
            ArrayList<LockGraphNode> arrayList = acquiredLocks.get();
            object = object.getLockGraphNode();
            for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                if (arrayList.get(i2) != object) continue;
                arrayList.remove(i2);
                break;
            }
        }
    }

    public static CycleDetectingLockFactory newInstance(Policy policy) {
        return new CycleDetectingLockFactory(policy);
    }

    public static <E extends Enum<E>> WithExplicitOrdering<E> newInstanceWithExplicitOrdering(Class<E> clazz, Policy policy) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(policy);
        return new WithExplicitOrdering<Enum>(policy, CycleDetectingLockFactory.getOrCreateNodes(clazz));
    }

    public ReentrantLock newReentrantLock(String string2) {
        return this.newReentrantLock(string2, false);
    }

    public ReentrantLock newReentrantLock(String object, boolean bl) {
        object = this.policy == Policies.DISABLED ? new ReentrantLock(bl) : new CycleDetectingReentrantLock(new LockGraphNode((String)object), bl);
        return object;
    }

    public ReentrantReadWriteLock newReentrantReadWriteLock(String string2) {
        return this.newReentrantReadWriteLock(string2, false);
    }

    public ReentrantReadWriteLock newReentrantReadWriteLock(String object, boolean bl) {
        object = this.policy == Policies.DISABLED ? new ReentrantReadWriteLock(bl) : new CycleDetectingReentrantReadWriteLock(new LockGraphNode((String)object), bl);
        return object;
    }

    private static interface CycleDetectingLock {
        public LockGraphNode getLockGraphNode();

        public boolean isAcquiredByCurrentThread();
    }

    final class CycleDetectingReentrantLock
    extends ReentrantLock
    implements CycleDetectingLock {
        private final LockGraphNode lockGraphNode;

        private CycleDetectingReentrantLock(LockGraphNode lockGraphNode, boolean bl) {
            super(bl);
            this.lockGraphNode = Preconditions.checkNotNull(lockGraphNode);
        }

        @Override
        public LockGraphNode getLockGraphNode() {
            return this.lockGraphNode;
        }

        @Override
        public boolean isAcquiredByCurrentThread() {
            return this.isHeldByCurrentThread();
        }

        @Override
        public void lock() {
            CycleDetectingLockFactory.this.aboutToAcquire(this);
            try {
                super.lock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CycleDetectingLockFactory.this.aboutToAcquire(this);
            try {
                super.lockInterruptibly();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }

        @Override
        public boolean tryLock() {
            CycleDetectingLockFactory.this.aboutToAcquire(this);
            try {
                boolean bl = super.tryLock();
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }

        @Override
        public boolean tryLock(long l2, TimeUnit timeUnit) throws InterruptedException {
            CycleDetectingLockFactory.this.aboutToAcquire(this);
            try {
                boolean bl = super.tryLock(l2, timeUnit);
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }

        @Override
        public void unlock() {
            try {
                super.unlock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }
    }

    private class CycleDetectingReentrantReadLock
    extends ReentrantReadWriteLock.ReadLock {
        final CycleDetectingReentrantReadWriteLock readWriteLock;

        CycleDetectingReentrantReadLock(CycleDetectingReentrantReadWriteLock cycleDetectingReentrantReadWriteLock) {
            super(cycleDetectingReentrantReadWriteLock);
            this.readWriteLock = cycleDetectingReentrantReadWriteLock;
        }

        @Override
        public void lock() {
            CycleDetectingLockFactory.this.aboutToAcquire(this.readWriteLock);
            try {
                super.lock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CycleDetectingLockFactory.this.aboutToAcquire(this.readWriteLock);
            try {
                super.lockInterruptibly();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public boolean tryLock() {
            CycleDetectingLockFactory.this.aboutToAcquire(this.readWriteLock);
            try {
                boolean bl = super.tryLock();
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public boolean tryLock(long l2, TimeUnit timeUnit) throws InterruptedException {
            CycleDetectingLockFactory.this.aboutToAcquire(this.readWriteLock);
            try {
                boolean bl = super.tryLock(l2, timeUnit);
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public void unlock() {
            try {
                super.unlock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }
    }

    final class CycleDetectingReentrantReadWriteLock
    extends ReentrantReadWriteLock
    implements CycleDetectingLock {
        private final LockGraphNode lockGraphNode;
        private final CycleDetectingReentrantReadLock readLock;
        private final CycleDetectingReentrantWriteLock writeLock;

        private CycleDetectingReentrantReadWriteLock(LockGraphNode lockGraphNode, boolean bl) {
            super(bl);
            this.readLock = new CycleDetectingReentrantReadLock(this);
            this.writeLock = new CycleDetectingReentrantWriteLock(this);
            this.lockGraphNode = Preconditions.checkNotNull(lockGraphNode);
        }

        @Override
        public LockGraphNode getLockGraphNode() {
            return this.lockGraphNode;
        }

        @Override
        public boolean isAcquiredByCurrentThread() {
            boolean bl = this.isWriteLockedByCurrentThread() || this.getReadHoldCount() > 0;
            return bl;
        }

        @Override
        public ReentrantReadWriteLock.ReadLock readLock() {
            return this.readLock;
        }

        @Override
        public ReentrantReadWriteLock.WriteLock writeLock() {
            return this.writeLock;
        }
    }

    private class CycleDetectingReentrantWriteLock
    extends ReentrantReadWriteLock.WriteLock {
        final CycleDetectingReentrantReadWriteLock readWriteLock;

        CycleDetectingReentrantWriteLock(CycleDetectingReentrantReadWriteLock cycleDetectingReentrantReadWriteLock) {
            super(cycleDetectingReentrantReadWriteLock);
            this.readWriteLock = cycleDetectingReentrantReadWriteLock;
        }

        @Override
        public void lock() {
            CycleDetectingLockFactory.this.aboutToAcquire(this.readWriteLock);
            try {
                super.lock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CycleDetectingLockFactory.this.aboutToAcquire(this.readWriteLock);
            try {
                super.lockInterruptibly();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public boolean tryLock() {
            CycleDetectingLockFactory.this.aboutToAcquire(this.readWriteLock);
            try {
                boolean bl = super.tryLock();
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public boolean tryLock(long l2, TimeUnit timeUnit) throws InterruptedException {
            CycleDetectingLockFactory.this.aboutToAcquire(this.readWriteLock);
            try {
                boolean bl = super.tryLock(l2, timeUnit);
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public void unlock() {
            try {
                super.unlock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }
    }

    private static class ExampleStackTrace
    extends IllegalStateException {
        static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
        static final ImmutableSet<String> EXCLUDED_CLASS_NAMES = ImmutableSet.of(CycleDetectingLockFactory.class.getName(), ExampleStackTrace.class.getName(), LockGraphNode.class.getName());

        ExampleStackTrace(LockGraphNode stackTraceElementArray, LockGraphNode lockGraphNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(stackTraceElementArray.getLockName());
            stringBuilder.append(" -> ");
            stringBuilder.append(lockGraphNode.getLockName());
            super(stringBuilder.toString());
            stackTraceElementArray = this.getStackTrace();
            int n2 = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (WithExplicitOrdering.class.getName().equals(stackTraceElementArray[i2].getClassName())) {
                    this.setStackTrace(EMPTY_STACK_TRACE);
                    break;
                }
                if (EXCLUDED_CLASS_NAMES.contains(stackTraceElementArray[i2].getClassName())) continue;
                this.setStackTrace(Arrays.copyOfRange(stackTraceElementArray, i2, n2));
                break;
            }
        }
    }

    private static class LockGraphNode {
        final Map<LockGraphNode, ExampleStackTrace> allowedPriorLocks = new MapMaker().weakKeys().makeMap();
        final Map<LockGraphNode, PotentialDeadlockException> disallowedPriorLocks = new MapMaker().weakKeys().makeMap();
        final String lockName;

        LockGraphNode(String string2) {
            this.lockName = Preconditions.checkNotNull(string2);
        }

        @NullableDecl
        private ExampleStackTrace findPathTo(LockGraphNode object, Set<LockGraphNode> set) {
            if (!set.add(this)) {
                return null;
            }
            ExampleStackTrace exampleStackTrace = this.allowedPriorLocks.get(object);
            if (exampleStackTrace != null) {
                return exampleStackTrace;
            }
            for (Map.Entry<LockGraphNode, ExampleStackTrace> entry : this.allowedPriorLocks.entrySet()) {
                LockGraphNode lockGraphNode = entry.getKey();
                exampleStackTrace = lockGraphNode.findPathTo((LockGraphNode)object, set);
                if (exampleStackTrace == null) continue;
                object = new ExampleStackTrace(lockGraphNode, this);
                ((Throwable)object).setStackTrace(entry.getValue().getStackTrace());
                ((Throwable)object).initCause(exampleStackTrace);
                return object;
            }
            return null;
        }

        void checkAcquiredLock(Policy policy, LockGraphNode lockGraphNode) {
            boolean bl = this != lockGraphNode;
            Preconditions.checkState(bl, "Attempted to acquire multiple locks with the same rank %s", (Object)lockGraphNode.getLockName());
            if (this.allowedPriorLocks.containsKey(lockGraphNode)) {
                return;
            }
            ExampleStackTrace exampleStackTrace = this.disallowedPriorLocks.get(lockGraphNode);
            if (exampleStackTrace != null) {
                policy.handlePotentialDeadlock(new PotentialDeadlockException(lockGraphNode, this, ((PotentialDeadlockException)exampleStackTrace).getConflictingStackTrace()));
                return;
            }
            exampleStackTrace = lockGraphNode.findPathTo(this, Sets.<LockGraphNode>newIdentityHashSet());
            if (exampleStackTrace == null) {
                this.allowedPriorLocks.put(lockGraphNode, new ExampleStackTrace(lockGraphNode, this));
            } else {
                exampleStackTrace = new PotentialDeadlockException(lockGraphNode, this, exampleStackTrace);
                this.disallowedPriorLocks.put(lockGraphNode, (PotentialDeadlockException)exampleStackTrace);
                policy.handlePotentialDeadlock((PotentialDeadlockException)exampleStackTrace);
            }
        }

        void checkAcquiredLocks(Policy policy, List<LockGraphNode> list) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.checkAcquiredLock(policy, list.get(i2));
            }
        }

        String getLockName() {
            return this.lockName;
        }
    }

    public static enum Policies implements Policy
    {
        THROW{

            @Override
            public void handlePotentialDeadlock(PotentialDeadlockException potentialDeadlockException) {
                throw potentialDeadlockException;
            }
        }
        ,
        WARN{

            @Override
            public void handlePotentialDeadlock(PotentialDeadlockException potentialDeadlockException) {
                logger.log(Level.SEVERE, "Detected potential deadlock", potentialDeadlockException);
            }
        }
        ,
        DISABLED{

            @Override
            public void handlePotentialDeadlock(PotentialDeadlockException potentialDeadlockException) {
            }
        };

    }

    public static interface Policy {
        public void handlePotentialDeadlock(PotentialDeadlockException var1);
    }

    public static final class PotentialDeadlockException
    extends ExampleStackTrace {
        private final ExampleStackTrace conflictingStackTrace;

        private PotentialDeadlockException(LockGraphNode lockGraphNode, LockGraphNode lockGraphNode2, ExampleStackTrace exampleStackTrace) {
            super(lockGraphNode, lockGraphNode2);
            this.conflictingStackTrace = exampleStackTrace;
            this.initCause(exampleStackTrace);
        }

        public ExampleStackTrace getConflictingStackTrace() {
            return this.conflictingStackTrace;
        }

        @Override
        public String getMessage() {
            StringBuilder stringBuilder = new StringBuilder(super.getMessage());
            for (Throwable throwable = this.conflictingStackTrace; throwable != null; throwable = throwable.getCause()) {
                stringBuilder.append(", ");
                stringBuilder.append(throwable.getMessage());
            }
            return stringBuilder.toString();
        }
    }

    public static final class WithExplicitOrdering<E extends Enum<E>>
    extends CycleDetectingLockFactory {
        private final Map<E, LockGraphNode> lockGraphNodes;

        WithExplicitOrdering(Policy policy, Map<E, LockGraphNode> map) {
            super(policy);
            this.lockGraphNodes = map;
        }

        public ReentrantLock newReentrantLock(E e2) {
            return this.newReentrantLock(e2, false);
        }

        public ReentrantLock newReentrantLock(E object, boolean bl) {
            object = this.policy == Policies.DISABLED ? new ReentrantLock(bl) : new CycleDetectingReentrantLock(this.lockGraphNodes.get(object), bl);
            return object;
        }

        public ReentrantReadWriteLock newReentrantReadWriteLock(E e2) {
            return this.newReentrantReadWriteLock(e2, false);
        }

        public ReentrantReadWriteLock newReentrantReadWriteLock(E object, boolean bl) {
            object = this.policy == Policies.DISABLED ? new ReentrantReadWriteLock(bl) : new CycleDetectingReentrantReadWriteLock(this.lockGraphNodes.get(object), bl);
            return object;
        }
    }
}

