/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.util.concurrent.AggregateFuture;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.InterruptibleTask;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class CombinedFuture<V>
extends AggregateFuture<Object, V> {
    CombinedFuture(ImmutableCollection<? extends ListenableFuture<?>> immutableCollection, boolean bl, Executor executor, AsyncCallable<V> asyncCallable) {
        this.init(new CombinedFutureRunningState(immutableCollection, bl, new AsyncCallableInterruptibleTask(asyncCallable, executor)));
    }

    CombinedFuture(ImmutableCollection<? extends ListenableFuture<?>> immutableCollection, boolean bl, Executor executor, Callable<V> callable) {
        this.init(new CombinedFutureRunningState(immutableCollection, bl, new CallableInterruptibleTask(callable, executor)));
    }

    private final class AsyncCallableInterruptibleTask
    extends CombinedFutureInterruptibleTask<ListenableFuture<V>> {
        private final AsyncCallable<V> callable;

        public AsyncCallableInterruptibleTask(AsyncCallable<V> asyncCallable, Executor executor) {
            super(executor);
            this.callable = Preconditions.checkNotNull(asyncCallable);
        }

        @Override
        ListenableFuture<V> runInterruptibly() throws Exception {
            this.thrownByExecute = false;
            return Preconditions.checkNotNull(this.callable.call(), "AsyncCallable.call returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", this.callable);
        }

        @Override
        void setValue(ListenableFuture<V> listenableFuture) {
            CombinedFuture.this.setFuture(listenableFuture);
        }

        @Override
        String toPendingString() {
            return this.callable.toString();
        }
    }

    private final class CallableInterruptibleTask
    extends CombinedFutureInterruptibleTask<V> {
        private final Callable<V> callable;

        public CallableInterruptibleTask(Callable<V> callable, Executor executor) {
            super(executor);
            this.callable = Preconditions.checkNotNull(callable);
        }

        @Override
        V runInterruptibly() throws Exception {
            this.thrownByExecute = false;
            return this.callable.call();
        }

        @Override
        void setValue(V v2) {
            CombinedFuture.this.set(v2);
        }

        @Override
        String toPendingString() {
            return this.callable.toString();
        }
    }

    private abstract class CombinedFutureInterruptibleTask<T>
    extends InterruptibleTask<T> {
        private final Executor listenerExecutor;
        boolean thrownByExecute = true;

        public CombinedFutureInterruptibleTask(Executor executor) {
            this.listenerExecutor = Preconditions.checkNotNull(executor);
        }

        @Override
        final void afterRanInterruptibly(T t2, Throwable throwable) {
            if (throwable != null) {
                if (throwable instanceof ExecutionException) {
                    CombinedFuture.this.setException(throwable.getCause());
                } else if (throwable instanceof CancellationException) {
                    CombinedFuture.this.cancel(false);
                } else {
                    CombinedFuture.this.setException(throwable);
                }
            } else {
                this.setValue(t2);
            }
        }

        final void execute() {
            block2: {
                try {
                    this.listenerExecutor.execute(this);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    if (!this.thrownByExecute) break block2;
                    CombinedFuture.this.setException(rejectedExecutionException);
                }
            }
        }

        @Override
        final boolean isDone() {
            return CombinedFuture.this.isDone();
        }

        abstract void setValue(T var1);
    }

    private final class CombinedFutureRunningState
    extends AggregateFuture.RunningState {
        private CombinedFutureInterruptibleTask task;

        CombinedFutureRunningState(ImmutableCollection<? extends ListenableFuture<?>> immutableCollection, boolean bl, CombinedFutureInterruptibleTask combinedFutureInterruptibleTask) {
            super(immutableCollection, bl, false);
            this.task = combinedFutureInterruptibleTask;
        }

        void collectOneValue(boolean bl, int n2, @NullableDecl Object object) {
        }

        @Override
        void handleAllCompleted() {
            CombinedFutureInterruptibleTask combinedFutureInterruptibleTask = this.task;
            if (combinedFutureInterruptibleTask != null) {
                combinedFutureInterruptibleTask.execute();
            } else {
                Preconditions.checkState(CombinedFuture.this.isDone());
            }
        }

        @Override
        void interruptTask() {
            CombinedFutureInterruptibleTask combinedFutureInterruptibleTask = this.task;
            if (combinedFutureInterruptibleTask != null) {
                combinedFutureInterruptibleTask.interruptTask();
            }
        }

        @Override
        void releaseResourcesAfterFailure() {
            super.releaseResourcesAfterFailure();
            this.task = null;
        }
    }
}

