/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AggregateFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    CollectionFuture() {
    }

    abstract class CollectionFutureRunningState
    extends AggregateFuture.RunningState {
        private List<Optional<V>> values;

        CollectionFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl) {
            super(immutableCollection, bl, true);
            CollectionFuture.this = immutableCollection.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(immutableCollection.size());
            this.values = CollectionFuture.this;
            for (int i2 = 0; i2 < immutableCollection.size(); ++i2) {
                this.values.add(null);
            }
        }

        final void collectOneValue(boolean bl, int n2, @NullableDecl V v2) {
            List list = this.values;
            if (list != null) {
                list.set(n2, Optional.fromNullable(v2));
            } else {
                bl = bl || CollectionFuture.this.isCancelled();
                Preconditions.checkState(bl, "Future was done before all dependencies completed");
            }
        }

        abstract C combine(List<Optional<V>> var1);

        @Override
        final void handleAllCompleted() {
            List list = this.values;
            if (list != null) {
                CollectionFuture.this.set(this.combine(list));
            } else {
                Preconditions.checkState(CollectionFuture.this.isDone());
            }
        }

        @Override
        void releaseResourcesAfterFailure() {
            super.releaseResourcesAfterFailure();
            this.values = null;
        }
    }

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl) {
            this.init(new ListFutureRunningState(immutableCollection, bl));
        }

        private final class ListFutureRunningState
        extends CollectionFutureRunningState {
            ListFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl) {
                super(immutableCollection, bl);
            }

            public List<V> combine(List<Optional<V>> optional) {
                ArrayList<Object> arrayList = Lists.newArrayListWithCapacity(optional.size());
                Iterator iterator2 = optional.iterator();
                while (iterator2.hasNext()) {
                    optional = iterator2.next();
                    optional = optional != null ? optional.orNull() : null;
                    arrayList.add(optional);
                }
                return Collections.unmodifiableList(arrayList);
            }
        }
    }
}

